/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ActionUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.alibabacloud.intellij.cosy.util.markdown.FlexMarkdownParser;
import com.alibabacloud.intellij.cosy.util.markdown.MarkdownParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ThemeUtil {
    private static Logger log = Logger.getInstance(ThemeUtil.class);
    public static final String SYSTEM_TAG = "<SYS>";
    public static String HELP_TO_BE_REPLACED_FORMAT = "{t('help.%s')}";
    public static String HELP_TO_REPLACE_FORMAT = "chat.help.answer.help.%s";
    public static List<String> HELP_NUMBERS = Arrays.asList("1", "2", "2.1", "2.2", "3", "4", "5", "6", "7", "8", "9", "10", "12", "13", "14", "15", "16", "17", "18");
    public static Pattern ASK_TAG_PATTERN = Pattern.compile("::LINGMA_ASK_TAG(.*?)::/LINGMA_ASK_TAG");
    private static MarkdownParser parser = new FlexMarkdownParser();

    public static String loadCodeTemplate() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        if (color == null) {
            return DarkTemplateHolder.darkTemplate;
        }
        return LightTemplateHolder.lightTemplate;
    }

    public static String loadCodeGeneralTemplate() {
        return GeneralTemplateHolder.generalTemplate;
    }

    public static String loadHelpTemplate() {
        return HelpTemplateHolder.template;
    }

    public static String loadMarkdownTemplate() {
        return MarkdownTemplateHolder.template;
    }

    public static String loadHelpContent() {
        int cancelShortcut;
        String helpTemplate = ThemeUtil.loadHelpTemplate();
        String nextShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ShowCosyNextInlayCompletionAction"), "\u2325 [");
        String prevShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ShowCosyPrevInlayCompletionAction"), "\u2325 ]");
        String acceptShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ApplyCosyInlayCompletion"), "Tab");
        String disposeShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionId("DisposeCosyInlayCompletionAction"), "esc");
        String triggerShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionIdWithAddPrefix("TriggerInlayCompletionAction"), "\u2325 P");
        String openPanelShortcut = KeyboardUtil.getShortcutText(ActionUtil.getActionId("TriggerCosySelectionChatAction"), "\u2318 \u21e7 L");
        int applyShortcut = KeyboardUtil.getShortcutKeyCode(ActionUtil.getActionId("ApplyCosyInlayCompletion"));
        if (applyShortcut == 9) {
            acceptShortcut = "Tab";
        }
        if ((cancelShortcut = KeyboardUtil.getShortcutKeyCode(ActionUtil.getActionId("DisposeCosyInlayCompletionAction"))) == 27) {
            disposeShortcut = "Esc";
        }
        helpTemplate = helpTemplate.replace("{{ CompletionAcceptShortCut }}", acceptShortcut).replace("{{ CompletionNextShortCut }}", nextShortcut).replace("{{ CompletionPrevShortCut }}", prevShortcut).replace("{{ CompletionCancelShortCut }}", disposeShortcut).replace("{{ CompletionTriggerShortCut }}", triggerShortcut).replace("{{ OpenPanelShortCut }}", openPanelShortcut);
        for (String helpNumber : HELP_NUMBERS) {
            helpTemplate = helpTemplate.replace(String.format(HELP_TO_BE_REPLACED_FORMAT, helpNumber), CosyBundle.message(String.format(HELP_TO_REPLACE_FORMAT, helpNumber), new Object[0]));
        }
        return helpTemplate;
    }

    public static String getMarkdownContent(Color foreground, Font font, String content) {
        String template = ThemeUtil.loadMarkdownTemplate();
        if (template != null) {
            if (!content.trim().startsWith(SYSTEM_TAG)) {
                content = parser.convert2Html(content);
            }
            if (content.startsWith(SYSTEM_TAG)) {
                content = StringUtils.replace((String)content, (String)SYSTEM_TAG, (String)"", (int)1);
            }
            String fontColor = String.format("#%02x%02x%02x", foreground.getRed(), foreground.getGreen(), foreground.getBlue());
            Color linkColor = ColorUtil.getLinkForegroundColor();
            String linkColorHex = String.format("#%02x%02x%02x", linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue());
            Color hoverColor = ColorUtil.getButtonHoverBackgroundColor();
            String hashtagColorHex = String.format("#%02x%02x%02x", hoverColor.getRed(), hoverColor.getGreen(), hoverColor.getBlue());
            JBColor markdownPunctColor = new JBColor(new Color(12020481), new Color(13736550));
            String markdownPunctColorHex = String.format("#%02x%02x%02x", markdownPunctColor.getRed(), markdownPunctColor.getGreen(), markdownPunctColor.getBlue());
            JBColor tableBorderColor = new JBColor(new Color(3159613), new Color(13686750));
            String tableBorderColorHex = String.format("#%02x%02x%02x", tableBorderColor.getRed(), tableBorderColor.getGreen(), tableBorderColor.getBlue());
            return template.replace("{{fontColor}}", fontColor).replace("{{fontFamily}}", font.getFamily()).replace("{{fontSize}}", String.valueOf(font.getSize())).replace("{{shortcutBackgroundColor}}", hashtagColorHex).replace("{{content}}", content.trim()).replace("{{linkColor}}", linkColorHex).replace("{{markdownPunctuationColor}}", markdownPunctColorHex).replace("{{tableBorderColor}}", tableBorderColorHex);
        }
        return null;
    }

    private static String readResource(String resourceName) {
        InputStream stream = ThemeUtil.class.getResourceAsStream(resourceName);
        if (stream != null) {
            try {
                return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("Read resource error.", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isNewUI() {
        try {
            Class<?> experimentalUI = Class.forName("com.intellij.ui.ExperimentalUI");
            return (Boolean)experimentalUI.getMethod("isNewUI", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String replaceTag(String content) {
        Matcher m = ASK_TAG_PATTERN.matcher(content);
        while (m.find()) {
            String tagContent = m.group(1);
            String tagResult = StringEscapeUtils.unescapeHtml4((String)tagContent);
            content = content.replace(m.group(), tagResult);
        }
        return content;
    }

    private static final class MarkdownTemplateHolder {
        private static final String template = ThemeUtil.readResource("/highlight/markdown.html");

        private MarkdownTemplateHolder() {
        }
    }

    private static final class HelpTemplateHolder {
        private static final String template = ThemeUtil.readResource(CosyBundle.message("chat.help.answer.help.template.file", new Object[0]));

        private HelpTemplateHolder() {
        }
    }

    private static final class LightTemplateHolder {
        private static final String lightTemplate = ThemeUtil.readResource("/highlight/one-light.html");

        private LightTemplateHolder() {
        }
    }

    private static final class DarkTemplateHolder {
        private static final String darkTemplate = ThemeUtil.readResource("/highlight/one-dark.html");

        private DarkTemplateHolder() {
        }
    }

    private static final class GeneralTemplateHolder {
        private static final String generalTemplate = ThemeUtil.readResource("/highlight/code_theme.html");

        private GeneralTemplateHolder() {
        }
    }
}

