/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.tool.excutor.TerminalCommandExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.terminal.JBTerminalPanel;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;

public class TerminalUtils {
    private static final Logger log = Logger.getInstance(TerminalUtils.class);
    public static final String TERMINAL_NEW_UI_KEY = "terminal.new.ui";
    public static final String TERMINAL_NEW_UI_REWORKED_KEY = "terminal.new.ui.reworked";
    private static Map<String, String> toolCallIdWidgetHashCodeMap = new ConcurrentHashMap<String, String>();
    private static Map<String, ShellTerminalWidget> widgetMap = new ConcurrentHashMap<String, ShellTerminalWidget>();
    private static Map<String, TerminalCommandExecutor> toolCallExecutor = new ConcurrentHashMap<String, TerminalCommandExecutor>();

    public static String getWidgetHashCode(String toolCallId) {
        return toolCallIdWidgetHashCodeMap.get(toolCallId);
    }

    public static void addToolCallIdWidgetHashCodeMap(String toolCallId, String widgetHashCode) {
        toolCallIdWidgetHashCodeMap.put(toolCallId, widgetHashCode);
    }

    public static ShellTerminalWidget getWidget(String widgetHashCode) {
        return widgetMap.get(widgetHashCode);
    }

    public static void addWidget(ShellTerminalWidget widget) {
        if (widget == null) {
            throw new RuntimeException("widget is empty");
        }
        widgetMap.put("" + widget.hashCode(), widget);
    }

    public static TerminalCommandExecutor getTerminalCommandExecutor(String toolCallId) {
        return toolCallExecutor.get(toolCallId);
    }

    public static void addTerminalCommandExecutor(String toolCallId, TerminalCommandExecutor terminalCommandExecutor) {
        toolCallExecutor.put(toolCallId, terminalCommandExecutor);
    }

    public static void removeTerminalCommandExecutor(String toolCallId) {
        if (StringUtils.isNotBlank((CharSequence)toolCallId)) {
            toolCallExecutor.remove(toolCallId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(ShellTerminalWidget widget) {
        if (widget == null) {
            return null;
        }
        JBTerminalPanel terminalPanel = (JBTerminalPanel)widget.getTerminalPanel();
        if (terminalPanel == null) {
            return null;
        }
        TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
        buffer.lock();
        String selectionText = null;
        try {
            String history = buffer.getHistoryBuffer().getLines();
            String screen = buffer.getScreenLines();
            selectionText = StringUtils.isBlank((CharSequence)history) ? screen : history + screen;
        }
        catch (Throwable e) {
            log.warn("TerminalUtils getText error", e);
        }
        finally {
            buffer.unlock();
        }
        return selectionText == null ? null : StringUtils.trim((String)selectionText);
    }

    public static String getNewTerminalType() {
        block9: {
            try {
                List newUIs;
                List registryValues = Registry.getAll();
                if (!CollectionUtils.isNotEmpty((Collection)registryValues) || !CollectionUtils.isNotEmpty(newUIs = registryValues.stream().filter(item -> TERMINAL_NEW_UI_KEY.equals(item.getKey()) || TERMINAL_NEW_UI_REWORKED_KEY.equals(item.getKey())).collect(Collectors.toList()))) break block9;
                Map<String, Boolean> newUIMap = newUIs.stream().collect(Collectors.toMap(RegistryValue::getKey, RegistryValue::asBoolean));
                if (newUIMap.containsKey(TERMINAL_NEW_UI_REWORKED_KEY)) {
                    log.debug("RunTerminalToolHandlerV2 getNewTerminalType newUI=terminal.new.ui.reworked,value=" + newUIMap.get(TERMINAL_NEW_UI_REWORKED_KEY));
                    TerminalOptionsProvider optionsProvider = TerminalOptionsProvider.getInstance();
                    if (optionsProvider.getState() == null) break block9;
                    try {
                        Field terminalEngineField = optionsProvider.getState().getClass().getDeclaredField("terminalEngine");
                        terminalEngineField.setAccessible(true);
                        Object terminalEngine = terminalEngineField.get(optionsProvider.getState());
                        if (terminalEngine != null) {
                            String engineValue = terminalEngine.toString();
                            log.debug("Current TerminalEngine: " + engineValue);
                            if (!"CLASSIC".equalsIgnoreCase(engineValue)) {
                                return TERMINAL_NEW_UI_REWORKED_KEY;
                            }
                        }
                        break block9;
                    }
                    catch (NoSuchFieldException e) {
                        log.debug("Current TerminalEngine no such field");
                        if (BooleanUtils.isTrue((Boolean)newUIMap.get(TERMINAL_NEW_UI_REWORKED_KEY))) {
                            return TERMINAL_NEW_UI_REWORKED_KEY;
                        }
                        break block9;
                    }
                }
                log.debug("RunTerminalToolHandlerV2 getNewTerminalType newUI=terminal.new.ui,value=" + newUIMap.get(TERMINAL_NEW_UI_KEY));
                if (BooleanUtils.isTrue((Boolean)newUIMap.get(TERMINAL_NEW_UI_KEY))) {
                    return TERMINAL_NEW_UI_KEY;
                }
            }
            catch (Exception e) {
                log.warn("RunTerminalToolHandlerV2 isNewTerminal error", (Throwable)e);
            }
        }
        return null;
    }

    public static String getTerminalShellPath(Project project) {
        try {
            TerminalProjectOptionsProvider terminalOptionsProvider = TerminalProjectOptionsProvider.getInstance((Project)project);
            return terminalOptionsProvider.getShellPath();
        }
        catch (Exception e) {
            log.warn("getTerminalShellPath error", (Throwable)e);
            return null;
        }
    }
}

