/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ReflectUtil {
    private static final Logger LOGGER = Logger.getInstance(ReflectUtil.class);
    private static Map<String, CacheClass> classMap = new ConcurrentHashMap<String, CacheClass>();
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Method[]> declaredMethodCache = new ConcurrentHashMap();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];

    public static Object instanceClass(Class<?> targetClass, Class<?>[] parameterTypes, Object ... args) {
        try {
            Constructor<?> constructor = targetClass.getConstructor(parameterTypes);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            LOGGER.warn("instance class error:" + targetClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getStaticField(Class<?> targetClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass must not be null");
        }
        Field field = targetClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(null);
    }

    public static <T> T callStaticField(Class<?> targetClass, String fieldName) {
        Field field = null;
        try {
            field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (Exception e) {
            LOGGER.warn("get field error:" + fieldName, (Throwable)e);
            return null;
        }
    }

    public static <T> T getField(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public static Object getEnumValue(Class<?> enumClass, String enumValueName) {
        ?[] enumConstants;
        for (Object object : enumConstants = enumClass.getEnumConstants()) {
            if (!enumValueName.equals(object.toString())) continue;
            return object;
        }
        return null;
    }

    public static Set<String> classSetToNames(Set<String> classNameSet) {
        HashSet<String> result = new HashSet<String>();
        for (String className : classNameSet) {
            Class<?> clazz = ReflectUtil.classForNameQuietly(className);
            if (clazz == null) continue;
            result.add(clazz.getName());
        }
        return result;
    }

    public static List<Class<?>> classNameSetToClasses(Set<String> classNameSet) {
        ArrayList result = new ArrayList();
        for (String className : classNameSet) {
            Class<?> clazz = ReflectUtil.classForNameQuietly(className);
            if (clazz == null) continue;
            result.add(clazz);
        }
        return result;
    }

    public static Class<?> classForNameQuietly(String className) {
        try {
            return ReflectUtil.classForName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        Class<?> result = null;
        CacheClass target = classMap.get(className);
        if (target == null) {
            target = new CacheClass(null);
            try {
                result = Class.forName(className);
                target.setClassObject(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            classMap.put(className, target);
        }
        return target.getClassObject();
    }

    public static Class<?> classForNameQuietly(String className, ClassLoader classLoader) {
        try {
            return ReflectUtil.classForName(className, classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> classForName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> result = null;
        CacheClass target = classMap.get(className);
        if (target == null) {
            target = new CacheClass(null);
            try {
                result = Class.forName(className, true, classLoader);
                target.setClassObject(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            classMap.put(className, target);
        }
        return target.getClassObject();
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class targetClass = clazz;
        do {
            Field[] fields;
            if ((fields = ReflectUtil.getDeclaredFields(targetClass)) == null || fields.length <= 0) continue;
            result.addAll(Arrays.asList(fields));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return result;
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Field[] result = declaredFieldsCache.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, result.length == 0 ? EMPTY_FIELD_ARRAY : result);
            }
            catch (Throwable var3) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", var3);
            }
        }
        return result;
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Method[] result = declaredMethodCache.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredMethods();
                declaredMethodCache.put(clazz, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable var3) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", var3);
            }
        }
        return result;
    }

    public static List<Method> getAllMethod(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        Class<?> targetClass = clazz;
        do {
            Method[] methods;
            if ((methods = ReflectUtil.getDeclaredMethods(targetClass)) == null || methods.length <= 0) continue;
            result.addAll(Arrays.asList(methods));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return result;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Class<?> targetClass = clazz;
        do {
            Method method = null;
            try {
                method = targetClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) continue;
            return method;
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return null;
    }

    public static <T> T callStaticMethod(Class<?> targetClass, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Method method = ReflectUtil.getMethod(targetClass, methodName, parameterTypes);
        if (method == null) {
            return null;
        }
        try {
            method.setAccessible(true);
            return (T)method.invoke(null, args);
        }
        catch (Exception e) {
            LOGGER.warn("call static method failed:" + methodName, (Throwable)e);
            return null;
        }
    }

    public static <T> T callStaticMethod(String targetClassName, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Class<?> databaseViewClass = ReflectUtil.classForNameQuietly(targetClassName);
        if (databaseViewClass == null) {
            return null;
        }
        return ReflectUtil.callStaticMethod(databaseViewClass, methodName, parameterTypes, args);
    }

    public static <T> T callStaticMethod(ClassLoader classLoader, String targetClassName, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Class<?> databaseViewClass = ReflectUtil.classForNameQuietly(targetClassName, classLoader);
        if (databaseViewClass == null) {
            return null;
        }
        return ReflectUtil.callStaticMethod(databaseViewClass, methodName, parameterTypes, args);
    }

    public static <T> T callMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        if (object == null) {
            return null;
        }
        Method method = ReflectUtil.getMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            return null;
        }
        try {
            method.setAccessible(true);
            return (T)method.invoke(object, args);
        }
        catch (Exception e) {
            LOGGER.warn("call method failed:" + methodName, (Throwable)e);
            return null;
        }
    }

    public static <T> T getDeepField(Object obj, String fieldName) throws Exception {
        Class<?> targetClass = obj.getClass();
        do {
            Field field = null;
            try {
                field = targetClass.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (field == null) continue;
            field.setAccessible(true);
            return (T)field.get(obj);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return null;
    }

    public static Object invokeDefaultMethod(Object instance, Class<?> interfaceClass, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            Method method = interfaceClass.getMethod(methodName, parameterTypes);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = lookup.unreflectSpecial(method, interfaceClass);
            return methodHandle.bindTo(instance).invokeWithArguments(args);
        }
        catch (Throwable e) {
            LOGGER.warn("invoke default method failed:" + methodName, e);
            return null;
        }
    }

    static class CacheClass {
        private Class<?> classObject;

        @Generated
        public Class<?> getClassObject() {
            return this.classObject;
        }

        @Generated
        public void setClassObject(Class<?> classObject) {
            this.classObject = classObject;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheClass)) {
                return false;
            }
            CacheClass other = (CacheClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$classObject = this.getClassObject();
            Class<?> other$classObject = other.getClassObject();
            return !(this$classObject == null ? other$classObject != null : !this$classObject.equals(other$classObject));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheClass;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $classObject = this.getClassObject();
            result = result * 59 + ($classObject == null ? 43 : $classObject.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReflectUtil.CacheClass(classObject=" + this.getClassObject() + ")";
        }

        @Generated
        public CacheClass(Class<?> classObject) {
            this.classObject = classObject;
        }
    }
}

