/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.cosy.common.ChatRecentQuery;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RecentQueryUtil {
    private static Logger log = Logger.getInstance(RecentQueryUtil.class);
    private static int RECENT_QUERY_MAX_COUNT = 20;

    public static void addRecentQuery(Project project, String query, List<ChatAskTag> tagList) {
        if (CosyPersistentSetting.getInstance().getState() == null) {
            log.warn("CosyPersistentSetting state is null");
            return;
        }
        ArrayList<ChatAskTag> chatAskTags = new ArrayList<ChatAskTag>();
        if (CollectionUtils.isNotEmpty(tagList)) {
            chatAskTags.addAll(tagList);
        }
        StringBuilder completeQuery = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)query) && !CollectionUtils.isEmpty(chatAskTags)) {
            query = ((ChatAskTag)chatAskTags.get(chatAskTags.size() - 1)).getText();
            chatAskTags.remove(chatAskTags.size() - 1);
        } else {
            chatAskTags.forEach(chatAskTag -> {
                if (StringUtils.isNotBlank((CharSequence)completeQuery)) {
                    completeQuery.append(" ");
                }
                completeQuery.append(chatAskTag.getText());
            });
            if (StringUtils.isNotBlank((CharSequence)query)) {
                if (StringUtils.isNotBlank((CharSequence)completeQuery)) {
                    completeQuery.append(" ");
                }
                completeQuery.append(query);
            }
        }
        if (query == null) {
            return;
        }
        String key = RecentQueryUtil.constructRecentQueryKey(project, null);
        String keyWithTag = RecentQueryUtil.constructRecentQueryKey(project, chatAskTags);
        RecentQueryUtil.doSaveRecentQuery(key, completeQuery.toString());
        RecentQueryUtil.doSaveRecentQuery(keyWithTag, query);
    }

    public static void addRecentComplexQuery(Project project, ChatAskInput chatAskInput) {
        String key = RecentQueryUtil.constructRecentQueryKey(project, null);
        RecentQueryUtil.doSaveRecentComplexQuery(key, chatAskInput.getChatInputElements(), chatAskInput.getContextTags());
    }

    private static void doSaveRecentQuery(String key, String query) {
        List<String> queryList;
        if (key == null || StringUtils.isBlank((CharSequence)query)) {
            return;
        }
        Map<String, List<String>> recentQueries = CosyPersistentSetting.getInstance().getState().getRecentQueries();
        if (recentQueries == null) {
            recentQueries = new HashMap<String, List<String>>();
        }
        if (!recentQueries.containsKey(key)) {
            recentQueries.put(key, new ArrayList());
        }
        if (CollectionUtils.isNotEmpty(queryList = recentQueries.get(key)) && query.equals(queryList.get(queryList.size() - 1))) {
            return;
        }
        if (queryList.size() >= RECENT_QUERY_MAX_COUNT) {
            queryList.remove(0);
        }
        queryList.add(query);
        CosyPersistentSetting.getInstance().getState().setRecentQueries(recentQueries);
    }

    private static void doSaveRecentComplexQuery(String key, List<ChatInputElement> chatInputElements, List<ChatContextTag> contextTags) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (key == null || chatInputElements.isEmpty() || setting == null) {
            return;
        }
        Map<String, List<ChatRecentQuery>> recentQueries = setting.getRecentComplexQueries();
        if (recentQueries == null) {
            recentQueries = new HashMap<String, List<ChatRecentQuery>>();
        }
        if (!recentQueries.containsKey(key)) {
            recentQueries.put(key, new ArrayList());
        }
        ChatRecentQuery chatRecentQuery = new ChatRecentQuery(chatInputElements, contextTags);
        List<ChatRecentQuery> queryList = recentQueries.get(key);
        if (CollectionUtils.isNotEmpty(queryList)) {
            ChatRecentQuery lastQuery = queryList.get(queryList.size() - 1);
            if (chatRecentQuery.getInputString().equals(lastQuery.getInputString())) {
                return;
            }
        }
        if (queryList.size() >= RECENT_QUERY_MAX_COUNT) {
            queryList.remove(0);
        }
        queryList.add(chatRecentQuery);
        CosyPersistentSetting.getInstance().getState().setRecentComplexQueries(recentQueries);
    }

    public static String getRecentQueries(Project project, int index, List<ChatAskTag> tagList) {
        if (CosyPersistentSetting.getInstance().getState() == null) {
            log.warn("CosyPersistentSetting state is null");
            return null;
        }
        String key = RecentQueryUtil.constructRecentQueryKey(project, tagList);
        if (key == null) {
            return null;
        }
        Map<String, List<String>> recentQueries = CosyPersistentSetting.getInstance().getState().getRecentQueries();
        if (recentQueries == null) {
            log.warn("recentQueries is null");
            return null;
        }
        if (!recentQueries.containsKey(key)) {
            return null;
        }
        List<String> queries = recentQueries.get(key);
        if (queries.size() <= index || index < 0) {
            log.warn(String.format("index out of range. query count = %d, index = %d", queries.size(), index));
            return null;
        }
        return queries.get(index);
    }

    public static String constructRecentQueryKey(Project project, List<ChatAskTag> tagList) {
        String currentTab;
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        if (authStatus == null || authStatus.getId() == null) {
            log.warn("AuthStatus is null or uid is null, cannot add recent query");
            return null;
        }
        String uid = authStatus.getId();
        String projectName = project.getName();
        ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
        String string = currentTab = null == userData || null == userData.getTabType() ? LingmaToolWindowPanel.getDefaultSessionTab() : userData.getTabType();
        if (CollectionUtils.isNotEmpty(tagList)) {
            StringBuilder tagBuilder = new StringBuilder();
            for (ChatAskTag tag : tagList) {
                if (tagBuilder.length() > 0) {
                    tagBuilder.append("|");
                }
                tagBuilder.append(tag.getText());
            }
            if ("chat".equals(currentTab)) {
                return String.format("%s|%s|%s", projectName, uid, tagBuilder);
            }
            return String.format("%s|%s|%s|%s", projectName, uid, currentTab, tagBuilder);
        }
        if ("chat".equals(currentTab)) {
            return String.format("%s|%s", projectName, uid);
        }
        return String.format("%s|%s|%s", projectName, uid, currentTab);
    }

    public static List<ChatRecentQuery> queryRecentComplexQueries(Project project, List<ChatInputElement> curInputElements) {
        String recentQueryKey;
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting == null) {
            return List.of();
        }
        Map<String, List<ChatRecentQuery>> recentQueryMap = setting.getRecentComplexQueries();
        List<ChatRecentQuery> recentQueries = recentQueryMap.get(recentQueryKey = RecentQueryUtil.constructRecentQueryKey(project, null));
        if (recentQueries == null || recentQueries.isEmpty()) {
            return List.of();
        }
        if (curInputElements == null || curInputElements.isEmpty()) {
            return recentQueries;
        }
        ArrayList<ChatRecentQuery> matchedQueries = new ArrayList<ChatRecentQuery>();
        for (ChatRecentQuery recentQuery : recentQueries) {
            List<ChatInputElement> chatInputElements = recentQuery.getChatInputElements();
            if (CollectionUtils.isEmpty(chatInputElements) || chatInputElements.size() <= curInputElements.size()) continue;
            boolean match = true;
            for (int i = 0; i < curInputElements.size(); ++i) {
                ChatInputElement curInputElement;
                ChatInputElement chatInputElement = chatInputElements.get(i);
                if (chatInputElement.equals(curInputElement = curInputElements.get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            matchedQueries.add(recentQuery);
        }
        return matchedQueries;
    }
}

