/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.core.lsp.model.testagent.MavenConfigResult;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenConfigUtils {
    private static final Logger log = Logger.getInstance(MavenConfigUtils.class);

    public static MavenConfigResult getProjectMavenConfig(Project project) {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenGeneralSettings generalSettings = mavenProjectsManager.getGeneralSettings();
        MavenConfigResult result = new MavenConfigResult();
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() <= 241) {
            File mavenHomeFile = MavenUtil.resolveMavenHomeDirectory((String)generalSettings.getMavenHome());
            if (mavenHomeFile != null) {
                result.setMavenHome(mavenHomeFile.getAbsolutePath());
            }
            File userSettingsFile = MavenUtil.resolveUserSettingsFile((String)generalSettings.getUserSettingsFile());
            result.setSettingsFileLocation(userSettingsFile.getAbsolutePath());
            File localRepositoryFile = MavenUtil.resolveLocalRepository((String)generalSettings.getLocalRepository(), (String)generalSettings.getMavenHome(), (String)generalSettings.getUserSettingsFile());
            result.setLocalRepositoryLocation(localRepositoryFile.getAbsolutePath());
        } else {
            try {
                Method getMavenHomeType = ReflectUtil.getMethod(MavenGeneralSettings.class, "getMavenHomeType", new Class[0]);
                if (getMavenHomeType != null) {
                    Object localRepositoryFile;
                    Method resolveLocalRepository;
                    Object mavenHomeFile;
                    Object mavenHomeType = getMavenHomeType.invoke((Object)generalSettings, new Object[0]);
                    Method getMavenHomeFile = ReflectUtil.getMethod(MavenUtil.class, "getMavenHomeFile", mavenHomeType.getClass().getInterfaces()[0]);
                    if (getMavenHomeFile != null && (mavenHomeFile = getMavenHomeFile.invoke(null, mavenHomeType)) instanceof File) {
                        result.setMavenHome(((File)mavenHomeFile).getAbsolutePath());
                    }
                    if ((resolveLocalRepository = ReflectUtil.getMethod(MavenUtil.class, "resolveLocalRepository", String.class, mavenHomeType.getClass().getInterfaces()[0], String.class)) != null && (localRepositoryFile = resolveLocalRepository.invoke(null, generalSettings.getLocalRepository(), mavenHomeType, generalSettings.getUserSettingsFile())) instanceof File) {
                        result.setLocalRepositoryLocation(((File)localRepositoryFile).getAbsolutePath());
                    }
                }
                File userSettingsFile = MavenUtil.resolveUserSettingsFile((String)generalSettings.getUserSettingsFile());
                result.setSettingsFileLocation(userSettingsFile.getAbsolutePath());
            }
            catch (Exception e) {
                log.error("getMavenConfigInternal error: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static Set<String> getMavenActiveProfiles(Project project) {
        HashSet<String> activeProfiles = new HashSet<String>();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        mavenProjectsManager.getProjects().forEach(mavenProject -> activeProfiles.addAll(mavenProject.getActivatedProfilesIds().getEnabledProfiles()));
        return activeProfiles;
    }
}

