/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.core.lsp.model.params.UploadImageCallBackResult;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ImageUploadUtil {
    private static final Logger log = Logger.getInstance(ImageUploadUtil.class);
    private static Map<String, Lock> imageUploadLockMap = new ConcurrentHashMap<String, Lock>();
    private static Map<String, Condition> waitImageUploadMap = new ConcurrentHashMap<String, Condition>();
    private static Map<String, UploadImageCallBackResult> imageUploadResultMap = new ConcurrentHashMap<String, UploadImageCallBackResult>();

    public static void init(String requestId) {
        imageUploadLockMap.put(requestId, new ReentrantLock());
        waitImageUploadMap.put(requestId, imageUploadLockMap.get(requestId).newCondition());
    }

    public static void destroy(String requestId) {
        imageUploadLockMap.remove(requestId);
        waitImageUploadMap.remove(requestId);
        imageUploadResultMap.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitImageUpload(String requestId, long time, TimeUnit unit) throws Exception {
        Lock lock = imageUploadLockMap.get(requestId);
        Condition condition = waitImageUploadMap.get(requestId);
        if (lock == null || condition == null) {
            log.warn("waitImageUpload requestId" + requestId + "error,lock is null or condition is null");
            return false;
        }
        lock.lock();
        try {
            boolean bl = condition.await(time, unit);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void notifyImageUpload(String requestId) {
        Lock lock = imageUploadLockMap.get(requestId);
        Condition condition = waitImageUploadMap.get(requestId);
        if (lock == null || condition == null) {
            log.warn("notifyImageUpload requestId" + requestId + "error,lock is null or condition is null");
            return;
        }
        lock.lock();
        try {
            condition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    public static UploadImageCallBackResult getImageUploadResult(String requestId) {
        if (imageUploadResultMap != null) {
            return imageUploadResultMap.get(requestId);
        }
        return null;
    }

    public static void setImageUploadResult(String requestId, UploadImageCallBackResult result) {
        imageUploadResultMap.put(requestId, result);
    }
}

