/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Logger log = Logger.getInstance(IconUtil.class);
    private static final int SIZE = 16;

    public static Icon getIcon(String url) {
        byte[] data = null;
        try {
            URL imageUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setConnectTimeout(500);
            InputStream inStream = conn.getInputStream();
            data = IOUtils.toByteArray((InputStream)inStream);
        }
        catch (Exception e) {
            log.warn(String.format("Can not get image from url  [%s] ", url));
            return null;
        }
        ImageIcon icon = new ImageIcon(data);
        if (icon.getIconHeight() != 16) {
            Image image = icon.getImage();
            Image smallImage = image.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(smallImage);
        }
        return icon;
    }

    public static Icon getFileTypeIcon(@Nullable Project project, String filePath) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return fileTypeManager.getFileTypeByFileName(FileUtil.getFileName(filePath)).getIcon();
        }
        FileType fileType = fileTypeManager.getFileTypeByFile(virtualFile);
        Icon icon = null;
        if (project != null) {
            try {
                AtomicReference fileIcon = new AtomicReference();
                for (IconProvider iconProvider : IconProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                        if (null != psiFile) {
                            fileIcon.set(iconProvider.getIcon((PsiElement)psiFile, 0));
                        }
                    });
                    icon = (Icon)fileIcon.get();
                    if (icon == null) continue;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = fileType.getIcon();
        }
        return icon;
    }

    public static Icon createTransparentIcon(Icon icon, float opacity) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(3, opacity));
        icon.paintIcon(null, g2d, 0, 0);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }
}

