/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class FileQueryUtil {
    private static final Logger log = Logger.getInstance(FileQueryUtil.class);
    private static final int TIMEOUT = 3;
    private static final int DEFAULT_PAGE_SIZE = 30;

    public static List<VirtualFile> query(Project project, String query) {
        try {
            DataContext dataContext = dataId -> {
                if (PlatformDataKeys.PROJECT.is(dataId)) {
                    return project;
                }
                return null;
            };
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"", (Presentation)new Presentation(), (DataContext)dataContext);
            AtomicReference contributorRef = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> contributorRef.set(StringUtils.isEmpty((CharSequence)query) ? new RecentFilesSEContributor(event) : new FileSearchEverywhereContributor(event)));
            List<VirtualFile> localResults = Collections.synchronizedList(new ArrayList());
            CountDownLatch searchCompleteLatch = new CountDownLatch(1);
            AtomicInteger resultCount = new AtomicInteger(0);
            Processor processor = element -> {
                if (element instanceof PsiElement && resultCount.get() < 30) {
                    ReadAction.run(() -> {
                        VirtualFile file;
                        VirtualFile virtualFile = file = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : ((PsiElement)element).getContainingFile().getVirtualFile();
                        if (null != file && StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)query)) {
                            localResults.add(file);
                            int updateCount = resultCount.incrementAndGet();
                            if (updateCount >= 30) {
                                searchCompleteLatch.countDown();
                            }
                        }
                    });
                }
                return resultCount.get() < 30;
            };
            try {
                EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                ((SearchEverywhereContributor)contributorRef.get()).fetchElements(query, (ProgressIndicator)new EmptyProgressIndicator(), processor);
                if (!indicator.isRunning()) {
                    log.info("Search file completed\uff0cindicator stop running, query=" + query);
                    searchCompleteLatch.countDown();
                }
            }
            catch (Exception e) {
                log.warn("Error during search execution", (Throwable)e);
                searchCompleteLatch.countDown();
            }
            if (!searchCompleteLatch.await(3L, TimeUnit.SECONDS)) {
                log.info("Search file timeout after 3 seconds, found " + resultCount.get() + " results");
            }
            return localResults;
        }
        catch (Exception e) {
            log.warn("SearchFilesToolHandler error,", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

