/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.constants.ScenarioConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.CosySseErrorMessage;
import com.alibabacloud.intellij.cosy.util.AuthStatusUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.apache.commons.lang3.StringUtils;

public class ErrorMessageHandler {
    private static Logger log = Logger.getInstance(ErrorMessageHandler.class);

    public static String convertErrorMessage(Project project, String requestId, String reason, String scenario) {
        if (reason == null) {
            return "";
        }
        CosySseErrorMessage cosySseErrorMessage = null;
        try {
            cosySseErrorMessage = (CosySseErrorMessage)JSON.parseObject((String)reason, CosySseErrorMessage.class);
        }
        catch (Exception e) {
            log.warn("reason cannot be parsed to CosySseErrorMessage");
        }
        if (cosySseErrorMessage == null) {
            return I18NConstant.CHAT_ANSWER_ABNORMAL + reason;
        }
        if (cosySseErrorMessage.getCode() == null) {
            return I18NConstant.CHAT_ANSWER_ABNORMAL + "request_id=" + requestId;
        }
        switch (cosySseErrorMessage.getCode()) {
            case "101": {
                return I18NConstant.AUTH_SIGNATURE_INVALID;
            }
            case "102": {
                return I18NConstant.AUTH_TIMESTAMP_OUTDATED;
            }
            case "103": {
                return I18NConstant.AUTH_DUPLICATE_REQUEST;
            }
            case "104": {
                return ErrorMessageHandler.getNoAccessRightText(LoginUtil.getAuthStatusCacheFirst(project));
            }
            case "111": {
                return ErrorMessageHandler.getErrorMessageForOrderExpired(project);
            }
            case "105": {
                return I18NConstant.AUTH_LOGIN_OUTDATED;
            }
            case "107": {
                return CosyBundle.message("message.chat.answer.login.ip.whitelist.error", new Object[0]);
            }
            case "108": {
                return CosyBundle.message("message.chat.answer.login.require.licence.access", new Object[0]);
            }
            case "109": {
                return CosyBundle.message("message.chat.answer.login.app.disabled.error", new Object[0]);
            }
            case "112": 
            case "114": {
                return InlineChatPanel.getQuotaUsageExceptionMessage("", reason);
            }
            case "418": {
                return I18NConstant.INTENTION_INVALID;
            }
            case "110": {
                if (ScenarioConstants.SCENARIO_GENERATE_COMMIT_MSG.equals(scenario)) {
                    return CosyBundle.message("message.inlay.completion.reach.limit.error", new Object[0]);
                }
                return CosyBundle.message("message.chat.answer.reach.limit.error", new Object[0]);
            }
        }
        return I18NConstant.CHAT_ANSWER_ABNORMAL + "code=" + cosySseErrorMessage.getCode() + ", request_id=" + requestId;
    }

    private static String getNoAccessRightText(AuthStatus status) {
        String message = CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        if (status == null || status.getWhitelist() == null) {
            return message;
        }
        if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
            message = CosyBundle.message("message.chat.answer.login.require.licence.access", new Object[0]);
        } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.ORG_ORDER_EXPIRED.getValue()) {
            message = String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), status.getName(), status.getOrgName());
        } else if (status.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            message = StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? String.format(AuthStatusUtil.getNoAccessMessageForOrgMember("message.chat.answer.login.require.org.access"), status.getName(), status.getOrgName()) : String.format(CosyBundle.message("message.chat.answer.login.require.access", new Object[0]), status.getName());
        }
        return message;
    }

    private static String getErrorMessageForOrderExpired(Project project) {
        String message = CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        if (authStatus == null) {
            return message;
        }
        return String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), authStatus.getName(), authStatus.getOrgName());
    }
}

