/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorUtil {
    private static final Logger LOGGER = Logger.getInstance(EditorUtil.class);
    private static final String DATE_FORMATE = "yyyy-MM-dd-HH-mm-ss";

    public static boolean isFocusedEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (ApplicationUtil.isRemoteIDE()) {
            return true;
        }
        return editor.getContentComponent().isFocusOwner();
    }

    public static boolean isSelectedEditor(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null || project.isDisposed()) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return false;
        }
        if (editorManager instanceof FileEditorManagerImpl) {
            Editor editor1 = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true);
            return editor1 != null && editor1.equals(editor);
        }
        FileEditor current = editorManager.getSelectedEditor();
        return current instanceof TextEditor && editor.equals(((TextEditor)current).getEditor());
    }

    public static long getDocumentModificationStamp(@NotNull Document document) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(2);
        }
        return document instanceof DocumentEx ? (long)((DocumentEx)document).getModificationSequence() : document.getModificationStamp();
    }

    public static int whitespacePrefixLength(@NotNull String lineContent) {
        int i;
        if (lineContent == null) {
            EditorUtil.$$$reportNull$$$0(3);
        }
        int maxLength = lineContent.length();
        for (i = 0; i < maxLength; ++i) {
            char c = lineContent.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return i;
    }

    @Nullable
    public static Editor getSelectedEditorSafely(@NotNull Project project) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(4);
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                return editorManager != null ? editorManager.getSelectedTextEditor() : null;
            }
            AtomicReference editor = new AtomicReference();
            SwingUtilities.invokeAndWait(() -> {
                try {
                    FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                    editor.set(editorManager != null ? editorManager.getSelectedTextEditor() : null);
                }
                catch (Exception e1) {
                    LOGGER.warn("Error to get editor", (Throwable)e1);
                }
            });
            return (Editor)editor.get();
        }
        catch (Exception e) {
            LOGGER.warn("Error to get editor first time", (Throwable)e);
            return null;
        }
    }

    private boolean isUnsupportedEditorState(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(5);
        }
        if (editor.getCaretModel().getCaretCount() > 1) {
            return true;
        }
        return editor.getSelectionModel().hasSelection();
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(6);
        }
        return EditorUtil.indentLine(project, editor, lineNumber, indent, caretOffset, EditorActionUtil.shouldUseSmartTabs((Project)project, (Editor)editor));
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset, boolean shouldUseSmartTabs) {
        int newCaretOffset;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(7);
        }
        EditorSettings editorSettings = editor.getSettings();
        int tabSize = editorSettings.getTabSize(project);
        Document document = editor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document.getLineCount()) {
            lineStart = document.getLineStartOffset(lineNumber);
            lineEnd = document.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        if ((newCaretOffset = caretOffset) >= lineStart && newCaretOffset < lineEnd && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = EditorUtil.getSpaceWidthInColumns(text, lineStart, spacesEnd, tabSize);
        tabsEnd = EditorUtil.getSpaceWidthInColumns(text, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd += indent) < 0) {
            tabsEnd = 0;
        }
        if (!shouldUseSmartTabs) {
            tabsEnd = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project) && i + tabSize <= tabsEnd) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - spacesEnd - lineStart;
        } else if (newCaretOffset >= lineStart && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        return newCaretOffset;
    }

    private static int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            if (seq.charAt(i) == '\t') {
                result = (result / tabSize + 1) * tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static Editor getActiveEditor() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        return ApplicationManager.getApplication().isDisposed() ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    @Nullable
    public static Editor getActiveEditor(@NotNull Document document) {
        Editor activeEditor;
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(8);
        }
        if (document.isInBulkUpdate()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        Editor editor = activeEditor = ApplicationManager.getApplication().isDisposed() ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (activeEditor != null && activeEditor.getDocument() != document) {
            activeEditor = null;
        }
        return activeEditor;
    }

    public static Point getEditorCaretPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(9);
        }
        try {
            Point cursorPosition = editor.logicalPositionToXY(editor.getCaretModel().getCurrentCaret().getLogicalPosition());
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            Rectangle contentArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
            int x = (int)visibleArea.getX() + cursorPosition.x;
            int y = (int)visibleArea.getY() + cursorPosition.y;
            if ((double)x < contentArea.getX()) {
                x = (int)contentArea.getX();
            } else if ((double)x > contentArea.getMaxX()) {
                x = (int)contentArea.getMaxX();
            }
            if ((double)y < contentArea.getY()) {
                y = (int)contentArea.getY();
            } else if ((double)y > contentArea.getMaxY()) {
                y = (int)contentArea.getMaxY();
            }
            return new Point(x, y);
        }
        catch (Exception e) {
            LOGGER.error("fail to get editor caret position. ", (Throwable)e);
            return null;
        }
    }

    public static Point getEditorCaretScreenPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(10);
        }
        Point cursorAbsoluteLocation = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        Point editorLocation = editor.getComponent().getLocationOnScreen();
        Point editorContentLocation = editor.getContentComponent().getLocationOnScreen();
        return new Point(editorContentLocation.x + cursorAbsoluteLocation.x, editorLocation.y + cursorAbsoluteLocation.y - editor.getScrollingModel().getVerticalScrollOffset());
    }

    public static String getEditorFilePath(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(11);
        }
        String filePath = null;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile != null) {
            filePath = virtualFile.getPresentableUrl();
        }
        return filePath;
    }

    public static String getActiveFilePath() {
        Project project = ProjectUtils.getActiveProject();
        if (null == project) {
            LOGGER.warn("invalid project: null");
            return null;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(project);
        return null == editor ? null : EditorUtil.getEditorFilePath(editor);
    }

    public static boolean isActiveProjectEditor(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(12);
        }
        return (project = ProjectUtils.getActiveProject()) != null && project.getBasePath() != null && editor.getProject() != null && project.getBasePath().equals(editor.getProject().getBasePath());
    }

    public static String getCopyPasteText() {
        CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
        Transferable contents = copyPasteManager.getContents();
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isAvailableLanguage(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(13);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null && setting.getParameter() != null && setting.getParameter().getCloud() != null && setting.getParameter().getCloud().getDisableLanguages() != null) {
            List<String> disableLanguages = setting.getParameter().getCloud().getDisableLanguages();
            Set languageSet = disableLanguages.stream().map(String::toLowerCase).collect(Collectors.toSet());
            String currentLanguage = LanguageUtil.getLanguageByFilePath(file.getPath());
            if (StringUtils.isNotBlank((CharSequence)currentLanguage) && languageSet.contains(currentLanguage.toLowerCase(Locale.ROOT))) {
                return false;
            }
            String ext = LanguageUtil.getExtensionByFileName(file.getPath());
            if (StringUtils.isNotBlank((CharSequence)ext) && languageSet.contains(ext.toLowerCase(Locale.ROOT))) {
                return false;
            }
        }
        return true;
    }

    public static void openEditorFile(@NotNull Project project, String filePath, @Nullable LineRange lineRange, JComponent ownedComponent) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(14);
        }
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            VirtualFile virtualFile = null;
            if (filePath.contains("://")) {
                String protocol = filePath.substring(0, filePath.indexOf("://"));
                String targetFilePath = filePath.substring(filePath.indexOf("://") + 3).replace("!\\", "!/");
                VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
                if (fileSystem != null) {
                    virtualFile = fileSystem.findFileByPath(targetFilePath);
                }
            } else {
                File file = new File(filePath);
                if (!file.exists()) {
                    LOGGER.warn("Cannot found file:" + filePath);
                    NotificationFactory.showToast(ownedComponent, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]));
                    return;
                }
                virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            }
            if (virtualFile == null) {
                LOGGER.warn("Cannot found file form vfs:" + filePath);
                NotificationFactory.showToast(ownedComponent, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]));
                return;
            }
            if (virtualFile.isDirectory()) {
                EditorUtil.openDirectoryInProjectView(project, virtualFile);
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                LOGGER.warn("Cannot open editor for file:" + filePath);
                return;
            }
            if (lineRange == null) {
                return;
            }
            Integer startLine = lineRange.getStartLine();
            Integer endLine = lineRange.getEndLine();
            int totalLines = editor.getDocument().getLineCount();
            if (startLine == null || startLine < 0 || startLine > totalLines) {
                startLine = 0;
            }
            if (endLine == null || endLine < 0 || endLine >= totalLines) {
                endLine = totalLines - 1;
            }
            CaretModel caretModel = editor.getCaretModel();
            caretModel.moveToLogicalPosition(new LogicalPosition(startLine.intValue(), 0));
            SelectionModel selectionModel = editor.getSelectionModel();
            selectionModel.setSelection(caretModel.getOffset(), editor.getDocument().getLineEndOffset(endLine.intValue()));
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    public static void openDirectoryInProjectView(Project project, VirtualFile directory) {
        ProjectView projectView = ProjectView.getInstance((Project)project);
        projectView.select(null, directory, true);
    }

    public static void openTempFileInEditor(@NotNull Project project, String fileName, @Nullable String content, Integer sectionNum) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(15);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMATE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String virtualName = fileName + "_Section" + sectionNum + "_" + simpleDateFormat.format(calendar.getTime());
        ReadOnlyLightVirtualFile virtualFile = new ReadOnlyLightVirtualFile(virtualName, (Language)PlainTextLanguage.INSTANCE, (CharSequence)content);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        fileEditorManager.openFile((VirtualFile)virtualFile, true, true);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)virtualFile);
        DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, false);
    }

    public static int getCaretOffset(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(16);
        }
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            CaretModel caretModel = editor.getCaretModel();
            return caretModel.getOffset();
        });
    }

    public static List<HighlightInfo> getDiagnostics(@NotNull Editor editor) throws InterruptedException, InvocationTargetException {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(17);
        }
        if ((project = editor.getProject()) == null) {
            return Collections.emptyList();
        }
        return EditorUtil.runInEdtAndWait(() -> {
            PsiFile file = EditorUtil.getPsiFile(project, editor);
            if (file == null) {
                return Collections.emptyList();
            }
            return (List)ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    return DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get diagnostics: " + e.getMessage(), (Throwable)e);
                    return Collections.emptyList();
                }
            });
        });
    }

    public static PsiFile getPsiFile(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(19);
        }
        return (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()));
    }

    public static boolean isCaretInComment(Editor editor) {
        boolean isComment = false;
        PsiElement element = PsiUtils.getCaratElement(editor);
        if (element != null && PsiUtils.isCommentElement(element, editor)) {
            isComment = true;
        }
        return isComment;
    }

    public static int getOffsetFromPosition(@NotNull Editor editor, @NotNull Position position) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(20);
        }
        if (position == null) {
            EditorUtil.$$$reportNull$$$0(21);
        }
        int line = position.getLine();
        int character = position.getCharacter();
        Document document = editor.getDocument();
        if (line < 0 || line >= document.getLineCount()) {
            return 0;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        int lineLength = lineEndOffset - lineStartOffset;
        if (character < 0) {
            return lineStartOffset;
        }
        if (character >= lineLength) {
            return lineEndOffset;
        }
        return lineStartOffset + character;
    }

    public static void runInEdt(@NotNull Runnable runnable) {
        if (runnable == null) {
            EditorUtil.$$$reportNull$$$0(22);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEdtAndWait(@NotNull Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (runnable == null) {
            EditorUtil.$$$reportNull$$$0(23);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static <T> T runInEdtAndWait(@NotNull Supplier<T> computable) throws InterruptedException, InvocationTargetException {
        if (computable == null) {
            EditorUtil.$$$reportNull$$$0(24);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return computable.get();
        }
        AtomicReference result = new AtomicReference();
        SwingUtilities.invokeAndWait(() -> result.set(computable.get()));
        return (T)result.get();
    }

    public static List<Inlay<?>> collectInlays(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(25);
        }
        InlayModel model = editor.getInlayModel();
        ArrayList inlays = new ArrayList();
        inlays.addAll(model.getInlineElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getAfterLineEndElementsInRange(startOffset, endOffset));
        inlays.addAll(model.getBlockElementsInRange(startOffset, endOffset));
        return inlays;
    }

    @NotNull
    public static String getCodeWithContext(@NotNull Document document, int lineNumber, int contextLines) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(26);
        }
        int totalLines = document.getLineCount();
        if (lineNumber < 0 || lineNumber >= totalLines) {
            LOGGER.warn("Invalid line number: " + lineNumber + ", total lines: " + totalLines);
            return "";
        }
        int startLine = Math.max(0, lineNumber - contextLines);
        int endLine = Math.min(totalLines - 1, lineNumber + contextLines);
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        String string = document.getText(new TextRange(startOffset, endOffset));
        if (string == null) {
            EditorUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getCodeWithContext(@NotNull Editor editor, int lineNumber, int contextLines) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(28);
        }
        return EditorUtil.getCodeWithContext(editor.getDocument(), lineNumber, contextLines);
    }

    @NotNull
    public static Map<String, Object> getCodeWithContextAndLineRange(@NotNull Document document, int lineNumber, int contextLines) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(29);
        }
        int totalLines = document.getLineCount();
        if (lineNumber < 0 || lineNumber >= totalLines) {
            LOGGER.warn("Invalid line number: " + lineNumber + ", total lines: " + totalLines);
            Map<String, Object> map = Map.of("text", "", "lineRange", new LineRange(0, 0));
            if (map == null) {
                EditorUtil.$$$reportNull$$$0(30);
            }
            return map;
        }
        int startLine = Math.max(0, lineNumber - contextLines);
        int endLine = Math.min(totalLines - 1, lineNumber + contextLines);
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        String text = document.getText(new TextRange(startOffset, endOffset));
        LineRange lineRange = new LineRange(startLine, endLine);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("text", text);
        result.put("lineRange", lineRange);
        HashMap<String, Object> hashMap = result;
        if (hashMap == null) {
            EditorUtil.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    public static String getContentByRange(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(32);
        }
        int totalLines = document.getLineCount();
        startLine = Math.max(startLine, 0);
        startLine = Math.min(startLine, totalLines - 1);
        endLine = Math.max(endLine, 0);
        endLine = Math.min(endLine, totalLines - 1);
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        return document.getText(new TextRange(startOffset, endOffset));
    }

    public static String getEditTextByOffsetRange(@NotNull Document document, int offset1, int offset2) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(33);
        }
        if (offset1 > offset2) {
            int temp = offset1;
            offset1 = offset2;
            offset2 = temp;
        }
        return document.getText(new TextRange(offset1, offset2));
    }

    public static EditorTextField createTextField(@NotNull Editor editor, Document newDocument) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(34);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        EditorTextField textField = EditorUtil.createTextField(editor, newDocument.getText());
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        LineStatusMarkerPopupPanel.installBaseEditorSyntaxHighlighters((Project)editor.getProject(), (EditorTextField)textField, (Document)newDocument, (TextRange)new TextRange(0, newDocument.getTextLength()), (FileType)psiFile.getFileType());
        return textField;
    }

    @NotNull
    public static EditorTextField createTextField(@NotNull Editor editor, @NotNull String content) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(35);
        }
        if (content == null) {
            EditorUtil.$$$reportNull$$$0(36);
        }
        EditorTextField field = new EditorTextField(content);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.setFontInheritedFromLAF(false);
        field.addSettingsProvider(uEditor -> {
            uEditor.setVerticalScrollbarVisible(true);
            uEditor.setHorizontalScrollbarVisible(true);
            uEditor.setRendererMode(true);
            uEditor.setBorder((Border)null);
            uEditor.setColorsScheme(editor.getColorsScheme());
            uEditor.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)editor, (boolean)false));
            uEditor.getSettings().setCaretRowShown(false);
            uEditor.getSettings().setTabSize(editor.getSettings().getTabSize(editor.getProject()));
            uEditor.getSettings().setUseTabCharacter(editor.getSettings().isUseTabCharacter(editor.getProject()));
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            EditorUtil.$$$reportNull$$$0(37);
        }
        return editorTextField;
    }

    public static Integer getEditorVisibleWidth(Project project) {
        if (null == project) {
            return null;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(project);
        if (null == editor) {
            return null;
        }
        return editor.getScrollingModel().getVisibleArea().width;
    }

    public static String getLineTextByOffset(@NotNull Document document, int offset) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(38);
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        return document.getText(new TextRange(lineStartOffset, lineEndOffset));
    }

    public static int getStickyLinesPanelHeight(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(39);
        }
        if (!(editor instanceof EditorImpl)) {
            return 0;
        }
        try {
            EditorImpl editorImpl = (EditorImpl)editor;
            Integer result = (Integer)ReflectUtil.callMethod(editorImpl, "getStickyLinesPanelHeight", new Class[0], new Object[0]);
            return result == null ? 0 : result;
        }
        catch (Exception e) {
            LOGGER.warn("Error getting sticky lines panel height", (Throwable)e);
            return 0;
        }
    }

    public static SelectionModelInfo getSelectionModelInfo(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            EditorUtil.$$$reportNull$$$0(40);
        }
        return (SelectionModelInfo)ReadAction.compute(() -> new SelectionModelInfo(selectionModel));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineContent";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/util/EditorUtil";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/util/EditorUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeWithContext";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeWithContextAndLineRange";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFocusedEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentModificationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "whitespacePrefixLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorSafely";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnsupportedEditorState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActiveEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditorCaretPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditorCaretScreenPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isActiveProjectEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "openTempFileInEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCaretOffset";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnostics";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromPosition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runInEdt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runInEdtAndWait";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectInlays";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCodeWithContext";
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCodeWithContextAndLineRange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getContentByRange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEditTextByOffsetRange";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextByOffset";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStickyLinesPanelHeight";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionModelInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SelectionModelInfo {
        String selectedText;
        VisualPosition selectionStartPosition;
        VisualPosition selectionEndPosition;
        int selectionStart;
        int selectionEnd;

        public SelectionModelInfo(SelectionModel selectionModel) {
            this.selectedText = selectionModel.getSelectedText();
            this.selectionStartPosition = selectionModel.getSelectionStartPosition();
            this.selectionEndPosition = selectionModel.getSelectionEndPosition();
            this.selectionStart = selectionModel.getSelectionStart();
            this.selectionEnd = selectionModel.getSelectionEnd();
        }

        @Generated
        public SelectionModelInfo(String selectedText, VisualPosition selectionStartPosition, VisualPosition selectionEndPosition, int selectionStart, int selectionEnd) {
            this.selectedText = selectedText;
            this.selectionStartPosition = selectionStartPosition;
            this.selectionEndPosition = selectionEndPosition;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        @Generated
        public String getSelectedText() {
            return this.selectedText;
        }

        @Generated
        public VisualPosition getSelectionStartPosition() {
            return this.selectionStartPosition;
        }

        @Generated
        public VisualPosition getSelectionEndPosition() {
            return this.selectionEndPosition;
        }

        @Generated
        public int getSelectionStart() {
            return this.selectionStart;
        }

        @Generated
        public int getSelectionEnd() {
            return this.selectionEnd;
        }

        @Generated
        public void setSelectedText(String selectedText) {
            this.selectedText = selectedText;
        }

        @Generated
        public void setSelectionStartPosition(VisualPosition selectionStartPosition) {
            this.selectionStartPosition = selectionStartPosition;
        }

        @Generated
        public void setSelectionEndPosition(VisualPosition selectionEndPosition) {
            this.selectionEndPosition = selectionEndPosition;
        }

        @Generated
        public void setSelectionStart(int selectionStart) {
            this.selectionStart = selectionStart;
        }

        @Generated
        public void setSelectionEnd(int selectionEnd) {
            this.selectionEnd = selectionEnd;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectionModelInfo)) {
                return false;
            }
            SelectionModelInfo other = (SelectionModelInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$selectedText = this.getSelectedText();
            String other$selectedText = other.getSelectedText();
            if (this$selectedText == null ? other$selectedText != null : !this$selectedText.equals(other$selectedText)) {
                return false;
            }
            VisualPosition this$selectionStartPosition = this.getSelectionStartPosition();
            VisualPosition other$selectionStartPosition = other.getSelectionStartPosition();
            if (this$selectionStartPosition == null ? other$selectionStartPosition != null : !this$selectionStartPosition.equals(other$selectionStartPosition)) {
                return false;
            }
            VisualPosition this$selectionEndPosition = this.getSelectionEndPosition();
            VisualPosition other$selectionEndPosition = other.getSelectionEndPosition();
            if (this$selectionEndPosition == null ? other$selectionEndPosition != null : !this$selectionEndPosition.equals(other$selectionEndPosition)) {
                return false;
            }
            if (this.getSelectionStart() != other.getSelectionStart()) {
                return false;
            }
            return this.getSelectionEnd() == other.getSelectionEnd();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SelectionModelInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $selectedText = this.getSelectedText();
            result = result * 59 + ($selectedText == null ? 43 : $selectedText.hashCode());
            VisualPosition $selectionStartPosition = this.getSelectionStartPosition();
            result = result * 59 + ($selectionStartPosition == null ? 43 : $selectionStartPosition.hashCode());
            VisualPosition $selectionEndPosition = this.getSelectionEndPosition();
            result = result * 59 + ($selectionEndPosition == null ? 43 : $selectionEndPosition.hashCode());
            result = result * 59 + this.getSelectionStart();
            result = result * 59 + this.getSelectionEnd();
            return result;
        }

        @Generated
        public String toString() {
            return "EditorUtil.SelectionModelInfo(selectedText=" + this.getSelectedText() + ", selectionStartPosition=" + this.getSelectionStartPosition() + ", selectionEndPosition=" + this.getSelectionEndPosition() + ", selectionStart=" + this.getSelectionStart() + ", selectionEnd=" + this.getSelectionEnd() + ")";
        }
    }
}

