/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.intellij.openapi.diagnostic.Logger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public class DownloadUtils {
    private static final Logger log = Logger.getInstance(DownloadUtils.class);
    public static final String DARK_SEARCH_PANEL_WELCOME_TEXT_URL = "https://codeup-algo.oss-cn-hangzhou.aliyuncs.com/biz/cosy-search/dark-cosy-search-default-panel-text.html";
    public static final String LIGHT_SEARCH_PANEL_WELCOME_TEXT_URL = "https://codeup-algo.oss-cn-hangzhou.aliyuncs.com/biz/cosy-search/light-cosy-search-default-panel-text.html";
    public static final Path DARK_SEARCH_PANEL_WELCOME_TEXT_LOCAL = CosyConfig.getHomeDirectory().resolve("tmp/dark-cosy-search-default-panel-text.html");
    public static final Path LIGHT_SEARCH_PANEL_WELCOME_TEXT_LOCAL = CosyConfig.getHomeDirectory().resolve("tmp/light-cosy-search-default-panel-text.html");

    @Nullable
    public static String downloadSearchPanelWelcomeText(Boolean isDark) throws IOException {
        String darkHtml = DownloadUtils.download(DARK_SEARCH_PANEL_WELCOME_TEXT_URL, DARK_SEARCH_PANEL_WELCOME_TEXT_LOCAL);
        String lightHtml = DownloadUtils.download(LIGHT_SEARCH_PANEL_WELCOME_TEXT_URL, LIGHT_SEARCH_PANEL_WELCOME_TEXT_LOCAL);
        if (isDark.booleanValue()) {
            return darkHtml;
        }
        return lightHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String download(String remoteUrl, Path localPath) throws IOException {
        URL url = new URL(remoteUrl);
        StringBuilder sb = new StringBuilder();
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            int byteRead;
            URLConnection conn = url.openConnection();
            inStream = conn.getInputStream();
            fs = new FileOutputStream(localPath.toUri().getPath());
            byte[] buffer = new byte[1204];
            while ((byteRead = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteRead);
                sb.append(new String(buffer, 0, byteRead));
            }
        }
        catch (FileNotFoundException e) {
            log.warn(String.format("Search welcome text download target path %s not found", localPath));
            String string = null;
            return string;
        }
        catch (IOException e) {
            log.warn("Search welcome text download IO exception");
            String string = null;
            return string;
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return sb.toString();
    }
}

