/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public final class DatabaseUtil {
    private static final Logger LOG = Logger.getInstance(DatabaseUtil.class);
    private static final String[] SUPPORTED_DATABASES_FOR_SYSTEM_TABLE = new String[]{"mysql", "amazon aurora mysql", "mariadb", "postgresql", "amazon redshift", "cockroachdb", "oracle", "microsoft sql server", "azure sql database", "azure synapse analytics", "apache cassandra", "mongodb", "snowflake", "hive", "clickhouse", "h2", "hsqldb", "sqlite"};

    public static ClassLoader getDatabaseUtilClassLoader() {
        IdeaPluginDescriptor targetPlugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.intellij.database"));
        if (targetPlugin != null) {
            return targetPlugin.getPluginClassLoader();
        }
        return null;
    }

    public static void registerDataSourceChangeListener(Project project, MessageBusConnection connection, Consumer<Object> callback) {
        ClassLoader classLoader = DatabaseUtil.getDatabaseUtilClassLoader();
        if (classLoader == null) {
            return;
        }
        Class<?> dbPsiFacadeClass = ReflectUtil.classForNameQuietly("com.intellij.database.psi.DbPsiFacade", classLoader);
        if (dbPsiFacadeClass == null) {
            return;
        }
        Topic topic = (Topic)ReflectUtil.callStaticField(dbPsiFacadeClass, "TOPIC");
        if (topic == null) {
            return;
        }
        Class<?> listenerClass = ReflectUtil.classForNameQuietly("com.intellij.database.psi.DbPsiFacade$Listener", classLoader);
        if (listenerClass == null) {
            return;
        }
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{listenerClass}, (InvocationHandler)new DefaultCallInvocationHandler(callback));
        connection.subscribe(topic, proxy);
    }

    public static List<Object> getAllDataSources(Project project) {
        ClassLoader classLoader = DatabaseUtil.getDatabaseUtilClassLoader();
        if (classLoader == null) {
            return null;
        }
        Object dbView = ReflectUtil.callStaticMethod(classLoader, "com.intellij.database.view.DatabaseView", "getDatabaseView", new Class[]{Project.class}, project);
        if (dbView == null) {
            return null;
        }
        Object dbPsiFacade = ReflectUtil.callStaticMethod(classLoader, "com.intellij.database.psi.DbPsiFacade", "getInstance", new Class[]{Project.class}, project);
        if (dbPsiFacade == null) {
            return null;
        }
        return (List)ReflectUtil.callMethod(dbPsiFacade, "getDataSources", new Class[0], new Object[0]);
    }

    public static List<DBTable> getDataSourceTables(Object dataSource) {
        Object sourceModel;
        if (dataSource == null) {
            return Collections.emptyList();
        }
        ArrayList<DBTable> tables = new ArrayList<DBTable>();
        ClassLoader classLoader = DatabaseUtil.getDatabaseUtilClassLoader();
        if (classLoader == null) {
            return null;
        }
        Class<?> baseModelClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.BaseModel", classLoader);
        if (baseModelClass == null) {
            return tables;
        }
        Boolean valid = (Boolean)ReflectUtil.callMethod(dataSource, "isValid", new Class[0], new Object[0]);
        if (valid != null && valid.booleanValue() && (sourceModel = ReflectUtil.callMethod(dataSource, "getModel", new Class[0], new Object[0])) != null && baseModelClass.isAssignableFrom(sourceModel.getClass())) {
            Class<?> basicModelClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.basic.BasicModel", classLoader);
            if (basicModelClass == null) {
                return tables;
            }
            Object traverser = ReflectUtil.invokeDefaultMethod(sourceModel, basicModelClass, "traverser", new Class[0], new Object[0]);
            if (traverser == null) {
                return tables;
            }
            JBIterable it = (JBIterable)ReflectUtil.callMethod(traverser, "traverse", new Class[0], new Object[0]);
            if (it == null) {
                return tables;
            }
            Class<?> dasTableClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.DasTable", classLoader);
            if (dasTableClass == null) {
                return tables;
            }
            Class<?> dasObjectClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.DasObject", classLoader);
            if (dasObjectClass == null) {
                return tables;
            }
            it.forEach(dasObject -> {
                Object dbTable;
                if (dasTableClass.isAssignableFrom(dasObject.getClass()) && (dbTable = ReflectUtil.callMethod(dataSource, "findElement", new Class[]{dasObjectClass}, dasObject)) != null) {
                    tables.add(new DBTable(dataSource, dbTable, dasObject, classLoader));
                }
            });
        }
        return tables;
    }

    public static String generateScript(Project project, ClassLoader classLoader, Object dataSource, List<Object> elements) {
        Class<?> scriptGeneratorsClass = ReflectUtil.classForNameQuietly("com.intellij.database.script.generator.ScriptGenerators", classLoader);
        Object scriptGenerators = ReflectUtil.callStaticField(scriptGeneratorsClass, "INSTANCE");
        if (scriptGenerators == null) {
            return null;
        }
        Class<?> baseModelClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.BaseModel", classLoader);
        if (baseModelClass == null) {
            return null;
        }
        Object sourceModel = ReflectUtil.callMethod(dataSource, "getModel", new Class[0], new Object[0]);
        if (sourceModel == null) {
            return null;
        }
        Object scriptGenerator = ReflectUtil.callMethod(scriptGenerators, "byModel", new Class[]{baseModelClass}, sourceModel);
        if (scriptGenerator == null) {
            return null;
        }
        Class<?> builderClass = ReflectUtil.classForNameQuietly("com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder", classLoader);
        if (builderClass == null) {
            return null;
        }
        Class<?> basicModelClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.basic.BasicModel", classLoader);
        if (basicModelClass == null) {
            return null;
        }
        Class<?> categoryClass = ReflectUtil.classForNameQuietly("com.intellij.database.script.generator.ScriptCategory", classLoader);
        if (categoryClass == null) {
            return null;
        }
        Object enumValue = ReflectUtil.getEnumValue(categoryClass, "CREATE_DEFINITION");
        if (enumValue == null) {
            return null;
        }
        Object builder = ReflectUtil.instanceClass(builderClass, new Class[]{basicModelClass, categoryClass}, sourceModel, enumValue);
        if (builder == null) {
            return null;
        }
        ReflectUtil.callMethod(builder, "addElements", new Class[]{Iterable.class}, elements);
        Object task = ReflectUtil.callMethod(builder, "build", new Class[0], new Object[0]);
        if (task == null) {
            return null;
        }
        Class<?> taskClass = ReflectUtil.classForNameQuietly("com.intellij.database.script.generator.ScriptingTask", classLoader);
        if (taskClass == null) {
            return null;
        }
        Object sr = ReflectUtil.callMethod(scriptGenerator, "makeScript", new Class[]{Project.class, taskClass}, project, task);
        if (sr == null) {
            return null;
        }
        return (String)ReflectUtil.callMethod(sr, "getScript", new Class[0], new Object[0]);
    }

    public static String generateDDL(Object dataSource, DBTable dbTable) {
        ClassLoader classLoader = DatabaseUtil.getDatabaseUtilClassLoader();
        if (classLoader == null) {
            return null;
        }
        Class<?> scriptGeneratorsClass = ReflectUtil.classForNameQuietly("com.intellij.database.script.generator.ScriptGenerators", classLoader);
        Object scriptGenerators = ReflectUtil.callStaticField(scriptGeneratorsClass, "INSTANCE");
        if (scriptGenerators == null) {
            return null;
        }
        Class<?> baseModelClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.BaseModel", classLoader);
        if (baseModelClass == null) {
            return null;
        }
        Object sourceModel = ReflectUtil.callMethod(dataSource, "getModel", new Class[0], new Object[0]);
        if (sourceModel == null) {
            return null;
        }
        Object scriptGenerator = ReflectUtil.callMethod(scriptGenerators, "byModel", new Class[]{baseModelClass}, sourceModel);
        JBIterable<?> columns = dbTable.getColumns();
        if (columns == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String tableName = dbTable.getName();
        String comment = dbTable.getComment();
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            sb.append("-- ").append(comment).append("\n");
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        ArrayList<String> columnContents = new ArrayList<String>();
        sb.append("CREATE TABLE ").append(tableName).append(" (\n");
        for (Object column : columns) {
            String colComment;
            Boolean isNotNul;
            Boolean isAuto;
            Object dataType;
            StringBuilder colSb = new StringBuilder();
            String columnName = (String)ReflectUtil.callMethod(column, "getName", new Class[0], new Object[0]);
            Object dasType = ReflectUtil.callMethod(column, "getDasType", new Class[0], new Object[0]);
            if (dasType == null || (dataType = ReflectUtil.callMethod(dasType, "toDataType", new Class[0], new Object[0])) == null) continue;
            String columnType = dataType.toString();
            if (scriptGenerator != null) {
                columnType = (String)ReflectUtil.callMethod(scriptGenerator, "prettyPrint", new Class[]{dataType.getClass()}, dataType);
            }
            if (columnType == null) continue;
            colSb.append("  ").append(columnName).append(" ").append(columnType.toUpperCase(Locale.ROOT));
            Boolean isPrimaryKey = (Boolean)ReflectUtil.callStaticMethod(classLoader, "com.intellij.database.util.DasUtil", "isPrimary", new Class[]{column.getClass()}, column);
            if (isPrimaryKey != null && isPrimaryKey.booleanValue()) {
                primaryKeys.add(columnName);
            }
            if ((isAuto = (Boolean)ReflectUtil.callStaticMethod(classLoader, "com.intellij.database.util.DasUtil", "isAuto", new Class[]{column.getClass()}, column)) != null && isAuto.booleanValue()) {
                colSb.append(" AUTO_INCREMENT");
            }
            if ((isNotNul = (Boolean)ReflectUtil.callMethod(column, "isNotNull", new Class[0], new Object[0])) != null && isNotNul.booleanValue()) {
                colSb.append(" NOT NULL");
            }
            if (StringUtils.isNotBlank((CharSequence)(colComment = (String)ReflectUtil.callMethod(column, "getComment", new Class[0], new Object[0])))) {
                String escapeComment = colComment.replace("'", "''");
                colSb.append(" COMMENT '").append(escapeComment).append("'");
            }
            columnContents.add(colSb.toString());
        }
        if (!primaryKeys.isEmpty()) {
            columnContents.add(String.format("  PRIMARY KEY (%s)", String.join((CharSequence)", ", primaryKeys)));
        }
        sb.append(String.join((CharSequence)",\n", columnContents));
        sb.append("\n);");
        return sb.toString();
    }

    public static boolean isSystemTable(String databaseType, String tableName, String schemaName, String databaseName) {
        if (StringUtils.isBlank((CharSequence)databaseType) || StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)schemaName)) {
            return false;
        }
        switch (databaseType.toLowerCase()) {
            case "mysql": 
            case "amazon aurora mysql": 
            case "mariadb": {
                return schemaName != null && (schemaName.equals("mysql") || schemaName.equals("information_schema") || schemaName.equals("performance_schema") || schemaName.equals("sys"));
            }
            case "postgresql": 
            case "amazon redshift": 
            case "cockroachdb": {
                return schemaName != null && (schemaName.equals("pg_catalog") || schemaName.equals("information_schema"));
            }
            case "oracle": {
                return schemaName != null && (schemaName.equals("SYS") || schemaName.equals("SYSTEM"));
            }
            case "microsoft sql server": 
            case "azure sql database": 
            case "azure synapse analytics": {
                return schemaName != null && (schemaName.equals("sys") || schemaName.equals("INFORMATION_SCHEMA"));
            }
            case "apache cassandra": {
                return schemaName != null && (schemaName.equals("system") || schemaName.equals("system_schema") || schemaName.equals("system_auth") || schemaName.equals("system_distributed"));
            }
            case "mongodb": {
                return tableName.startsWith("system.") || "admin".equals(databaseName) || "local".equals(databaseName);
            }
            case "snowflake": {
                return "SNOWFLAKE".equals(databaseName) || "INFORMATION_SCHEMA".equals(schemaName);
            }
            case "hive": {
                return "information_schema".equals(schemaName);
            }
            case "clickhouse": {
                return "system".equals(databaseName);
            }
            case "h2": 
            case "hsqldb": {
                return schemaName != null && schemaName.equalsIgnoreCase("INFORMATION_SCHEMA");
            }
            case "sqlite": {
                return tableName.startsWith("sqlite_");
            }
        }
        return false;
    }

    public static boolean isSystemTableInSupportedDatabases(String tableName, String schemaName, String databaseName) {
        for (String databaseType : SUPPORTED_DATABASES_FOR_SYSTEM_TABLE) {
            if (!DatabaseUtil.isSystemTable(databaseType, tableName, schemaName, databaseName)) continue;
            return true;
        }
        return false;
    }

    public static class DBTable {
        final Object dataSource;
        final Object dbTable;
        final ClassLoader classLoader;
        final Object dasObject;

        public DBTable(Object dataSource, Object dbTable, Object dasObject, ClassLoader classLoader) {
            this.dataSource = dataSource;
            this.dbTable = dbTable;
            this.dasObject = dasObject;
            this.classLoader = classLoader;
        }

        public Object getSchema() {
            return ReflectUtil.callMethod(this.dasObject, "getSchema", new Class[0], new Object[0]);
        }

        public String getCatalogName() {
            Class<?> basicMixinNamedElementClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.basic.BasicMixinNamedElement", this.classLoader);
            if (basicMixinNamedElementClass == null) {
                return null;
            }
            return (String)ReflectUtil.invokeDefaultMethod(this.dasObject, basicMixinNamedElementClass, "getCatalogName", new Class[0], new Object[0]);
        }

        public String getSchemaName() {
            Class<?> basicMixinSchemaObjectClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.basic.BasicMixinSchemaObject", this.classLoader);
            if (basicMixinSchemaObjectClass == null) {
                return null;
            }
            return (String)ReflectUtil.invokeDefaultMethod(this.dasObject, basicMixinSchemaObjectClass, "getSchemaName", new Class[0], new Object[0]);
        }

        public boolean isSystem() {
            Boolean result = (Boolean)ReflectUtil.callMethod(this.dasObject, "isSystem", new Class[0], new Object[0]);
            return result != null && result != false;
        }

        public boolean isTemporary() {
            Boolean result = (Boolean)ReflectUtil.callMethod(this.dasObject, "isTemporary", new Class[0], new Object[0]);
            return result != null && result != false;
        }

        public boolean isView() {
            Class<?> viewClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.basic.BasicView", this.classLoader);
            if (viewClass == null) {
                return false;
            }
            return viewClass.isAssignableFrom(this.dasObject.getClass());
        }

        public String getName() {
            return (String)ReflectUtil.callMethod(this.dbTable, "getName", new Class[0], new Object[0]);
        }

        public String getComment() {
            return (String)ReflectUtil.callMethod(this.dbTable, "getComment", new Class[0], new Object[0]);
        }

        public JBIterable<?> getColumns() {
            Class<?> dasObjectClass = ReflectUtil.classForNameQuietly("com.intellij.database.model.DasObject", this.classLoader);
            if (dasObjectClass == null) {
                return null;
            }
            return (JBIterable)ReflectUtil.callStaticMethod(this.classLoader, "com.intellij.database.util.DasUtil", "getColumns", new Class[]{dasObjectClass}, this.dbTable);
        }

        public String getScript(Project project) {
            return DatabaseUtil.generateScript(project, this.classLoader, this.dataSource, Collections.singletonList(this.dasObject));
        }

        public boolean isSystemTable() {
            if (this.isSystem()) {
                return true;
            }
            String schemaName = this.getSchemaName();
            String tableName = this.getName();
            return DatabaseUtil.isSystemTableInSupportedDatabases(tableName, schemaName, this.getCatalogName());
        }
    }

    static class DefaultCallInvocationHandler
    implements InvocationHandler {
        private final Consumer<Object> callback;

        public DefaultCallInvocationHandler(Consumer<Object> callback) {
            this.callback = callback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.callback.accept(args[0]);
            return null;
        }
    }
}

