/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;

public class CodeMarkdownRenderUtils {
    private static final Logger LOG = Logger.getInstance(CodeMarkdownRenderUtils.class);
    public static final String GRAPH_LANG_PLANTUML = "plantuml";
    public static final String GRAPH_LANG_MERMAID = "mermaid";
    public static final List<String> LANGUAGE_SUPPORT_CHART = new ArrayList<String>(){
        {
            this.add(CodeMarkdownRenderUtils.GRAPH_LANG_MERMAID);
        }
    };

    public static Icon render(String text, String language) {
        return CodeMarkdownRenderUtils.renderPlantUml(text, false);
    }

    public static Object render(String text, String language, boolean isDarkTheme, int maxWidth, int maxHeight) {
        if (language.equals(GRAPH_LANG_PLANTUML)) {
            return CodeMarkdownRenderUtils.renderPlantUml(text, isDarkTheme);
        }
        return null;
    }

    private static Icon renderPlantUml(String text, boolean isDarkTheme) {
        return CodeMarkdownRenderUtils.renderPlantUml(CodeMarkdownRenderUtils.addUmlTheme(text, isDarkTheme));
    }

    private static Icon renderPlantUml(String text) {
        SourceStringReader reader = new SourceStringReader(text);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DiagramDescription desc = reader.outputImage((OutputStream)os);
            if (desc == null || "(Error)".equals(desc.getDescription())) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        byte[] imageBytes = os.toByteArray();
        return new ImageIcon(imageBytes);
    }

    private static String addUmlTheme(String text, boolean isDarkTheme) {
        Pattern plantUmlPattern = Pattern.compile("@startuml\\s*(!theme \\w*\\s*)*\\s*((.|\\s)*)\\s*@enduml");
        Matcher m = plantUmlPattern.matcher(text);
        if (m.find()) {
            String body = m.group(2);
            return "@startuml\n!theme " + (isDarkTheme ? "crt-amber" : "plain") + "\nskinparam backgroundColor transparent\n" + body + "\n@enduml";
        }
        return text;
    }
}

