/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.SimpleTextDto;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelClassItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelClassResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.cosy.service.ModelService;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.chooser.ChatModelClassChooser;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ChatModelConfig;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ChatTaskExtra;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ExtraContext;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ExtraContextSelectedItem;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatModelClassNotifier;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.MapUtil;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChatTaskUtil {
    private static final Logger LOGGER = Logger.getInstance(ChatTaskUtil.class);

    public static GenerateInput getInitInput(Project project, String sessionTab) {
        Object chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(project))).filePath("")).sessionId(UUID.randomUUID().toString())).range(null)).methodContent(null)).docContent(null)).sourceCode(null)).inputComplete(false)).build();
        GenerateInput genInput = new GenerateInput("", null, (ChatContext)chatContext);
        genInput.setSessionTab(sessionTab);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        genInput.setQuestionObject(simpleTextDto);
        HashMap map = (HashMap)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
        if (map == null) {
            map = new HashMap();
            ApplicationManager.getApplication().putUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP, map);
        } else {
            map.remove(project.getName());
        }
        ChatSessionContext chatSessionContext = new ChatSessionContext();
        chatSessionContext.setTabType(sessionTab);
        ApplicationManager.getApplication().putUserData(CosyKey.CHAT_SESSION_CONTEXT, (Object)chatSessionContext);
        return genInput;
    }

    public static String getQuickAskChatTask(GenerateInput input) {
        boolean isReply = ChatTaskUtil.isReply(input);
        boolean isRetry = ChatTaskEnum.RETRY_TASK.getName().equals(input.getChatTask());
        boolean isFreeInput = ChatTaskEnum.FREE_INPUT.name().equals(input.getChatTask());
        boolean isTerminal = ChatTaskEnum.TERMINAL_COMMAND_GENERATION.name().equals(input.getChatTask());
        return isReply && !isRetry && !isFreeInput && !isTerminal ? ChatTaskEnum.REPLY_TASK.getName() : input.getChatTask();
    }

    public static boolean isReply(GenerateInput input) {
        return input.getChatHistory() != null && input.getChatHistory().getAskAnswerList() != null && !input.getChatHistory().getAskAnswerList().isEmpty();
    }

    public static List<ChatContextFeature> getFeatureFromTag(List<ChatAskTag> chatAskTags) {
        ArrayList<ChatContextFeature> features = new ArrayList<ChatContextFeature>();
        if (CollectionUtils.isEmpty(chatAskTags)) {
            return features;
        }
        for (ChatAskTag chatAskTag : chatAskTags) {
            ChatContextFeature feature = new ChatContextFeature();
            feature.setId(chatAskTag.getId());
            feature.setName(chatAskTag.getText());
            feature.setType(chatAskTag.getType());
            features.add(feature);
        }
        return features;
    }

    public static void configChatTaskExtraModel(Project project, GenerateInput input, String sessionType) {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            return;
        }
        if (CosyConfig.isQoderEnabled()) {
            List<ChatModelClassResult> modelClasses = Cosy.INSTANCE.getLanguageService(project).queryModelClasses(sessionType);
            ChatModelClassItem item = ChatModelClassChooser.getInitModeItem(modelClasses, validItem -> ((ChatModelClassNotifier)project.getMessageBus().syncPublisher(ChatModelClassNotifier.CHAT_MODEL_CLASS_NOTIFIER)).refreshModelClass((ChatModelClassItem)validItem));
            if (item != null) {
                if (input.getExtra() == null) {
                    input.setExtra(new ChatTaskExtra());
                }
                LOGGER.info("Select model class is " + item.getModelClassId());
                input.getExtra().setModelConfig(ChatModelConfig.builder().key(item.getModelClassId()).build());
            } else {
                LOGGER.warn("Cannot get config model class for " + sessionType);
            }
        } else {
            AuthStatus authStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
            if (null != authStatus && authStatus.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
                if (StringUtils.isBlank((CharSequence)authStatus.getOrgId())) {
                    List<ChatModelItem> modelList = ModelService.getInstance().getModelList(project, sessionType);
                    if (CollectionUtils.isEmpty(modelList)) {
                        LOGGER.warn("empty model map for " + sessionType);
                    } else {
                        if (input.getExtra() == null) {
                            input.setExtra(new ChatTaskExtra());
                        }
                        input.getExtra().setModelConfig(ChatModelConfig.builder().key(modelList.get(0).getKey()).build());
                    }
                } else {
                    ChatModelItem selectModel = ModelService.getInstance().getSelectionModelItem(project, sessionType);
                    if (selectModel != null) {
                        if (input.getExtra() == null) {
                            input.setExtra(new ChatTaskExtra());
                        }
                        LOGGER.info("Select model is " + selectModel.getKey());
                        input.getExtra().setModelConfig(ChatModelConfig.builder().key(selectModel.getKey()).build());
                    } else {
                        LOGGER.warn("Cannot get config model for " + sessionType);
                    }
                }
            } else {
                LOGGER.warn("Failed to get model chooser, authStatus is null or not login");
            }
        }
    }

    public static ChatTaskExtra getChatTaskExtras(ChatAskInput chatAskInput) {
        ChatTaskExtra chatTaskExtra = new ChatTaskExtra();
        ArrayList<ExtraContext> extraContextList = new ArrayList<ExtraContext>();
        Iterator<ChatContextTag> iterator = chatAskInput.getContextTags().iterator();
        while (iterator.hasNext()) {
            String sourceType;
            ChatContextTag oneContextTag = iterator.next();
            String string = sourceType = null == oneContextTag.getContextProvider() ? oneContextTag.getSourceType() : oneContextTag.getContextProvider().getSourceType();
            if (!oneContextTag.getActualValid().booleanValue()) {
                iterator.remove();
                continue;
            }
            HashMap<String, Object> selectedItemExtraMap = new HashMap<String, Object>();
            String selectedItemContent = null;
            selectedItemExtraMap.put("contextType", oneContextTag.getType());
            selectedItemExtraMap.put("content", oneContextTag.getPayload());
            Map<String, Object> extraMap = oneContextTag.getExtra();
            if (extraMap != null && extraMap.containsKey("contentData")) {
                selectedItemExtraMap.put("contentData", extraMap.get("contentData"));
            }
            String contextType = "";
            Map<String, Object> extra = oneContextTag.getExtra();
            if (null != extra) {
                contextType = MapUtil.getStringOrDefault(extra, "contextType", "");
                if (StringUtils.isNotBlank((CharSequence)contextType)) {
                    selectedItemExtraMap.put("contextType", contextType);
                }
                if (ChatContextTypeEnum.CURRENT_FILE.getType().equals(contextType)) {
                    contextType = null != extra.get("startLine") && null != extra.get("endLine") ? ChatContextTypeEnum.SELECTED_CODE.getType() : ChatContextTypeEnum.FILE.getType();
                }
                if (ChatContextTypeEnum.IMAGE.getType().equals(contextType)) {
                    selectedItemExtraMap.put("fileType", "image");
                    selectedItemExtraMap.put("imgUrl", MapUtil.getStringOrDefault(extra, "imgUrl", ""));
                    selectedItemExtraMap.put("filePath", MapUtil.getStringOrDefault(extra, "filePath", ""));
                } else if (ChatContextTypeEnum.FILE.getType().equals(contextType)) {
                    selectedItemExtraMap.put("fileType", MapUtil.getStringOrDefault(extra, "fileType", ChatContextTypeEnum.FILE.getType()));
                    selectedItemExtraMap.put("filePath", MapUtil.getStringOrDefault(extra, "filePath", ""));
                } else if (ChatContextTypeEnum.SELECTED_CODE.getType().equals(contextType)) {
                    Integer startLine = null;
                    Integer endLine = null;
                    try {
                        startLine = Integer.valueOf(MapUtil.getStringOrDefault(extra, "startLine", ""));
                        endLine = Integer.valueOf(MapUtil.getStringOrDefault(extra, "endLine", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    selectedItemExtraMap.put("startLine", startLine);
                    selectedItemExtraMap.put("endLine", endLine);
                    selectedItemExtraMap.put("filePath", MapUtil.getStringOrDefault(extra, "filePath", ""));
                    selectedItemContent = MapUtil.getStringOrDefault(extra, "selectedItemContent", "");
                    if (extra.containsKey("fullContent")) {
                        selectedItemExtraMap.put("fullContent", extra.get("fullContent"));
                    }
                }
            }
            ExtraContext extraContext = ChatContextTypeEnum.TEAM_DOCS.getType().equals(contextType) ? new ExtraContext(oneContextTag.getContextProvider().getId(), ChatContextTypeEnum.TEAM_DOCS.getType(), oneContextTag.getComponentType(), ExtraContextSelectedItem.builder().name(oneContextTag.getName()).identifier(oneContextTag.getId()).extra(oneContextTag.getExtra()).build(), sourceType) : ChatTaskUtil.getExtraContext(oneContextTag, selectedItemExtraMap, selectedItemContent);
            extraContextList.add(extraContext);
        }
        chatTaskExtra.setContext(extraContextList);
        return chatTaskExtra;
    }

    @NotNull
    private static ExtraContext getExtraContext(ChatContextTag oneContextTag, Map<String, Object> selectedItemExtraMap, String selectedItemContent) {
        String sourceType;
        ExtraContextSelectedItem extraSelectedItem = null;
        String componentType = oneContextTag.getComponentType();
        String string = sourceType = null == oneContextTag.getContextProvider() ? oneContextTag.getSourceType() : oneContextTag.getContextProvider().getSourceType();
        if ("comboBox".equals(componentType)) {
            extraSelectedItem = new ExtraContextSelectedItem(oneContextTag.getName(), oneContextTag.getId(), null, selectedItemExtraMap, selectedItemContent);
        } else {
            if ("general".equals(componentType)) {
                return new ExtraContext(oneContextTag.getId(), oneContextTag.getType(), oneContextTag.getComponentType(), null, sourceType);
            }
            extraSelectedItem = new ExtraContextSelectedItem(oneContextTag.getName(), oneContextTag.getId(), null, selectedItemExtraMap, null);
        }
        return new ExtraContext(null == oneContextTag.getContextProvider() ? null : oneContextTag.getContextProvider().getId(), null == oneContextTag.getContextProvider() ? null : oneContextTag.getContextProvider().getContextName(), componentType, extraSelectedItem, sourceType);
    }

    public static List<String> getChatTaskImageUrls(ChatAskInput chatAskInput) {
        ArrayList<String> imageUrls = new ArrayList<String>();
        chatAskInput.getContextTags().forEach(oneContextTag -> {
            if (null != oneContextTag.getExtra()) {
                String imageUrl;
                String contextType = MapUtil.getStringOrDefault(oneContextTag.getExtra(), "contextType", "");
                if (ChatContextTypeEnum.IMAGE.getType().equals(contextType) && StringUtils.isNotBlank((CharSequence)(imageUrl = MapUtil.getStringOrDefault(oneContextTag.getExtra(), "imgUrl", "")))) {
                    imageUrls.add(imageUrl);
                }
            }
        });
        return imageUrls;
    }

    public static List<ChatInputElement> convertTextToElements(ChatInputTextArea textArea) {
        List<ChatInputElement> elements = textArea.getElements();
        if ((elements = ChatTaskUtil.mergeElements(elements)).isEmpty()) {
            return elements;
        }
        boolean match = elements.stream().anyMatch(element -> {
            if (element.getType().equals("tag")) {
                ChatAskTag tag = element.getTag();
                return "agent".equals(tag.getType()) || "task".equals(tag.getType());
            }
            return false;
        });
        if (match) {
            return elements;
        }
        Project project = textArea.getChatInputContext().getProject();
        ArrayList<ChatInputElement> newElements = new ArrayList<ChatInputElement>();
        for (int i = 0; i < elements.size(); ++i) {
            ChatInputElement element2 = elements.get(i);
            if (i == 0) {
                String elText;
                boolean detected = false;
                if (element2.getType().equals("text") && (elText = element2.getText()) != null && (elText.startsWith("@") || elText.startsWith("/"))) {
                    ChatTaskUtil.detectTagsFromText(project, textArea, newElements, elText, textArea.getChatInputContext().getBaseChatPanel().getSessionType());
                    detected = true;
                }
                if (detected) continue;
                newElements.add(element2);
                continue;
            }
            newElements.add(element2);
        }
        return newElements;
    }

    public static List<ChatInputElement> mergeElements(List<ChatInputElement> elements) {
        ArrayList<ChatInputElement> newElements = new ArrayList<ChatInputElement>();
        ChatInputElement lastElement = null;
        for (int i = 0; i < elements.size(); ++i) {
            ChatInputElement element = elements.get(i);
            if (lastElement != null && element.getType().equals(lastElement.getType()) && element.getType().equals("text")) {
                lastElement.setText(lastElement.getText() + element.getText());
                continue;
            }
            newElements.add(element);
            lastElement = element;
        }
        return newElements;
    }

    public static void detectTagsFromText(Project project, ChatInputTextArea textArea, List<ChatInputElement> newElements, String text, String sessionType) {
        String[] words = text.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.startsWith("@") || word.startsWith("/")) {
                if (sb.length() > 0) {
                    newElements.add(ChatInputElement.builder().text(sb.toString()).type("text").build());
                }
                sb = new StringBuilder();
            }
            sb.append(word).append(" ");
            if (!ChatTaskUtil.detectTagFromText(project, textArea, newElements, sb.toString().trim(), sessionType)) continue;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            newElements.add(ChatInputElement.builder().text(sb.toString()).type("text").build());
        }
    }

    public static boolean detectTagFromText(Project project, ChatInputTextArea textArea, List<ChatInputElement> newElements, String text, String sessionType) {
        String queryText = text;
        if (queryText.startsWith("@") || queryText.startsWith("/")) {
            queryText = queryText.substring(1);
        }
        if (text.startsWith("@") && !ChatContextTypeEnum.TEAM_DOCS.getType().equals(queryText)) {
            return false;
        }
        SuggestPrompt suggestPrompt = SuggestPromptUtil.getAllSuggestPromptOfTag(project, sessionType).get(queryText);
        if (suggestPrompt == null) {
            return false;
        }
        ChatAskTag chatAskTag = ChatAskTag.buildTag(suggestPrompt.getId(), text);
        if (chatAskTag != null) {
            newElements.add(ChatInputElement.builder().tag(chatAskTag).type("tag").build());
            return true;
        }
        return false;
    }

    public static List<ChatAskTag> getTagsByElements(List<ChatInputElement> elements) {
        return elements.stream().filter(element -> element.getType().equals("tag")).map(ChatInputElement::getTag).collect(Collectors.toList());
    }
}

