/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.BaseChatTaskDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.CodeProblemSolveDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.CodeRelatedDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.ExplainCodeDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.TestcaseGenerationDto;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatRecord;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ChatTaskExtra;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ExtraContext;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.MapUtil;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatSessionUtil {
    private static final Logger log = Logger.getInstance(ChatSessionUtil.class);
    private static String CHAT_CONTEXT_FIELD_TEXT_FIELD = "text";
    private static String CHAT_CONTEXT_FIELD_DISPLAY_TEXT = "displayText";

    public static ChatAskInput getChatAskInputFromRecord(ChatRecord chatRecord, Project project) {
        if (chatRecord == null || chatRecord.getChatContext() == null) {
            return null;
        }
        JSONObject chatContextJson = JSON.parseObject((String)chatRecord.getChatContext());
        String text = null;
        if (chatContextJson != null) {
            if (ChatTaskEnum.REPLY_TASK.getName().equals(chatRecord.getChatTask()) || ChatTaskEnum.RETRY_TASK.getName().equals(chatRecord.getChatTask())) {
                text = chatContextJson.getString(CHAT_CONTEXT_FIELD_DISPLAY_TEXT);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = chatRecord.getQuestion();
                }
            } else {
                text = chatContextJson.getString(CHAT_CONTEXT_FIELD_TEXT_FIELD);
            }
        }
        List<ChatAskTag> tags = ChatSessionUtil.getChatTagsFromRecord(chatRecord, project);
        List<ChatContextTag> contextTags = ChatSessionUtil.getChatContextTagsFromRecord(chatRecord, project);
        return new ChatAskInput(text, tags, contextTags);
    }

    public static String getExtraTextFromRecord(ChatRecord chatRecord) {
        if (chatRecord == null) {
            return null;
        }
        if (chatRecord.getChatTask() == null || chatRecord.getChatContext() == null) {
            return chatRecord.getQuestion();
        }
        String chatTask = chatRecord.getChatTask();
        String code = null;
        StringBuilder textBuilder = new StringBuilder();
        if (ChatTaskEnum.GENERATE_TESTCASE.getName().equals(chatTask)) {
            TestcaseGenerationDto testcaseGenerationDto = (TestcaseGenerationDto)JSON.parseObject((String)chatRecord.getChatContext(), TestcaseGenerationDto.class);
            if (testcaseGenerationDto != null) {
                code = testcaseGenerationDto.getSelectionCode();
            }
        } else if (ChatTaskEnum.EXPLAIN_CODE.getName().equals(chatTask)) {
            ExplainCodeDto explainCodeDto = (ExplainCodeDto)JSON.parseObject((String)chatRecord.getChatContext(), ExplainCodeDto.class);
            if (explainCodeDto != null) {
                code = explainCodeDto.getCode();
            }
        } else if (InputConstants.SIMPLE_CODE_RELATED_TASKS.contains(chatTask)) {
            CodeRelatedDto codeRelatedDto = (CodeRelatedDto)JSON.parseObject((String)chatRecord.getChatContext(), CodeRelatedDto.class);
            if (codeRelatedDto != null) {
                code = codeRelatedDto.getCode();
            }
        } else if (ChatTaskEnum.CODE_PROBLEM_SOLVE.getName().equals(chatTask)) {
            CodeProblemSolveDto codeProblemSolveDto = (CodeProblemSolveDto)JSON.parseObject((String)chatRecord.getChatContext(), CodeProblemSolveDto.class);
            StringBuilder codeProblemsText = new StringBuilder();
            codeProblemsText.append(CosyBundle.message("code.problems.solve.text", new Object[0]));
            codeProblemsText.append("\n");
            if (CollectionUtils.isNotEmpty(codeProblemSolveDto.getErrorMessages())) {
                List<String> errorMessages = codeProblemSolveDto.getErrorMessages();
                for (int index = 0; index < errorMessages.size(); ++index) {
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append(index + 1);
                    errorMessage.append(". ");
                    errorMessage.append(errorMessages.get(index));
                    errorMessage.append("\n");
                    codeProblemsText.append((CharSequence)errorMessage);
                }
            }
            code = codeProblemSolveDto.getCode();
            textBuilder.append((CharSequence)codeProblemsText);
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            textBuilder.append("```\n");
            textBuilder.append(code);
            textBuilder.append("```\n");
        }
        return textBuilder.toString();
    }

    public static List<ChatAskTag> getChatTagsFromRecord(ChatRecord chatRecord, Project project) {
        if (chatRecord == null) {
            return null;
        }
        if (chatRecord.getChatTask() == null || chatRecord.getChatContext() == null) {
            return null;
        }
        BaseChatTaskDto baseChatTaskDto = (BaseChatTaskDto)JSON.parseObject((String)chatRecord.getChatContext(), BaseChatTaskDto.class);
        if (baseChatTaskDto == null) {
            return null;
        }
        ArrayList<ChatAskTag> tags = new ArrayList<ChatAskTag>();
        if (CollectionUtils.isNotEmpty(baseChatTaskDto.getFeatures())) {
            List<ChatContextFeature> features = baseChatTaskDto.getFeatures();
            for (ChatContextFeature feature : features) {
                ChatAskTag chatAskTag = ChatAskTag.buildTag(feature.getId(), feature.getName());
                if (chatAskTag == null) continue;
                tags.add(chatAskTag);
            }
        } else {
            ChatAskTag chatAskTag;
            SuggestPrompt suggestPrompt;
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(chatRecord.getChatTask());
            if (StringUtils.isNotBlank((CharSequence)text) && text.length() > 1 && (suggestPrompt = SuggestPromptUtil.getAllSuggestPrompt(project, chatRecord.getSessionType()).get(text.substring(1))) != null && (chatAskTag = ChatAskTag.buildTag(suggestPrompt.getId(), text)) != null) {
                tags.add(chatAskTag);
            }
        }
        return tags;
    }

    public static List<ChatContextTag> getChatContextTagsFromRecord(ChatRecord chatRecord, Project project) {
        ChatTaskExtra chatTaskExtra;
        if (chatRecord == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)chatRecord.getExtra())) {
            return null;
        }
        try {
            chatTaskExtra = (ChatTaskExtra)JSON.parseObject((String)chatRecord.getExtra(), ChatTaskExtra.class);
            if (chatTaskExtra == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<ChatContextTag> tags = new ArrayList<ChatContextTag>();
        if (CollectionUtils.isNotEmpty(chatTaskExtra.getContext())) {
            List<ExtraContext> contexts = chatTaskExtra.getContext();
            for (ExtraContext context : contexts) {
                try {
                    String endLine;
                    ChatContextTag chatContextTag;
                    HashMap<String, Object> extra;
                    if (context.getSelectedItem() == null || StringUtils.isEmpty((CharSequence)context.getSelectedItem().getIdentifier())) {
                        extra = new HashMap<String, String>();
                        extra.put("contextType", context.getName());
                        chatContextTag = ChatContextTag.builder().id(context.getIdentifier()).text(context.getName()).type(context.getName()).componentType(context.getComponentType()).payload(context.getIdentifier()).extra(extra).sourceType(context.getSourceType()).build();
                        tags.add(chatContextTag);
                        continue;
                    }
                    extra = context.getSelectedItem().getExtra();
                    chatContextTag = new ChatContextTag();
                    chatContextTag.setId(context.getSelectedItem().getIdentifier());
                    chatContextTag.setComponentType(context.getComponentType());
                    String contextType = MapUtil.getStringOrDefault(extra, "contextType", ChatContextTypeEnum.FILE.getType());
                    chatContextTag.setType(contextType);
                    chatContextTag.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.getOrDefault(contextType, null));
                    chatContextTag.setPayload(extra.getOrDefault("content", null));
                    extra.remove("content");
                    chatContextTag.setExtra(extra);
                    String startLine = MapUtil.getStringOrDefault(extra, "startLine", "");
                    if (StringUtils.isNotBlank((CharSequence)startLine)) {
                        chatContextTag.setStatLine(Integer.valueOf(startLine));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(endLine = MapUtil.getStringOrDefault(extra, "endLine", "")))) {
                        chatContextTag.setEndLine(Integer.valueOf(endLine));
                    }
                    if (StringUtils.isBlank((CharSequence)chatContextTag.getText())) {
                        chatContextTag.setText(context.getSelectedItem().getName());
                    }
                    tags.add(chatContextTag);
                }
                catch (Exception exception) {}
            }
        }
        return tags;
    }

    public static void updateAnsweringStatus(String requestId) {
        if (StringUtils.isBlank((CharSequence)requestId)) {
            log.warn("requestId is blank when updateAnsweringStatus");
            return;
        }
        ConcurrentHashMap<String, Long> requestAnsweringMap = (ConcurrentHashMap<String, Long>)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING);
        if (requestAnsweringMap == null) {
            requestAnsweringMap = new ConcurrentHashMap<String, Long>();
        }
        requestAnsweringMap.put(requestId, System.currentTimeMillis());
    }

    public static String getRequestId(String sessionType) {
        Map<String, String> map = (Map<String, String>)CosyCacheKeys.KEY_CHAT_REQUEST_ID_MAP.get((UserDataHolder)ApplicationManager.getApplication());
        if (null == map) {
            map = ChatSessionUtil.initAndGetRequestIdMap();
        }
        return map.computeIfAbsent(sessionType, key -> UUID.randomUUID().toString());
    }

    public static void updateRequestId(String sessionType) {
        Map<String, String> map = (Map<String, String>)CosyCacheKeys.KEY_CHAT_REQUEST_ID_MAP.get((UserDataHolder)ApplicationManager.getApplication());
        if (null == map) {
            map = ChatSessionUtil.initAndGetRequestIdMap();
        }
        map.put(sessionType, UUID.randomUUID().toString());
    }

    public static synchronized Map<String, String> initAndGetRequestIdMap() {
        Map map = (Map)CosyCacheKeys.KEY_CHAT_REQUEST_ID_MAP.get((UserDataHolder)ApplicationManager.getApplication());
        if (null != map) {
            return map;
        }
        HashMap<String, String> requestIdMap = new HashMap<String, String>(){
            private static final long serialVersionUID = -4156224460839905563L;
            {
                this.put(SessionTypeEnum.CHAT.getType(), UUID.randomUUID().toString());
                this.put(SessionTypeEnum.DEVELOPER.getType(), UUID.randomUUID().toString());
                this.put(SessionTypeEnum.ASSISTANT.getType(), UUID.randomUUID().toString());
            }
        };
        CosyCacheKeys.KEY_CHAT_REQUEST_ID_MAP.set((UserDataHolder)ApplicationManager.getApplication(), (Object)requestIdMap);
        return requestIdMap;
    }
}

