/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.renderer;

import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SuggestPromptPopupPanelSourceEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.MapUtil;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.AllOccurrencesMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputSuggestPromptListCellRender
extends DefaultListCellRenderer {
    private static final Logger LOG = Logger.getInstance(InputSuggestPromptListCellRender.class);
    private static final int MIN_RESERVED_TEXT_WIDTH = 30;
    Project project;
    JComponent hostComponent;
    SuggestPromptPopupPanel suggestPromptPopupPanel;

    public InputSuggestPromptListCellRender(Project project, JComponent hostComponent, SuggestPromptPopupPanel suggestPromptPopupPanel) {
        this.project = project;
        this.hostComponent = hostComponent;
        this.suggestPromptPopupPanel = suggestPromptPopupPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> paramJList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
        if (!(paramObject instanceof SuggestPrompt)) {
            return super.getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        }
        SuggestPrompt suggestPrompt = (SuggestPrompt)paramObject;
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout());
        opaquePanel.setBorder(BorderFactory.createEmptyBorder(6, 4, 6, 4));
        Component component = new SuggestPromptCellRender(this.hostComponent).getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        Color bgColor = component.getBackground();
        opaquePanel.add(component, (Object)"West");
        JPanel hintPanel = new JPanel((LayoutManager)new HorizontalLayout(5));
        hintPanel.setOpaque(false);
        opaquePanel.add((Component)hintPanel, (Object)"East");
        boolean hasSelected = this.suggestPromptPopupPanel.getChatInputContext().getInputMainPanel().getInputTagsPanel().getSelectedTagIds().contains(suggestPrompt.getId());
        if ("EMPTY_ITEM".equals(suggestPrompt.getId())) {
            opaquePanel.setBackground(bgColor);
        } else if (isSelected && !cellHasFocus) {
            component.setBackground(ColorUtil.getEditorBackgroundColor());
            opaquePanel.setBackground(ColorUtil.getEditorBackgroundColor());
        } else {
            opaquePanel.setBackground(bgColor);
        }
        if (!"EMPTY_ITEM".equals(suggestPrompt.getId())) {
            if (StringUtils.isEmpty((CharSequence)suggestPrompt.getLinkText())) {
                if (SuggestPromptPopupPanelSourceEnum.INPUT == this.suggestPromptPopupPanel.getSource()) {
                    if (isSelected || cellHasFocus) {
                        this.addSelectHint(component, (SuggestPrompt)paramObject, hintPanel);
                    } else {
                        this.addHintText(component, (SuggestPrompt)paramObject, hintPanel);
                    }
                } else if (SuggestPromptPopupPanelSourceEnum.BUTTON == this.suggestPromptPopupPanel.getSource()) {
                    if (cellHasFocus && hasSelected && !"TOP_BAR_ITEM".equals(suggestPrompt.getId()) && SuggestPromptUtil.isSupportDrillDown(this.project, suggestPrompt.getContextName())) {
                        this.addSelectedLabel(suggestPrompt, hintPanel);
                    } else if (isSelected) {
                        if (hasSelected && SuggestPromptUtil.isSupportDrillDown(this.project, suggestPrompt.getContextName())) {
                            this.addSelectedLabel(suggestPrompt, hintPanel);
                        } else {
                            this.addSelectHint(component, suggestPrompt, hintPanel);
                        }
                    } else if (hasSelected && SuggestPromptUtil.isSupportDrillDown(this.project, suggestPrompt.getContextName())) {
                        this.addSelectedLabel(suggestPrompt, hintPanel);
                    } else {
                        this.addHintText(component, suggestPrompt, hintPanel);
                    }
                }
            } else {
                this.addHintText(component, suggestPrompt, hintPanel);
            }
        }
        return opaquePanel;
    }

    private void addSelectedLabel(SuggestPrompt suggestPrompt, JPanel hintPanel) {
        if (BooleanUtils.isNotTrue((Boolean)suggestPrompt.getDrillDownEnable())) {
            hintPanel.removeAll();
            hintPanel.add(this.suggestPromptPopupPanel.getSelectedLabel());
        }
    }

    private void addHintText(Component component, SuggestPrompt suggestPrompt, JPanel hintPanel) {
        if (BooleanUtils.isTrue((Boolean)suggestPrompt.getDrillDownEnable())) {
            JLabel drillDownLabel = new JLabel(CommonIcons.arrowRightIcon);
            hintPanel.add(drillDownLabel);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)suggestPrompt.getHint())) {
            String hint = suggestPrompt.getHint();
            String basePath = this.project.getBasePath();
            if (null != basePath && (ChatContextTypeEnum.FILE.getType().equals(suggestPrompt.getContextName()) || ChatContextTypeEnum.FOLDER.getType().equals(suggestPrompt.getContextName()))) {
                hint = hint.replace(basePath, "");
            }
            float maxWidth = this.hostComponent.getWidth() - component.getPreferredSize().width - 24;
            hint = FontUtil.getStringAdaptiveWidth(this, hint, (int)maxWidth, true);
            JLabel hintLabel = new JLabel(hint);
            hintLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            hintLabel.setFont(component.getFont().deriveFont(12.0f));
            JLabel learnMoreLabel = null;
            if (StringUtils.isNotBlank((CharSequence)suggestPrompt.getLinkText())) {
                learnMoreLabel = new JLabel(CosyBundle.message("individual.team.doc.learn.more", new Object[0]));
                hintLabel.setFont(component.getFont().deriveFont(12.0f));
                learnMoreLabel.setForeground(ColorUtil.getLinkForegroundColor());
                learnMoreLabel.setFont(component.getFont());
            }
            hintPanel.add(hintLabel);
            if (learnMoreLabel != null) {
                hintPanel.add(learnMoreLabel);
            }
        }
    }

    private void addSelectHint(Component component, SuggestPrompt suggestPrompt, JPanel hintPanel) {
        String selectHint = BooleanUtils.isTrue((Boolean)suggestPrompt.getDrillDownEnable()) ? CosyBundle.message("suggest.prompt.popup.enter.pick", new Object[0]) : CosyBundle.message("suggest.prompt.popup.enter.add", new Object[0]);
        Icon icon = CommonIcons.newLineIcon;
        if ("TOP_BAR_ITEM".equals(suggestPrompt.getId())) {
            selectHint = CosyBundle.message("suggest.prompt.popup.enter.back", new Object[0]);
        } else if (ChatContextTypeEnum.IMAGE.getType().equals(suggestPrompt.getContextName()) && BooleanUtils.isFalse((Boolean)suggestPrompt.isEnabled())) {
            selectHint = String.format(CosyBundle.message("suggest.prompt.popup.max.image.limit", new Object[0]), 5);
            icon = null;
        }
        JLabel hintLabel = new JLabel(icon);
        hintLabel.setText(selectHint);
        hintLabel.setFont(component.getFont().deriveFont(12.0f));
        hintLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        hintPanel.add(hintLabel);
    }

    public static void appendColoredFragmentForMatcher(@NotNull @NlsContexts.Label String text, SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, @Nullable Matcher matcher, Color selectedBg) {
        if (text == null) {
            InputSuggestPromptListCellRender.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            InputSuggestPromptListCellRender.$$$reportNull$$$0(1);
        }
        if (!(matcher instanceof MinusculeMatcher)) {
            component.append(text, attributes);
            return;
        }
        FList iterable = ((MinusculeMatcher)matcher).matchingFragments(text);
        component.setDynamicSearchMatchHighlighting(iterable != null);
        if (iterable != null) {
            Color fg = attributes.getFgColor();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(selectedBg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)component, (String)text, (Iterable)iterable, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        } else {
            component.append(text, attributes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attributes";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/cosy/ui/search/renderer/InputSuggestPromptListCellRender";
        objectArray[2] = "appendColoredFragmentForMatcher";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class SuggestPromptCellRender
    extends ColoredListCellRenderer {
        private static final String PROMPT_ELLIPSIS = "...";
        private static final int NLP_ITEM_SUB_PADDING = 60;
        JComponent hostComponent;

        private SuggestPromptCellRender(JComponent hostComponent) {
            this.hostComponent = hostComponent;
        }

        protected void customizeCellRenderer(@NotNull JList param1JList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
            if (param1JList == null) {
                SuggestPromptCellRender.$$$reportNull$$$0(0);
            }
            this.mySelectionForeground = ColorUtil.getListForeground();
            Matcher matcher = MatcherHolder.getAssociatedMatcher((JComponent)param1JList);
            String pattern = InputSuggestPromptListCellRender.this.suggestPromptPopupPanel.getQuery();
            if (null == matcher && StringUtils.isNotEmpty((CharSequence)pattern)) {
                matcher = AllOccurrencesMatcher.create((String)("*" + pattern + "*"), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE, (String)"");
            }
            Color color2 = ColorUtil.getListBackground();
            Color color1 = ColorUtil.getListForeground();
            this.setPaintFocusBorder(cellHasFocus && UIUtil.isToUseDottedCellBorder());
            if (paramObject instanceof SuggestPrompt) {
                SuggestPrompt suggestPrompt = (SuggestPrompt)paramObject;
                String text = suggestPrompt.getText();
                Color foregroundColor = suggestPrompt.isEnabled() ? color1 : ColorUtil.getInactiveForegroundColor();
                SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, foregroundColor);
                String niceName = this.truncateText(text, isSelected);
                float maxWidth = (float)this.hostComponent.getWidth() * 0.7f;
                niceName = FontUtil.getStringAdaptiveWidth((JComponent)((Object)this), niceName, (int)maxWidth, false);
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)niceName, (SimpleColoredComponent)this, (SimpleTextAttributes)simpleTextAttributes, (Matcher)matcher, (Color)color2, (boolean)isSelected);
                this.setIconTextGap(JBUIScale.scale((int)4));
                this.setCellIcon(suggestPrompt);
                if ("EMPTY_ITEM".equals(suggestPrompt.getId())) {
                    this.setBackground(color2);
                } else {
                    this.setBackground(isSelected || cellHasFocus ? ColorUtil.getEditorBackgroundColor() : color2);
                }
            }
        }

        private void setCellIcon(SuggestPrompt suggestPrompt) {
            Icon icon;
            ChatContextTypeEnum typeEnum;
            if ("TOP_BAR_ITEM".equals(suggestPrompt.getId())) {
                this.setIcon(CommonIcons.returnIcon);
                return;
            }
            SuggestPrompt contextProvider = suggestPrompt.getContextProvider();
            if (contextProvider == null || contextProvider.getText() == null) {
                return;
            }
            String contextType = MapUtil.getStringOrDefault(suggestPrompt.getExtra(), "contextType", ChatContextTypeEnum.FILE.getType());
            if (contextType != null && (typeEnum = ChatContextTypeEnum.getByType(contextType)) != null && typeEnum.getProvider() != null && (icon = typeEnum.getProvider().getIconOfSuggestPrompt(InputSuggestPromptListCellRender.this.project, suggestPrompt)) != null) {
                this.setIcon(icon);
            }
        }

        private String truncateText(String text, boolean isSelected) {
            if (isSelected) {
                int searchBarWidth = Math.max(this.hostComponent.getSize().width, this.hostComponent.getPreferredSize().width);
                int popupWidth = InputSuggestPromptListCellRender.this.suggestPromptPopupPanel.getListComponent() == null ? 0 : InputSuggestPromptListCellRender.this.suggestPromptPopupPanel.getListComponent().getPreferredSize().width;
                int reservedWidth = (int)SwingUtil.getStringFontSize(PROMPT_ELLIPSIS, this.getFont()).getWidth();
                int remainWidth = Math.max(popupWidth, searchBarWidth) - reservedWidth - 60;
                remainWidth = Math.max(30, remainWidth);
                StringBuilder sb = new StringBuilder();
                int bufferWidth = 0;
                for (char ch : text.toCharArray()) {
                    int charWidth = (int)SwingUtil.getStringFontSize(String.valueOf(ch), this.getFont()).getWidth();
                    if ((bufferWidth += charWidth) >= remainWidth) continue;
                    sb.append(ch);
                }
                if (!sb.toString().equals(text)) {
                    sb.append(PROMPT_ELLIPSIS);
                }
                return sb.toString();
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param1JList", "com/alibabacloud/intellij/cosy/ui/search/renderer/InputSuggestPromptListCellRender$SuggestPromptCellRender", "customizeCellRenderer"));
        }
    }
}

