/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.model.tag;

import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ScopeChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.TaskChatAskTag;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ChatAskTag {
    String id;
    String text;
    String type;
    String displayText;

    public static ChatAskTag buildTag(String id, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        if (text.startsWith("/")) {
            return new TaskChatAskTag(id, text);
        }
        if (text.startsWith("@")) {
            return new ScopeChatAskTag(id, text);
        }
        if (text.startsWith("#")) {
            return new ScopeChatAskTag(id, text);
        }
        return null;
    }

    public static ChatAskTag buildTagFromContext(ChatContextTag contextTag) {
        String contextType = ChatContextTag.getContextType(contextTag.getExtra());
        Object displayText = contextTag.getText();
        if (ChatContextTypeEnum.FILE.getType().equals(contextType) || ChatContextTypeEnum.IMAGE.getType().equals(contextType)) {
            displayText = "@" + contextTag.getText();
        } else if (ChatContextTypeEnum.SELECTED_CODE.getType().equals(contextType)) {
            displayText = "@" + contextTag.getText() + " " + contextTag.getStatLine() + "-" + contextTag.getEndLine();
        }
        if (!((String)displayText).startsWith("@")) {
            displayText = "@" + (String)displayText;
        }
        return ScopeChatAskTag.builder().id(contextTag.getId()).text(contextTag.getText()).displayText((String)displayText).contextProvider(contextTag.getContextProvider()).componentType(contextTag.getComponentType()).extra(contextTag.getExtra()).build();
    }

    public static Boolean nonContext(List<ChatAskTag> tags) {
        if (tags == null) {
            return false;
        }
        return tags.stream().anyMatch(chatAskTag -> {
            if ("task".equals(chatAskTag.getType()) && InputConstants.CHAT_TASK_QUERY_MAP.containsKey(chatAskTag.getId())) {
                return true;
            }
            return "agent".equals(chatAskTag.getType()) && InputConstants.AGENT_NO_CONTEXT_TAG_LIST.contains(chatAskTag.getText());
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDisplayText() {
        return this.displayText;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatAskTag)) {
            return false;
        }
        ChatAskTag other = (ChatAskTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$displayText = this.getDisplayText();
        String other$displayText = other.getDisplayText();
        return !(this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatAskTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $displayText = this.getDisplayText();
        result = result * 59 + ($displayText == null ? 43 : $displayText.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatAskTag(id=" + this.getId() + ", text=" + this.getText() + ", type=" + this.getType() + ", displayText=" + this.getDisplayText() + ")";
    }

    @Generated
    public ChatAskTag() {
    }

    @Generated
    public ChatAskTag(String id, String text, String type, String displayText) {
        this.id = id;
        this.text = text;
        this.type = type;
        this.displayText = displayText;
    }
}

