/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.model;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.SnapshotInfo;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.intellij.util.IconUtil;
import icons.LingmaIcons;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Snapshot
implements Serializable {
    private String id;
    private int index;
    private String sessionId;
    private String requestId;
    private String originName;
    private String name;
    private String status;
    private String description;
    private boolean current;
    private boolean latest;
    private boolean invalid;
    private boolean displayInList;

    public Icon buildStatusIcon() {
        SnapshotStatusEnum statusEnum = SnapshotStatusEnum.getById(this.status);
        if (statusEnum != null) {
            switch (statusEnum) {
                case INIT: {
                    return LingmaIcons.Target16Icon;
                }
                case GENERATING: 
                case APPLYING: {
                    return null;
                }
                case APPLIED: {
                    return LingmaIcons.AcceptNoGreen16Icon;
                }
                case ACCEPTED: {
                    return LingmaIcons.AcceptGreen16Icon;
                }
                case PARTIALLY_ACCEPTED: {
                    return LingmaIcons.AcceptPartGreen16Icon;
                }
                case GENERATING_CANCELLED: 
                case APPLYING_CANCELLED: 
                case REJECTED: {
                    return LingmaIcons.ErrorGrey16Icon;
                }
                case OUTDATED: {
                    return LingmaIcons.Outdated16Icon;
                }
            }
            return IconUtil.getEmptyIcon((boolean)false);
        }
        return IconUtil.getEmptyIcon((boolean)false);
    }

    public String buildStatusName() {
        SnapshotStatusEnum statusEnum = SnapshotStatusEnum.getById(this.status);
        if (statusEnum != null && StringUtils.isNotBlank((CharSequence)statusEnum.getNameKey())) {
            return CosyBundle.message(statusEnum.getNameKey(), new Object[0]);
        }
        return this.status;
    }

    public void resetName() {
        this.name = this.index == 0 ? CosyBundle.message("working.space.snapshot.latest", new Object[0]) : CosyBundle.message("working.space.snapshot.prefix", new Object[0]) + " " + this.originName;
    }

    public static Snapshot build(SnapshotInfo snapshotInfo, int index, int currentIndex) {
        if (snapshotInfo == null) {
            return null;
        }
        return Snapshot.builder().id(snapshotInfo.getId()).index(index).sessionId(snapshotInfo.getSessionId()).requestId(snapshotInfo.getRequestId()).originName(snapshotInfo.getName()).name((String)(index == 0 ? CosyBundle.message("working.space.snapshot.latest", new Object[0]) : CosyBundle.message("working.space.snapshot.prefix", new Object[0]) + " " + snapshotInfo.getName())).status(snapshotInfo.getStatus()).description(snapshotInfo.getDescription()).current(index == currentIndex).latest(index == 0).invalid(index < currentIndex).build();
    }

    public static List<Snapshot> builds(List<SnapshotInfo> snapshotInfoList, int currentIndex) {
        if (CollectionUtils.isEmpty(snapshotInfoList)) {
            return new ArrayList<Snapshot>();
        }
        return snapshotInfoList.stream().map(snapshotInfo -> Snapshot.build(snapshotInfo, snapshotInfoList.indexOf(snapshotInfo), currentIndex)).collect(Collectors.toList());
    }

    @Generated
    public static SnapshotBuilder builder() {
        return new SnapshotBuilder();
    }

    @Generated
    public Snapshot() {
    }

    @Generated
    public Snapshot(String id, int index, String sessionId, String requestId, String originName, String name, String status, String description, boolean current, boolean latest, boolean invalid, boolean displayInList) {
        this.id = id;
        this.index = index;
        this.sessionId = sessionId;
        this.requestId = requestId;
        this.originName = originName;
        this.name = name;
        this.status = status;
        this.description = description;
        this.current = current;
        this.latest = latest;
        this.invalid = invalid;
        this.displayInList = displayInList;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getOriginName() {
        return this.originName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isCurrent() {
        return this.current;
    }

    @Generated
    public boolean isLatest() {
        return this.latest;
    }

    @Generated
    public boolean isInvalid() {
        return this.invalid;
    }

    @Generated
    public boolean isDisplayInList() {
        return this.displayInList;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Generated
    public void setOriginName(String originName) {
        this.originName = originName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCurrent(boolean current) {
        this.current = current;
    }

    @Generated
    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    @Generated
    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    @Generated
    public void setDisplayInList(boolean displayInList) {
        this.displayInList = displayInList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$originName = this.getOriginName();
        String other$originName = other.getOriginName();
        if (this$originName == null ? other$originName != null : !this$originName.equals(other$originName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isCurrent() != other.isCurrent()) {
            return false;
        }
        if (this.isLatest() != other.isLatest()) {
            return false;
        }
        if (this.isInvalid() != other.isInvalid()) {
            return false;
        }
        return this.isDisplayInList() == other.isDisplayInList();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Snapshot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + this.getIndex();
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $originName = this.getOriginName();
        result = result * 59 + ($originName == null ? 43 : $originName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isCurrent() ? 79 : 97);
        result = result * 59 + (this.isLatest() ? 79 : 97);
        result = result * 59 + (this.isInvalid() ? 79 : 97);
        result = result * 59 + (this.isDisplayInList() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "Snapshot(id=" + this.getId() + ", index=" + this.getIndex() + ", sessionId=" + this.getSessionId() + ", requestId=" + this.getRequestId() + ", originName=" + this.getOriginName() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", current=" + this.isCurrent() + ", latest=" + this.isLatest() + ", invalid=" + this.isInvalid() + ", displayInList=" + this.isDisplayInList() + ")";
    }

    @Generated
    public static class SnapshotBuilder {
        @Generated
        private String id;
        @Generated
        private int index;
        @Generated
        private String sessionId;
        @Generated
        private String requestId;
        @Generated
        private String originName;
        @Generated
        private String name;
        @Generated
        private String status;
        @Generated
        private String description;
        @Generated
        private boolean current;
        @Generated
        private boolean latest;
        @Generated
        private boolean invalid;
        @Generated
        private boolean displayInList;

        @Generated
        SnapshotBuilder() {
        }

        @Generated
        public SnapshotBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SnapshotBuilder index(int index) {
            this.index = index;
            return this;
        }

        @Generated
        public SnapshotBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public SnapshotBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Generated
        public SnapshotBuilder originName(String originName) {
            this.originName = originName;
            return this;
        }

        @Generated
        public SnapshotBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SnapshotBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public SnapshotBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public SnapshotBuilder current(boolean current) {
            this.current = current;
            return this;
        }

        @Generated
        public SnapshotBuilder latest(boolean latest) {
            this.latest = latest;
            return this;
        }

        @Generated
        public SnapshotBuilder invalid(boolean invalid) {
            this.invalid = invalid;
            return this;
        }

        @Generated
        public SnapshotBuilder displayInList(boolean displayInList) {
            this.displayInList = displayInList;
            return this;
        }

        @Generated
        public Snapshot build() {
            return new Snapshot(this.id, this.index, this.sessionId, this.requestId, this.originName, this.name, this.status, this.description, this.current, this.latest, this.invalid, this.displayInList);
        }

        @Generated
        public String toString() {
            return "Snapshot.SnapshotBuilder(id=" + this.id + ", index=" + this.index + ", sessionId=" + this.sessionId + ", requestId=" + this.requestId + ", originName=" + this.originName + ", name=" + this.name + ", status=" + this.status + ", description=" + this.description + ", current=" + this.current + ", latest=" + this.latest + ", invalid=" + this.invalid + ", displayInList=" + this.displayInList + ")";
        }
    }
}

