/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate.input;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTagsController;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.transfer.ObjectEncoder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.TransferHandler;

public class ChatTextAreaTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getInstance(ChatTextAreaTransferHandler.class);
    ChatInputContext inputContext;

    public ChatTextAreaTransferHandler(ChatInputContext inputContext) {
        super("text");
        this.inputContext = inputContext;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.stringFlavor) || support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return this.handleContextTagDrag(support.getTransferable());
        }
        if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return this.handleFileDrag(support.getTransferable());
        }
        return false;
    }

    private boolean handleContextTagDrag(Transferable transferable) {
        try {
            String obj = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            ChatContextTag tag = ObjectEncoder.decodeObject(obj);
            if (tag != null) {
                this.inputContext.getInputMainPanel().transferAutoContextTag(tag);
                ChatAskTag chatAskTag = ChatAskTag.buildTagFromContext(tag);
                ChatInputTextArea textArea = this.inputContext.getInputMainPanel().getTextArea();
                ChatInputTagsController inputTagsController = this.inputContext.getInputMainPanel().getInputTagsController();
                if (inputTagsController.hasNonContextAskTag()) {
                    textArea.removeTag(chatAskTag, (a, b) -> a.getId().equals(b.getId()));
                }
                this.inputContext.getInputMainPanel().addTag(chatAskTag);
            } else {
                this.inputContext.getInputMainPanel().getTextArea().insertText(obj);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn("drag context tag error:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean handleFileDrag(Transferable transferable) {
        try {
            AuthStatus authStatus = LingmaToolWindowPanel.getAuthStatusFromCache();
            if (AuthStateEnum.LOGIN.getValue() != authStatus.getStatus().intValue()) {
                LOG.warn("handleFileDrag failed, not login");
                return false;
            }
            List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (files != null && !files.isEmpty()) {
                ChatInputTagsController inputTagsController = this.inputContext.getInputMainPanel().getInputTagsController();
                return inputTagsController.addTagByFiles(files, 1);
            }
        }
        catch (Exception e) {
            LOG.warn("drag file error:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

