/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate.input;

import com.alibabacloud.intellij.cosy.chat.context.FileChatContextRefProvider;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.component.AutoHeightTextArea;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatAskTagLabel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextKeyListener;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatTextAreaTransferHandler;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ChatAskTagUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.alibabacloud.intellij.cosy.util.TagUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class ChatInputTextArea
extends AutoHeightTextArea {
    private static final Logger LOG = Logger.getInstance(ChatInputTextArea.class);
    ChatInputContext inputContext;

    public ChatInputTextArea(ChatInputContext inputContext, AskInputPanel parentPanel, String placeholderText, int maxHeight) {
        super(inputContext.getProject(), parentPanel, placeholderText, maxHeight);
        this.inputContext = inputContext;
        this.addKeyListener(new ChatInputTextKeyListener(this));
        StyledDocument doc = this.getStyledDocument();
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(attrs, 0.2f);
        doc.setParagraphAttributes(0, doc.getLength(), attrs, false);
        this.setupDocumentFilter();
        this.setupDragDrop();
    }

    public void recoverElements(List<ChatInputElement> elements) {
        this.clearTextArea();
        this.setCaretPosition(0);
        for (int i = 0; i < elements.size(); ++i) {
            ChatAskTag tag;
            ChatInputElement element = elements.get(i);
            if (element.getType().equals("text")) {
                String text = element.getText();
                if (i == elements.size() - 1) {
                    text = org.apache.commons.lang3.StringUtils.stripEnd((String)text, (String)"\n");
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)text)) continue;
                this.insertText(text);
                continue;
            }
            if (!element.getType().equals("tag") || (tag = element.getTag()) == null) continue;
            this.inputContext.getInputMainPanel().addTag(element.getTag());
        }
    }

    private void setupDocumentFilter() {
        if (this.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
                    VirtualFile file;
                    ActiveFileInfo lastCopyInfo = (ActiveFileInfo)CosyCacheKeys.KEY_LAST_EDITOR_COPY.get((UserDataHolder)ApplicationManager.getApplication());
                    if (null != text && null != lastCopyInfo && text.equals(lastCopyInfo.getSelectedCode()) && null != (file = LocalFileSystem.getInstance().findFileByPath(lastCopyInfo.getFilePath())) && !ChatInputTextArea.this.inputContext.getInputMainPanel().getInputTagsController().hasNonContextAskTag()) {
                        ChatInputTextArea.this.constructAndAddTag(file, lastCopyInfo);
                        return;
                    }
                    String newText = ChatInputTextArea.this.filterEditorInsert(offset, text);
                    if (null != newText) {
                        super.insertString(fb, offset, newText, attr);
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    VirtualFile file;
                    String newText = null;
                    ActiveFileInfo lastCopyInfo = (ActiveFileInfo)CosyCacheKeys.KEY_LAST_EDITOR_COPY.get((UserDataHolder)ApplicationManager.getApplication());
                    if (null != text && null != lastCopyInfo && text.equals(lastCopyInfo.getSelectedCode()) && null != (file = LocalFileSystem.getInstance().findFileByPath(lastCopyInfo.getFilePath())) && !ChatInputTextArea.this.inputContext.getInputMainPanel().getInputTagsController().hasNonContextAskTag()) {
                        ChatInputTextArea.this.constructAndAddTag(file, lastCopyInfo);
                        newText = "";
                    }
                    if (null == newText) {
                        newText = ChatInputTextArea.this.filterEditorInsert(offset, text);
                    }
                    if (null != newText) {
                        super.replace(fb, offset, length, newText, attrs);
                    }
                }

                @Override
                public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                    try {
                        ChatInputTextArea.this.textBeforeDeleted.getAndSet(fb.getDocument().getText(offset, length));
                    }
                    catch (BadLocationException e) {
                        LOG.warn("get text before deleted error", (Throwable)e);
                    }
                    if (ChatInputTextArea.this.isPinyinInput()) {
                        super.remove(fb, offset, length);
                        return;
                    }
                    List<ChatAskTag> tagsNotInKeepList = ChatInputTextArea.this.listTagsNotInKeepList(offset, length);
                    super.remove(fb, offset, length);
                    if (CollectionUtils.isNotEmpty(tagsNotInKeepList)) {
                        ChatInputTextArea.this.filterAndRemoveContextTags(tagsNotInKeepList);
                    }
                    if (ChatAskTag.nonContext(tagsNotInKeepList).booleanValue()) {
                        ChatInputTextArea.this.inputContext.getInputMainPanel().getInputTagsPanel().updateTagsExcept(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}), 2);
                    }
                }
            });
        }
    }

    private void constructAndAddTag(VirtualFile file, ActiveFileInfo lastCopyInfo) {
        SuggestPrompt suggestPrompt = FileChatContextRefProvider.getSuggestPrompt(file, InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.SELECTED_CODE.getType()), this.inputContext.getProject());
        Integer startLine = lastCopyInfo.getStatLine();
        Integer endLine = lastCopyInfo.getEndLine();
        ChatContextTag contextTag = this.constructContextTag(suggestPrompt, startLine, endLine, lastCopyInfo);
        this.inputContext.getInputMainPanel().addTag(ChatAskTag.buildTagFromContext(contextTag));
        this.inputContext.getInputMainPanel().addContextTag(contextTag);
    }

    private ChatContextTag constructContextTag(SuggestPrompt suggestPrompt, Integer startLine, Integer endLine, ActiveFileInfo lastCopyInfo) {
        return ChatContextTag.builder().id(TagUtil.getSelectCodeTagId(suggestPrompt.getId(), startLine, endLine)).type(String.valueOf(suggestPrompt.getExtra().get("contextType"))).text(lastCopyInfo.getFileName()).statLine(startLine).endLine(endLine).payload(suggestPrompt.getId()).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(ChatContextTag.buildExtraOfChatContextTag(startLine, endLine, suggestPrompt.getId(), lastCopyInfo.getFileName(), lastCopyInfo.getSelectedCode())).sourceType(suggestPrompt.getSourceType()).build();
    }

    private String filterEditorInsert(int offset, String text) {
        if (this.filterPasteTextAreaTag(text) || text == null) {
            return null;
        }
        int textLength = 0;
        String oldText = this.getText();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oldText)) {
            textLength = oldText.length();
        }
        int newTextLength = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)text)) {
            newTextLength = text.length();
        }
        if (textLength + newTextLength > 12000) {
            int diff = textLength + newTextLength - 12000;
            if (diff > 0 && newTextLength > diff) {
                text = text.substring(0, newTextLength - diff);
            } else {
                return null;
            }
        }
        text = this.filterTaskAgentText(offset, text);
        String newText = StringUtils.removeEmojis(text);
        this.textBeforeDeleted.getAndSet("");
        return newText;
    }

    private List<ChatAskTag> listTagsNotInKeepList(int offset, int length) {
        Element element;
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        ArrayList<ChatAskTag> tagsToRemove = new ArrayList<ChatAskTag>();
        ArrayList<ChatAskTag> tagsToKeep = new ArrayList<ChatAskTag>();
        while ((element = iterator.next()) != null) {
            try {
                Component comp;
                if (!element.getName().equals("component") || !((comp = StyleConstants.getComponent(element.getAttributes())) instanceof ChatAskTagLabel)) continue;
                ChatAskTagLabel askTag = (ChatAskTagLabel)comp;
                int start = element.getStartOffset();
                if (offset <= start && start < offset + length) {
                    tagsToRemove.add(askTag.getTag());
                    continue;
                }
                tagsToKeep.add(askTag.getTag());
            }
            catch (Exception e) {
                LOG.warn("list enable remove context tag error " + e.getMessage(), (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(tagsToRemove)) {
            return null;
        }
        if (CollectionUtils.isEmpty(tagsToKeep)) {
            return tagsToRemove;
        }
        ArrayList<ChatAskTag> tagsNotInKeepList = new ArrayList<ChatAskTag>();
        List noRemoveTagIds = tagsToKeep.stream().map(ChatAskTag::getId).collect(Collectors.toList());
        for (ChatAskTag askTag : tagsToRemove) {
            if (noRemoveTagIds.contains(askTag.getId())) continue;
            tagsNotInKeepList.add(askTag);
        }
        return tagsNotInKeepList;
    }

    void filterAndRemoveContextTags(List<ChatAskTag> askTags) {
        if (CollectionUtils.isEmpty(askTags)) {
            return;
        }
        AskInputPanel inputMainPanel = this.inputContext.getInputMainPanel();
        if (inputMainPanel == null) {
            return;
        }
        List<ChatContextTag> chatContextTags = this.inputContext.getInputMainPanel().getInputTagsPanel().getTags();
        if (CollectionUtils.isEmpty(chatContextTags)) {
            return;
        }
        for (ChatAskTag askTag : askTags) {
            for (ChatContextTag contextTag : chatContextTags) {
                if (!contextTag.getActualValid().booleanValue() || !contextTag.equalsToAskTag(askTag).booleanValue()) continue;
                this.inputContext.getInputMainPanel().getInputTagsPanel().removeById(contextTag.getId());
            }
        }
    }

    private boolean filterPasteTextAreaTag(String newText) {
        String data;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getText()) && newText.equals(data = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) && (newText.startsWith("@") || newText.startsWith("/"))) {
            this.filterTagsFromText(newText);
            return true;
        }
        return false;
    }

    @Override
    public boolean canSend() {
        boolean isImageLoading = this.isImageLoading();
        if (isImageLoading) {
            LOG.warn("canSend ...isImageLoading=" + isImageLoading);
            NotificationFactory.showToast((JComponent)this.inputContext.getInputMainPanel().getInputOperationPanel().getSendLabel(), MessageType.INFO, CosyBundle.message("notifications.send.button.image.uploading", new Object[0]));
            return false;
        }
        List<ChatInputElement> elements = this.getElements();
        if (elements.isEmpty()) {
            return false;
        }
        ChatInputElement firstElement = elements.get(0);
        if (!"tag".equals(firstElement.getType())) {
            return !this.isBlankText(elements);
        }
        ChatAskTag tag = firstElement.getTag();
        if (tag != null && "agent".equals(tag.getType()) && InputConstants.AGENT_MUST_HAVE_CONTEXT.contains(tag.getId())) {
            return !this.isBlankText(elements);
        }
        return true;
    }

    private boolean isImageLoading() {
        List<ChatContextTag> chatContextTags = this.inputContext.getInputMainPanel().getInputTagsPanel().getTags();
        if (CollectionUtils.isNotEmpty(chatContextTags)) {
            return chatContextTags.stream().anyMatch(chatContextTag -> ChatContextTypeEnum.IMAGE.getType().equalsIgnoreCase(chatContextTag.getType()) && BooleanUtils.isTrue((Boolean)chatContextTag.getLoading().get()));
        }
        return false;
    }

    private boolean isBlankText(List<ChatInputElement> elements) {
        boolean isBlank = true;
        for (ChatInputElement element : elements) {
            if (element.getType().equals("text") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)element.getText())) {
                isBlank = false;
                break;
            }
            if (!element.getType().equals("tag") || "agent".equals(element.getTag().getType())) continue;
            isBlank = false;
            break;
        }
        return isBlank;
    }

    private void setupDragDrop() {
        this.setTransferHandler(new ChatTextAreaTransferHandler(this.inputContext));
    }

    private String filterTaskAgentText(int offset, String text) {
        ChatAskTag tag;
        List<ChatInputElement> elements = this.getElements();
        if (!elements.isEmpty() && offset == 0 && (tag = elements.get(0).getTag()) != null && ("agent".equals(tag.getType()) || "task".equals(tag.getType()))) {
            return "";
        }
        return text;
    }

    public List<ChatAskTag> getTags() {
        ArrayList<ChatAskTag> tags = new ArrayList<ChatAskTag>();
        List<Component> components = this.getEmbedComponents();
        for (Component component : components) {
            if (!(component instanceof ChatAskTagLabel)) continue;
            ChatAskTagLabel askTag = (ChatAskTagLabel)component;
            tags.add(askTag.getTag());
        }
        return tags;
    }

    public List<ChatInputElement> getElements() {
        ChatInputElement lastElement;
        Element element;
        ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((element = iterator.next()) != null) {
            try {
                Component comp;
                if (element.getName().equals("content")) {
                    int start = element.getStartOffset();
                    int end = element.getEndOffset();
                    String text = doc.getText(start, end - start);
                    elements.add(ChatInputElement.builder().text(text).type("text").build());
                    continue;
                }
                if (!element.getName().equals("component") || (comp = StyleConstants.getComponent(element.getAttributes())) == null || !(comp instanceof ChatAskTagLabel)) continue;
                ChatAskTagLabel askTag = (ChatAskTagLabel)comp;
                elements.add(ChatInputElement.builder().tag(askTag.getTag()).type("tag").build());
            }
            catch (Exception e) {
                LOG.warn("build input elements error " + e.getMessage(), (Throwable)e);
            }
        }
        if (!elements.isEmpty() && "\n".equals((lastElement = (ChatInputElement)elements.get(elements.size() - 1)).getText()) && "text".equals(lastElement.getType())) {
            elements.remove(elements.size() - 1);
        }
        return elements;
    }

    public ChatInputElement getCaretElement() {
        StyledDocument doc = this.getStyledDocument();
        Element element = null;
        int caretPos = this.getCaretPosition();
        element = caretPos > 0 && caretPos == doc.getLength() ? doc.getCharacterElement(caretPos - 1) : doc.getCharacterElement(caretPos);
        try {
            Component comp;
            if (element.getName().equals("content")) {
                int start = element.getStartOffset();
                int end = element.getEndOffset();
                String text = doc.getText(start, caretPos - start);
                return ChatInputElement.builder().text(text).type("text").build();
            }
            if (element.getName().equals("component") && (comp = StyleConstants.getComponent(element.getAttributes())) != null && comp instanceof ChatAskTagLabel) {
                ChatAskTagLabel askTag = (ChatAskTagLabel)comp;
                return ChatInputElement.builder().tag(askTag.getTag()).type("tag").build();
            }
        }
        catch (Exception e) {
            LOG.warn("build input elements error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void removeTag(ChatAskTag targetTag, BiFunction<ChatAskTag, ChatAskTag, Boolean> tagComparator) {
        Element e;
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((e = iterator.next()) != null) {
            ChatAskTagLabel askTag;
            Component comp;
            if (!e.getName().equals("component") || !((comp = StyleConstants.getComponent(e.getAttributes())) instanceof ChatAskTagLabel) || !tagComparator.apply((askTag = (ChatAskTagLabel)comp).getTag(), targetTag).booleanValue()) continue;
            try {
                doc.remove(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
            }
            catch (BadLocationException ex) {
                LOG.warn("removeTag error " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void replaceTagWithText(ChatAskTag targetTag, String replaceText, BiFunction<ChatAskTag, ChatAskTag, Boolean> tagComparator) {
        Element e;
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((e = iterator.next()) != null) {
            ChatAskTagLabel askTag;
            Component comp;
            if (!e.getName().equals("component") || !((comp = StyleConstants.getComponent(e.getAttributes())) instanceof ChatAskTagLabel) || !tagComparator.apply((askTag = (ChatAskTagLabel)comp).getTag(), targetTag).booleanValue()) continue;
            try {
                doc.remove(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
                this.insertText(e.getStartOffset(), replaceText);
            }
            catch (BadLocationException ex) {
                LOG.warn("replaceTagWithText error " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void filterTagsFromText(String text) {
        String[] words = text.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.startsWith("@") || word.startsWith("/")) {
                if (sb.length() > 0) {
                    this.insertText(sb.toString());
                }
                sb = new StringBuilder();
            }
            sb.append(word).append(" ");
            if (!this.doFilterTagFromText(sb.toString().trim())) continue;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            this.insertText(sb.toString());
        }
    }

    private boolean doFilterTagFromText(String text) {
        String queryText = text;
        if (queryText.startsWith("@") || queryText.startsWith("/")) {
            queryText = queryText.substring(1);
        }
        if (text.startsWith("@")) {
            return false;
        }
        SuggestPrompt suggestPrompt = SuggestPromptUtil.getAllSuggestPromptOfTag(this.inputContext.getProject(), this.inputContext.getSessionType()).get(queryText);
        if (suggestPrompt == null) {
            return false;
        }
        ChatAskTag chatAskTag = ChatAskTag.buildTag(suggestPrompt.getId(), text);
        if (chatAskTag != null) {
            this.addTag(chatAskTag);
            return true;
        }
        return false;
    }

    public void clearAfterSent() {
        List<ChatInputElement> elements = this.getElements();
        this.clearTextArea();
        if (CollectionUtils.isEmpty(elements)) {
            return;
        }
        List keepElements = elements.stream().filter(element -> {
            ChatAskTag tag;
            return element.getType().equals("tag") && (tag = element.getTag()) != null && InputConstants.KEEP_TAG_AFTER_SEND.contains(tag.getText());
        }).collect(Collectors.toList());
        for (ChatInputElement element2 : keepElements) {
            if (element2.getTag() == null) continue;
            this.addTag(element2.getTag());
        }
    }

    public void addTag(ChatAskTag tag) {
        ChatAskTagLabel askTag = new ChatAskTagLabel(tag);
        this.insertComponent(askTag);
        this.revalidate();
        this.repaint();
        String placeHolder = ChatAskTagUtil.getPlaceholderByTextArea(this);
        this.setPlaceholder(placeHolder);
    }

    public void addTag(int startOffset, int endOffset, ChatAskTag tag) {
        ChatAskTagLabel askTag = new ChatAskTagLabel(tag);
        this.replaceComponent(startOffset, endOffset, askTag);
        this.revalidate();
        this.repaint();
        String placeHolder = ChatAskTagUtil.getPlaceholderByTextArea(this);
        this.setPlaceholder(placeHolder);
    }

    public ChatInputContext getChatInputContext() {
        return this.inputContext;
    }

    public void updateSuggestPopupPosition() {
        SuggestPromptPopupPanel suggestPromptPopupPanel = this.inputContext.getInputMainPanel().getChatInputSuggester().getSuggestPromptPopupPanel();
        if (suggestPromptPopupPanel == null || !suggestPromptPopupPanel.isShowPopup()) {
            return;
        }
        int displayY = (int)this.inputContext.getInputMainPanel().getInputPanel().getLocationOnScreen().getY();
        int displayX = (int)this.inputContext.getInputMainPanel().getInputPanel().getLocationOnScreen().getX();
        suggestPromptPopupPanel.updatePromptSuggestPopupPosition(new Point(displayX, displayY));
    }
}

