/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate.input;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.constants.ActionConstants;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.constants.ShortcutConstants;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.QueryRange;
import com.alibabacloud.intellij.cosy.ui.search.generate.SelectedSuggestResult;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputSuggestPopupListener;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ScopeChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.TaskChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCreateNewChatNotifier;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.TagUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.Consumer;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatInputSuggester {
    private static final Logger Log = Logger.getInstance(ChatInputSuggester.class);
    private SuggestPromptPopupPanel suggestPromptPopupPanel;
    private ChatInputContext inputContext;

    public ChatInputSuggester(ChatInputContext inputContext) {
        this.inputContext = inputContext;
        this.suggestPromptPopupPanel = new SuggestPromptPopupPanel(inputContext, new ChatInputSuggestPopupListener(inputContext), (Consumer<SelectedSuggestResult>)((Consumer)this::triggerChooserSuggestPromptSelection));
        this.addInputPanelListener();
    }

    public void triggerChooserSuggestPromptSelection(SelectedSuggestResult selectedSuggestResult) {
        SuggestPrompt suggestPrompt = selectedSuggestResult.getSuggestPrompt();
        QueryRange queryRange = selectedSuggestResult.getQueryRange();
        boolean triggerInContextPanel = "contextPanel".equals(selectedSuggestResult.getTriggerComponent());
        if (suggestPrompt.getActionCommand() != null) {
            String command = suggestPrompt.getActionCommand();
            if (command.startsWith("action:")) {
                String actionId = command.substring("action:".length());
                if (ActionConstants.TRIGGER_SELECTION_CODE_ACTION_LIST.contains(actionId)) {
                    this.addTag(queryRange, new TaskChatAskTag(suggestPrompt.getId(), suggestPrompt.getText()));
                    this.clearContextTags(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.SELECTED_CODE}));
                } else if (ActionConstants.TRIGGER_COSY_CLEAR_HISTORY_ACTION.equals(actionId)) {
                    String sessionId = this.inputContext.getBaseChatPanel().getInitInput().getChatContext().getSessionId();
                    this.inputContext.getBaseChatPanel().clearChat(sessionId, UUID.randomUUID().toString());
                    this.inputContext.getInputMainPanel().clearAll();
                } else if (ActionConstants.TRIGGER_COSY_HELP_ACTION.equals(actionId)) {
                    this.inputContext.getBaseChatPanel().showHelpAnswer();
                    this.inputContext.getInputMainPanel().clearAll();
                } else if (ActionConstants.TRIGGER_COSY_NEW_TASK_ACTION.equals(actionId)) {
                    AskInputPanel inputPanel = this.inputContext.getInputMainPanel();
                    Point inputLocation = inputPanel.getInputPanel().getLocationOnScreen();
                    ((LingmaCreateNewChatNotifier)this.inputContext.getProject().getMessageBus().syncPublisher(LingmaCreateNewChatNotifier.CREATE_NEW_CHAT_NOTIFICATION)).createNewChat(new Point(inputLocation.x, inputLocation.y - 100));
                }
            }
        } else if ("context".equals(suggestPrompt.getType())) {
            this.triggerAddContextTag(selectedSuggestResult, triggerInContextPanel);
        } else {
            ChatAskTag chatAskTag = ChatAskTag.buildTag(suggestPrompt.getId(), suggestPrompt.getText());
            if (chatAskTag != null) {
                this.addTag(queryRange, chatAskTag);
                if (AgentTagEnum.WORKSPACE.getId().equals(chatAskTag.getId())) {
                    this.clearContextTags(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.SELECTED_CODE, ChatContextTypeEnum.TEAM_DOCS}));
                } else if (AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())) {
                    this.clearAllContextTags();
                } else if (AgentTagEnum.TERMINAL.getId().equals(chatAskTag.getId())) {
                    this.clearContextTags(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.SELECTED_CODE}));
                }
            }
        }
    }

    public void triggerAddContextTag(SelectedSuggestResult selectedSuggestResult, boolean onlyContextTag) {
        SuggestPrompt suggestPrompt = selectedSuggestResult.getSuggestPrompt();
        Map<String, Object> extraMap = suggestPrompt.getExtra();
        if (extraMap == null || !extraMap.containsKey("contextType")) {
            Log.warn("context type is empty");
            return;
        }
        String contextType = (String)extraMap.get("contextType");
        if (contextType.equals("openFiles")) {
            this.addOpenFiles(selectedSuggestResult, true);
            this.cleanContextTag(selectedSuggestResult);
            return;
        }
        suggestPrompt = this.prepareAndCheckBeforeAdd(selectedSuggestResult, contextType);
        if (suggestPrompt == null) {
            return;
        }
        selectedSuggestResult.setSuggestPrompt(suggestPrompt);
        if (onlyContextTag) {
            this.addContextTag(selectedSuggestResult);
        } else {
            this.addInputAndContextTag(selectedSuggestResult, contextType);
        }
    }

    private void cleanContextTag(SelectedSuggestResult selectedSuggestResult) {
        QueryRange queryRange = selectedSuggestResult.getQueryRange();
        if (queryRange != null) {
            this.inputContext.getInputMainPanel().clearContent(queryRange.getStartOffset(), queryRange.getEndOffset());
        }
    }

    private void addOpenFiles(SelectedSuggestResult selectedSuggestResult, boolean onlyContextTag) {
        Project project = this.inputContext.project;
        List<SuggestPrompt> suggestPrompts = ChatContextTypeEnum.OPEN_FILES.getProvider().listSuggestPrompts(project, "");
        for (SuggestPrompt fileSuggestPrompt : suggestPrompts) {
            SelectedSuggestResult fileSuggestResult = new SelectedSuggestResult();
            fileSuggestResult.setSuggestPrompt(fileSuggestPrompt);
            fileSuggestResult.setTriggerComponent(selectedSuggestResult.getTriggerComponent());
            this.triggerAddContextTag(fileSuggestResult, onlyContextTag);
        }
    }

    private SuggestPrompt prepareAndCheckBeforeAdd(SelectedSuggestResult selectedSuggestResult, String contextType) {
        JComponent jComponent;
        SuggestPrompt suggestPrompt = new SuggestPrompt(selectedSuggestResult.getSuggestPrompt());
        Project project = this.inputContext.getProject();
        Map<String, Object> extra = suggestPrompt.getExtra();
        boolean triggerInContextPanel = "contextPanel".equals(selectedSuggestResult.getTriggerComponent());
        JComponent jComponent2 = jComponent = triggerInContextPanel ? this.inputContext.getInputMainPanel().getInputTagsPanel() : this.inputContext.getInputMainPanel().getTextArea();
        if (ChatContextTypeEnum.FILE.getType().equals(contextType)) {
            boolean validate;
            String filePath = suggestPrompt.getId();
            if (StringUtils.isNotBlank((CharSequence)filePath) && (validate = FileUtil.isValidImageFormat(filePath))) {
                extra.put("fileType", "image");
                extra.put("contextType", ChatContextTypeEnum.IMAGE.getType());
                extra.put("filePath", filePath);
                suggestPrompt.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.IMAGE.getType()));
                boolean checkImageLimit = this.inputContext.getInputMainPanel().checkImageContextTagLimit(filePath);
                if (!checkImageLimit) {
                    NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.limit", new Object[0]));
                    return null;
                }
            }
        } else if (ChatContextTypeEnum.IMAGE.getType().equals(contextType)) {
            String filePath = (String)extra.get("filePath");
            if (StringUtils.isBlank((CharSequence)filePath)) {
                NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.type.invalid", new Object[0]));
                return null;
            }
            boolean validate = FileUtil.isValidImageFormat(filePath);
            if (!validate) {
                NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.type.invalid", new Object[0]));
                return null;
            }
            boolean checkImageLimit = this.inputContext.getInputMainPanel().checkImageContextTagLimit(filePath);
            if (!checkImageLimit) {
                NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.limit", new Object[0]));
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)filePath) && StringUtils.isBlank((CharSequence)suggestPrompt.getId())) {
                suggestPrompt.setId(filePath);
            }
        } else if (ChatContextTypeEnum.SELECTED_CODE.getType().equals(contextType)) {
            suggestPrompt.setContextProvider(new SuggestPrompt(suggestPrompt));
            Editor editor = EditorUtil.getSelectedEditorSafely(this.inputContext.getProject());
            if (editor == null) {
                NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message(I18NConstant.CHAT_NOTIFY_SELECT_CODE, new Object[0]));
                return null;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                NotificationFactory.showToast(jComponent, MessageType.ERROR, CosyBundle.message(I18NConstant.CHAT_NOTIFY_SELECT_CODE, new Object[0]));
                return null;
            }
            String selectedText = selectionModel.getSelectedText();
            if (selectedText == null) {
                NotificationFactory.showInfoNotification(project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
                return null;
            }
            ActiveFileInfo activeFileInfo = ActiveFileInfo.getFromEditor(editor);
            extra.put("startLine", activeFileInfo.getStatLine());
            extra.put("endLine", activeFileInfo.getEndLine());
            extra.put("filePath", activeFileInfo.getFilePath());
            extra.put("fileName", activeFileInfo.getFileName());
            extra.put("selectedItemContent", selectedText);
            suggestPrompt.setId(TagUtil.getSelectCodeTagId(activeFileInfo.getFilePath(), activeFileInfo.getStatLine(), activeFileInfo.getEndLine()));
        }
        return suggestPrompt;
    }

    private void clearAllContextTags() {
        this.inputContext.inputMainPanel.clearAllContextTags();
    }

    private void clearContextTags(Set<ChatContextTypeEnum> reserveTagTypes) {
        this.inputContext.inputMainPanel.updateContextTagsExceptReserves(reserveTagTypes, 0);
    }

    private void addTag(@Nullable QueryRange queryRange, @NotNull ChatAskTag tag) {
        if (tag == null) {
            ChatInputSuggester.$$$reportNull$$$0(0);
        }
        if (queryRange == null || queryRange.getEndOffset() == 0) {
            this.inputContext.getInputMainPanel().addTag(tag);
        } else {
            this.inputContext.getInputMainPanel().addTag(queryRange.getStartOffset(), queryRange.getEndOffset(), tag);
        }
        if (ChatAskTag.nonContext(List.of(tag)).booleanValue()) {
            this.inputContext.inputMainPanel.updateContextTagsExceptReserves(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}), 1);
        }
    }

    private void addContextTag(SelectedSuggestResult selectedSuggestResult) {
        SuggestPrompt suggestPrompt = selectedSuggestResult.getSuggestPrompt();
        this.addContextTag(suggestPrompt);
    }

    public void addContextTag(SuggestPrompt suggestPrompt) {
        if ("context".equals(suggestPrompt.getType())) {
            Map<String, Object> extraMap = suggestPrompt.getExtra();
            if (extraMap != null && extraMap.containsKey("contextType")) {
                String contextType = (String)extraMap.get("contextType");
                ChatContextTag chatContextTag = null;
                if (ChatContextTypeEnum.FILE.getType().equals(contextType)) {
                    chatContextTag = ChatContextTag.builder().id(suggestPrompt.getId()).type(contextType).text(suggestPrompt.getText()).payload(suggestPrompt.getId()).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).sourceType(suggestPrompt.getSourceType()).build();
                } else if (ChatContextTypeEnum.IMAGE.getType().equals(contextType)) {
                    String imageUrl = (String)extraMap.get("filePath");
                    chatContextTag = ChatContextTag.builder().id(suggestPrompt.getId()).type(contextType).text(suggestPrompt.getText()).payload(imageUrl).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).sourceType(suggestPrompt.getSourceType()).build();
                } else if (ChatContextTypeEnum.SELECTED_CODE.getType().equals(contextType)) {
                    Integer startLine = (Integer)extraMap.get("startLine");
                    Integer endLine = (Integer)extraMap.get("endLine");
                    String fileName = (String)extraMap.get("fileName");
                    chatContextTag = ChatContextTag.builder().id(suggestPrompt.getId()).type(contextType).text(fileName).statLine(startLine).endLine(endLine).payload(suggestPrompt.getId()).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).sourceType(suggestPrompt.getSourceType()).build();
                } else {
                    chatContextTag = ChatContextTag.builder().id(suggestPrompt.getId()).type(contextType).text(suggestPrompt.getText()).payload(suggestPrompt.getId()).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).sourceType(suggestPrompt.getSourceType()).build();
                }
                if (chatContextTag != null) {
                    this.inputContext.getInputMainPanel().addContextTag(chatContextTag);
                }
            } else {
                Log.warn("dealWithContextPanel contextType is empty");
            }
        } else {
            Log.warn("dealWithContextPanel type =" + suggestPrompt.getType() + " is illegal");
        }
    }

    private void addInputAndContextTag(SelectedSuggestResult selectedSuggestResult, String contextType) {
        ChatAskTag chatAskTag;
        SuggestPrompt suggestPrompt = selectedSuggestResult.getSuggestPrompt();
        QueryRange queryRange = selectedSuggestResult.getQueryRange();
        Map<String, Object> extraMap = suggestPrompt.getExtra();
        if (ChatContextTypeEnum.FILE.getType().equals(contextType) || ChatContextTypeEnum.IMAGE.getType().equals(contextType) || ChatContextTypeEnum.GIT_COMMIT.getType().equals(contextType) || ChatContextTypeEnum.TEAM_DOCS.getType().equals(contextType) || ChatContextTypeEnum.FOLDER.getType().equals(contextType) || ChatContextTypeEnum.RULE.getType().equals(contextType)) {
            String displayText = "@" + suggestPrompt.getText();
            chatAskTag = ScopeChatAskTag.builder().id(suggestPrompt.getId()).text(suggestPrompt.getText()).displayText(displayText).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).build();
        } else if (ChatContextTypeEnum.SELECTED_CODE.getType().equals(contextType)) {
            Integer startLine = (Integer)extraMap.get("startLine");
            Integer endLine = (Integer)extraMap.get("endLine");
            String fileName = (String)extraMap.get("fileName");
            String displayText = "#" + fileName + " " + startLine + "-" + endLine;
            chatAskTag = ScopeChatAskTag.builder().id(suggestPrompt.getId()).text(fileName).displayText(displayText).contextProvider(suggestPrompt.getContextProvider()).componentType(suggestPrompt.getComponentType()).extra(suggestPrompt.getExtra()).build();
        } else {
            chatAskTag = ChatAskTag.buildTag(suggestPrompt.getId(), suggestPrompt.getText());
        }
        if (chatAskTag != null) {
            this.addTag(queryRange, chatAskTag);
            this.addContextTag(selectedSuggestResult);
        }
    }

    private void addInputPanelListener() {
        final AskInputPanel inputPanel = this.inputContext.getInputMainPanel();
        inputPanel.getTextArea().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                String text;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtils.isBlank((CharSequence)(text = inputPanel.getTextArea().getText()))) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = ShortcutConstants.UP_SHORTCUTS.contains(stroke) ? 38 : (ShortcutConstants.DOWN_SHORTCUTS.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ChatInputSuggester.this.suggestPromptPopupPanel.moveDownPromptItemList(e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ChatInputSuggester.this.suggestPromptPopupPanel.moveUpPromptItemList(e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ChatInputSuggester.this.suggestPromptPopupPanel.movePageUpPromptItemList();
                        break;
                    }
                    case 34: {
                        ChatInputSuggester.this.suggestPromptPopupPanel.movePageDownPromptItemList();
                    }
                }
                if (ChatInputSuggester.this.suggestPromptPopupPanel.isShowPopup()) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 8 && "".equals(inputPanel.getTextArea().getText())) {
                    inputPanel.setTextAreaPlaceholder();
                    inputPanel.updateLayout();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/cosy/ui/search/generate/input/ChatInputSuggester$1", "keyPressed"));
            }
        });
    }

    @Generated
    public SuggestPromptPopupPanel getSuggestPromptPopupPanel() {
        return this.suggestPromptPopupPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/alibabacloud/intellij/cosy/ui/search/generate/input/ChatInputSuggester", "addTag"));
    }
}

