/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate.input;

import com.alibabacloud.intellij.cosy.chat.context.ImageChatContextRefProvider;
import com.alibabacloud.intellij.cosy.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.layout.ChatContextTagLayout;
import com.alibabacloud.intellij.cosy.service.ModeService;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextAddButton;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatMode;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatContextTagsDropTargetListener;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChatContextTagsPanel
extends JPanel {
    private static final Logger log = Logger.getInstance(ChatContextTagsPanel.class);
    private static final int MIN_ROW_HEIGHT = 24;
    public static final int BOTTOM_MARGIN = 8;
    public static final int FILTER_OPTION_NO_RECOMMEND = -1;
    public static final int FILTER_OPTION_ALL = 0;
    public static final int FILTER_OPTION_RECOMMEND = 1;
    public static String USAGE_QUESTION_PANEL = "QUESTION_PANEL";
    public static String USAGE_INPUT_PANE = "INPUT_PANEL";
    private ChatContextAddButton contextAddButton;
    Project project;
    ChatInputContext chatInputContext;
    private JLabel emptyLabel;
    private final Set<String> selectedTagIds;
    private final String usage;

    public ChatContextTagsPanel(ChatInputContext inputContext, String usage) {
        this.project = inputContext.getProject();
        this.chatInputContext = inputContext;
        this.usage = usage;
        this.selectedTagIds = new HashSet<String>();
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        this.setLayout(new ChatContextTagLayout(4, 4, 24));
        if (this.chatInputContext.getInputMainPanel() != null) {
            this.contextAddButton = new ChatContextAddButton(this);
            this.add(this.contextAddButton);
            this.addEmptyTooltip();
            this.setupDragDrop();
        }
    }

    private void setupDragDrop() {
        ChatContextTagsDropTargetListener listener = new ChatContextTagsDropTargetListener(this.chatInputContext);
        this.setTransferHandler(listener);
        try {
            this.getDropTarget().addDropTargetListener(listener);
        }
        catch (TooManyListenersException e) {
            log.warn("add drop target listener error", (Throwable)e);
        }
    }

    public void initCodebaseTag() {
        List codebaseTags;
        if (!this.chatInputContext.getHistoryEmpty().get()) {
            return;
        }
        ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
        if (null != userData && userData.isCodeBaseRemoved()) {
            return;
        }
        List<ChatContextTag> tags = this.chatInputContext.getInputMainPanel().getInputTagsPanel().getTags();
        if (CollectionUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(codebaseTags = tags.stream().filter(tag -> ChatContextTypeEnum.CODEBASE.getType().equals(tag.getType())).collect(Collectors.toList()))) {
            return;
        }
        SuggestPrompt codeBaseSuggestPrompt = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.CODEBASE.getType());
        if (codeBaseSuggestPrompt != null) {
            this.chatInputContext.getInputMainPanel().getChatInputSuggester().addContextTag(codeBaseSuggestPrompt);
        }
    }

    public void initTags() {
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return;
        }
        Boolean isValid = FileUtil.isValidProjectFile(this.project, file);
        if (!isValid.booleanValue()) {
            return;
        }
        ChatSessionContext chatSessionContext = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
        if (null != chatSessionContext && chatSessionContext.isCurrentFileRemoved()) {
            return;
        }
        ChatContextTag tag = ChatContextTag.buildFromActiveFileInfo(ActiveFileInfo.getFromEditor(editor));
        if (tag != null && !ChatMode.AGENT.getMode().equals(ModeService.getInstance().getSelectionModeItem(this.project).getMode())) {
            this.addTag(tag);
        }
    }

    public void focusTag(int index) {
        if (index < 0 || index >= this.getComponentCount()) {
            return;
        }
        Component component = this.getComponent(index);
        component.requestFocusInWindow();
    }

    public int getFocusIndex() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!component.isFocusOwner()) continue;
            return i;
        }
        return -1;
    }

    public void setComponentEnabled(boolean enabled) {
        this.setEnabled(enabled);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            component.setEnabled(enabled);
        }
    }

    public void checkState() {
        this.contextAddButton.checkState();
    }

    private void addEmptyTooltip() {
        if (this.emptyLabel == null) {
            this.emptyLabel = new JLabel(CosyBundle.message("chat.context.add.tooltip", new Object[0]));
            this.emptyLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.emptyLabel.setFont(FontUtil.LABEL_TAG_SMALL_FONT);
        }
        this.add(this.emptyLabel);
        this.emptyLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AuthStateEnum.LOGIN.getValue() == LoginUtil.getAuthStatus(ChatContextTagsPanel.this.project).getStatus().intValue()) {
                    ChatContextTagsPanel.this.contextAddButton.handleClick();
                }
            }
        });
    }

    private void removeEmptyTooltip() {
        if (this.emptyLabel != null) {
            this.remove(this.emptyLabel);
            this.emptyLabel = null;
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (USAGE_QUESTION_PANEL.equals(this.usage)) {
            super.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        } else {
            super.setBackground(ColorUtil.getEditorBackgroundColor());
        }
    }

    public void addTag(ChatContextTag tag) {
        if (!this.isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tag.getText())) {
            return;
        }
        this.removeEmptyTooltip();
        boolean needSetup = true;
        if (this.chatInputContext.getInputMainPanel() == null) {
            needSetup = false;
        }
        ChatContextTagButton askTag = this.buildTagButton(tag, needSetup);
        if (ChatContextTypeEnum.IMAGE.getType().equals(tag.getType())) {
            if (StringUtils.isNotBlank((CharSequence)tag.getRemoteFileUrl())) {
                askTag.setIcon(LingmaIcons.ImageGreyIcon);
                askTag.setValid(true);
            } else {
                askTag.setIcon(LingmaIcons.ImageFailRedIcon);
                askTag.setValid(false);
            }
        } else if (!tag.getActualValid().booleanValue()) {
            askTag.setValid(false);
        }
        this.add(askTag);
        this.updateSelectedTagIds(askTag.getTag());
        this.revalidate();
        this.repaint();
    }

    public void addOrUpdateTag(int offset, ChatContextTag tag, BiFunction<ChatContextTag, ChatContextTag, Boolean> tagComparator) {
        this.doAddOrUpdateTag(offset, tag, tagComparator);
    }

    public void doAddOrUpdateTag(int offset, ChatContextTag tag, BiFunction<ChatContextTag, ChatContextTag, Boolean> tagComparator) {
        if (!this.isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tag.getText())) {
            return;
        }
        this.removeEmptyTooltip();
        ChatContextTagButton target = null;
        int index = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ChatContextTagButton button;
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton) || !tagComparator.apply((button = (ChatContextTagButton)component).getTag(), tag).booleanValue()) continue;
            target = button;
            index = i;
            break;
        }
        if (target == null) {
            this.add((Component)this.buildTagButton(tag, true), offset);
        } else if (!ChatContextTypeEnum.IMAGE.getType().equals(tag.getType())) {
            ChatContextTag ct = ((ChatContextTagButton)this.getComponents()[index]).getTag();
            if (!ct.isSticky()) {
                this.remove(index);
                this.add((Component)this.buildTagButton(tag, true), index);
            }
            if (!StringUtils.equals((CharSequence)tag.getId(), (CharSequence)target.getTag().getId())) {
                this.removeAskInputTags(target.getTag());
            }
        }
        this.updateSelectedTagIds(tag);
        this.revalidate();
        this.repaint();
    }

    private void updateSelectedTagIds(ChatContextTag tag) {
        if (null != tag && BooleanUtils.isNotTrue((Boolean)tag.getRecommended())) {
            this.selectedTagIds.add(tag.getId());
        }
    }

    public Boolean removeCurrentTag(ChatContextTag tag, BiFunction<ChatContextTag, ChatContextTag, Boolean> tagComparator) {
        ChatContextTagButton target = null;
        int index = -1;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton)) continue;
            ChatContextTagButton button = (ChatContextTagButton)component;
            if (ChatContextTypeEnum.CURRENT_FILE.getType().equals(button.getTag().getType())) {
                target = button;
                index = i;
            } else if (tagComparator.apply(button.getTag(), tag).booleanValue()) {
                index = i;
            }
            if (target != null) break;
        }
        if (index > -1 && target != null && !target.getTag().isSticky()) {
            this.removeTag(target);
            this.selectedTagIds.remove(target.getTag().getId());
            return true;
        }
        return false;
    }

    public ChatContextTagButton buildTagButton(ChatContextTag tag, Boolean needSetup) {
        return this.buildTagButton(tag, needSetup, true);
    }

    public ChatContextTagButton buildTagButton(ChatContextTag tag, boolean needSetup, boolean needListeners) {
        boolean enableDrag = this.chatInputContext.getInputMainPanel() != null;
        ChatContextTagButton askTag = new ChatContextTagButton(this.project, this, tag, enableDrag, needListeners);
        ChatContextTypeEnum typeEnum = ChatContextTypeEnum.getByType(tag.getType());
        if (typeEnum != null) {
            askTag.setIcon(typeEnum.getDefaultIcon());
            if (typeEnum.getProvider() != null && (needSetup || !(typeEnum.getProvider() instanceof ImageChatContextRefProvider))) {
                typeEnum.getProvider().setup(this.project, tag, askTag);
            }
        }
        return askTag;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.contextAddButton != null) {
            this.contextAddButton.setEnabled(enabled);
        }
        this.revalidate();
        this.repaint();
    }

    public void setFocusState(boolean focus) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.contextAddButton != null) {
            this.contextAddButton.setFocusState(focus);
            this.revalidate();
            this.repaint();
        }
    }

    public List<ChatContextTag> getTags() {
        return this.getRecommendedTags(-1);
    }

    public List<ChatContextTag> getRecommendedTags(int filterOption) {
        ArrayList<ChatContextTag> tags = new ArrayList<ChatContextTag>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton)) continue;
            ChatContextTagButton askTag = (ChatContextTagButton)component;
            if (-1 == filterOption && null != askTag.getTag() && Boolean.TRUE.equals(askTag.getTag().getRecommended()) || 1 == filterOption && null != askTag.getTag() && Boolean.FALSE.equals(askTag.getTag().getRecommended())) continue;
            tags.add(askTag.getTag());
        }
        return tags;
    }

    public void removeTag(ChatContextTagButton tagButton) {
        this.remove(tagButton);
        this.selectedTagIds.remove(tagButton.getTag().getId());
        int validCount = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton)) continue;
            ++validCount;
        }
        if (validCount == 0) {
            this.addEmptyTooltip();
        }
        this.revalidate();
        this.repaint();
        this.removeAskInputTags(tagButton.getTag());
    }

    public void removeAskInputTags(ChatContextTag contextTag) {
        if (contextTag == null) {
            log.warn("removeAskInputTag contextTag is null");
            return;
        }
        List<ChatAskTag> tags = this.chatInputContext.getInputMainPanel().getTags();
        if (CollectionUtils.isNotEmpty(tags)) {
            List<ChatAskTag> sameIdTags = tags.stream().filter(contextTag::equalsToAskTag).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sameIdTags)) {
                sameIdTags.forEach(tag -> this.chatInputContext.getInputMainPanel().replaceTagWithText((ChatAskTag)tag));
            }
        }
    }

    public void removeAllTags() {
        this.updateTagsExcept(new HashSet<ChatContextTypeEnum>(1), 0);
        this.selectedTagIds.clear();
    }

    public void updateTagsExcept(Set<ChatContextTypeEnum> reserveTagTypes, int mode) {
        this.updateTagsWithCondition(reserveTagTypes, true, mode);
    }

    public void removeTagsOfTypes(Set<ChatContextTypeEnum> removeTagTypes) {
        this.updateTagsWithCondition(removeTagTypes, false, 0);
    }

    private void updateTagsWithCondition(@NotNull Set<ChatContextTypeEnum> tagTypes, boolean reserveMode, int mode) {
        if (tagTypes == null) {
            ChatContextTagsPanel.$$$reportNull$$$0(0);
        }
        ArrayList<Component> tagComponents = new ArrayList<Component>();
        int validCount = 0;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton)) continue;
            ChatContextTypeEnum tagType = ChatContextTypeEnum.getByType(((ChatContextTagButton)component).getTag().getType());
            boolean shouldRemove = reserveMode ? !tagTypes.contains((Object)tagType) : tagTypes.contains((Object)tagType);
            if (shouldRemove) {
                tagComponents.add(component);
                continue;
            }
            ++validCount;
        }
        if (!tagComponents.isEmpty()) {
            for (Component component : tagComponents) {
                if (mode == 0) {
                    this.remove(component);
                    this.selectedTagIds.remove(((ChatContextTagButton)component).getTag().getId());
                } else if (mode == 1) {
                    if (component instanceof ChatContextTagButton) {
                        ((ChatContextTagButton)component).setValid(false);
                    } else {
                        component.setEnabled(false);
                    }
                } else if (mode == 2) {
                    if (component instanceof ChatContextTagButton) {
                        ((ChatContextTagButton)component).setValid(true);
                    } else {
                        component.setEnabled(true);
                    }
                }
                if (mode >= 2 || !(component instanceof ChatContextTagButton)) continue;
                this.removeAskInputTags(((ChatContextTagButton)component).getTag());
            }
        }
        if (validCount == 0) {
            this.addEmptyTooltip();
        }
        this.revalidate();
        this.repaint();
    }

    public void removeLast() {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton)) continue;
            this.remove(component);
            this.revalidate();
            this.repaint();
            break;
        }
    }

    public void removeById(String id) {
        boolean removed = false;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ChatContextTagButton button;
            Component component = this.getComponent(i);
            if (!(component instanceof ChatContextTagButton) || !(button = (ChatContextTagButton)component).getTag().getId().equals(id)) continue;
            this.remove(button);
            removed = true;
            this.selectedTagIds.remove(id);
            break;
        }
        if (!removed) {
            log.warn("No component found with id: " + id);
        }
        if (this.getComponentCount() == 1) {
            this.addEmptyTooltip();
        }
        this.revalidate();
        this.repaint();
    }

    public void updateUiTexts() {
        if (null != this.emptyLabel) {
            this.emptyLabel.setText(CosyBundle.message("chat.context.add.tooltip", new Object[0]));
        }
    }

    public void recoverContextTags(List<ChatContextTag> contextTags) {
        if (null != contextTags) {
            this.removeAllTags();
            contextTags.forEach(this::addTag);
        }
    }

    @Generated
    public ChatContextAddButton getContextAddButton() {
        return this.contextAddButton;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public ChatInputContext getChatInputContext() {
        return this.chatInputContext;
    }

    @Generated
    public JLabel getEmptyLabel() {
        return this.emptyLabel;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public Set<String> getSelectedTagIds() {
        return this.selectedTagIds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagTypes", "com/alibabacloud/intellij/cosy/ui/search/generate/input/ChatContextTagsPanel", "updateTagsWithCondition"));
    }
}

