/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.context.AgentProvider;
import com.alibabacloud.intellij.cosy.chat.context.FileChatContextRefProvider;
import com.alibabacloud.intellij.cosy.chat.context.FoldersChatContextRefProvider;
import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.search.util.PopUtil;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SuggestPromptPopupPanelSourceEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.FilePathTreeNode;
import com.alibabacloud.intellij.cosy.ui.search.generate.QueryRange;
import com.alibabacloud.intellij.cosy.ui.search.generate.SelectedSuggestResult;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptAbstractPopup;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.renderer.FilePathTreeCellRender;
import com.alibabacloud.intellij.cosy.ui.search.renderer.InputSuggestPromptListCellRender;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileQueryUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SuggestPromptPopupPanel {
    private static final Logger LOG = Logger.getInstance(SuggestPromptPopupPanel.class);
    private static final int MIN_VERSION_2024 = 241;
    public static final String TRIGGER_AREA_INPUT_PANEL = "inputPanel";
    public static final String TRIGGER_AREA_CONTEXT_PANEL = "contextPanel";
    public static final String EMPTY_ITEM_ID = "EMPTY_ITEM";
    public static final String TOP_BAR_ITEM_ID = "TOP_BAR_ITEM";
    private static final int MAX_DISPLAY_LIST_HEIGHT = 320;
    private Project project;
    private List<SuggestPrompt> suggestValueList;
    private JBList<SuggestPrompt> promptItemList;
    private SuggestPromptAbstractPopup promptSuggestPopup;
    private Balloon balloon;
    private int lastPopupHeight = 0;
    private Consumer<SelectedSuggestResult> chooseSuggestPromptCallback;
    private JPanel topNavigationPanel;
    private JPanel bottomPanel;
    private JBTextField searchTextArea;
    private JBPopup filePathTreePopup;
    private JScrollPane suggestPromptScrollPane;
    private JPanel contentPanel;
    private String originPromptType;
    private String currentPromptType;
    private Point location;
    private int currentLevel = 1;
    private JComponent hostComponent;
    private String triggerComponent;
    private QueryRange queryRange;
    private ChatInputContext chatInputContext;
    private Debouncer filePathTreeDebouncer;
    private Debouncer searchSuggestPromptDebouncer;
    private AtomicLong lastChoozeTime = new AtomicLong(0L);
    JBPopupListener popupListener;
    SuggestPromptPopupPanelSourceEnum source;
    JLabel selectedLabel;
    String query;

    public SuggestPromptPopupPanel(ChatInputContext chatInputContext, JBPopupListener popupListener, Consumer<SelectedSuggestResult> chooseSuggestPromptCallback) {
        this.project = chatInputContext.getProject();
        this.hostComponent = chatInputContext.getInputMainPanel().inputPanel;
        this.popupListener = popupListener;
        this.chooseSuggestPromptCallback = chooseSuggestPromptCallback;
        this.chatInputContext = chatInputContext;
        this.filePathTreeDebouncer = new Debouncer();
        this.searchSuggestPromptDebouncer = new Debouncer();
        this.selectedLabel = new JLabel(LingmaIcons.ListSelectedBlue20Icon);
        this.initSuggestPromptChooser();
    }

    public void displaySuggestPrompts(String query, String promptType, Point location, String triggerComponent, QueryRange queryRange, SuggestPromptPopupPanelSourceEnum source) {
        this.originPromptType = promptType;
        this.location = location;
        this.queryRange = queryRange;
        this.triggerComponent = triggerComponent;
        this.source = source;
        this.doDisplaySuggestPrompts(query, promptType, location, 1);
        this.lastChoozeTime.getAndSet(0L);
    }

    private SuggestPrompt uploadImage() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter(virtualFile -> {
            String extension = FileNameUtils.getExtension((String)virtualFile.getName()) == null ? null : StringUtils.lowerCase((String)FileNameUtils.getExtension((String)virtualFile.getName()));
            Boolean result = FileUtil.VALIDATE_IMAGE_EXT.contains(extension);
            return result;
        }).withShowHiddenFiles(false).withTitle(CosyBundle.message("suggest.choose.image.dialog.title", new Object[0]));
        SuggestPrompt imageSuggestPrompt = new SuggestPrompt();
        AtomicBoolean selectFile = new AtomicBoolean(false);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.project, null, files -> {
            if (CollectionUtils.isEmpty((Collection)files)) {
                return;
            }
            selectFile.set(true);
            VirtualFile file = (VirtualFile)files.get(0);
            String filePath = file.getPresentableUrl();
            if (filePath == null || filePath.isEmpty()) {
                LOG.warn("filePath is empty, fileName is " + file.getName());
                NotificationFactory.showToast(this.hostComponent, MessageType.ERROR, CosyBundle.message("suggest.prompt.popup.image.file.type.invalid", new Object[0]));
                return;
            }
            imageSuggestPrompt.setText(file.getName());
            imageSuggestPrompt.setType("context");
            imageSuggestPrompt.setDrillDownEnable(false);
            imageSuggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("contextType", ChatContextTypeEnum.IMAGE.getType());
            extra.put("fileType", "image");
            extra.put("filePath", file.getPresentableUrl());
            imageSuggestPrompt.setExtra(extra);
        });
        if (selectFile.get()) {
            return imageSuggestPrompt;
        }
        return null;
    }

    private void doDisplaySuggestPrompts(String query, String promptType, Point location, int level) {
        this.searchSuggestPromptDebouncer.debounce(() -> {
            this.query = query;
            this.currentPromptType = promptType;
            this.currentLevel = level;
            List<SuggestPrompt> allSuggestPrompt = this.getSuggestPromptList(query);
            SwingUtilities.invokeLater(() -> {
                if (level == 1 && TRIGGER_AREA_INPUT_PANEL.equals(this.triggerComponent)) {
                    List emptySuggestList = allSuggestPrompt.stream().filter(suggestPrompt -> EMPTY_ITEM_ID.equals(suggestPrompt.getId())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty((Collection)allSuggestPrompt) || emptySuggestList.size() == 1) {
                        if (this.promptSuggestPopup != null) {
                            this.promptSuggestPopup.cancel();
                            return;
                        }
                        return;
                    }
                }
                this.suggestPrompts(allSuggestPrompt, location, query);
            });
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private List<SuggestPrompt> getSuggestPromptList(String query) {
        List imagePrompt;
        List<SuggestPrompt> prompts;
        List<SuggestPrompt> filePrompts;
        String sessionType = this.chatInputContext.getBaseChatPanel().getSessionType();
        String string = sessionType = sessionType == null ? SessionTypeEnum.CHAT.getType() : sessionType;
        if (query != null) {
            query = query.toLowerCase();
        }
        List<SuggestPrompt> allSuggestPrompt = new ArrayList<SuggestPrompt>();
        String finalQuery = query;
        AgentProvider agentProvider = SessionTypeEnum.getByType(sessionType).getProvider();
        if (this.currentPromptType == null) {
            if (agentProvider != null) {
                allSuggestPrompt.addAll(agentProvider.listAllPromptsExceptScope(this.project, query, this.chatInputContext.getHistoryEmpty().get()));
            }
        } else if (this.currentPromptType.equals("context")) {
            if (agentProvider != null) {
                allSuggestPrompt.addAll(agentProvider.listScopePrompts(this.project, query));
            }
            allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && !ChatContextTypeEnum.SELECTED_CODE.getType().equals(suggestPrompt.getContextName())).collect(Collectors.toList());
            if (query != null && !query.isEmpty()) {
                allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && suggestPrompt.getText().toLowerCase().contains(finalQuery)).collect(Collectors.toList());
            }
            filePrompts = StringUtils.isEmpty((CharSequence)query) ? ChatContextTypeEnum.FILE.getProvider().listSuggestPrompts(this.project, query) : FileQueryUtil.query(this.project, query).stream().filter(file -> !FileUtil.isRuleDirectory(file)).map(file -> file.isDirectory() ? FoldersChatContextRefProvider.getSuggestPrompt(file) : FileChatContextRefProvider.getSuggestPrompt(file, InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType()), this.project)).collect(Collectors.toList());
            allSuggestPrompt.addAll(filePrompts);
        } else if (this.currentPromptType.equals("agent")) {
            if (agentProvider != null) {
                allSuggestPrompt.addAll(agentProvider.listAgentPrompts(this.project, query));
            }
            if (query != null && !query.isEmpty()) {
                allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText() != null && suggestPrompt.getText().toLowerCase().contains(finalQuery)).collect(Collectors.toList());
            }
        } else if (this.currentPromptType.equals(ChatContextTypeEnum.FILE.getType())) {
            filePrompts = ChatContextTypeEnum.FILE.getProvider().listSuggestPrompts(this.project, query);
            allSuggestPrompt.addAll(filePrompts);
        } else if (this.currentPromptType.equals(ChatContextTypeEnum.GIT_COMMIT.getType())) {
            filePrompts = ChatContextTypeEnum.GIT_COMMIT.getProvider().listSuggestPrompts(this.project, query);
            allSuggestPrompt.addAll(filePrompts);
        } else if (this.currentPromptType.equals(ChatContextTypeEnum.TEAM_DOCS.getType())) {
            AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(this.project);
            if (StringUtils.isNotBlank((CharSequence)authStatus.getOrgId())) {
                List<SuggestPrompt> filePrompts2 = ChatContextTypeEnum.TEAM_DOCS.getProvider().listSuggestPrompts(this.project, query);
                allSuggestPrompt.addAll(filePrompts2);
            }
        } else if (this.currentPromptType.equals(ChatContextTypeEnum.FOLDER.getType())) {
            prompts = ChatContextTypeEnum.FOLDER.getProvider().listSuggestPrompts(this.project, query);
            allSuggestPrompt.addAll(prompts);
        } else if (this.currentPromptType.equals(ChatContextTypeEnum.RULE.getType())) {
            prompts = ChatContextTypeEnum.RULE.getProvider().listSuggestPrompts(this.project, query);
            allSuggestPrompt.addAll(prompts);
        }
        if (CollectionUtils.isEmpty(allSuggestPrompt)) {
            SuggestPrompt emptyPrompt = new SuggestPrompt();
            emptyPrompt.setId(EMPTY_ITEM_ID);
            emptyPrompt.setText(CosyBundle.message("suggest.prompt.popup.search.empty", new Object[0]));
            emptyPrompt.setEnabled(false);
            emptyPrompt.setDrillDownEnable(false);
            allSuggestPrompt.add(emptyPrompt);
        }
        if (CollectionUtils.isNotEmpty(imagePrompt = (allSuggestPrompt = this.filterValidSuggestPrompt(allSuggestPrompt)).stream().filter(suggestPrompt -> ChatContextTypeEnum.IMAGE.getType().equals(suggestPrompt.getContextName())).collect(Collectors.toList()))) {
            List<ChatContextTag> selectedContextTags = this.chatInputContext.getInputMainPanel().getInputTagsPanel().getTags();
            if (CollectionUtils.isNotEmpty(selectedContextTags)) {
                List imageContextTags = selectedContextTags.stream().filter(chatContextTag -> chatContextTag.getContextProvider() != null && ChatContextTypeEnum.IMAGE.getType().equals(chatContextTag.getContextProvider().getContextName())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(imageContextTags) && imageContextTags.size() >= 5) {
                    ((SuggestPrompt)imagePrompt.get(0)).setEnabled(false);
                } else {
                    ((SuggestPrompt)imagePrompt.get(0)).setEnabled(true);
                }
            } else {
                ((SuggestPrompt)imagePrompt.get(0)).setEnabled(true);
            }
        }
        this.setTopBarSuggestPrompt(allSuggestPrompt);
        return allSuggestPrompt;
    }

    private List<SuggestPrompt> filterValidSuggestPrompt(List<SuggestPrompt> allSuggestPrompt) {
        List<ChatAskTag> tags = this.chatInputContext.getInputMainPanel().getTags();
        if (CollectionUtils.isEmpty(tags)) {
            return allSuggestPrompt;
        }
        List agentTags = tags.stream().filter(tag -> tag.getType().equals("agent")).collect(Collectors.toList());
        List taskTags = tags.stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(agentTags)) {
            List agentTagTextList = agentTags.stream().map(ChatAskTag::getText).collect(Collectors.toList());
            if (agentTagTextList.contains(AgentTagEnum.WORKSPACE.getName())) {
                allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText().substring(1).equals(ChatContextTypeEnum.SELECTED_CODE.getType()) || suggestPrompt.getText().substring(1).equals(ChatContextTypeEnum.TEAM_DOCS.getType())).collect(Collectors.toList());
                return allSuggestPrompt;
            }
            if (agentTagTextList.contains(AgentTagEnum.TERMINAL.getName())) {
                allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText().substring(1).equals(ChatContextTypeEnum.SELECTED_CODE.getType())).collect(Collectors.toList());
                return allSuggestPrompt;
            }
            if (agentTagTextList.contains(AgentTagEnum.LINGMA.getName())) {
                return new ArrayList<SuggestPrompt>();
            }
        }
        if (CollectionUtils.isNotEmpty(taskTags)) {
            for (ChatAskTag tag2 : taskTags) {
                Set<String> keySet = InputConstants.TASK_SLASH_ACTION_MAP.keySet();
                if (!keySet.contains(tag2.getText())) continue;
                allSuggestPrompt = allSuggestPrompt.stream().filter(suggestPrompt -> suggestPrompt.getText().substring(1).equals(ChatContextTypeEnum.SELECTED_CODE.getType())).collect(Collectors.toList());
            }
        }
        return allSuggestPrompt;
    }

    public void suggestPrompts(List<SuggestPrompt> suggestPrompts, Point location, String query) {
        if (this.promptSuggestPopup != null && CollectionUtils.isEmpty(suggestPrompts)) {
            this.promptSuggestPopup.cancel();
            return;
        }
        if (CollectionUtils.isEmpty(suggestPrompts)) {
            return;
        }
        Rectangle ideBounds = SwingUtilities.getWindowAncestor(this.hostComponent).getBounds();
        if (PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
            this.promptItemList.setModel((ListModel)new CollectionListModel(suggestPrompts));
            ScrollingUtil.ensureIndexIsVisible(this.promptItemList, (int)0, (int)1);
            this.promptItemList.getEmptyText().setText("");
            this.adjustJbPopSize();
            int currentHeight = (int)this.promptSuggestPopup.getContent().getPreferredSize().getHeight();
            Point newPoint = this.getNewPoint(ideBounds, currentHeight);
            Rectangle targetBounds = new Rectangle(newPoint, this.promptSuggestPopup.getContent().getPreferredSize());
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ideBounds, null);
            if (this.lastPopupHeight != currentHeight) {
                this.promptSuggestPopup.setLocation(targetBounds.getLocation());
                this.lastPopupHeight = currentHeight;
            }
            this.suggestPromptScrollPane.getVerticalScrollBar().setValue(0);
            this.promptItemList.setSelectedIndex(0);
            if (this.searchTextArea != null) {
                this.searchTextArea.requestFocus();
            }
            return;
        }
        if (this.promptSuggestPopup != null) {
            this.suggestPromptScrollPane.getVerticalScrollBar().setValue(0);
            this.promptSuggestPopup.cancel();
        }
        this.initSuggestPromptPopup();
        this.suggestPromptScrollPane.getVerticalScrollBar().setValue(0);
        this.promptItemList.setModel((ListModel)new CollectionListModel(suggestPrompts));
        this.promptItemList.setSelectedIndex(0);
        this.promptItemList.getEmptyText().setText("");
        this.adjustJbPopSize();
        int currentHeight = (int)this.promptSuggestPopup.getSize().getHeight();
        if (this.popupListener != null) {
            this.promptSuggestPopup.addListener(this.popupListener);
        }
        this.promptSuggestPopup.showInScreenCoordinates(this.hostComponent, this.getNewPoint(ideBounds, currentHeight));
        this.addSearchPanel(location);
        this.lastPopupHeight = currentHeight;
        if (this.searchTextArea != null) {
            this.searchTextArea.requestFocus();
        }
    }

    private Point getNewPoint(Rectangle ideBounds, int currentHeight) {
        Point topPosition = new Point(this.location.x, this.location.y - currentHeight);
        Point bottomPosition = new Point(this.location.x, this.location.y + this.chatInputContext.getInputMainPanel().getHeight());
        return topPosition.y >= ideBounds.y ? topPosition : bottomPosition;
    }

    private void addSearchPanel(final Point location) {
        if (TRIGGER_AREA_CONTEXT_PANEL.equals(this.triggerComponent) && !"agent".equals(this.currentPromptType)) {
            this.bottomPanel = new JPanel(new BorderLayout());
            this.bottomPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)12, (int)2, (int)0));
            this.contentPanel.add((Component)this.bottomPanel, "South");
            final RoundRectPanel searchPanel = new RoundRectPanel(new BorderLayout());
            int version = ApplicationInfo.getInstance().getBuild().getBaselineVersion();
            searchPanel.setBorder((Border)JBUI.Borders.empty((int)7, (int)4));
            if (version < 241) {
                searchPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
            }
            searchPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.bottomPanel.add((Component)searchPanel, "Center");
            this.searchTextArea = this.promptSuggestPopup.getSearchField();
            if (SystemInfo.isMac) {
                // empty if block
            }
            searchPanel.add((Component)this.searchTextArea, "Center");
            this.searchTextArea.setBorder((Border)JBUI.Borders.empty());
            this.searchTextArea.getEmptyText().setText(CosyBundle.message("search.by.keywords", new Object[0]));
            this.searchTextArea.setBackground(ColorUtil.getEditorBackgroundColor());
            this.searchTextArea.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    searchPanel.setBorderColor(JBUI.CurrentTheme.Focus.focusColor());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    super.focusLost(e);
                    searchPanel.setBorderColor(null);
                }
            });
            this.searchTextArea.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 40: {
                            SuggestPromptPopupPanel.this.moveDownPromptItemList(e.getModifiersEx());
                            e.consume();
                            break;
                        }
                        case 38: {
                            SuggestPromptPopupPanel.this.moveUpPromptItemList(e.getModifiersEx());
                            e.consume();
                            break;
                        }
                        case 33: {
                            SuggestPromptPopupPanel.this.movePageUpPromptItemList();
                            break;
                        }
                        case 34: {
                            SuggestPromptPopupPanel.this.movePageDownPromptItemList();
                            break;
                        }
                        case 10: {
                            SuggestPrompt suggestPrompt = (SuggestPrompt)SuggestPromptPopupPanel.this.promptItemList.getSelectedValue();
                            SuggestPromptPopupPanel.this.handleChosenSuggest(suggestPrompt);
                        }
                    }
                }
            });
            this.searchTextArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent event) {
                    SuggestPromptPopupPanel.this.doDisplaySuggestPrompts(SuggestPromptPopupPanel.this.searchTextArea.getText(), SuggestPromptPopupPanel.this.currentPromptType, location, SuggestPromptPopupPanel.this.currentLevel);
                }
            });
            this.searchTextArea.addInputMethodListener(new InputMethodListener(){

                @Override
                public void inputMethodTextChanged(InputMethodEvent event) {
                    if (event.getCommittedCharacterCount() <= 0) {
                        event.consume();
                    }
                }

                @Override
                public void caretPositionChanged(InputMethodEvent event) {
                }
            });
        }
    }

    private void setTopBarSuggestPrompt(List<SuggestPrompt> suggestPrompts) {
        if (this.currentLevel <= 1) {
            return;
        }
        SuggestPrompt emptyPrompt = new SuggestPrompt();
        emptyPrompt.setId(TOP_BAR_ITEM_ID);
        emptyPrompt.setText(this.currentPromptType);
        emptyPrompt.setEnabled(true);
        suggestPrompts.add(0, emptyPrompt);
    }

    private void adjustJbPopSize() {
        int width = this.hostComponent.getSize().width;
        Dimension scrollPaneSize = this.suggestPromptScrollPane.getSize();
        scrollPaneSize.height = this.promptItemList.getPreferredSize().height >= 320 ? 320 : this.promptItemList.getPreferredSize().height;
        if (this.searchTextArea != null) {
            this.contentPanel.setSize(new Dimension(this.contentPanel.getSize().width, scrollPaneSize.getSize().height + 32 + 16));
        } else {
            this.contentPanel.setSize(new Dimension(this.contentPanel.getSize().width, scrollPaneSize.getSize().height + 16));
        }
        this.suggestPromptScrollPane.getViewport().setSize(scrollPaneSize);
        Dimension dimension = new Dimension(width, this.contentPanel.getSize().height);
        this.promptSuggestPopup.setSize(dimension);
    }

    public void initSuggestPromptChooser() {
        if (this.promptItemList == null) {
            this.promptItemList = new JBList();
            this.promptItemList.setVisibleRowCount(10);
            this.promptItemList.setOpaque(false);
            this.promptItemList.setCellRenderer((ListCellRenderer)new InputSuggestPromptListCellRender(this.project, this.hostComponent, this));
            this.promptItemList.setBorder(BorderFactory.createEmptyBorder());
            ListUtil.installAutoSelectOnMouseMove(this.promptItemList);
            ScrollingUtil.installActions(this.promptItemList);
            this.promptItemList.addListSelectionListener(e -> {
                if (!PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
                    return;
                }
                SuggestPrompt suggestPrompt = (SuggestPrompt)this.promptItemList.getSelectedValue();
                if (suggestPrompt == null || !"context".equals(suggestPrompt.getType()) || suggestPrompt.getContextProvider() == null) {
                    if (this.filePathTreePopup != null) {
                        this.filePathTreePopup.cancel();
                    }
                    return;
                }
                SuggestPrompt contextProvider = suggestPrompt.getContextProvider();
                String providerName = contextProvider.getText().substring(1);
                if (!ChatContextTypeEnum.FILE.getType().equals(providerName) && !ChatContextTypeEnum.FOLDER.getType().equals(providerName)) {
                    if (this.filePathTreePopup != null) {
                        this.filePathTreePopup.cancel();
                    }
                    return;
                }
                this.filePathTreeDebouncer.debounce(suggestPrompt.getId(), () -> {
                    Point indexPoint = this.promptItemList.indexToLocation(this.promptItemList.getSelectedIndex());
                    Point promptListPoint = this.promptItemList.getLocationOnScreen();
                    promptListPoint.y += indexPoint.y;
                    SwingUtilities.invokeLater(() -> {
                        if (null != this.filePathTreePopup) {
                            this.filePathTreePopup.cancel();
                        }
                        this.filePathTreePopup = SuggestPromptPopupPanel.displayFilePathTree(this.project, this.promptSuggestPopup.getOwner(), this.promptSuggestPopup.getContent().getPreferredSize(), suggestPrompt.getId(), this.promptItemList, promptListPoint);
                    });
                    return null;
                }, 100L, TimeUnit.MILLISECONDS);
            });
            this.promptItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!PopUtil.isPopUsable((JBPopup)SuggestPromptPopupPanel.this.promptSuggestPopup)) {
                        return;
                    }
                    SuggestPrompt suggestPrompt = (SuggestPrompt)SuggestPromptPopupPanel.this.promptItemList.getSelectedValue();
                    ChatContextTagsPanel inputTagsPanel = SuggestPromptPopupPanel.this.chatInputContext.getInputMainPanel().getInputTagsPanel();
                    Set<String> selectedTagIds = inputTagsPanel.getSelectedTagIds();
                    if (SuggestPromptPopupPanelSourceEnum.BUTTON == SuggestPromptPopupPanel.this.source && selectedTagIds.contains(suggestPrompt.getId())) {
                        if (SuggestPromptUtil.isSupportDrillDown(SuggestPromptPopupPanel.this.project, suggestPrompt.getContextName())) {
                            inputTagsPanel.removeById(suggestPrompt.getId());
                            inputTagsPanel.removeAskInputTags(ChatContextTag.builder().id(suggestPrompt.getId()).type(suggestPrompt.getType()).build());
                            selectedTagIds.remove(suggestPrompt.getId());
                        }
                    } else {
                        SuggestPromptPopupPanel.this.handleChosenSuggest(suggestPrompt);
                    }
                    SuggestPromptPopupPanel.this.promptItemList.revalidate();
                    SuggestPromptPopupPanel.this.promptItemList.repaint();
                    e.consume();
                }
            });
        }
        this.suggestPromptScrollPane = new JBScrollPane();
        this.suggestPromptScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.suggestPromptScrollPane.setViewportView((Component)this.promptItemList);
        this.suggestPromptScrollPane.setOpaque(false);
        this.suggestPromptScrollPane.setVerticalScrollBarPolicy(20);
        this.suggestPromptScrollPane.setHorizontalScrollBarPolicy(31);
        this.suggestPromptScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
            JScrollBar scrollBar = (JScrollBar)e.getAdjustable();
            int extent = scrollBar.getModel().getExtent();
            int maximum = scrollBar.getMaximum();
            int value = scrollBar.getValue();
            if (value + extent == maximum) {
                List<SuggestPrompt> delta;
                ListModel old;
                ChatContextTypeEnum contextType = ChatContextTypeEnum.getByType(this.currentPromptType);
                if (this.currentLevel > 1 && contextType != null && contextType.getProvider() != null && (old = this.promptItemList.getModel()).getSize() > 0 && !((SuggestPrompt)old.getElementAt(0)).getId().equals(EMPTY_ITEM_ID) && CollectionUtils.isNotEmpty(delta = contextType.getProvider().getRollingUpdateSuggestPrompts(this.project, null == this.searchTextArea ? null : this.searchTextArea.getText()))) {
                    int oldSize = old.getSize();
                    this.promptItemList.setModel((ListModel)new CollectionListModel(this.mergeSuggestPrompts(old, delta)));
                    SwingUtilities.invokeLater(() -> {
                        JScrollBar verticalScrollBar = this.suggestPromptScrollPane.getVerticalScrollBar();
                        int cellHeight = this.promptItemList.getFixedCellHeight();
                        if (cellHeight <= 0) {
                            Rectangle cellBounds = this.promptItemList.getCellBounds(0, 0);
                            cellHeight = cellBounds != null ? cellBounds.height : 20;
                        }
                        int targetScrollPosition = Math.max(0, (oldSize - 8) * cellHeight);
                        verticalScrollBar.setValue(targetScrollPosition);
                    });
                }
            }
        });
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.contentPanel.add((Component)this.suggestPromptScrollPane, "Center");
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.promptItemList.setBackground(ColorUtil.getListBackground());
        this.promptItemList.getEmptyText().setText("");
    }

    private List<SuggestPrompt> mergeSuggestPrompts(ListModel<SuggestPrompt> old, List<SuggestPrompt> delta) {
        ArrayList<SuggestPrompt> result = new ArrayList<SuggestPrompt>();
        for (int i = 0; i < old.getSize(); ++i) {
            result.add(old.getElementAt(i));
        }
        result.addAll(delta);
        return result;
    }

    private void initSuggestPromptPopup() {
        this.initSuggestPromptChooser();
        this.promptSuggestPopup = new SuggestPromptAbstractPopup(this.contentPanel, this.project, TRIGGER_AREA_CONTEXT_PANEL.equals(this.triggerComponent));
        this.promptSuggestPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                SuggestPromptPopupPanel.this.searchTextArea = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/cosy/ui/search/generate/SuggestPromptPopupPanel$6", "onClosed"));
            }
        });
    }

    private void handleChosenSuggest(SuggestPrompt suggestPrompt) {
        if (suggestPrompt == null || suggestPrompt.getText() == null) {
            return;
        }
        if (TOP_BAR_ITEM_ID.equals(suggestPrompt.getId())) {
            this.doDisplaySuggestPrompts(null, this.originPromptType, this.location, 1);
            return;
        }
        if (suggestPrompt.getDrillDownEnable().booleanValue()) {
            if (SuggestPromptUtil.isSupportDrillDown(this.project, suggestPrompt.getText().substring(1))) {
                this.doDisplaySuggestPrompts(null, suggestPrompt.getText().substring(1), this.location, 2);
            }
            return;
        }
        SelectedSuggestResult selectedSuggestResult = new SelectedSuggestResult();
        selectedSuggestResult.setQueryRange(this.queryRange);
        selectedSuggestResult.setTriggerComponent(this.triggerComponent);
        if (SuggestPromptPopupPanelSourceEnum.INPUT == this.source) {
            this.promptSuggestPopup.cancel();
        }
        if (ChatContextTypeEnum.IMAGE.getType().equals(suggestPrompt.getText().substring(1))) {
            if (!BooleanUtils.isTrue((Boolean)suggestPrompt.isEnabled())) {
                return;
            }
            this.chatInputContext.getInputMainPanel().getTags();
            SuggestPrompt imageSuggestPrompt = this.uploadImage();
            if (imageSuggestPrompt == null) {
                return;
            }
            imageSuggestPrompt.setContextProvider(suggestPrompt);
            selectedSuggestResult.setSuggestPrompt(imageSuggestPrompt);
        } else if (ChatContextTypeEnum.TEAM_DOCS.getType().equals(suggestPrompt.getText().substring(1))) {
            if (!BooleanUtils.isTrue((Boolean)suggestPrompt.isEnabled())) {
                BrowserUtil.browse((String)LingmaUrls.TEAM_DOCS_URL.getRealUrl());
                return;
            }
            selectedSuggestResult.setSuggestPrompt((SuggestPrompt)SerializationUtils.clone((Serializable)suggestPrompt));
        } else {
            selectedSuggestResult.setSuggestPrompt((SuggestPrompt)SerializationUtils.clone((Serializable)suggestPrompt));
        }
        this.lastChoozeTime.getAndSet(System.currentTimeMillis());
        this.chooseSuggestPromptCallback.consume((Object)selectedSuggestResult);
    }

    public long getLastChooseTime() {
        return this.lastChoozeTime.get();
    }

    public static JBPopup displayFilePathTree(Project project, Component windowForComponent, Dimension windowSize, String filePath, Component fileItem, Point popupPoint) {
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        FilePathTreeNode treeNode = new FilePathTreeNode(virtualFile, project);
        TreeModel treeModel = new TreeModel((TreeNode)treeNode.getRoot(), treeNode.getLevel(), treeNode.getLevel());
        JTree tree = new JTree((javax.swing.tree.TreeModel)treeModel);
        tree.setUI(SuggestPromptPopupPanel.getFIleTreeUI());
        tree.setCellRenderer((TreeCellRenderer)((Object)new FilePathTreeCellRender(project)));
        TreeUtil.expandAll((JTree)tree);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)6, (int)8, (int)8));
        treePanel.add((Component)tree, "Center");
        JBPopup newPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)treePanel, null).setFocusable(false).setRequestFocus(false).setResizable(false).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).createPopup();
        Window window = SwingUtilities.windowForComponent(windowForComponent);
        int x = popupPoint.x - treePanel.getPreferredSize().width - 16;
        if (popupPoint.x - window.getLocation().x < 100) {
            x = popupPoint.x + windowSize.width;
        }
        Point displayPoint = new Point(x, popupPoint.y);
        ReadAction.run(() -> newPopup.showInScreenCoordinates(fileItem, displayPoint));
        return newPopup;
    }

    @NotNull
    private static BasicTreeUI getFIleTreeUI() {
        return new BasicTreeUI(){

            private boolean onlyOneNode() {
                return this.tree.getModel().getChildCount(this.tree.getModel().getRoot()) == 0;
            }

            @Override
            protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                return !this.onlyOneNode() && !isLeaf;
            }

            @Override
            protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                if (this.onlyOneNode()) {
                    return;
                }
                if (!isLeaf) {
                    super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
            }

            @Override
            protected int getRowX(int row, int depth) {
                return this.onlyOneNode() ? 0 : super.getRowX(row, depth);
            }

            @Override
            protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
                if (!this.onlyOneNode()) {
                    super.paintHorizontalLine(g, c, y, left, right);
                }
            }

            @Override
            protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
                if (!this.onlyOneNode()) {
                    super.paintVerticalLine(g, c, x, top, bottom);
                }
            }
        };
    }

    public SuggestPrompt chooseSuggestPromptSelection() {
        if (!PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup) || this.promptItemList == null || this.promptItemList.getSelectedValue() == null) {
            return null;
        }
        SuggestPrompt suggestPrompt = (SuggestPrompt)this.promptItemList.getSelectedValue();
        if (!suggestPrompt.isEnabled() && suggestPrompt.getText().substring(1).equals(ChatContextTypeEnum.TEAM_DOCS.getType())) {
            BrowserUtil.browse((String)LingmaUrls.TEAM_DOCS_URL.getRealUrl());
        }
        return suggestPrompt;
    }

    public boolean isShowPopup() {
        return PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup) && this.promptItemList != null;
    }

    public JBList<SuggestPrompt> getListComponent() {
        return this.promptItemList;
    }

    public void moveDownPromptItemList(int modifiers) {
        if (PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
            ScrollingUtil.moveDown(this.promptItemList, (int)modifiers);
        }
    }

    public void moveUpPromptItemList(int modifiers) {
        if (PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
            this.handleMoveUpEvent(modifiers);
        }
    }

    public void movePageDownPromptItemList() {
        if (PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
            ScrollingUtil.movePageUp(this.promptItemList);
        }
    }

    public void movePageUpPromptItemList() {
        if (PopUtil.isPopUsable((JBPopup)this.promptSuggestPopup)) {
            ScrollingUtil.movePageDown(this.promptItemList);
        }
    }

    public void handleMoveUpEvent(int modifiers) {
        ScrollingUtil.moveUp(this.promptItemList, (int)modifiers);
    }

    public void triggerChooseSuggestPrompt(SuggestPrompt suggestPrompt) {
        this.handleChosenSuggest(suggestPrompt);
    }

    public void cancelPromptSuggestPopup() {
        if (this.promptSuggestPopup != null) {
            this.promptSuggestPopup.cancel();
        }
    }

    public void updatePromptSuggestPopupPosition(Point location) {
        this.location = location;
        int currentHeight = (int)this.promptSuggestPopup.getContent().getPreferredSize().getHeight();
        Window ideWindow = SwingUtilities.getWindowAncestor(this.hostComponent);
        Rectangle ideBounds = ideWindow.getBounds();
        Point newPoint = this.getNewPoint(ideBounds, currentHeight);
        Rectangle targetBounds = new Rectangle(newPoint, this.promptSuggestPopup.getContent().getPreferredSize());
        ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ideBounds, null);
        this.promptSuggestPopup.setLocation(targetBounds.getLocation());
        this.suggestPromptScrollPane.getVerticalScrollBar().setValue(0);
        this.promptItemList.setSelectedIndex(0);
        if (this.searchTextArea != null) {
            this.searchTextArea.requestFocus();
        }
    }

    @Generated
    public ChatInputContext getChatInputContext() {
        return this.chatInputContext;
    }

    @Generated
    public SuggestPromptPopupPanelSourceEnum getSource() {
        return this.source;
    }

    @Generated
    public JLabel getSelectedLabel() {
        return this.selectedLabel;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }
}

