/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.service.MergeFileService;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.component.DiffEditableWindow;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NewFileAction
extends AnAction {
    private static final Logger LOGGER = Logger.getInstance(NewFileAction.class);
    Project project;
    String content;
    boolean isTestcase;
    String ext;
    String filePath;

    public NewFileAction(@NotNull Project project, String content, boolean isTestcase, String ext, String filePath) {
        if (project == null) {
            NewFileAction.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.content = content;
        this.isTestcase = isTestcase;
        this.ext = ext;
        this.filePath = filePath;
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            NewFileAction.$$$reportNull$$$0(1);
        }
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        String path = this.project.getBasePath();
        String separator = FileUtil.getFileSeparator(path);
        LOGGER.info("Creating file, project.getBasePath()=" + path + ", separator=" + separator + ", filePath=" + this.filePath + ", ext=" + this.ext);
        String fullPath = null;
        Object fileName = "tempfile_" + System.currentTimeMillis();
        if (this.filePath != null) {
            String fileNameWithExt = this.filePath.substring(this.filePath.lastIndexOf(FileUtil.getFileSeparator(this.filePath)) + 1);
            fileName = fileNameWithExt.substring(0, fileNameWithExt.lastIndexOf("."));
            fullPath = this.filePath;
        }
        if (selectedEditor != null && selectedEditor.getFile() != null) {
            if (fullPath == null) {
                fullPath = selectedEditor.getFile().getPresentableUrl();
            }
            if (StringUtils.isNotBlank(fullPath)) {
                separator = FileUtil.getFileSeparator(fullPath);
                int sepIndex = fullPath.lastIndexOf(separator);
                if (sepIndex < 0) {
                    LOGGER.warn("bad fullPath:" + fullPath);
                    File dir = new File(fullPath).getParentFile();
                    path = dir != null ? dir.getAbsolutePath() : fullPath;
                } else {
                    path = fullPath.substring(0, sepIndex);
                }
                String selectionFileExt = selectedEditor.getFile().getExtension();
                if (StringUtils.isBlank((CharSequence)this.ext)) {
                    this.ext = selectionFileExt;
                }
                fileName = FileUtil.generateFileNameWhenNewFile(this.ext, this.content, fullPath, (String)fileName, separator, this.isTestcase);
                if (("java".equals(this.ext) || "go".equals(this.ext)) && this.ext.equals(selectionFileExt)) {
                    try {
                        String fileContent = new String(selectedEditor.getFile().contentsToByteArray());
                        path = FileUtil.generatePathWhenNewFile(this.ext, path, this.isTestcase);
                        String firstLine = fileContent.split("\n", 2)[0];
                        if (firstLine.startsWith("package ") && !this.content.trim().startsWith("package ")) {
                            this.content = firstLine + "\n\n" + this.content;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot get file content when new file for the selected file: " + path);
                    }
                }
                if (this.ext == null) {
                    this.ext = selectionFileExt;
                }
            }
        }
        if (path == null) {
            LOGGER.warn("Cannot find path when new file");
            NotificationFactory.showInfoNotification(this.project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            return;
        }
        VirtualFile directory = FileUtil.getDirectoryVirtualFileByPath(path);
        if (directory != null && directory.isDirectory()) {
            String fileNameExt = String.format("%s.%s", fileName, this.ext);
            VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(path + FileUtil.getFileSeparator(path) + fileNameExt);
            if (targetFile != null && targetFile.exists()) {
                fileNameExt = String.format("%s_%d.%s", fileName, System.currentTimeMillis(), this.ext);
                if (this.isTestcase && "java".equalsIgnoreCase(this.ext)) {
                    this.showNewFileDiff(targetFile, this.content, directory, fileNameExt);
                    return;
                }
            }
            this.createNewFile(directory, fileNameExt);
        }
    }

    private void showNewFileDiff(final VirtualFile targetFile, String content, final VirtualFile directory, final String newFileName) {
        ArrayList<DiffEditableWindow.DiffButtonAction> buttonActions = new ArrayList<DiffEditableWindow.DiffButtonAction>();
        buttonActions.add(new DiffEditableWindow.DiffCancelAction(CosyBundle.message("chat.diffview.button.cancel", new Object[0])));
        buttonActions.add(new DiffEditableWindow.DiffButtonAction(CosyBundle.message("chat.diffview.button.newfile", new Object[0])){

            @Override
            public void doAction() {
                NewFileAction.this.createNewFile(directory, newFileName);
            }
        });
        content = MergeFileService.getInstance().mergeFileContent(this.project, targetFile, content);
        buttonActions.add(new DiffEditableWindow.DiffAcceptAction(CosyBundle.message("chat.diffview.button.accept", new Object[0])){

            @Override
            public void doAccept(String content) {
                WriteCommandAction.runWriteCommandAction((Project)NewFileAction.this.project, () -> {
                    Document document = FileDocumentManager.getInstance().getDocument(targetFile);
                    if (document != null) {
                        String textToInsert = DocumentUtils.filterDocumentSlashR(document, content);
                        document.setText((CharSequence)textToInsert);
                    }
                });
            }
        });
        DiffEditableWindow dialog = new DiffEditableWindow(this.project, targetFile, content, buttonActions);
        dialog.setTitle(CosyBundle.message("chat.diffview.label.title", new Object[0]));
        dialog.show();
    }

    private void createNewFile(VirtualFile directory, String newFileName) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> {
            try {
                VirtualFile file = directory.createChildData((Object)this, newFileName);
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    String textToInsert = DocumentUtils.filterDocumentSlashR(document, this.content);
                    document.setText((CharSequence)textToInsert);
                }
                FileEditorManager.getInstance((Project)this.project).openFile(file, false, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anActionEvent";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/generate/NewFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

