/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatNoticeRequest;
import com.alibabacloud.intellij.cosy.chat.model.ChatStopParam;
import com.alibabacloud.intellij.cosy.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.layout.RightFlowLayout;
import com.alibabacloud.intellij.cosy.layout.WrapForKeywordLayout;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatAgentPanel;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.DynamicPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.ToolbarLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatReferencePanel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatThinkingPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.FileMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.ToolMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.BadFeedbackDialog;
import com.alibabacloud.intellij.cosy.ui.search.generate.QuickAskPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatReferenceItem;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiAssistantStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AiDeveloperStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelDisableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelEnableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelMouseEnteredNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelMouseExitedNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatPublishNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.QuestionFormMouseEnteredNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.QuestionFormMouseExitedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GenerateAnswerPanel
extends JPanel
implements Disposable {
    private static final Logger log = Logger.getInstance(GenerateAnswerPanel.class);
    private static final int MIN_BOTTOM_HEIGHT = 40;
    private static final String NoVisibleKnowledgeBase = "no visible knowledge base";
    private static final String FailedQueryRAG = "failed query RAG documents";
    private static final String NoRelevantDocumentsFound = "no relevant documents found";
    public static final String BASE_PANEL_NAME_PREFIX = "GenerateAnswerPanel_BasePanel_";
    protected JLabel cosyLabel;
    protected JPanel basePanel;
    private JPanel mdPanel;
    private JPanel titlePanel;
    private JPanel titleToolBarPanel;
    private JLabel goodLabel;
    private JLabel badLabel;
    private JPanel bottomPanel;
    private JLabel bannerLabel;
    private JLabel copyMarkdownLabel;
    private JPanel answerPanel;
    private JPanel generatingPanel;
    private QuickAskPanel quickAskPanel;
    private String requestId;
    private String sessionId;
    private final String chatTask;
    protected Project project;
    private CosyService cosyService;
    protected MarkdownStreamPanel markdownPanel;
    protected JPanel contentPanel;
    protected ChatStagePanel chatStagePanel;
    private ChatReferencePanel chatReferencePanel;
    private ChatThinkingPanel chatThinkingPanel;
    private BaseChatPanel generateContentForm;
    private DisplayLabel stopBtn;
    private MessageBusConnection messageBusConnection;
    private JLabel generateStateLabel;
    protected JPanel northPanel;
    private SessionTypeEnum sessionType;
    private final String chatMode;
    private String intentionType;

    public GenerateAnswerPanel(Project project, BaseChatPanel generateContentForm, JComponent parentComponent, String chatTask, ChatAskInput chatAskInput, SessionTypeEnum sessionType) {
        List agentTagList;
        this.generateContentForm = generateContentForm;
        this.chatTask = chatTask;
        this.sessionType = sessionType;
        this.$$$setupUI$$$();
        this.basePanel.setBorder((Border)JBUI.Borders.empty());
        this.chatMode = generateContentForm.getChatMode();
        this.cosyLabel.setAlignmentX(5.0f);
        this.cosyLabel.setIcon(LingmaIcons.Logo20Icon);
        this.cosyLabel.setText(I18NConstant.COSY_PLUGIN_NAME);
        if (chatAskInput != null && CollectionUtils.isNotEmpty(chatAskInput.getTags()) && CollectionUtils.isNotEmpty(agentTagList = chatAskInput.getTags().stream().filter(tag -> AgentTagEnum.WORKSPACE.getId().equals(tag.getId()) || AgentTagEnum.TERMINAL.getId().equals(tag.getId())).collect(Collectors.toList()))) {
            this.bannerLabel.setText(((ChatAskTag)agentTagList.get(0)).getText());
            this.bannerLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        }
        this.titleToolBarPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.titleToolBarPanel.setLayout(new RightFlowLayout(2, 16, 0));
        this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.cosyService = new CosyServiceImpl();
        this.project = project;
        this.configContentPanel(parentComponent);
        this.mdPanel.add((Component)this.contentPanel, "Center");
        this.configBottomPanel();
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            if (cp != this.basePanel && cp instanceof JPanel) {
                cp.setOpaque(false);
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
        this.showGenerateStatePanel();
        this.configGoodBadCopyListener();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(QuestionFormMouseEnteredNotifier.MOUSE_ENTERED_NOTIFIER, this::mouseEntered);
        this.messageBusConnection.subscribe(QuestionFormMouseExitedNotifier.MOUSE_EXITED_NOTIFIER, this::mouseExited);
        this.messageBusConnection.subscribe(AnswerPanelDisableNotifier.ANSWER_PANEL_DISABLE_NOTIFIER_TOPIC, this::disableGenerateAnswerPanel);
        this.messageBusConnection.subscribe(AnswerPanelEnableNotifier.ANSWER_PANEL_ENABLE_NOTIFIER, this::enableGenerateAnswerPanel);
        this.messageBusConnection.subscribe(ChatPublishNotifier.CHAT_PUBLISH_NOTIFIER_NOTIFICATION, this::publishNotice);
    }

    private void publishNotice(final ChatNoticeRequest request) {
        if (this.sessionId.equals(request.getSessionId()) && this.requestId.equals(request.getRequestId()) && null != request.getData()) {
            boolean hasMessage;
            String message = null;
            switch (request.getData().getReasonForCode()) {
                case 10408: {
                    message = CosyBundle.message("chat.network.error", new Object[0]);
                    break;
                }
                case 408: 
                case 80408: {
                    message = CosyBundle.message("chat.agent.timeout", new Object[0]);
                    break;
                }
                case 80409: {
                    message = CosyBundle.message("chat.agent.mcp.excess", new Object[0]);
                    break;
                }
                case 80410: {
                    message = CosyBundle.message("chat.agent.mcp.json.invalid", new Object[0]);
                    break;
                }
                case 10605: {
                    message = CosyBundle.message("chat.queued.error", new Object[0]);
                    break;
                }
                case 500: {
                    message = CosyBundle.message("chat.error", new Object[0]);
                    break;
                }
                case 40429: {
                    message = CosyBundle.message("chat.tool.usage.excessive", new Object[0]);
                }
            }
            boolean bl = hasMessage = null != message;
            if (hasMessage) {
                this.markdownPanel.add(this.getErrorMessageBox(message));
            }
            DisplayLabel label = new DisplayLabel(CosyBundle.message("chat.continue.tips", new Object[0]), ColorUtil.getToolWindowBackgroundColor(), null);
            label.setCursor(Cursor.getPredefinedCursor(12));
            final JPanel noticePanel = new JPanel(new WrapForKeywordLayout(0, 8));
            noticePanel.setBorder((Border)JBUI.Borders.empty());
            noticePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
            noticePanel.setOpaque(false);
            noticePanel.add(label);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Cosy.INSTANCE.getLanguageService(GenerateAnswerPanel.this.project).receiveNotice(request);
                    GenerateAnswerPanel.this.generatingPanel.remove(noticePanel);
                    GenerateAnswerPanel.this.generateStateLabel.setVisible(true);
                    if (hasMessage) {
                        GenerateAnswerPanel.this.markdownPanel.remove(GenerateAnswerPanel.this.markdownPanel.getComponents().length - 1);
                    }
                    GenerateAnswerPanel.this.revalidate();
                    GenerateAnswerPanel.this.generatingPanel.repaint();
                }
            });
            this.generatingPanel.add((Component)noticePanel, "West");
            this.generateStateLabel.setVisible(false);
            this.generatingPanel.revalidate();
            this.generatingPanel.repaint();
        }
    }

    private Box getErrorMessageBox(String message) {
        final Box box = Box.createHorizontalBox();
        box.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        final JLabel icon = new JLabel(CommonIcons.infoIcon);
        icon.setAlignmentY(0.0f);
        final JTextArea textArea = new JTextArea(message){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Insets insets = box.getInsets();
                int maxWith = box.getWidth() - icon.getWidth() - insets.left - insets.right;
                if (dim.width > maxWith) {
                    dim.width = maxWith;
                }
                return dim;
            }
        };
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(icon.getFont().deriveFont(0, 13.0f));
        textArea.setAlignmentY(0.0f);
        box.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dim = textArea.getSize();
                Insets insets = box.getInsets();
                int maxWith = box.getWidth() - icon.getWidth() - insets.left - insets.right;
                if (dim.width > maxWith) {
                    dim.width = maxWith;
                }
                textArea.setSize(dim);
                GenerateAnswerPanel.this.markdownPanel.revalidate();
                GenerateAnswerPanel.this.markdownPanel.repaint();
            }
        });
        box.add(icon);
        box.add(Box.createHorizontalStrut(4));
        box.add(textArea);
        SwingUtil.foreachChildComponent(box, cp -> {
            cp.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        });
        return box;
    }

    private void mouseEntered(String requestId) {
        if (StringUtils.equals((CharSequence)this.requestId, (CharSequence)requestId)) {
            this.goodLabel.setVisible(true);
            this.badLabel.setVisible(true);
            this.copyMarkdownLabel.setVisible(true);
            this.titlePanel.revalidate();
            this.titlePanel.repaint();
        }
    }

    private void mouseExited(String requestId) {
        if (StringUtils.equals((CharSequence)this.requestId, (CharSequence)requestId)) {
            this.goodLabel.setVisible(false);
            this.badLabel.setVisible(false);
            this.copyMarkdownLabel.setVisible(false);
            this.titlePanel.revalidate();
            this.titlePanel.repaint();
        }
    }

    protected void configContentPanel(JComponent parentComponent) {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.northPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 8, true, false));
        this.contentPanel.add((Component)this.northPanel, "North");
        this.northPanel.setVisible(false);
        this.markdownPanel = new MarkdownStreamPanel(this.project, parentComponent, this);
        this.contentPanel.add((Component)this.markdownPanel, "Center");
    }

    protected void configGoodBadCopyListener() {
        this.goodLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GenerateAnswerPanel.this.getRequestId() != null && GenerateAnswerPanel.this.getSessionId() != null && GenerateAnswerPanel.this.goodLabel.isEnabled()) {
                    log.info("Like to request id " + GenerateAnswerPanel.this.getRequestId());
                    ChatLikeParam chatLikeParam = ChatLikeParam.builder().sessionId(GenerateAnswerPanel.this.getSessionId()).requestId(GenerateAnswerPanel.this.getRequestId()).like(1).build();
                    GenerateAnswerPanel.this.goodLabel.setIcon(LingmaIcons.LikeBlueIcon);
                    GenerateAnswerPanel.this.invalidLabel(GenerateAnswerPanel.this.goodLabel);
                    GenerateAnswerPanel.this.invalidLabel(GenerateAnswerPanel.this.badLabel);
                    if (!Cosy.INSTANCE.checkCosy(GenerateAnswerPanel.this.project, true)) {
                        return;
                    }
                    GenerateAnswerPanel.this.cosyService.chatLike(GenerateAnswerPanel.this.project, chatLikeParam);
                    TelemetryService.getInstance().telemetrySessionId(GenerateAnswerPanel.this.project, TrackEventTypeEnum.CHAT_ANSWER_CODE_LIKE, GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId(), GenerateAnswerPanel.this.getSessionType().getTelemetryType());
                    GenerateAnswerPanel.this.titlePanel.revalidate();
                    GenerateAnswerPanel.this.titlePanel.repaint();
                }
            }
        });
        this.badLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GenerateAnswerPanel.this.getRequestId() != null && GenerateAnswerPanel.this.getSessionId() != null && GenerateAnswerPanel.this.badLabel.isEnabled()) {
                    log.info("Dislike to request id " + GenerateAnswerPanel.this.getRequestId());
                    ChatLikeParam chatLikeParam = ChatLikeParam.builder().sessionId(GenerateAnswerPanel.this.getSessionId()).requestId(GenerateAnswerPanel.this.getRequestId()).like(-1).build();
                    GenerateAnswerPanel.this.badLabel.setIcon(LingmaIcons.UnlikeBlueIcon);
                    GenerateAnswerPanel.this.invalidLabel(GenerateAnswerPanel.this.goodLabel);
                    GenerateAnswerPanel.this.invalidLabel(GenerateAnswerPanel.this.badLabel);
                    if (!Cosy.INSTANCE.checkCosy(GenerateAnswerPanel.this.project, true)) {
                        return;
                    }
                    GenerateAnswerPanel.this.cosyService.chatLike(GenerateAnswerPanel.this.project, chatLikeParam);
                    TelemetryService.getInstance().telemetrySessionId(GenerateAnswerPanel.this.project, TrackEventTypeEnum.CHAT_ANSWER_CODE_DISLIKE, GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId(), GenerateAnswerPanel.this.getSessionType().getTelemetryType());
                    GenerateAnswerPanel.this.titlePanel.revalidate();
                    GenerateAnswerPanel.this.titlePanel.repaint();
                    BadFeedbackDialog badFeedbackDialog = new BadFeedbackDialog(GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId(), GenerateAnswerPanel.this.project, GenerateAnswerPanel.this.chatTask, GenerateAnswerPanel.this.titleToolBarPanel);
                    badFeedbackDialog.show();
                }
            }
        });
        this.copyMarkdownLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!GenerateAnswerPanel.this.copyMarkdownLabel.isEnabled()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (null != GenerateAnswerPanel.this.chatStagePanel && MapUtils.isNotEmpty(GenerateAnswerPanel.this.chatStagePanel.getStageItems())) {
                    GenerateAnswerPanel.this.chatStagePanel.getStageItems().forEach((k, v) -> sb.append(v.convertToMdText()).append("\n"));
                }
                sb.append(GenerateAnswerPanel.this.markdownPanel.getTextWithCodeBlock());
                StringSelection selection = new StringSelection(sb.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
                NotificationFactory.showToast((JComponent)GenerateAnswerPanel.this.copyMarkdownLabel, LingmaIcons.AcceptIcon, CosyBundle.message("chat.answer.copied", new Object[0]));
                TelemetryService.getInstance().telemetryChatExport(GenerateAnswerPanel.this.project, GenerateAnswerPanel.this.requestId, GenerateAnswerPanel.this.sessionId, GenerateAnswerPanel.this.chatTask, "markdown", GenerateAnswerPanel.this.getSessionType().getTelemetryType());
            }
        });
    }

    private void invalidLabel(JLabel label) {
        label.setCursor(Cursor.getPredefinedCursor(0));
        for (MouseListener listener : label.getMouseListeners()) {
            label.removeMouseListener(listener);
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GenerateAnswerPanel.this.mouseEntered(GenerateAnswerPanel.this.getRequestId());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GenerateAnswerPanel.this.mouseExited(GenerateAnswerPanel.this.getRequestId());
            }
        });
    }

    protected MouseAdapter getBasePanelMouseAdapter(final JComponent cp) {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GenerateAnswerPanel.this.goodLabel.setVisible(true);
                GenerateAnswerPanel.this.badLabel.setVisible(true);
                GenerateAnswerPanel.this.copyMarkdownLabel.setVisible(true);
                ((AnswerPanelMouseEnteredNotifier)GenerateAnswerPanel.this.project.getMessageBus().syncPublisher(AnswerPanelMouseEnteredNotifier.MOUSE_ENTERED_NOTIFIER)).mouseEntered(GenerateAnswerPanel.this.getRequestId());
                GenerateAnswerPanel.this.titlePanel.revalidate();
                GenerateAnswerPanel.this.titlePanel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (cp != GenerateAnswerPanel.this.copyMarkdownLabel && cp != GenerateAnswerPanel.this.goodLabel && cp != GenerateAnswerPanel.this.badLabel) {
                    GenerateAnswerPanel.this.goodLabel.setVisible(false);
                    GenerateAnswerPanel.this.badLabel.setVisible(false);
                    GenerateAnswerPanel.this.copyMarkdownLabel.setVisible(false);
                    ((AnswerPanelMouseExitedNotifier)GenerateAnswerPanel.this.project.getMessageBus().syncPublisher(AnswerPanelMouseExitedNotifier.MOUSE_EXITED_NOTIFIER)).mouseExited(GenerateAnswerPanel.this.getRequestId());
                    GenerateAnswerPanel.this.titlePanel.revalidate();
                    GenerateAnswerPanel.this.titlePanel.repaint();
                }
            }
        };
    }

    public void showReferencePanel() {
        ListModel listModel = (ListModel)this.chatStagePanel.getContext().getContext(ChatStageParseKey.CODE_CHUNK.getKey());
        if (listModel == null || listModel.getSize() == 0) {
            listModel = (ListModel)this.chatStagePanel.getContext().getContext(ChatStageParseKey.DOC_CHUNK.getKey());
        }
        if (listModel == null || listModel.getSize() == 0) {
            String message = (String)this.chatStagePanel.getContext().getContext(ChatStageParseKey.MESSAGE.getKey());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                String displayMessage = this.getDisplayMessageByMessage(message);
                if (StringUtils.isBlank((CharSequence)displayMessage)) {
                    return;
                }
                if (this.chatReferencePanel == null) {
                    this.chatReferencePanel = new ChatReferencePanel(displayMessage);
                }
                this.northPanel.add(this.chatReferencePanel);
                this.northPanel.revalidate();
                this.northPanel.repaint();
            }
            return;
        }
        if (this.chatReferencePanel == null) {
            this.chatReferencePanel = new ChatReferencePanel(this.project, listModel);
        }
        this.northPanel.add(this.chatReferencePanel);
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    public void showReferencePanel(Color listBackground, Color background) {
        ListModel listModel = (ListModel)this.chatStagePanel.getContext().getContext(ChatStageParseKey.CODE_CHUNK.getKey());
        if (listModel == null || listModel.getSize() == 0) {
            listModel = (ListModel)this.chatStagePanel.getContext().getContext(ChatStageParseKey.DOC_CHUNK.getKey());
        }
        if (listModel == null || listModel.getSize() == 0) {
            String message = (String)this.chatStagePanel.getContext().getContext(ChatStageParseKey.MESSAGE.getKey());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                String displayMessage = this.getDisplayMessageByMessage(message);
                if (StringUtils.isBlank((CharSequence)displayMessage)) {
                    return;
                }
                if (this.chatReferencePanel == null) {
                    this.chatReferencePanel = new ChatReferencePanel(displayMessage, ColorUtil.getToolWindowBackgroundColor(), ColorUtil.getAuxiliaryForegroundColor(), ColorUtil.getToolWindowBackgroundColor());
                }
                this.northPanel.add(this.chatReferencePanel);
                this.northPanel.revalidate();
                this.northPanel.repaint();
            }
            return;
        }
        if (this.chatReferencePanel == null) {
            this.chatReferencePanel = new ChatReferencePanel(this.project, listModel, listBackground, background);
        }
        this.northPanel.add(this.chatReferencePanel);
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    private String getDisplayMessageByMessage(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        switch (message) {
            case "no visible knowledge base": {
                return CosyBundle.message("doc.rag.search.visible.empty", new Object[0]);
            }
            case "failed query RAG documents": {
                return CosyBundle.message("doc.rag.search.exception", new Object[0]);
            }
            case "no relevant documents found": {
                return CosyBundle.message("doc.rag.search.empty", new Object[0]);
            }
        }
        return null;
    }

    public void showReferencePanelForRecoverSession(ListModel<ChatReferenceItem> listModel) {
        if (this.chatStagePanel == null) {
            this.chatStagePanel = new ChatStagePanel(this.project, this);
            this.chatStagePanel.checkIfShowPanel();
            this.northPanel.add(this.chatStagePanel);
        }
        if (this.chatReferencePanel == null) {
            this.chatReferencePanel = new ChatReferencePanel(this.project, listModel);
        }
        this.northPanel.add(this.chatReferencePanel);
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    public void showReferencePanelMessageForRecoverSession(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (this.chatStagePanel == null) {
            this.chatStagePanel = new ChatStagePanel(this.project, this);
            this.northPanel.add(this.chatStagePanel);
        }
        if (this.chatReferencePanel == null) {
            String displayMessage = this.getDisplayMessageByMessage(message);
            if (StringUtils.isBlank((CharSequence)displayMessage)) {
                return;
            }
            this.chatReferencePanel = new ChatReferencePanel(displayMessage);
        }
        this.northPanel.add(this.chatReferencePanel);
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    public void addOrUpdateStep(ChatStep stepItem, boolean isRecoverSession) {
        if (ChatStepEnum.END.getKey().equals(stepItem.getStep())) {
            if (this.chatStagePanel == null) {
                return;
            }
            this.showReferencePanel();
            if (this.chatStagePanel != null) {
                this.chatStagePanel.clearStepsAfterStepEnd();
            }
        } else {
            if (this.chatStagePanel == null) {
                if (ChatStepEnum.START.getKey().equals(stepItem.getStep())) {
                    return;
                }
                this.chatStagePanel = new ChatStagePanel(this.project, this);
                this.northPanel.add(this.chatStagePanel);
            }
            if (this.chatStagePanel != null) {
                this.chatStagePanel.setVisible(true);
                this.chatStagePanel.addOrUpdateStep(this.project, stepItem, isRecoverSession);
            }
        }
        if (this.chatStagePanel != null) {
            this.chatStagePanel.revalidate();
            this.chatStagePanel.repaint();
        }
    }

    public void updateThinkingPanel(String text, boolean isDone, boolean isRecoverSession, Long thinkTime) {
        if (this.chatThinkingPanel == null) {
            log.debug("init chat thinking panel");
            this.chatThinkingPanel = new ChatThinkingPanel(isRecoverSession, thinkTime);
            this.northPanel.add(this.chatThinkingPanel);
            Disposer.register((Disposable)this, (Disposable)this.chatThinkingPanel);
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.chatThinkingPanel.setText(text);
        }
        if (isDone) {
            log.debug("update chat thinking done");
            this.chatThinkingPanel.stopTimer();
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    public void stopAllSteps() {
        if (!this.getCurrentSteps().isEmpty()) {
            this.chatStagePanel.stopAllSteps();
        }
    }

    private void configBottomPanel() {
        Color toolWindowBackground = ColorUtil.getToolWindowBackgroundColor();
        this.bottomPanel.setBorder(JBUI.Borders.customLine((Color)toolWindowBackground, (int)2, (int)0, (int)0, (int)0));
    }

    public void showGenerateStatePanel() {
        if (this.generatingPanel == null) {
            this.generatingPanel = new JPanel();
            this.generatingPanel.setBorder((Border)JBUI.Borders.empty());
            this.generatingPanel.setLayout(new BorderLayout());
            Color toolWindowBackground = ColorUtil.getToolWindowBackgroundColor();
            this.generatingPanel.setPreferredSize(new Dimension(-1, 40));
            if (this.generateStateLabel == null) {
                this.generateStateLabel = new JLabel(CosyBundle.message("chat.answer.btn.generating", new Object[0]), LingmaIcons.StatusBarLoadingIcon, 10);
                this.generateStateLabel.setFont(this.generateStateLabel.getFont().deriveFont(14.0f));
                this.generateStateLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                this.generatingPanel.add((Component)this.generateStateLabel, "West");
            } else {
                this.generateStateLabel.setText(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
            }
            JPanel bottomRightPanel = new JPanel(new WrapForKeywordLayout(0, 8));
            bottomRightPanel.setBorder((Border)JBUI.Borders.empty());
            bottomRightPanel.setBackground(toolWindowBackground);
            this.generatingPanel.add((Component)bottomRightPanel, "East");
            this.stopBtn = new DisplayLabel(CosyBundle.message("chat.answer.btn.stop", new Object[0]), null, ColorUtil.getToolWindowBackgroundColor(), null);
            this.stopBtn.setCursor(Cursor.getPredefinedCursor(12));
            this.stopBtn.addLabelMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    GenerateAnswerPanel.this.stopBtn.setBackground(ColorUtil.getEditorBackgroundColor());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GenerateAnswerPanel.this.stopBtn.setBackground(ColorUtil.getToolWindowBackgroundColor());
                }
            });
            bottomRightPanel.add(this.stopBtn);
            this.generatingPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
            SwingUtil.foreachChildComponent(this.generatingPanel, cp -> {
                if (!(cp instanceof DisplayLabel) && cp instanceof JPanel) {
                    cp.setOpaque(false);
                    cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
                }
            });
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.generatingPanel, "Center");
        this.copyMarkdownLabel.setEnabled(false);
    }

    public void updateGenerateState(String state) {
        if (this.generateStateLabel == null) {
            this.generateStateLabel = new JLabel(state, LingmaIcons.StatusBarLoadingIcon, 10);
            this.generateStateLabel.setFont(this.generateStateLabel.getFont().deriveFont(14.0f));
            this.generateStateLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            if (null != this.generatingPanel) {
                this.generatingPanel.add((Component)this.generateStateLabel, "West");
            }
        } else {
            this.generateStateLabel.setText(state);
        }
    }

    public void registerStopButton() {
        MouseListener[] listeners;
        if (this.stopBtn == null) {
            log.warn("Stop button is null when registering stop button.");
            return;
        }
        for (MouseListener listener : listeners = this.stopBtn.getMouseListeners()) {
            this.stopBtn.removeLabelMouseListener(listener);
        }
        this.stopBtn.addLabelMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateAnswerPanel.this.stopChat();
            }
        });
    }

    public void stopChat() {
        ApplicationManager.getApplication().invokeLater(() -> this.cosyService.chatStop(this.project, ChatStopParam.builder().sessionId(this.sessionId).requestId(this.requestId).build()));
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(this.requestId);
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_GENERATE_STOP, this.requestId, this.sessionId, this.chatTask, this.sessionType.getTelemetryType());
        try {
            SwingUtilities.invokeLater(() -> {
                if (SessionTypeEnum.DEVELOPER.equals((Object)this.sessionType)) {
                    ((AiDeveloperStreamPauseNotifier)this.project.getMessageBus().syncPublisher(AiDeveloperStreamPauseNotifier.AI_DEVELOPER_STREAM_PAUSE_NOTIFICATION)).pause(this.requestId, this.sessionId);
                } else if (SessionTypeEnum.CHAT.equals((Object)this.sessionType)) {
                    ((GenerateStreamPauseNotifier)this.project.getMessageBus().syncPublisher(GenerateStreamPauseNotifier.GENERATE_STREAM_PAUSE_NOTIFICATION)).pause(this.requestId, this.sessionId);
                }
            });
        }
        catch (Exception ex) {
            log.error("Pause message sent error: ", (Throwable)ex);
        }
    }

    public void stopChatSync() {
        this.cosyService.chatStop(this.project, ChatStopParam.builder().sessionId(this.sessionId).requestId(this.requestId).build());
        Map answeringMap = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING);
        if (null != answeringMap) {
            answeringMap.remove(this.requestId);
        }
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_GENERATE_STOP, this.requestId, this.sessionId, this.chatTask, this.sessionType.getTelemetryType());
        try {
            if (SessionTypeEnum.DEVELOPER.equals((Object)this.sessionType)) {
                ((AiDeveloperStreamPauseNotifier)this.project.getMessageBus().syncPublisher(AiDeveloperStreamPauseNotifier.AI_DEVELOPER_STREAM_PAUSE_NOTIFICATION)).pause(this.requestId, this.sessionId);
            } else if (SessionTypeEnum.ASSISTANT.equals((Object)this.sessionType)) {
                ((AiAssistantStreamPauseNotifier)this.project.getMessageBus().syncPublisher(AiAssistantStreamPauseNotifier.AI_ASSISTANT_STREAM_PAUSE_NOTIFICATION)).pause(this.requestId, this.sessionId);
            } else {
                ((GenerateStreamPauseNotifier)this.project.getMessageBus().syncPublisher(GenerateStreamPauseNotifier.GENERATE_STREAM_PAUSE_NOTIFICATION)).pause(this.requestId, this.sessionId);
            }
        }
        catch (Exception ex) {
            log.error("Pause message sent error: ", (Throwable)ex);
        }
    }

    public void hideGenerateStatePanel() {
        this.stopBtn = null;
        this.generatingPanel = null;
        this.generateStateLabel = null;
        this.copyMarkdownLabel.setEnabled(true);
        this.bottomPanel.removeAll();
        if (this.chatThinkingPanel != null) {
            this.chatThinkingPanel.stopTimer();
        }
    }

    public void doneThinking() {
        if (this.chatThinkingPanel != null) {
            this.chatThinkingPanel.stopTimer();
        }
    }

    public void showQuickPanel(GenerateInput input, List<DisplayTask> functionsList) {
        if (this.quickAskPanel == null) {
            this.quickAskPanel = new QuickAskPanel(this.project, this.generateContentForm, input, functionsList);
            this.quickAskPanel.setBorder((Border)JBUI.Borders.empty());
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.quickAskPanel, "Center");
        this.bottomPanel.invalidate();
        this.bottomPanel.repaint();
        this.generateContentForm.moveScrollToBottom(false);
    }

    public void showQuickPanelWithMessage(GenerateInput input, List<DisplayTask> functionsList, String message) {
        if (this.quickAskPanel == null) {
            this.quickAskPanel = new QuickAskPanel(this.project, this.generateContentForm, input, functionsList, message);
            this.quickAskPanel.setBorder((Border)JBUI.Borders.empty());
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.quickAskPanel, "Center");
        this.bottomPanel.invalidate();
        this.bottomPanel.repaint();
        this.generateContentForm.moveScrollToBottom(false);
    }

    public void showToolOperate2QuickPanel(GenerateInput input, List<DisplayTask> functionsList) {
        this.quickAskPanel = new QuickAskPanel(this.project, this.generateContentForm, input, functionsList);
        this.quickAskPanel.setBorder((Border)JBUI.Borders.empty());
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.quickAskPanel, "Center");
        this.bottomPanel.invalidate();
        this.bottomPanel.repaint();
        this.generateContentForm.moveScrollToBottom(false);
    }

    public void removeToolOperate2QuickPanel() {
        if (this.quickAskPanel != null && this.quickAskPanel.containsToolOperate2QuickPanel()) {
            this.bottomPanel.removeAll();
            this.bottomPanel.invalidate();
            this.bottomPanel.repaint();
        }
    }

    public String getAnswerText() {
        return this.markdownPanel.getText();
    }

    public List<String> getCurrentSteps() {
        if (Arrays.asList(this.northPanel.getComponents()).contains(this.chatStagePanel)) {
            return this.chatStagePanel.getStageNames();
        }
        return new ArrayList<String>();
    }

    public void appendChatStagePanelBottomBorder() {
        this.chatStagePanel.appendBottomBorder();
    }

    public void clearText() {
        this.markdownPanel.clear();
    }

    @Override
    public void revalidate() {
        if (this.markdownPanel != null) {
            this.markdownPanel.revalidate();
        }
    }

    public void appendText(String value, boolean isRecoverSession) {
        this.markdownPanel.append(value, isRecoverSession);
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
        if (StringUtils.isNotBlank((CharSequence)requestId) && this.basePanel != null) {
            this.basePanel.setName(BASE_PANEL_NAME_PREFIX + requestId);
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public JComponent getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.basePanel = new RoundRectPanel(){

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                SwingUtil.foreachChildComponent(GenerateAnswerPanel.this.basePanel, cp -> {
                    if (cp instanceof JPanel && !(cp instanceof RefreshColorComponent)) {
                        cp.setBackground(ColorUtil.getChatCardBackgroundColor());
                    }
                });
            }
        };
        ((RoundRectPanel)this.basePanel).setCornorBackgroundColor(ColorUtil.getToolWindowBackgroundColor());
        this.titlePanel = new DynamicPanel(40, (Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.titlePanel.setBorder((Border)JBUI.Borders.empty());
        this.goodLabel = new JLabel(LingmaIcons.LikeIcon);
        this.goodLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.goodLabel.setVisible(false);
        this.badLabel = new JLabel(LingmaIcons.UnlikeIcon);
        this.badLabel.setVisible(false);
        this.badLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.copyMarkdownLabel = new ToolbarLabel(CommonIcons.copyGreyIcon, null, null);
        this.copyMarkdownLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.copyMarkdownLabel.setVisible(false);
        this.bottomPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.height < 40 && GenerateAnswerPanel.this.bottomPanel.getComponentCount() > 0) {
                    dimension.height = 40;
                }
                return dimension;
            }
        };
    }

    private void updateUiTexts() {
        this.cosyLabel.setText(I18NConstant.COSY_PLUGIN_NAME);
        this.copyMarkdownLabel.setToolTipText(CosyBundle.message("chat.answer.copy.tooltip", new Object[0]));
        this.goodLabel.setToolTipText(CosyBundle.message("chat.answer.like.tooltip", new Object[0]));
        this.badLabel.setToolTipText(CosyBundle.message("chat.answer.dislike.tooltip", new Object[0]));
        this.titlePanel.revalidate();
        this.titlePanel.repaint();
    }

    public void hideBottomPanel() {
        this.bottomPanel.removeAll();
        this.bottomPanel.setBorder(null);
        this.bottomPanel.setPreferredSize(new Dimension(-1, 0));
        this.quickAskPanel = null;
        this.stopBtn = null;
        this.basePanel.invalidate();
        this.basePanel.repaint();
    }

    public void renderLike(int likeStatus) {
        if (likeStatus == 0) {
            return;
        }
        if (likeStatus > 0) {
            this.goodLabel.setIcon(LingmaIcons.LikeBlueIcon);
        } else {
            this.badLabel.setIcon(LingmaIcons.UnlikeBlueIcon);
        }
        this.invalidLabel(this.goodLabel);
        this.invalidLabel(this.badLabel);
        this.titlePanel.revalidate();
    }

    public void endGenerate() {
        this.copyMarkdownLabel.setEnabled(true);
        this.copyMarkdownLabel.setCursor(Cursor.getPredefinedCursor(12));
        SwingUtil.foreachChildComponent(this.answerPanel, cp -> cp.addMouseListener(this.getBasePanelMouseAdapter((JComponent)cp)));
    }

    public void clearForRetry() {
        if (null != this.markdownPanel) {
            this.markdownPanel.clearForRetry();
        }
        if (null != this.northPanel) {
            this.northPanel.removeAll();
        }
        this.chatStagePanel = null;
        this.chatReferencePanel = null;
        this.stopBtn = null;
        this.generatingPanel = null;
        this.generateStateLabel = null;
        this.chatThinkingPanel = null;
        this.configBottomPanel();
        this.showGenerateStatePanel();
    }

    public void switchStateToWaiting() {
        if (this.generateStateLabel != null) {
            this.generateStateLabel.setText(CosyBundle.message("chat.answer.btn.waiting", new Object[0]));
        }
        this.moveScrollToBottom(true);
    }

    public void moveScrollToBottom(boolean force) {
        if (this.generateContentForm instanceof BaseChatAgentPanel) {
            this.generateContentForm.moveScrollToBottom(force);
        } else {
            this.generateContentForm.moveScrollToBottom(false);
        }
    }

    public void moveDownRelatively(int relativeHeight) {
        if (this.generateContentForm instanceof BaseChatAgentPanel) {
            ((BaseChatAgentPanel)this.generateContentForm).moveDownRelatively(relativeHeight);
        }
    }

    public void switchStateToGenerating() {
        if (this.generateStateLabel != null) {
            this.generateStateLabel.setText(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
        }
    }

    public void disableGenerateAnswerPanel(List<String> requestIds) {
        if (CollectionUtils.isEmpty(requestIds)) {
            return;
        }
        if (requestIds.contains(this.getRequestId())) {
            this.cosyLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            if (CollectionUtils.isNotEmpty(this.markdownPanel.getBlocks())) {
                this.markdownPanel.getBlocks().forEach(block -> {
                    MarkdownComponent component = block.getComponent();
                    if (component != null) {
                        if (component instanceof TextMarkdownComponent) {
                            TextMarkdownComponent textMarkdownComponent = (TextMarkdownComponent)component;
                            textMarkdownComponent.disableTextMarkdown();
                        } else if (component instanceof FileMarkdownComponent) {
                            FileMarkdownComponent fileMarkdownComponent = (FileMarkdownComponent)component;
                            Component markdownComponent = fileMarkdownComponent.getComponent();
                            if (markdownComponent instanceof AIDevFilePanel) {
                                AIDevFilePanel aiDevFilePanel = (AIDevFilePanel)markdownComponent;
                                SwingUtil.foreachChildComponent(aiDevFilePanel, cp -> cp.setEnabled(false));
                                aiDevFilePanel.invalidate();
                                aiDevFilePanel.repaint();
                            }
                        } else if (component instanceof ToolMarkdownComponent) {
                            SwingUtil.foreachChildComponent((JComponent)component.getComponent(), cp -> cp.setEnabled(false));
                        }
                    }
                });
            }
            if (this.chatStagePanel != null) {
                SwingUtil.foreachChildComponent(this.chatStagePanel, cp -> cp.setEnabled(false));
            }
            if (this.bottomPanel != null) {
                this.bottomPanel.setVisible(false);
            }
        }
    }

    public void enableGenerateAnswerPanel(List<String> requestIds) {
        if (CollectionUtils.isEmpty(requestIds)) {
            return;
        }
        if (requestIds.contains(this.getRequestId())) {
            this.cosyLabel.setForeground(ColorUtil.getTextForegroundColor());
            if (CollectionUtils.isNotEmpty(this.markdownPanel.getBlocks())) {
                this.markdownPanel.getBlocks().forEach(block -> {
                    MarkdownComponent component = block.getComponent();
                    if (component != null) {
                        if (component instanceof TextMarkdownComponent) {
                            TextMarkdownComponent textMarkdownComponent = (TextMarkdownComponent)component;
                            textMarkdownComponent.enableTextMarkdown();
                        } else if (component instanceof FileMarkdownComponent) {
                            FileMarkdownComponent fileMarkdownComponent = (FileMarkdownComponent)component;
                            Component markdownComponent = fileMarkdownComponent.getComponent();
                            if (markdownComponent instanceof AIDevFilePanel) {
                                AIDevFilePanel aiDevFilePanel = (AIDevFilePanel)markdownComponent;
                                SwingUtil.foreachChildComponent(aiDevFilePanel, cp -> cp.setEnabled(true));
                            }
                        } else if (component instanceof ToolMarkdownComponent) {
                            SwingUtil.foreachChildComponent((JComponent)component.getComponent(), cp -> cp.setEnabled(true));
                        }
                    }
                });
            }
            if (this.chatStagePanel != null) {
                SwingUtil.foreachChildComponent(this.chatStagePanel, cp -> cp.setEnabled(true));
            }
            if (this.bottomPanel != null) {
                this.bottomPanel.setVisible(true);
            }
        }
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
            this.messageBusConnection = null;
        }
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getChatTask() {
        return this.chatTask;
    }

    @Generated
    public MarkdownStreamPanel getMarkdownPanel() {
        return this.markdownPanel;
    }

    @Generated
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Generated
    public BaseChatPanel getGenerateContentForm() {
        return this.generateContentForm;
    }

    @Generated
    public SessionTypeEnum getSessionType() {
        return this.sessionType;
    }

    @Generated
    public String getChatMode() {
        return this.chatMode;
    }

    @Generated
    public String getIntentionType() {
        return this.intentionType;
    }

    @Generated
    public void setIntentionType(String intentionType) {
        this.intentionType = intentionType;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JLabel jLabel2;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = this.basePanel;
        jPanel4.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel4).setEnabled(true);
        this.answerPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "Center");
        JPanel jPanel5 = this.titlePanel;
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel5, "North");
        this.cosyLabel = jLabel2 = new JLabel();
        jLabel2.setIconTextGap(5);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messageBundle").getString("cosy.plugin.name"));
        jPanel5.add((Component)jLabel2, "West");
        this.titleToolBarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 16, 3));
        jPanel5.add((Component)jPanel2, "East");
        JLabel jLabel3 = this.copyMarkdownLabel;
        ((Component)jLabel3).setEnabled(true);
        jLabel3.setText("");
        jLabel3.setToolTipText(ResourceBundle.getBundle("messageBundle").getString("chat.answer.copy.tooltip"));
        Component component = jPanel2.add(jLabel3);
        JLabel jLabel4 = this.goodLabel;
        jLabel4.setText("");
        jLabel4.setToolTipText(ResourceBundle.getBundle("messageBundle").getString("chat.answer.like.tooltip"));
        Component component2 = jPanel2.add(jLabel4);
        JLabel jLabel5 = this.badLabel;
        jLabel5.setText("");
        jLabel5.setToolTipText(ResourceBundle.getBundle("messageBundle").getString("chat.answer.dislike.tooltip"));
        Component component3 = jPanel2.add(jLabel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 10, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "Center");
        this.bannerLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mdPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
        JPanel jPanel7 = this.bottomPanel;
        jPanel4.add((Component)jPanel7, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

