/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FilePathTreeNode
implements TreeNode {
    private VirtualFile file;
    private Vector<TreeNode> children;
    private TreeNode parent;
    private FilePathTreeNode root;
    private int level;
    private Boolean isPlaceholder = false;

    public FilePathTreeNode(VirtualFile file, Project project) {
        this.file = file;
        this.children = new Vector();
        this.level = 1;
        this.root = this.buildPathTree(this, project);
        this.truncateTree(this.root);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (this.children.size() == 0) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isPlaceHolder() {
        return this.isPlaceholder;
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        if (this.children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public FilePathTreeNode getRoot() {
        return this.root;
    }

    public VirtualFile getFile() {
        return this.file;
    }

    public int getLevel() {
        return this.level;
    }

    private FilePathTreeNode buildPathTree(FilePathTreeNode currentFileNode, Project project) {
        if (currentFileNode.file == null) {
            return currentFileNode;
        }
        VirtualFile parent = currentFileNode.file.getParent();
        if (parent == null || parent.getPath().equals(project.getBasePath())) {
            return currentFileNode;
        }
        ++this.level;
        FilePathTreeNode parentNode = new FilePathTreeNode(parent, project);
        parentNode.children = new Vector();
        parentNode.children.add(currentFileNode);
        currentFileNode.parent = parentNode;
        return this.buildPathTree(parentNode, project);
    }

    private FilePathTreeNode truncateTree(FilePathTreeNode rootFileNode) {
        if (this.level <= 8) {
            return rootFileNode;
        }
        FilePathTreeNode currentNode = rootFileNode;
        FilePathTreeNode middleNode = null;
        for (int index = this.level - 2; index >= 0; --index) {
            if ((currentNode = (FilePathTreeNode)currentNode.getChildAt(0)) == null) {
                return rootFileNode;
            }
            if (index == this.level - 5) {
                middleNode = currentNode;
                middleNode.isPlaceholder = true;
                continue;
            }
            if (index != 2) continue;
            if (middleNode == null) {
                return rootFileNode;
            }
            middleNode.children = new Vector();
            middleNode.children.add(currentNode);
        }
        return rootFileNode;
    }
}

