/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.constants.ActionConstants;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class ChatQuestionManager {
    private static Map<String, ChatQuestion> questions = new LinkedHashMap<String, ChatQuestion>();

    private static void register(String question, String actionId) {
        ChatQuestionManager.register(question, actionId, true, true);
    }

    private static void register(String question, String actionId, boolean showInWelcome, boolean showInMethodHintMenu) {
        questions.put(actionId, new ChatQuestion(question, actionId, showInWelcome, showInMethodHintMenu));
    }

    public static List<ChatQuestion> getWelcomeQuestions() {
        return questions.values().stream().filter(ChatQuestion::isShowInWelcome).collect(Collectors.toList());
    }

    public static List<ChatQuestion> getMethodHintQuestions() {
        return questions.values().stream().filter(ChatQuestion::isShowInMethodHintMenu).collect(Collectors.toList());
    }

    public static Map<String, ChatQuestion> getAllQuestions() {
        return questions;
    }

    static {
        ChatQuestionManager.register(I18NConstant.ACTION_TRIGGER_EXPLAIN_CODE, ActionConstants.TRIGGER_COSY_EXPLAIN_CODE_GENERATION_ACTION);
        ChatQuestionManager.register(I18NConstant.ACTION_TRIGGER_TESTCASE_GENERATION, ActionConstants.TRIGGER_COSY_TESTCASE_GENERATION_ACTION);
        ChatQuestionManager.register(I18NConstant.ACTION_TRIGGER_CODE_GENERATE_COMMENT, ActionConstants.TRIGGER_COSY_CODE_GENERATE_COMMENT_GENERATION_ACTION, false, true);
        ChatQuestionManager.register(I18NConstant.ACTION_TRIGGER_OPTIMIZE_CODE, ActionConstants.TRIGGER_COSY_OPTIMIZE_CODE_GENERATION_ACTION);
    }

    public static class ChatQuestion {
        String question;
        String actionId;
        boolean showInWelcome;
        boolean showInMethodHintMenu;

        @Generated
        public String getQuestion() {
            return this.question;
        }

        @Generated
        public String getActionId() {
            return this.actionId;
        }

        @Generated
        public boolean isShowInWelcome() {
            return this.showInWelcome;
        }

        @Generated
        public boolean isShowInMethodHintMenu() {
            return this.showInMethodHintMenu;
        }

        @Generated
        public void setQuestion(String question) {
            this.question = question;
        }

        @Generated
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Generated
        public void setShowInWelcome(boolean showInWelcome) {
            this.showInWelcome = showInWelcome;
        }

        @Generated
        public void setShowInMethodHintMenu(boolean showInMethodHintMenu) {
            this.showInMethodHintMenu = showInMethodHintMenu;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChatQuestion)) {
                return false;
            }
            ChatQuestion other = (ChatQuestion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$question = this.getQuestion();
            String other$question = other.getQuestion();
            if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
                return false;
            }
            String this$actionId = this.getActionId();
            String other$actionId = other.getActionId();
            if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
                return false;
            }
            if (this.isShowInWelcome() != other.isShowInWelcome()) {
                return false;
            }
            return this.isShowInMethodHintMenu() == other.isShowInMethodHintMenu();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChatQuestion;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $question = this.getQuestion();
            result = result * 59 + ($question == null ? 43 : $question.hashCode());
            String $actionId = this.getActionId();
            result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
            result = result * 59 + (this.isShowInWelcome() ? 79 : 97);
            result = result * 59 + (this.isShowInMethodHintMenu() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "ChatQuestionManager.ChatQuestion(question=" + this.getQuestion() + ", actionId=" + this.getActionId() + ", showInWelcome=" + this.isShowInWelcome() + ", showInMethodHintMenu=" + this.isShowInMethodHintMenu() + ")";
        }

        @Generated
        public ChatQuestion() {
        }

        @Generated
        public ChatQuestion(String question, String actionId, boolean showInWelcome, boolean showInMethodHintMenu) {
            this.question = question;
            this.actionId = actionId;
            this.showInWelcome = showInWelcome;
            this.showInMethodHintMenu = showInMethodHintMenu;
        }
    }
}

