/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.form;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.SearchTitleDto;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocContentDetail;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.util.CosyServiceUtil;
import com.alibabacloud.intellij.cosy.search.util.StringCheckUtil;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.CosyJBTableCell;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.BestAnswerCell;
import com.alibabacloud.intellij.cosy.ui.search.component.DescriptionPopup;
import com.alibabacloud.intellij.cosy.ui.search.component.DynamicPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TagListPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TitleTextPane;
import com.alibabacloud.intellij.cosy.ui.search.component.VoteAcceptPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.form.QAContentForm;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.QaActionNotifier;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.text.StringEscapeUtils;

public class QAListCell
implements CosyJBTableCell {
    private static final int TITLE_CUT_PADDING = 100;
    private static final int TOOLBAR_WIDTH = 29;
    private static final int TOOLBAR_HEIGHT = 28;
    private static final int TOOLBAR_X_OFFSET = 20;
    private TitleTextPane titlePane;
    private VoteAcceptPanel votePane;
    private JLabel qaTimeLabel;
    private JLabel iconLabel;
    private JPanel labelPane;
    private JPanel contentPane;
    private JPanel shortAnswerPane;
    private JLabel bestAnswerLabel;
    private JLabel countLabel;
    private JPanel flowPane;
    private JPanel infoPane;
    private JPanel htmlPane;
    private JPanel foldInfoPanel;
    private JPanel iconPanel;
    private JPanel operaPanel;
    private JPanel headerPanel;
    private JLabel titleAskLabel;
    private MessageBusConnection messageBusConnection;
    private static final Logger log = Logger.getInstance(QAListCell.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String shortAnswer;
    private final Project project;
    private static final Color STAR_TEXT_COLOR = new JBColor(new Color(0), new Color(0xFFFFFF));
    private final CosyService cosyService;
    private Component mainComponent;
    private static final int TAG_LIST_HGAP = 5;
    CodeDocOverviewDetail codeDocOverviewDetail;
    DescriptionPopup descriptionPopup;
    private JBPopup toolBarPopup;
    private JPanel popupPanel;

    public QAListCell(CodeDocOverviewDetail codeDocOverviewDetail, final Project project, SearchResultPanel searchResultPanel, DescriptionPopup descriptionPopup) {
        this.project = project;
        this.codeDocOverviewDetail = codeDocOverviewDetail;
        this.descriptionPopup = descriptionPopup;
        this.$$$setupUI$$$();
        final String title = codeDocOverviewDetail.getTitle();
        this.iconLabel.setIcon(CommonIcons.stackOverflowIcon);
        final Component resizeComponent = SwingManager.INSTANCE.getComponent(project, "MAIN_PANEL_KEY", this.contentPane);
        resizeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                QAListCell.this.titlePane.initUI((JComponent)resizeComponent, title, 100 + QAListCell.this.iconLabel.getPreferredSize().width);
                ((TagListPanel)QAListCell.this.labelPane).updateLayout();
            }
        });
        this.contentPane.setBorder(JBUI.Borders.customLine((Color)CosyColor.QA_BORDER_COLOR, (int)0, (int)0, (int)2, (int)0));
        this.initContent(title, searchResultPanel, codeDocOverviewDetail);
        this.bestAnswerLabel.setForeground(STAR_TEXT_COLOR);
        String text = I18NConstant.QUESTION_TXT + codeDocOverviewDetail.getCommentCount() + " " + I18NConstant.COUNT_ANSWER_TEXT;
        this.countLabel.setText(text);
        this.countLabel.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
        this.countLabel.setHorizontalTextPosition(2);
        this.shortAnswerPane.setVisible(false);
        this.cosyService = new CosyServiceImpl();
        this.votePane.setVoteCount(codeDocOverviewDetail.getLikeCount());
        this.votePane.setAnswerCount(codeDocOverviewDetail.getCommentCount());
        this.votePane.setHasAccepted(codeDocOverviewDetail.getIsAnswered());
        this.votePane.setLayoutStyle(0);
        this.votePane.initUI();
        this.votePane.setCursor(Cursor.getPredefinedCursor(12));
        this.qaTimeLabel.setText(sdf.format(codeDocOverviewDetail.getCreateDate()));
        this.qaTimeLabel.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        String tags = codeDocOverviewDetail.getTags();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tags)) {
            this.contentPane.remove(this.flowPane);
        } else {
            ((TagListPanel)this.labelPane).updateComponent(project, tags, 0);
        }
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        this.countLabel.setIcon(CommonIcons.arrowRightIcon);
        this.htmlPane.setCursor(new Cursor(0));
        if (color == null) {
            this.titleAskLabel.setIcon(CommonIcons.promptIcon);
        } else {
            this.titleAskLabel.setIcon(CommonIcons.lightPromptIcon);
        }
        this.titleAskLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QAListCell.this.initShortAnswer();
                String unescapedBestAnswer = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)QAListCell.this.shortAnswer) ? StringUtils.removeHtmlTags(StringEscapeUtils.unescapeHtml4((String)QAListCell.this.shortAnswer)) : "";
                String language = FileUtil.getLanguageFileType(project);
                Object chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().fileLanguage(language)).localeLanguage(Locale.getDefault().getLanguage())).build();
                SearchTitleDto questionObject = SearchTitleDto.builder().title(QAListCell.this.titlePane.getText()).bestAnswer(unescapedBestAnswer).language(language).build();
                String question = String.format(ChatTaskEnum.SEARCH_TITLE_ASK.getDisplayText(), unescapedBestAnswer, QAListCell.this.titlePane.getText());
                GenerateInput genInput = new GenerateInput(question, ChatTaskEnum.SEARCH_TITLE_ASK.getName(), (ChatContext)chatContext);
                genInput.setQuestionObject(questionObject);
                SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
                String requestId = UUID.randomUUID().toString();
                TelemetryService.getInstance().telemetryChatTask(project, TrackEventTypeEnum.CHAT_SEARCH_TITLE_ASK, requestId, ((ChatContext)chatContext).getSessionId(), ChatTaskEnum.SEARCH_TITLE_ASK.getName(), genInput, SessionTypeEnum.CHAT.getTelemetryType());
                ((AnyGenerateNotifier)project.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, true);
            }
        });
        this.mouseClickContentPane(project, codeDocOverviewDetail, searchResultPanel);
    }

    private void initContent(String title, SearchResultPanel searchResultPanel, CodeDocOverviewDetail codeDocOverviewDetail) {
        Component cutWidthComponent = SwingManager.INSTANCE.getComponent(this.project, "MAIN_PANEL_KEY", searchResultPanel.getBasePanel());
        this.titlePane.setToolTipText(title);
        this.titlePane.setBackground(searchResultPanel.getBasePanel().getBackground());
        this.titlePane.setCursor(Cursor.getPredefinedCursor(12));
        this.titlePane.initUI((JComponent)cutWidthComponent, title, 100 + this.iconLabel.getPreferredSize().width);
    }

    private void updateUiTexts() {
        this.votePane.updateUiTexts();
    }

    private void mouseClickContentPane(final Project project, final CodeDocOverviewDetail codeDocOverviewDetail, SearchResultPanel searchResultPanel) {
        this.countLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RecommendResult recommendation = QAListCell.this.cosyService.searchQAContent(project, codeDocOverviewDetail.getDocId(), SearchActionTypeEnum.CLICK_CONTENT_TRIGGER.getType());
                List<CodeDocContentDetail> codeDocContentDetails = CosyServiceUtil.parseQAContent(recommendation);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
                assert (toolWindow != null);
                if (toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) != null) {
                    Content content = toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME);
                    JComponent mainComponent = content.getComponent();
                    QAContentForm contentForm = new QAContentForm(project, codeDocOverviewDetail, codeDocContentDetails, mainComponent);
                    content.setComponent(contentForm.getComponent());
                    toolWindow.getContentManager().setSelectedContent(content);
                }
                ((QaActionNotifier)project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "click_content");
                QAListCell.this.descriptionPopup.closePopup();
            }
        });
        this.contentPane.setCursor(new Cursor(12));
        this.registerHoverEvent(this.contentPane, searchResultPanel);
        this.registerHoverEvent(this.iconLabel, searchResultPanel);
        this.registerHoverEvent(this.labelPane, searchResultPanel);
        this.registerHoverEvent(this.foldInfoPanel, searchResultPanel);
        this.registerHoverEvent(this.titlePane, searchResultPanel);
        this.registerHoverEvent(this.flowPane, searchResultPanel);
        this.registerHoverEvent(this.qaTimeLabel, searchResultPanel);
        this.registerHoverEvent(this.iconPanel, searchResultPanel);
        this.registerHoverEvent(this.operaPanel, searchResultPanel);
        this.registerHoverEvent(this.headerPanel, searchResultPanel);
        this.registerClickEvent(this.contentPane, codeDocOverviewDetail);
        this.registerClickEvent(this.headerPanel, codeDocOverviewDetail);
        this.registerClickEvent(this.iconLabel, codeDocOverviewDetail);
        this.registerClickEvent(this.labelPane, codeDocOverviewDetail);
        this.registerClickEvent(this.foldInfoPanel, codeDocOverviewDetail);
        this.registerClickEvent(this.titlePane, codeDocOverviewDetail);
        this.registerClickEvent(this.flowPane, codeDocOverviewDetail);
        this.registerClickEvent(this.qaTimeLabel, codeDocOverviewDetail);
        this.registerClickEvent(this.iconPanel, codeDocOverviewDetail);
        this.registerClickEvent(this.operaPanel, codeDocOverviewDetail);
        this.registerClickEvent(this.votePane, codeDocOverviewDetail);
    }

    public void registerClickEvent(JComponent component, final CodeDocOverviewDetail codeDocOverviewDetail) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QAListCell.this.foldInfoPanel.isVisible()) {
                    QAListCell.this.initShortAnswer();
                    QAListCell.this.shortAnswerPane.setVisible(true);
                    QAListCell.this.foldInfoPanel.setVisible(false);
                    ((QaActionNotifier)QAListCell.this.project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "click_answer");
                } else {
                    QAListCell.this.shortAnswerPane.setVisible(false);
                    QAListCell.this.foldInfoPanel.setVisible(true);
                }
            }
        });
    }

    private void initShortAnswer() {
        if (this.shortAnswer == null) {
            RecommendResult recommendResult = this.cosyService.searchQAContent(this.project, this.codeDocOverviewDetail.getDocId(), SearchActionTypeEnum.CLICK_OVERVIEW_TRIGGER.getType());
            List<CodeDocContentDetail> codeDocContentDetailList = CosyServiceUtil.parseQAContent(recommendResult);
            if (CollectionUtils.isEmpty(codeDocContentDetailList)) {
                return;
            }
            this.shortAnswer = codeDocContentDetailList.get(0).getContent();
            BestAnswerCell bestAnswerCell = new BestAnswerCell(this.project, codeDocContentDetailList.get(0));
            JLabel jLabel = bestAnswerCell.getFoldLabel();
            jLabel.setVisible(true);
            jLabel.setCursor(new Cursor(12));
            this.registerClickEvent(jLabel, this.codeDocOverviewDetail);
            this.htmlPane.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
            this.shortAnswerPane.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
            this.htmlPane.add(bestAnswerCell.getComponent(), "Center");
            this.registerToolbarHoverEvent(bestAnswerCell.getComponent());
        }
    }

    public void registerHoverEvent(JComponent component, final SearchResultPanel searchResultPanel) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                QAListCell.this.contentPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.iconLabel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.labelPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.iconPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.foldInfoPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.titlePane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.flowPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.qaTimeLabel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.operaPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.headerPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.votePane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                QAListCell.this.descriptionPopup.createPopup(QAListCell.this.contentPane, QAListCell.this.clearDescription(QAListCell.this.codeDocOverviewDetail.getDescription()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                QAListCell.this.contentPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.iconLabel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.iconPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.labelPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.foldInfoPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.titlePane.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.flowPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.qaTimeLabel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.operaPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.votePane.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.headerPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                QAListCell.this.descriptionPopup.tryClosePopup(QAListCell.this.contentPane, e.getLocationOnScreen());
            }
        });
    }

    public void registerToolbarHoverEvent(Component component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (QAListCell.this.toolBarPopup != null && QAListCell.this.toolBarPopup.isVisible()) {
                    return;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (QAListCell.this.toolBarPopup != null) {
                    Point screenMousePoint;
                    Dimension paneDim;
                    MouseEvent childEvent = SwingUtilities.convertMouseEvent(QAListCell.this.htmlPane, e, QAListCell.this.popupPanel);
                    Point mousePosition = childEvent.getPoint();
                    Rectangle popupBounds = QAListCell.this.popupPanel.getBounds();
                    mousePosition.x = Math.max(mousePosition.x, 0);
                    mousePosition.y = Math.max(mousePosition.y, 0);
                    Point screenPoint = QAListCell.this.htmlPane.getLocationOnScreen();
                    Rectangle rect = new Rectangle(screenPoint, paneDim = QAListCell.this.htmlPane.getSize());
                    if (!rect.contains(screenMousePoint = e.getLocationOnScreen())) {
                        QAListCell.this.toolBarPopup.cancel();
                        QAListCell.this.popupPanel = null;
                        QAListCell.this.toolBarPopup = null;
                    }
                }
            }
        });
    }

    private String clearDescription(String description) {
        String content = StringCheckUtil.removeMultiSpace(description);
        if (content.length() > 300) {
            content = content.substring(0, 300);
        }
        return content;
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return this.contentPane.getPreferredSize().height;
    }

    @Override
    public Component getComponent() {
        return this.contentPane;
    }

    private void createUIComponents() {
        this.labelPane = new TagListPanel(5);
        this.titlePane = new TitleTextPane();
        this.infoPane = new DynamicPanel(32, (Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.infoPane.setBorder(JBUI.Borders.customLine((Color)CosyColor.BEST_ANSWER_BORDER_COLOR, (int)0, (int)0, (int)2, (int)0));
    }

    @Generated
    public TitleTextPane getTitlePane() {
        return this.titlePane;
    }

    @Generated
    public VoteAcceptPanel getVotePane() {
        return this.votePane;
    }

    @Generated
    public JLabel getQaTimeLabel() {
        return this.qaTimeLabel;
    }

    @Generated
    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    @Generated
    public JPanel getLabelPane() {
        return this.labelPane;
    }

    @Generated
    public JPanel getContentPane() {
        return this.contentPane;
    }

    @Generated
    public JPanel getShortAnswerPane() {
        return this.shortAnswerPane;
    }

    @Generated
    public JLabel getBestAnswerLabel() {
        return this.bestAnswerLabel;
    }

    @Generated
    public JLabel getCountLabel() {
        return this.countLabel;
    }

    @Generated
    public JPanel getFlowPane() {
        return this.flowPane;
    }

    @Generated
    public JPanel getInfoPane() {
        return this.infoPane;
    }

    @Generated
    public JPanel getHtmlPane() {
        return this.htmlPane;
    }

    @Generated
    public JPanel getFoldInfoPanel() {
        return this.foldInfoPanel;
    }

    @Generated
    public JPanel getIconPanel() {
        return this.iconPanel;
    }

    @Generated
    public JPanel getOperaPanel() {
        return this.operaPanel;
    }

    @Generated
    public JPanel getHeaderPanel() {
        return this.headerPanel;
    }

    @Generated
    public JLabel getTitleAskLabel() {
        return this.titleAskLabel;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public String getShortAnswer() {
        return this.shortAnswer;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public CosyService getCosyService() {
        return this.cosyService;
    }

    @Generated
    public Component getMainComponent() {
        return this.mainComponent;
    }

    @Generated
    public CodeDocOverviewDetail getCodeDocOverviewDetail() {
        return this.codeDocOverviewDetail;
    }

    @Generated
    public DescriptionPopup getDescriptionPopup() {
        return this.descriptionPopup;
    }

    @Generated
    public JBPopup getToolBarPopup() {
        return this.toolBarPopup;
    }

    @Generated
    public JPanel getPopupPanel() {
        return this.popupPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        VoteAcceptPanel voteAcceptPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        this.createUIComponents();
        this.contentPane = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(12, 10, 8, 10), -1, 12, false, false));
        this.headerPanel = jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(10, 0));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitleTextPane titleTextPane = this.titlePane;
        jPanel7.add((Component)titleTextPane, "Center");
        this.iconPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, "West");
        this.iconLabel = jLabel5 = new JLabel();
        jLabel5.setText("");
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, "East");
        this.titleAskLabel = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel9.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.flowPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = this.labelPane;
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.shortAnswerPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = this.infoPane;
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.bestAnswerLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messageBundle").getString("best.answer.label.name"));
        jPanel11.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel11.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.countLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel11.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.htmlPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.foldInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.votePane = voteAcceptPanel = new VoteAcceptPanel();
        jPanel2.add((Component)voteAcceptPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.operaPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.qaTimeLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

