/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.form;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchCodeResult;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.CosyCodeTableCell;
import com.alibabacloud.intellij.cosy.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.DescriptionPopup;
import com.alibabacloud.intellij.cosy.ui.search.enums.SourceEnum;
import com.alibabacloud.intellij.cosy.ui.search.form.DocListCell;
import com.alibabacloud.intellij.cosy.ui.search.form.QAListCell;
import com.alibabacloud.intellij.cosy.util.JCefUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;

public class DocumentPanel
extends JPanel {
    private static Logger logger = Logger.getInstance(DocumentPanel.class);
    private static JBCefBrowser jbcefBrowser;
    List<CodeDocOverviewDetail> codeDocOverviewDetailList;
    SearchResultPanel searchResultPanel;
    DescriptionPopup descriptionPopup;
    Project project;

    public DocumentPanel(SearchResultPanel searchResultPanel, Project project) {
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 2));
        this.descriptionPopup = new DescriptionPopup();
        this.searchResultPanel = searchResultPanel;
        this.project = project;
    }

    public void updateQAData(Project project, List<CodeDocOverviewDetail> codeDocOverviewDetailList) {
        this.codeDocOverviewDetailList = codeDocOverviewDetailList;
        this.removeAll();
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 2));
        this.initCefBrowser(codeDocOverviewDetailList);
        for (CodeDocOverviewDetail codeDocOverviewDetail : codeDocOverviewDetailList) {
            if (SourceEnum.STACK_OVERFLOW.getSource().equalsIgnoreCase(codeDocOverviewDetail.getSource())) {
                this.add(new QAListCell(codeDocOverviewDetail, project, this.searchResultPanel, this.descriptionPopup).getComponent());
                continue;
            }
            this.add(new DocListCell(codeDocOverviewDetail, project, this.searchResultPanel, this.descriptionPopup, jbcefBrowser).getComponent());
        }
        this.searchResultPanel.getQaScrollPane().getVerticalScrollBar().setValue(0);
    }

    private synchronized void initCefBrowser(List<CodeDocOverviewDetail> codeDocOverviewDetailList) {
        if (jbcefBrowser != null) {
            return;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (!JBCefApp.isSupported() || setting != null && DocumentOpenModeEnum.OPEN_IN_WEB.equals((Object)setting.getDefaultDocumentOpenMode())) {
            return;
        }
        boolean needCef = false;
        for (CodeDocOverviewDetail codeDocOverviewDetail : codeDocOverviewDetailList) {
            if (SourceEnum.STACK_OVERFLOW.getSource().equalsIgnoreCase(codeDocOverviewDetail.getSource())) continue;
            needCef = true;
        }
        if (needCef) {
            JCefUtil.initDocumentSettings();
            Object jbCefBrowser = null;
            try {
                logger.info("Initializing JBCefBrowser...");
                jbcefBrowser = JCefUtil.getJBCefBrowser(this.project);
                jbCefBrowser.loadHTML("");
                logger.info("Complete to initialize JBCefBrowser");
            }
            catch (Exception e) {
                logger.warn("Unsupported JBCefBrowser:" + e.getMessage());
            }
        }
    }

    public void updateCodeData(Project project, List<SearchCodeResult> searchCodeResultList) {
        this.removeAll();
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 2));
        for (SearchCodeResult searchCodeResult : searchCodeResultList) {
            this.add(new CosyCodeTableCell(searchCodeResult, project).getComponent());
        }
        this.searchResultPanel.getCodeScrollPanel().getVerticalScrollBar().setValue(0);
    }

    public void addDocument(CodeDocOverviewDetail codeDocOverviewDetail, Project project) {
        if (SourceEnum.STACK_OVERFLOW.getSource().equalsIgnoreCase(codeDocOverviewDetail.getSource())) {
            this.add(new QAListCell(codeDocOverviewDetail, project, this.searchResultPanel, this.descriptionPopup).getComponent());
        } else {
            this.add(new DocListCell(codeDocOverviewDetail, project, this.searchResultPanel, this.descriptionPopup, jbcefBrowser).getComponent());
        }
    }

    public void setJbcefBrowser(JBCefBrowser jbcefBrowser) {
        DocumentPanel.jbcefBrowser = jbcefBrowser;
    }
}

