/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.filter;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.search.enums.ExceptionResolveModeEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.renderer.CosyPresentation;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyDebuggerFilter
implements JvmExceptionOccurrenceFilter {
    @Nullable
    public Filter.ResultItem applyFilter(@NotNull String exceptionClassName, @NotNull List<PsiClass> classes, int exceptionStartOffset) {
        CosySetting setting;
        if (exceptionClassName == null) {
            CosyDebuggerFilter.$$$reportNull$$$0(0);
        }
        if (classes == null) {
            CosyDebuggerFilter.$$$reportNull$$$0(1);
        }
        if ((setting = CosyPersistentSetting.getInstance().getState()) != null && setting.getExceptionResolveV2ModeEnum() != null && ExceptionResolveModeEnum.DISABLED.getType().equals(setting.getExceptionResolveV2ModeEnum().getType())) {
            return null;
        }
        return new CreateExceptionBreakpointResult(exceptionStartOffset, exceptionStartOffset + exceptionClassName.length(), exceptionClassName, classes.get(0).getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "exceptionClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "classes";
                break;
            }
        }
        objectArray[1] = "com/alibabacloud/intellij/cosy/ui/search/filter/CosyDebuggerFilter";
        objectArray[2] = "applyFilter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CreateExceptionBreakpointResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myExceptionClassName;
        private final Project project;
        private final int startOffset;

        CreateExceptionBreakpointResult(int highlightStartOffset, int highlightEndOffset, String exceptionClassName, Project project) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myExceptionClassName = exceptionClassName;
            this.project = project;
            this.startOffset = highlightStartOffset;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            return new CosyPresentation(editor, this.project, this.startOffset);
        }
    }
}

