/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.enums;

import com.alibabacloud.intellij.cosy.chat.context.tool.AddTasksToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.CreateFileToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.DeleteFileToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.EditFileToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.FetchContentToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.FetchRuleToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.GetProblemsContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.GetTerminalOutputToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.GrepCodeToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.ListDirToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.MCPToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.ReadFileToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.RunInTerminalToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.SearchCodeBaseToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.SearchFileToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.SearchMemoryToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.SearchReplaceToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.SearchWebToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.UnknownToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.UpdateMemoryToolContextProvider;
import com.alibabacloud.intellij.cosy.chat.context.tool.UpdateTasksToolContextProvider;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public enum ToolTypeEnum {
    SEARCH_CODEBASE("search_codebase", new SearchCodeBaseToolContextProvider(), true),
    SEARCH_FILE("search_file", new SearchFileToolContextProvider(), true),
    GREP_CODE("grep_code", new GrepCodeToolContextProvider(), true),
    SEARCH_SYMBOL("search_symbol", new SearchCodeBaseToolContextProvider(), true),
    LIST_DIR("list_dir", new ListDirToolContextProvider(), true),
    GET_PROBLEMS("get_problems", new GetProblemsContextProvider(), true),
    RUN_IN_TERMINAL("run_in_terminal", new RunInTerminalToolContextProvider(), false),
    GET_TERMINAL_OUTPUT("get_terminal_output", new GetTerminalOutputToolContextProvider(), true),
    READ_FILE("read_file", new ReadFileToolContextProvider(), true),
    EDIT_FILE("edit_file", new EditFileToolContextProvider(), false),
    UPDATE_MEMORY("update_memory", new UpdateMemoryToolContextProvider(), true),
    SEARCH_MEMORY("search_memory", new SearchMemoryToolContextProvider(), true),
    FETCH_CONTENT("fetch_content", new FetchContentToolContextProvider(), true),
    SEARCH_WEB("search_web", new SearchWebToolContextProvider(), true),
    MCP_TOOL("mcp", new MCPToolContextProvider(), false),
    FETCH_RULE("fetch_rules", new FetchRuleToolContextProvider(), true),
    UPDATE_TASKS("update_tasks", new UpdateTasksToolContextProvider(), true),
    ADD_TASKS("add_tasks", new AddTasksToolContextProvider(), false),
    CREATE_FILE("create_file", new CreateFileToolContextProvider(), false),
    DELETE_FILE("delete_file", new DeleteFileToolContextProvider(), false),
    SEARCH_REPLACE("search_replace", new SearchReplaceToolContextProvider(), false),
    UNKNOWN("unknown", new UnknownToolContextProvider(), true);

    private final String toolName;
    private final BaseToolContextProvider toolContextProvider;
    private final boolean weekUi;

    private ToolTypeEnum(String toolName, BaseToolContextProvider toolContextProvider, boolean weekUi) {
        this.toolName = toolName;
        this.toolContextProvider = toolContextProvider;
        this.weekUi = weekUi;
    }

    public static ToolTypeEnum getByToolName(String toolName) {
        for (ToolTypeEnum toolTypeEnum : ToolTypeEnum.values()) {
            if (toolTypeEnum.getToolName().equals(toolName)) {
                return toolTypeEnum;
            }
            if (!StringUtils.isNotBlank((String)toolName) || !toolName.startsWith("MCP")) continue;
            return MCP_TOOL;
        }
        return UNKNOWN;
    }

    @Generated
    public String getToolName() {
        return this.toolName;
    }

    @Generated
    public BaseToolContextProvider getToolContextProvider() {
        return this.toolContextProvider;
    }

    @Generated
    public boolean isWeekUi() {
        return this.weekUi;
    }
}

