/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tree;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskItem;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskOperation;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskResponseItem;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskTreeItem;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TreeBuilder {
    public static TaskItem buildTreeFromJson(String jsonString) {
        Gson gson = new Gson();
        TaskItem virtualRoot = TaskItem.builder().id("virtualRoot").build();
        List taskItems = (List)gson.fromJson(jsonString, new TypeToken<List<TaskItem>>(){}.getType());
        virtualRoot.setChildren(taskItems);
        return virtualRoot;
    }

    public static TaskItem buildTreeFromList(List<TaskItem> items) {
        return TaskItem.builder().id("virtualRoot").children(items).build();
    }

    public static String parseTaskTree(TaskResponseItem item) {
        if (item == null || item.getResults() == null || item.getDetailPlan() == null || item.getDetailPlan().getTaskTreeJson() == null) {
            return "[]";
        }
        Set<String> targetTaskIds = item.getResults().stream().map(TaskOperation::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (targetTaskIds.isEmpty()) {
            return "[]";
        }
        Gson gson = new Gson();
        TaskTreeItem taskTreeItem = (TaskTreeItem)JSONObject.parseObject((String)item.getDetailPlan().getTaskTreeJson(), TaskTreeItem.class);
        if (null == taskTreeItem || CollectionUtils.isEmpty(taskTreeItem.getTasks())) {
            return "[]";
        }
        List<TaskItem> taskItems = taskTreeItem.getTasks();
        if (taskItems == null || taskItems.isEmpty()) {
            return "[]";
        }
        return gson.toJson(TreeBuilder.buildFilteredTree(taskItems, targetTaskIds));
    }

    private static List<TaskItem> buildFilteredTree(List<TaskItem> originalItems, Set<String> targetTaskIds) {
        ArrayList<TaskItem> result = new ArrayList<TaskItem>();
        for (TaskItem item : originalItems) {
            TaskItem filteredItem = TreeBuilder.buildFilteredNode(item, targetTaskIds);
            if (filteredItem == null) continue;
            result.add(filteredItem);
        }
        return result;
    }

    private static TaskItem buildFilteredNode(TaskItem originalItem, Set<String> targetTaskIds) {
        if (originalItem == null) {
            return null;
        }
        boolean isTargetNode = originalItem.getId() != null && targetTaskIds.contains(originalItem.getId());
        ArrayList<TaskItem> filteredChildren = new ArrayList<TaskItem>();
        if (originalItem.getChildren() != null) {
            for (TaskItem child : originalItem.getChildren()) {
                TaskItem filteredChild = TreeBuilder.buildFilteredNode(child, targetTaskIds);
                if (filteredChild == null) continue;
                filteredChildren.add(filteredChild);
            }
        }
        if (isTargetNode || !filteredChildren.isEmpty()) {
            return TaskItem.builder().id(originalItem.getId()).status(originalItem.getStatus()).content(originalItem.getContent()).parentId(originalItem.getParentId()).relatedMessageIDs(originalItem.getRelatedMessageIDs()).children(filteredChildren.isEmpty() ? null : filteredChildren).build();
        }
        return null;
    }
}

