/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.SymbolItem;
import com.alibabacloud.intellij.cosy.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class SearchSymbolToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(SearchSymbolToolDetailPanel.class);
    private Project project;
    private ToolPanel toolPanel;
    private JPanel contentPanel;
    private JBList<SymbolItem> symbolItemList;
    private RoundRectPanel filePanel;
    private JScrollPane fileScrollPane;

    public SearchSymbolToolDetailPanel(Project project, ToolPanel toolPanel) {
        this.project = project;
        this.toolPanel = toolPanel;
        this.contentPanel = this.initContentPanel(toolPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List symbolItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), SymbolItem.class);
            if (symbolItems.isEmpty()) {
                return;
            }
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(symbolItems);
            this.symbolItemList = new JBList(listModel);
            this.symbolItemList.setVisibleRowCount(8);
            this.symbolItemList.setOpaque(false);
            this.symbolItemList.setFixedCellHeight(28);
            this.symbolItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            this.symbolItemList.setBorder(BorderFactory.createEmptyBorder());
            this.symbolItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions(this.symbolItemList);
            this.symbolItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SymbolItem symbolItem = (SymbolItem)SearchSymbolToolDetailPanel.this.symbolItemList.getSelectedValue();
                    if (symbolItem.getStartLine() == null || symbolItem.getEndLine() == null) {
                        EditorUtil.openEditorFile(SearchSymbolToolDetailPanel.this.project, symbolItem.getPath(), null, SearchSymbolToolDetailPanel.this.symbolItemList);
                    } else {
                        EditorUtil.openEditorFile(SearchSymbolToolDetailPanel.this.project, symbolItem.getPath(), new LineRange(symbolItem.getStartLine() - 1, symbolItem.getEndLine() - 1), SearchSymbolToolDetailPanel.this.symbolItemList);
                    }
                    SearchSymbolToolDetailPanel.this.symbolItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SearchSymbolToolDetailPanel.this.hoveredIndex.set(-1);
                    SearchSymbolToolDetailPanel.this.symbolItemList.revalidate();
                    SearchSymbolToolDetailPanel.this.symbolItemList.repaint();
                }
            });
            this.symbolItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(this.symbolItemList));
            this.fileScrollPane = new JBScrollPane();
            this.fileScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.fileScrollPane.setViewportView((Component)this.symbolItemList);
            this.fileScrollPane.setOpaque(false);
            this.fileScrollPane.setVerticalScrollBarPolicy(20);
            this.fileScrollPane.setHorizontalScrollBarPolicy(31);
            this.filePanel = new RoundRectPanel();
            this.filePanel.setLayout(new BorderLayout());
            this.filePanel.add((Component)this.fileScrollPane, "Center");
            this.contentPanel.add(this.filePanel);
            SwingUtil.foreachChildComponent(this.filePanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

