/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.CodeItem;
import com.alibabacloud.intellij.cosy.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class SearchCodeBaseToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(SearchCodeBaseToolDetailPanel.class);
    private Project project;
    private ToolPanel parentPanel;
    private JBList<CodeItem> codebaseItemList;
    private JPanel contentPanel;
    private RoundRectPanel codeBasePanel;
    private JScrollPane codeBaseScrollPane;

    public SearchCodeBaseToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List codeBaseItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), CodeItem.class);
            if (codeBaseItems.isEmpty()) {
                return;
            }
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(codeBaseItems);
            this.codebaseItemList = new JBList(listModel);
            this.codebaseItemList.setVisibleRowCount(8);
            this.codebaseItemList.setOpaque(false);
            this.codebaseItemList.setFixedCellHeight(28);
            this.codebaseItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            this.codebaseItemList.setBorder(BorderFactory.createEmptyBorder());
            this.codebaseItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions(this.codebaseItemList);
            this.codebaseItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CodeItem codeItem = (CodeItem)SearchCodeBaseToolDetailPanel.this.codebaseItemList.getSelectedValue();
                    LineRange lineRange = null;
                    if (codeItem.getStartLine() != null && codeItem.getEndLine() != null) {
                        lineRange = new LineRange(codeItem.getStartLine() - 1, codeItem.getEndLine() - 1);
                    }
                    EditorUtil.openEditorFile(SearchCodeBaseToolDetailPanel.this.project, codeItem.getPath(), lineRange, SearchCodeBaseToolDetailPanel.this.codebaseItemList);
                    SearchCodeBaseToolDetailPanel.this.codebaseItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SearchCodeBaseToolDetailPanel.this.hoveredIndex.set(-1);
                    SearchCodeBaseToolDetailPanel.this.codebaseItemList.revalidate();
                    SearchCodeBaseToolDetailPanel.this.codebaseItemList.repaint();
                }
            });
            this.codebaseItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(this.codebaseItemList));
            this.codeBaseScrollPane = new JBScrollPane();
            this.codeBaseScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.codeBaseScrollPane.setViewportView((Component)this.codebaseItemList);
            this.codeBaseScrollPane.setOpaque(false);
            this.codeBaseScrollPane.setVerticalScrollBarPolicy(20);
            this.codeBaseScrollPane.setHorizontalScrollBarPolicy(31);
            this.codeBasePanel = new RoundRectPanel();
            this.codeBasePanel.setLayout(new BorderLayout());
            this.codeBasePanel.add((Component)this.codeBaseScrollPane, "Center");
            this.contentPanel.add(this.codeBasePanel);
            SwingUtil.foreachChildComponent(this.codeBasePanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

