/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.result;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.common.ToolCallConstant;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import lombok.Generated;

public class RunInTerminalToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(RunInTerminalToolDetailPanel.class);
    public AtomicReference<Boolean> runTerminalPanelIsHover = new AtomicReference<Boolean>(false);
    private AtomicReference<Boolean> runInTerminalFinished = new AtomicReference<Boolean>(false);
    private Project project;
    private ToolCallInfo toolCallInfo;
    private ToolPanel parentPanel;
    private JPanel contentPanel;
    private RoundRectPanel terminalPanel;
    private JLabel newTerminalUILabel;
    private JPanel newTerminalUIPanel;

    public RunInTerminalToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public JPanel initContentPanel(boolean isWeekUi) {
        JPanel contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                int halfHeight = height / 2;
                int quarterHeight = height / 4;
                Rectangle upperRect = new Rectangle(0, 1, width, height - quarterHeight);
                RoundRectangle2D.Float lowerRoundRect = new RoundRectangle2D.Float(0.0f, halfHeight, width, halfHeight, 8.0f, 8.0f);
                g2.setColor(RunInTerminalToolDetailPanel.this.getBackgroundColor());
                g2.fill(upperRect);
                g2.fill(lowerRoundRect);
                this.paintChildren(g2);
                g2.dispose();
            }
        };
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        contentPanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        return contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        this.toolCallInfo = toolCallInfo;
        this.contentPanel.removeAll();
        if (Lists.newArrayList((Object[])new String[]{ToolCallStatusEnum.INIT.getStatus(), ToolCallStatusEnum.PENDING.getStatus()}).contains(toolCallInfo.getToolCallStatus())) {
            return;
        }
        if (toolCallInfo.getParameters() == null) {
            return;
        }
        Map<String, Object> parameters = toolCallInfo.getParameters();
        if (!parameters.containsKey("command") && !parameters.containsKey("is_background")) {
            return;
        }
        if (ToolCallStatusEnum.isFinished(toolCallInfo.getToolCallStatus())) {
            this.runInTerminalFinished.set(true);
        }
        Color backgroundColor = this.getBackgroundColor();
        this.terminalPanel = new RoundRectPanel();
        this.terminalPanel.setLayout(new BorderLayout());
        this.terminalPanel.setBorder(JBUI.Borders.empty((int)8));
        this.terminalPanel.setBackground(backgroundColor);
        if (parameters.containsKey("command")) {
            JPanel commandPanel = new JPanel(new BorderLayout());
            commandPanel.setBorder((Border)JBUI.Borders.empty());
            commandPanel.setBackground(backgroundColor);
            String command = (String)parameters.get("command");
            JTextArea commandTextArea = new JTextArea(command);
            commandTextArea.setFont(commandTextArea.getFont().deriveFont(0, 13.0f));
            commandTextArea.setLineWrap(true);
            commandTextArea.setWrapStyleWord(true);
            commandTextArea.setEditable(false);
            commandTextArea.setBackground(backgroundColor);
            commandTextArea.setBorder((Border)JBUI.Borders.empty());
            commandPanel.add((Component)commandTextArea, "Center");
            this.terminalPanel.add((Component)commandPanel, "Center");
        }
        try {
            final Pair<Boolean, String> checkTerminalDisabled = ToolCallConstant.checkTerminalDisabled(toolCallInfo);
            if (checkTerminalDisabled != null) {
                this.newTerminalUIPanel = new JPanel(new BorderLayout());
                this.newTerminalUIPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
                this.newTerminalUIPanel.setBackground(backgroundColor);
                this.newTerminalUILabel = new JLabel(this.truncate(this.newTerminalUIPanel, this.newTerminalUILabel, (String)checkTerminalDisabled.getSecond()));
                this.newTerminalUILabel.setIcon(LingmaIcons.AttentionYellowIcon);
                this.newTerminalUILabel.setOpaque(true);
                this.newTerminalUILabel.setBackground(backgroundColor);
                this.newTerminalUILabel.setFont(this.newTerminalUILabel.getFont().deriveFont(0, 12.0f));
                this.newTerminalUILabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                this.newTerminalUIPanel.add((Component)this.newTerminalUILabel, "West");
                this.newTerminalUIPanel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        if (RunInTerminalToolDetailPanel.this.newTerminalUIPanel.getWidth() > 0) {
                            String text = RunInTerminalToolDetailPanel.this.truncate(RunInTerminalToolDetailPanel.this.newTerminalUIPanel, RunInTerminalToolDetailPanel.this.newTerminalUILabel, (String)checkTerminalDisabled.getSecond());
                            RunInTerminalToolDetailPanel.this.newTerminalUILabel.setText(text);
                            RunInTerminalToolDetailPanel.this.newTerminalUILabel.repaint();
                        }
                    }
                });
                this.terminalPanel.add((Component)this.newTerminalUIPanel, "South");
            }
        }
        catch (Exception e) {
            log.warn("RunInTerminalToolDetailPanel render error terminal ui bar error", (Throwable)e);
        }
        this.contentPanel.add(this.terminalPanel);
        this.contentPanel.addMouseListener(this.myMouseAdapter());
        SwingUtil.foreachChildComponent(this.contentPanel, cp -> cp.addMouseListener(this.myMouseAdapter()));
        this.contentPanel.setVisible(true);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private String truncate(JComponent hostComponent, JLabel newTerminalUILabel, String text) {
        Dimension panelSize = hostComponent.getSize();
        if (panelSize.width > 0) {
            int maxWidth = panelSize.width - 30;
            return FontUtil.getStringAdaptiveWidth(newTerminalUILabel, text, maxWidth, false);
        }
        return text;
    }

    @Override
    public void updateUiTexts() {
        Pair<Boolean, String> checked;
        if (this.newTerminalUILabel != null && this.newTerminalUIPanel != null && this.toolCallInfo != null && (checked = ToolCallConstant.checkTerminalDisabled(this.toolCallInfo)) != null) {
            this.newTerminalUILabel.setText(this.truncate(this.newTerminalUIPanel, this.newTerminalUILabel, (String)checked.getSecond()));
        }
    }

    public void repaintBackground() {
        if (this.terminalPanel != null) {
            Color backgroundColor = this.getBackgroundColor();
            SwingUtil.foreachChildComponent(this.terminalPanel, cp -> cp.setBackground(backgroundColor));
            this.terminalPanel.setBackground(backgroundColor);
        }
    }

    private MouseAdapter myMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                RunInTerminalToolDetailPanel.this.runTerminalPanelIsHover.set(true);
                RunInTerminalToolDetailPanel.this.repaintBackground();
                RunInTerminalToolDetailPanel.this.contentPanel.repaint();
                RunInTerminalToolDetailPanel.this.parentPanel.repaint();
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                RunInTerminalToolDetailPanel.this.runTerminalPanelIsHover.set(false);
                RunInTerminalToolDetailPanel.this.repaintBackground();
                RunInTerminalToolDetailPanel.this.contentPanel.repaint();
                RunInTerminalToolDetailPanel.this.parentPanel.repaint();
                e.consume();
            }
        };
    }

    private Color getBackgroundColor() {
        return this.runInTerminalFinished.get() == false || this.parentPanel.getTitlePanelIsHover().get() != false || this.runTerminalPanelIsHover.get() != false ? ColorUtil.getEditorBackgroundColor() : ColorUtil.getToolWindowBackgroundColor();
    }

    @Generated
    public AtomicReference<Boolean> getRunTerminalPanelIsHover() {
        return this.runTerminalPanelIsHover;
    }
}

