/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.RuleItem;
import com.alibabacloud.intellij.cosy.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FetchRuleToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(FetchRuleToolDetailPanel.class);
    private final Project project;
    private final JPanel contentPanel;

    public FetchRuleToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        List symbolItems;
        if (toolCallInfo.getResults() != null && CollectionUtils.isNotEmpty((Collection)(symbolItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), RuleItem.class)))) {
            this.contentPanel.removeAll();
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(symbolItems);
            final JBList ruleItemList = new JBList(listModel);
            ruleItemList.setVisibleRowCount(8);
            ruleItemList.setFixedCellHeight(28);
            ruleItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            ruleItemList.setBorder(BorderFactory.createEmptyBorder());
            ruleItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions((JList)ruleItemList);
            ruleItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RuleItem ruleItem = (RuleItem)ruleItemList.getSelectedValue();
                    if (null == ruleItem.getMetadata() || StringUtils.isEmpty((CharSequence)ruleItem.getMetadata().getFilePath())) {
                        log.warn("filePath is empty, ruleItem: " + ruleItem);
                    } else {
                        EditorUtil.openEditorFile(FetchRuleToolDetailPanel.this.project, ruleItem.getMetadata().getFilePath(), null, (JComponent)ruleItemList);
                    }
                    ruleItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FetchRuleToolDetailPanel.this.hoveredIndex.set(-1);
                    ruleItemList.revalidate();
                    ruleItemList.repaint();
                }
            });
            ruleItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(ruleItemList));
            JBScrollPane ruleScrollPane = new JBScrollPane((Component)ruleItemList);
            ruleScrollPane.setBorder(BorderFactory.createEmptyBorder());
            ruleScrollPane.setVerticalScrollBarPolicy(20);
            ruleScrollPane.setHorizontalScrollBarPolicy(31);
            RoundRectPanel rulePanel = new RoundRectPanel(new BorderLayout());
            rulePanel.add((Component)ruleScrollPane, "Center");
            this.contentPanel.add(rulePanel);
            SwingUtil.foreachChildComponent(rulePanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

