/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.approval;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class WebToolApprovalPanel
extends BaseToolCallHandler
implements ToolApprovalPanel {
    private Project project;
    private JPanel contentPanel;
    private RoundRectLabel agreeLabel;
    private JLabel refuseLabel;
    private ToolCallInfo currentToolCallInfo;
    private final ToolPanel toolPanel;

    public WebToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.project = project;
        this.contentPanel = this.initContentPanel(false);
        this.toolPanel = toolPanel;
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void initToolApprovalPanel(Project project, ToolCallInfo toolCallInfo) {
        this.contentPanel.removeAll();
        this.currentToolCallInfo = toolCallInfo;
        if (!ToolCallStatusEnum.PENDING.getStatus().equals(toolCallInfo.getToolCallStatus())) {
            return;
        }
        RoundRectPanel webPanel = new RoundRectPanel();
        webPanel.setLayout(new BorderLayout());
        webPanel.setBorder(JBUI.Borders.empty((int)8));
        webPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        JPanel toolApprovalPanel = this.initToolApprovalLabels(toolCallInfo);
        webPanel.add((Component)toolApprovalPanel, "South");
        webPanel.setFocusable(true);
        webPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeWebTools(true)));
        webPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeWebTools(false)));
        this.contentPanel.add(webPanel);
        this.contentPanel.setVisible(true);
        this.contentPanel.setFocusable(true);
        this.contentPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeWebTools(true)));
        this.contentPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeWebTools(false)));
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        SwingUtilities.invokeLater(webPanel::requestFocusInWindow);
    }

    private void executeWebTools(boolean isAgree) {
        if (this.currentToolCallInfo != null) {
            this.operate(this.project, this.currentToolCallInfo.getSessionId(), this.currentToolCallInfo.getRequestId(), this.currentToolCallInfo.getToolCallId(), isAgree);
        }
    }

    private JPanel initToolApprovalLabels(final ToolCallInfo toolCallInfo) {
        JPanel toolApprovalPanel = new JPanel();
        toolApprovalPanel.setLayout(new BoxLayout(toolApprovalPanel, 0));
        toolApprovalPanel.setBorder((Border)JBUI.Borders.empty());
        toolApprovalPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        Box toolApprovalBox = Box.createHorizontalBox();
        this.agreeLabel = this.initWebToolsAgreeLabel();
        this.agreeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WebToolApprovalPanel.this.operate(WebToolApprovalPanel.this.project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), true);
                WebToolApprovalPanel.this.toolPanel.getToolAutoRunChooser().setVisible(false);
            }
        });
        toolApprovalBox.add(this.agreeLabel);
        toolApprovalBox.add(Box.createHorizontalStrut(10));
        this.refuseLabel = this.initWebToolsRejectLabel();
        this.refuseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WebToolApprovalPanel.this.operate(WebToolApprovalPanel.this.project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), false);
            }
        });
        toolApprovalBox.add(this.refuseLabel);
        toolApprovalPanel.add(toolApprovalBox);
        return toolApprovalPanel;
    }

    @Override
    public void updateUiTexts() {
        if (this.agreeLabel != null) {
            this.agreeLabel.setText(WebToolApprovalPanel.getCmdReturnKey() + " " + CosyBundle.message("tool.mcp.execute.operation.execute", new Object[0]));
            this.agreeLabel.repaint();
        }
        if (this.refuseLabel != null) {
            this.refuseLabel.setText(WebToolApprovalPanel.getCmdDeleteKey() + " " + CosyBundle.message("tool.mcp.execute.operation.cancel", new Object[0]));
            this.refuseLabel.repaint();
        }
    }
}

