/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.tool.approval;

import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MCPToolApprovalPanel
extends BaseToolCallHandler
implements ToolApprovalPanel {
    private Project project;
    private JPanel contentPanel;
    private JLabel parametersLabel;
    private RoundRectLabel agreeLabel;
    private JLabel refuseLabel;
    private ToolCallInfo currentToolCallInfo;
    private final ToolPanel toolPanel;

    public MCPToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.project = project;
        this.contentPanel = this.initContentPanel(toolPanel.getToolTypeEnum().isWeekUi());
        this.toolPanel = toolPanel;
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void initToolApprovalPanel(Project project, ToolCallInfo toolCallInfo) {
        this.contentPanel.removeAll();
        this.currentToolCallInfo = toolCallInfo;
        if (!ToolCallStatusEnum.PENDING.getStatus().equals(toolCallInfo.getToolCallStatus())) {
            return;
        }
        RoundRectPanel mcpPanel = new RoundRectPanel();
        mcpPanel.setLayout(new BorderLayout());
        mcpPanel.setBorder(JBUI.Borders.empty((int)8));
        mcpPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        JPanel paramsPanel = this.initParamsPanel(toolCallInfo);
        if (paramsPanel != null) {
            mcpPanel.add((Component)paramsPanel, "Center");
        }
        JPanel toolApprovalPanel = this.initToolApprovalLabels(toolCallInfo);
        mcpPanel.add((Component)toolApprovalPanel, "South");
        mcpPanel.setFocusable(true);
        mcpPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeMcpCommand(true)));
        mcpPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeMcpCommand(false)));
        this.contentPanel.add(mcpPanel);
        this.contentPanel.setVisible(true);
        this.contentPanel.setFocusable(true);
        this.contentPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeMcpCommand(true)));
        this.contentPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeMcpCommand(false)));
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        SwingUtilities.invokeLater(mcpPanel::requestFocusInWindow);
    }

    private void executeMcpCommand(boolean isAgree) {
        if (this.currentToolCallInfo != null) {
            this.operate(this.project, this.currentToolCallInfo.getSessionId(), this.currentToolCallInfo.getRequestId(), this.currentToolCallInfo.getToolCallId(), isAgree);
        }
    }

    private JPanel initToolApprovalLabels(final ToolCallInfo toolCallInfo) {
        JPanel toolApprovalPanel = new JPanel();
        toolApprovalPanel.setLayout(new BoxLayout(toolApprovalPanel, 0));
        toolApprovalPanel.setBorder((Border)JBUI.Borders.empty());
        toolApprovalPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        Box toolApprovalBox = Box.createHorizontalBox();
        this.agreeLabel = new RoundRectLabel(MCPToolApprovalPanel.getAgreeText(), ColorUtil.getItemSelectionBackground(), 8, 3, 8, 0);
        this.agreeLabel.setBackground(ColorUtil.getItemSelectionBackground());
        this.agreeLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.agreeLabel.setFont(this.agreeLabel.getFont().deriveFont(0, 13.0f));
        this.agreeLabel.setForeground(ColorUtil.getItemSelectionForeground());
        this.agreeLabel.setHorizontalAlignment(0);
        this.agreeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MCPToolApprovalPanel.this.operate(MCPToolApprovalPanel.this.project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), true);
                MCPToolApprovalPanel.this.toolPanel.getToolAutoRunChooser().setVisible(false);
            }
        });
        toolApprovalBox.add(this.agreeLabel);
        toolApprovalBox.add(Box.createHorizontalStrut(10));
        this.refuseLabel = new JLabel(MCPToolApprovalPanel.getRefuseText());
        this.refuseLabel.setOpaque(true);
        this.refuseLabel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.refuseLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.refuseLabel.setFont(this.refuseLabel.getFont().deriveFont(0, 13.0f));
        this.refuseLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.refuseLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)3, (int)14));
        this.refuseLabel.setHorizontalAlignment(0);
        this.refuseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MCPToolApprovalPanel.this.operate(MCPToolApprovalPanel.this.project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), false);
            }
        });
        toolApprovalBox.add(this.refuseLabel);
        toolApprovalPanel.add(toolApprovalBox);
        return toolApprovalPanel;
    }

    private JPanel initParamsPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() != null) {
            JPanel parametersPanel = new JPanel(new BorderLayout());
            parametersPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            parametersPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.parametersLabel = new JLabel(CosyBundle.message("tool.mcp.execute.params", new Object[0]));
            this.parametersLabel.setOpaque(true);
            this.parametersLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.parametersLabel.setFont(this.parametersLabel.getFont().deriveFont(0, 12.0f));
            this.parametersLabel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.parametersLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
            parametersPanel.add((Component)this.parametersLabel, "North");
            RoundRectPanel jPanel = new RoundRectPanel(new BorderLayout());
            jPanel.setBorder(JBUI.Borders.empty((int)8));
            jPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
            JTextPane jsonPane = new JTextPane();
            jsonPane.setEditable(false);
            jsonPane.setBackground(ColorUtil.getToolWindowBackgroundColor());
            String formattedJson = this.formatJson(toolCallInfo.getParameters());
            this.addStyledText(jsonPane, StringUtils.trim((String)formattedJson));
            JBScrollPane scrollPane = new JBScrollPane(jsonPane){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (size.height > 120) {
                        size.height = 120;
                    }
                    return size;
                }
            };
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setBackground(ColorUtil.getToolWindowBackgroundColor());
            scrollPane.getViewport().setBackground(ColorUtil.getToolWindowBackgroundColor());
            jPanel.add((Component)scrollPane, "Center");
            parametersPanel.add((Component)jPanel, "Center");
            return parametersPanel;
        }
        return null;
    }

    @Override
    public void updateUiTexts() {
        if (this.agreeLabel != null) {
            this.agreeLabel.setText(MCPToolApprovalPanel.getAgreeText());
            this.agreeLabel.repaint();
        }
        if (this.refuseLabel != null) {
            this.refuseLabel.setText(MCPToolApprovalPanel.getRefuseText());
            this.refuseLabel.repaint();
        }
    }

    @NotNull
    private static String getRefuseText() {
        String string = MCPToolApprovalPanel.getCmdDeleteKey() + " " + CosyBundle.message("tool.mcp.execute.operation.cancel", new Object[0]);
        if (string == null) {
            MCPToolApprovalPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getAgreeText() {
        String string = MCPToolApprovalPanel.getCmdReturnKey() + " " + CosyBundle.message("tool.mcp.execute.operation.execute", new Object[0]);
        if (string == null) {
            MCPToolApprovalPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/alibabacloud/intellij/cosy/ui/search/component/tool/approval/MCPToolApprovalPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefuseText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgreeText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

