/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.textpane;

import com.alibabacloud.intellij.cosy.ui.search.component.textpane.ChatStyledEditorKit;
import com.alibabacloud.intellij.cosy.ui.search.component.textpane.ContinuousText;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatAskTagLabel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public class RichTextPane
extends JTextPane {
    private static final Logger LOGGER = Logger.getInstance(RichTextPane.class);
    private final TextComponentEmptyText myEmptyText;

    public RichTextPane() {
        this.setEditorKit(new ChatStyledEditorKit());
        this.myEmptyText = new TextComponentEmptyText(this);
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RichTextPane.this.invalidate();
                RichTextPane.this.revalidate();
                RichTextPane.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/cosy/ui/search/component/textpane/RichTextPane$1", "textChanged"));
            }
        });
    }

    public void insertText(String text) {
        this.insertText(this.getCaretPosition(), text);
    }

    @Override
    public void insertComponent(Component component) {
        this.insertComponent(this.getCaretPosition(), component);
    }

    public void insertText(int offset, String text) {
        try {
            this.getStyledDocument().insertString(offset, text, null);
        }
        catch (BadLocationException e) {
            LOGGER.warn("insertString error " + e.getMessage(), (Throwable)e);
        }
    }

    public void insertComponent(int offset, Component component) {
        try {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setComponent(attrs, component);
            this.getStyledDocument().insertString(offset, " ", attrs);
        }
        catch (BadLocationException e) {
            LOGGER.warn("insertComponent error " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Element> getUIElements() {
        Element element;
        ArrayList<Element> elements = new ArrayList<Element>();
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((element = iterator.next()) != null) {
            try {
                Component comp;
                if (element.getName().equals("content")) {
                    elements.add(element);
                    continue;
                }
                if (!element.getName().equals("component") || (comp = StyleConstants.getComponent(element.getAttributes())) == null || !(comp instanceof ChatAskTagLabel)) continue;
                elements.add(element);
            }
            catch (Exception e) {
                LOGGER.warn("build input elements error " + e.getMessage(), (Throwable)e);
            }
        }
        return elements;
    }

    public void clearContent(int startOffset, int endOffset) {
        if (endOffset <= startOffset) {
            return;
        }
        try {
            this.getStyledDocument().remove(startOffset, endOffset - startOffset);
            this.setCaretPosition(startOffset);
        }
        catch (Exception e) {
            LOGGER.warn("clear content error " + e.getMessage(), (Throwable)e);
        }
    }

    public void replaceComponent(int startOffset, int endOffset, Component component) {
        if (endOffset <= startOffset) {
            return;
        }
        try {
            this.getStyledDocument().remove(startOffset, endOffset - startOffset);
            this.setCaretPosition(startOffset);
            this.insertComponent(startOffset, component);
        }
        catch (Exception e) {
            LOGGER.warn("insertComponent error " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Element> getElementsUntilCaret(int caretOffset) {
        Element element;
        ArrayList<Element> elements = new ArrayList<Element>();
        StyledDocument doc = this.getStyledDocument();
        ElementIterator iterator = new ElementIterator(doc);
        while ((element = iterator.next()) != null) {
            try {
                if (!element.getName().equals("content") && !element.getName().equals("component")) continue;
                int start = element.getStartOffset();
                if (start > caretOffset) break;
                elements.add(element);
            }
            catch (Exception e) {
                LOGGER.warn("get elements until caret error " + e.getMessage(), (Throwable)e);
            }
        }
        return elements;
    }

    public ContinuousText getContinuousTextUntilCaret(int caretOffset) {
        StyledDocument doc = this.getStyledDocument();
        List<Element> elements = this.getElementsUntilCaret(caretOffset);
        ContinuousText continuousText = new ContinuousText();
        Integer startOffset = null;
        Integer endOffset = null;
        StringBuilder sb = new StringBuilder();
        try {
            Element element;
            for (int i = elements.size() - 1; i >= 0 && (element = elements.get(i)).getName().equals("content"); --i) {
                int start = element.getStartOffset();
                int end = element.getEndOffset();
                if (end > caretOffset) {
                    end = caretOffset;
                }
                if (startOffset == null || startOffset > start) {
                    startOffset = start;
                }
                if (endOffset == null || endOffset < end) {
                    endOffset = end;
                }
                String text = doc.getText(start, end - start);
                sb.insert(0, text);
            }
        }
        catch (BadLocationException e) {
            LOGGER.warn("getContinuousTextUntilCaret error " + e.getMessage(), (Throwable)e);
        }
        if (startOffset == null) {
            return null;
        }
        continuousText.setStartOffset(startOffset);
        continuousText.setEndOffset(endOffset);
        continuousText.setText(sb.toString());
        return continuousText;
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
        JViewport viewport = (JViewport)ComponentUtil.getParentOfType(JViewport.class, (Component)this);
        if (viewport != null) {
            r = SwingUtilities.convertRectangle(this, r, viewport);
            viewport.scrollRectToVisible(r);
        }
    }

    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            RichTextPane.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getMargin());
            ((Graphics2D)g).fill(rect);
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEmptyText.getComponent().setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/search/component/textpane/RichTextPane", "getEmptyText"));
    }

    public static class TextComponentEmptyText
    extends StatusText {
        private final JTextComponent myOwner;
        private String myStatusTriggerText = "";

        TextComponentEmptyText(JTextComponent owner) {
            super((JComponent)owner);
            this.myOwner = owner;
            this.clear();
            this.myOwner.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    myOwner.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    myOwner.repaint();
                }
            });
        }

        public void setTextToTriggerStatus(@NotNull String defaultText) {
            if (defaultText == null) {
                TextComponentEmptyText.$$$reportNull$$$0(0);
            }
            this.myStatusTriggerText = defaultText;
        }

        @NotNull
        public String getStatusTriggerText() {
            String string = this.myStatusTriggerText;
            if (string == null) {
                TextComponentEmptyText.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void paintStatusText(Graphics g) {
            if (!this.isFontSet()) {
                this.setFont(this.myOwner.getFont());
            }
            this.paint(this.myOwner, g);
        }

        protected boolean isStatusVisible() {
            return this.myOwner.getText().equals(this.myStatusTriggerText) && !this.myOwner.isFocusOwner();
        }

        protected Rectangle getTextComponentBound() {
            Rectangle b = this.myOwner.getBounds();
            Insets insets = (Insets)ObjectUtils.notNull((Object)this.myOwner.getInsets(), (Object)JBUI.emptyInsets());
            Insets margin = (Insets)ObjectUtils.notNull((Object)this.myOwner.getMargin(), (Object)JBUI.emptyInsets());
            Insets ipad = this.getComponent().getIpad();
            int left = insets.left + margin.left - ipad.left;
            int right = insets.right + margin.right - ipad.right;
            int top = insets.top + margin.top - ipad.top - 5;
            int bottom = insets.bottom + margin.bottom - ipad.bottom;
            return new Rectangle(left, top, b.width - left - right, b.height - top - bottom);
        }

        @NotNull
        protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
            if (component == null) {
                TextComponentEmptyText.$$$reportNull$$$0(2);
            }
            if (bounds == null) {
                TextComponentEmptyText.$$$reportNull$$$0(3);
            }
            Dimension size = component.getPreferredSize();
            return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, size.width, bounds.height) : new Rectangle(bounds.x + bounds.width - size.width, bounds.y, size.width, bounds.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/search/component/textpane/RichTextPane$TextComponentEmptyText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/component/textpane/RichTextPane$TextComponentEmptyText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusTriggerText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setTextToTriggerStatus";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustComponentBounds";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

