/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.markdown;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatCodeChangeApplyParam;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatCodeChangeApplyResult;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.layout.RightFlowLayout;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.util.WelcomePanelUtil;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.enums.SceneTypeEnum;
import com.alibabacloud.intellij.cosy.service.handler.ChatAskApplyDiffHandler;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.ineditordiff.InEditorDiffRenderer;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.component.CodeTextPane;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayIcon;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.Code2HtmlConverter;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.PrismCode2HtmlConverter;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatCopyContext;
import com.alibabacloud.intellij.cosy.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatCodeChangeApplyFinishNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeDiffNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeNewFileNotifier;
import com.alibabacloud.intellij.cosy.util.CodeMarkdownRenderUtils;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.JCefUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class CodeMarkdownHighlightComponent
implements MarkdownComponent {
    private static final Logger LOG = Logger.getInstance(CodeMarkdownHighlightComponent.class);
    public static final String CODE_PANE_PROPERTIES_KEY = "codePane";
    private static final int HGAP = 24;
    private static final int TOOLBAR_HEIGHT = 32;
    private static final int SCROLL_HEIGHT_PADDING = 4;
    private static final int SUPPORT_MERMAID_CHART_VERSION_FOR_MAC = 221;
    private static final int SUPPORT_MERMAID_CHART_VERSION_FOR_WIN = 231;
    private static final int CEF_SUPPORT_RELOAD_VERSION = 241;
    private static final int ASK_APPLY_RESULT_CHECK_INTERVAL = 5000;
    private static final int ASK_APPLY_RESULT_CHECK_COUNT = 25;
    private Project project;
    private String chatTask;
    private String requestId;
    private String sessionId;
    private CodeTextPane editorTextField;
    private JPanel chartPanel;
    JScrollPane jbScrollPane;
    private JComponent parentComponent;
    private GenerateAnswerPanel generateAnswerPanel;
    private final JPanel contentPane;
    private RoundRectPanel basePane;
    private JLayeredPane layeredPane;
    private ToolbarPane fixedToolbarPane;
    private ToolbarPane floatToolbarPane;
    private boolean showFloatToolbar;
    Dimension parentComponentSize;
    private static Code2HtmlConverter converter = new PrismCode2HtmlConverter();
    private String content;
    private boolean showCode = true;
    private boolean isCompleted = false;
    private JBCefBrowser jbCefBrowser;
    private double chartZoomLevel;
    private String chartPageHtml;
    private Boolean hasZoomInTelemetry = false;
    private Boolean hasZoomOutTelemetry = false;
    private static Set<String> DIFF_TASK_SET = new HashSet<String>(){
        {
            this.add(ChatTaskEnum.CODE_GENERATE_COMMENT.getName());
            this.add(ChatTaskEnum.OPTIMIZE_CODE.getName());
        }
    };
    private int limitCodeBlockHeight = 0;
    private SessionTypeEnum sessionType;
    private CosyService cosyService;
    private AtomicReference<Pair<String, Boolean>> applyResultPair = new AtomicReference();
    private InEditorDiffRenderer inEditorDiffRenderer;

    public CodeMarkdownHighlightComponent(final Project project, String content, String language, String filePath, final JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel, final int limitCodeBlockHeight, boolean isCompleted) {
        this.project = project;
        this.parentComponent = parentComponent;
        this.generateAnswerPanel = generateAnswerPanel;
        this.sessionType = generateAnswerPanel.getSessionType();
        this.chatTask = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getChatTask();
        this.requestId = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getRequestId();
        this.sessionId = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getSessionId();
        this.cosyService = new CosyServiceImpl();
        this.contentPane = new JPanel(new BorderLayout());
        this.basePane = new RoundRectPanel((LayoutManager)new BorderLayout(), 8);
        this.basePane.setCornorBackgroundColor(ColorUtil.getChatCardChildBackgroundColor());
        this.layeredPane = new JLayeredPane();
        this.limitCodeBlockHeight = limitCodeBlockHeight;
        this.isCompleted = isCompleted;
        this.editorTextField = new CodeTextPane(project, content, language, this.chatTask, this.requestId, this.sessionId);
        this.contentPane.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.contentPane.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.contentPane.add((Component)this.basePane, "Center");
        this.basePane.putClientProperty(CODE_PANE_PROPERTIES_KEY, true);
        this.parentComponentSize = parentComponent.getSize();
        this.chartPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (ArrayUtils.isEmpty((Object[])CodeMarkdownHighlightComponent.this.chartPanel.getComponents())) {
                    return size;
                }
                Component child = CodeMarkdownHighlightComponent.this.chartPanel.getComponent(0);
                return new Dimension(child.getPreferredSize().width, child.getPreferredSize().height);
            }
        };
        this.chartPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.chartPanel.setBackground(this.editorTextField.getBackground());
        this.jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension parentSize = parentComponent.getSize();
                int height = size.height + 4;
                if (limitCodeBlockHeight > 0 && height > limitCodeBlockHeight) {
                    height = limitCodeBlockHeight;
                }
                return new Dimension(parentSize.width - 24, height);
            }
        };
        this.jbScrollPane.setViewportView(this.editorTextField);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(32);
        Dimension editSize = this.editorTextField.getPreferredSize();
        if (limitCodeBlockHeight > 0 && editSize.height > limitCodeBlockHeight) {
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        } else {
            this.jbScrollPane.setVerticalScrollBarPolicy(21);
        }
        this.editorTextField.addMouseMotionListener(new MouseMotionAdapter(){
            private int lastMouseY = -1;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CodeMarkdownHighlightComponent.this.editorTextField.getVisibleRect().contains(e.getPoint())) {
                    this.lastMouseY = e.getY();
                } else {
                    JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
                    this.lastMouseY = CodeMarkdownHighlightComponent.this.handleTextDragEvent(project, e, this.lastMouseY, scrollPane);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.lastMouseY = e.getY();
            }
        });
        this.editorTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CodeMarkdownHighlightComponent.this.editorTextField.copy();
                    NotificationFactory.showToast((JComponent)CodeMarkdownHighlightComponent.this.editorTextField, LingmaIcons.AcceptIcon, CosyBundle.message("notifications.code.btn.copied", new Object[0]));
                }
            }
        });
        this.layeredPane.add((Component)this.jbScrollPane, JLayeredPane.DEFAULT_LAYER);
        if (generateAnswerPanel != null) {
            this.initToolbar(language, filePath);
            this.initFloatToolbar(language, filePath);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            this.updateText(content, language, this.isCompleted);
        }
        SwingUtil.foreachChildComponent(this.fixedToolbarPane.toolbarPane, cp -> cp.setOpaque(false));
        SwingUtil.foreachChildComponent(this.layeredPane, cp -> cp.setOpaque(false));
        this.basePane.add((Component)this.layeredPane, "Center");
        SwingUtil.setComponentBackgroudColor(this.basePane, ColorUtil.getEditorBackgroundColor(), new Class[0]);
        this.basePane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CodeMarkdownHighlightComponent.this.updateLayerLocation();
                CodeMarkdownHighlightComponent.this.basePane.revalidate();
                CodeMarkdownHighlightComponent.this.basePane.repaint();
            }
        });
        if (this.sessionType == SessionTypeEnum.INLINE) {
            this.editorTextField.putClientProperty("AuxEditorComponent", true);
        }
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            MessageBusConnection messageBusConnection = project.getMessageBus().connect();
            messageBusConnection.subscribe(ChatCodeChangeApplyFinishNotifier.CHAT_CODE_CHANGE_APPLY_NOTIFICATION, this::applyFinishNotify);
        }
    }

    MouseAdapter applyClickAdapter(final String applyFilePath, final String language, final String sessionType, final String chatMode) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VirtualFile file;
                if (CodeMarkdownHighlightComponent.this.applyResultPair.get() != null && BooleanUtils.isNotTrue((Boolean)((Boolean)CodeMarkdownHighlightComponent.this.applyResultPair.get().getSecond()))) {
                    LOG.warn("Apply Label is applying, apply id=" + (String)CodeMarkdownHighlightComponent.this.applyResultPair.get().getFirst());
                    return;
                }
                if (CodeMarkdownHighlightComponent.this.inEditorDiffRenderer != null) {
                    CodeMarkdownHighlightComponent.this.inEditorDiffRenderer.dispose();
                }
                if ((file = LocalFileSystem.getInstance().findFileByPath(applyFilePath)) == null) {
                    LOG.warn("getApplyLabel file not found:" + applyFilePath);
                    NotificationFactory.showToast((JComponent)evt.getComponent(), MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]));
                    return;
                }
                FileDocumentManager manager = FileDocumentManager.getInstance();
                Document document = manager.getDocument(file);
                if (document == null) {
                    LOG.warn("getApplyLabel document not found:" + applyFilePath);
                    NotificationFactory.showToast((JComponent)evt.getComponent(), MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]));
                    return;
                }
                FileDocumentManager.getInstance().saveDocument(document);
                CompletableFuture.runAsync(() -> {
                    ChatCodeChangeApplyParam chatCodeChangeApplyParam = new ChatCodeChangeApplyParam();
                    chatCodeChangeApplyParam.setApplyId(UUID.randomUUID().toString());
                    chatCodeChangeApplyParam.setProjectPath(ProjectUtils.getProjectBaseDir(CodeMarkdownHighlightComponent.this.project));
                    chatCodeChangeApplyParam.setFilePath(applyFilePath);
                    chatCodeChangeApplyParam.setLanguage(language);
                    chatCodeChangeApplyParam.setCodeEdit(CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    chatCodeChangeApplyParam.setRequestId(CodeMarkdownHighlightComponent.this.requestId);
                    chatCodeChangeApplyParam.setSessionId(CodeMarkdownHighlightComponent.this.sessionId);
                    chatCodeChangeApplyParam.setSessionType(sessionType);
                    chatCodeChangeApplyParam.setMode(chatMode);
                    CodeMarkdownHighlightComponent.this.applyResultPair.set((Pair<String, Boolean>)new Pair((Object)chatCodeChangeApplyParam.getApplyId(), (Object)false));
                    CodeMarkdownHighlightComponent.this.updateToolbarApplyLabelIcons(LingmaIcons.StatusBarLoadingIcon);
                    ChatAskApplyDiffHandler.addChatAskApplyDiffHandler(CodeMarkdownHighlightComponent.this.project, applyFilePath, CodeMarkdownHighlightComponent.this);
                    CompletableFuture.runAsync(() -> CodeMarkdownHighlightComponent.this.cosyService.chatCodeChangeApply(CodeMarkdownHighlightComponent.this.project, chatCodeChangeApplyParam));
                    CodeMarkdownHighlightComponent.this.scheduleApplyTimeout(chatCodeChangeApplyParam.getApplyId(), CodeMarkdownHighlightComponent.this.applyResultPair);
                    TelemetryService.getInstance().telemetryChatAskApply(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, file.getPresentableUrl());
                });
            }
        };
    }

    private void scheduleApplyTimeout(String applyId, AtomicReference<Pair<String, Boolean>> applyResultPair) {
        AtomicInteger counter = new AtomicInteger(0);
        Timer timer = new Timer(5000, evt -> {
            counter.incrementAndGet();
            Pair currentPair = (Pair)applyResultPair.get();
            if (currentPair == null || !applyId.equals(currentPair.getFirst())) {
                ((Timer)evt.getSource()).stop();
                return;
            }
            if (Boolean.TRUE.equals(currentPair.getSecond())) {
                ((Timer)evt.getSource()).stop();
                return;
            }
            if (counter.get() > 25) {
                applyResultPair.set(null);
                this.updateToolbarApplyLabelIcons(LingmaIcons.ApplyBlueIcon);
                ((Timer)evt.getSource()).stop();
            }
        });
        timer.setRepeats(true);
        timer.start();
    }

    void applyFinishNotify(ChatCodeChangeApplyResult result) {
        Pair<String, Boolean> oldApplyResult = this.applyResultPair.get();
        if (oldApplyResult == null) {
            LOG.debug("applyFinishNotify oldApplyResult is null&result=" + JSON.toJSONString((Object)result));
            return;
        }
        if (!((String)oldApplyResult.getFirst()).equals(result.getApplyId())) {
            LOG.debug("applyFinishNotify not same applyId=" + (String)oldApplyResult.getFirst() + "&result=" + JSON.toJSONString((Object)result));
            return;
        }
        if (BooleanUtils.isTrue((Boolean)((Boolean)oldApplyResult.getSecond()))) {
            LOG.debug("applyFinishNotify the applyId has finished apply, applyId=" + (String)oldApplyResult.getFirst() + "&result=" + JSON.toJSONString((Object)result));
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(result.getFilePath());
            if (file == null) {
                LOG.warn("applyFinishNotify file not found:" + result.getFilePath());
                return;
            }
            String fileExtension = file.getExtension();
            FileType fileType = null;
            if (StringUtils.isNotBlank((CharSequence)fileExtension)) {
                fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(fileExtension);
            }
            if (fileType == null || fileType instanceof UnknownFileType) {
                fileType = FileTypes.PLAIN_TEXT;
            }
            if ((document = FileDocumentManager.getInstance().getDocument(file)) == null) {
                LOG.warn("applyFinishNotify document is null, filePath=" + result.getFilePath());
                return;
            }
            String originalText = document.getText();
            FileType finalFileType = fileType;
            VirtualFile finalFile = file;
            String finalOriginalText = originalText;
            ApplicationManager.getApplication().invokeLater(() -> {
                FileEditorManager.getInstance((Project)this.project).openFile(finalFile, true);
                Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
                if (editor == null) {
                    LOG.warn("applyFinishNotify editor is null, filePath=" + result.getFilePath());
                    return;
                }
                this.inEditorDiffRenderer = InEditorDiffRenderer.create(editor, this.project, finalFileType, 0, finalOriginalText, this.requestId, this.sessionId, null);
                this.inEditorDiffRenderer.renderInlineDiffs(DocumentUtils.convertSeparatorToSlashN(result.getApplyCode()));
                this.applyResultPair.set((Pair<String, Boolean>)new Pair((Object)((String)oldApplyResult.getFirst()), (Object)true));
                this.updateToolbarApplyLabelIcons(LingmaIcons.ApplyBlueIcon);
            });
        });
    }

    private void updateToolbarApplyLabelIcons(Icon icon) {
        if (this.fixedToolbarPane != null && this.fixedToolbarPane.applyLabel != null) {
            this.fixedToolbarPane.applyLabel.setIcon(icon);
        }
        if (this.floatToolbarPane != null && this.floatToolbarPane.applyLabel != null) {
            this.floatToolbarPane.applyLabel.setIcon(icon);
        }
    }

    public void stopApplyOrDisposeDiffRenderer() {
        if (this.applyResultPair.get() != null && !((Boolean)this.applyResultPair.get().getSecond()).booleanValue()) {
            this.applyResultPair.set(null);
            this.updateToolbarApplyLabelIcons(LingmaIcons.ApplyBlueIcon);
        }
        if (this.inEditorDiffRenderer != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.inEditorDiffRenderer.dispose());
        }
    }

    private void initFloatToolbar(String language, String filePath) {
        this.floatToolbarPane = new ToolbarPane(this.project, language, filePath, this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getGenerateContentForm().getQuestionCodeWithExt(), this.chatTask);
        SwingUtil.setComponentBackgroudColor(this.floatToolbarPane.getToolbarPane(), ColorUtil.getEditorBackgroundColor(), new Class[0]);
        this.editorTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CodeMarkdownHighlightComponent.this.showFloatToolbar(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Rectangle rectangle;
                if (CodeMarkdownHighlightComponent.this.showFloatToolbar && !(rectangle = new Rectangle(CodeMarkdownHighlightComponent.this.floatToolbarPane.getToolbarPane().getLocationOnScreen(), CodeMarkdownHighlightComponent.this.floatToolbarPane.getToolbarPane().getSize())).contains(e.getLocationOnScreen())) {
                    CodeMarkdownHighlightComponent.this.hideFloatToolbar();
                }
            }
        });
        JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
        scrollPane.addMouseWheelListener(e -> {
            if (this.showFloatToolbar) {
                if (this.showCode) {
                    if (!this.editorTextField.isShowing() || !this.isShowFloatToolbar(e, scrollPane)) {
                        this.hideFloatToolbar();
                    } else {
                        Dimension size = this.fixedToolbarPane.getToolbarPane().getSize();
                        this.floatToolbarPane.getToolbarPane().setBounds(0, scrollPane.getLocationOnScreen().y - this.editorTextField.getLocationOnScreen().y, size.width, size.height);
                        this.layeredPane.revalidate();
                        this.layeredPane.repaint();
                    }
                } else if (!this.chartPanel.isShowing() || !this.isShowFloatToolbarForChart(e, scrollPane)) {
                    this.hideFloatToolbar();
                }
            } else {
                this.showFloatToolbar(e);
            }
        });
    }

    private void hideFloatToolbar() {
        if (!this.showFloatToolbar) {
            return;
        }
        this.layeredPane.remove(this.floatToolbarPane.getToolbarPane());
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.showFloatToolbar = false;
    }

    private void showFloatToolbar(MouseEvent e) {
        if (!this.showCode) {
            return;
        }
        JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
        if (this.showCode) {
            if (this.showFloatToolbar || !this.editorTextField.isShowing()) {
                return;
            }
            if (!this.isShowFloatToolbar(e, scrollPane)) {
                return;
            }
        } else {
            if (this.showFloatToolbar || !this.chartPanel.isShowing()) {
                return;
            }
            if (!this.isShowFloatToolbarForChart(e, scrollPane)) {
                return;
            }
        }
        this.showFloatToolbar = true;
        this.layeredPane.add((Component)this.floatToolbarPane.getToolbarPane(), JLayeredPane.POPUP_LAYER);
        Dimension size = this.fixedToolbarPane.getToolbarPane().getSize();
        try {
            if (this.showCode) {
                this.floatToolbarPane.getToolbarPane().setBounds(0, scrollPane.getLocationOnScreen().y - this.editorTextField.getLocationOnScreen().y, size.width, size.height);
            } else {
                this.floatToolbarPane.getToolbarPane().setBounds(0, scrollPane.getLocationOnScreen().y - this.chartPanel.getLocationOnScreen().y, size.width, size.height);
            }
        }
        catch (Exception ex) {
            LOG.warn("showFloatToolbar error", (Throwable)ex);
        }
        this.layeredPane.revalidate();
    }

    private boolean isShowFloatToolbar(MouseEvent e, JBScrollPane scrollPane) {
        try {
            if (this.editorTextField.getLocationOnScreen().y - scrollPane.getLocationOnScreen().y > -2 || this.editorTextField.getLocationOnScreen().y + this.editorTextField.getHeight() - scrollPane.getLocationOnScreen().y < 0) {
                return false;
            }
        }
        catch (Exception e1) {
            LOG.warn("getLocationOnScreen error", (Throwable)e1);
            return true;
        }
        Dimension editorDimensions = this.editorTextField.getSize();
        Dimension size = new Dimension(editorDimensions.width, editorDimensions.height - scrollPane.getLocationOnScreen().y + this.editorTextField.getLocationOnScreen().y);
        Rectangle rectangle = new Rectangle(scrollPane.getLocationOnScreen(), size);
        return rectangle.contains(e.getLocationOnScreen());
    }

    private boolean isShowFloatToolbarForChart(MouseEvent e, JBScrollPane scrollPane) {
        if (this.chartPanel.getLocationOnScreen().y - scrollPane.getLocationOnScreen().y > -2 || this.chartPanel.getLocationOnScreen().y + this.chartPanel.getHeight() - scrollPane.getLocationOnScreen().y < 0) {
            return false;
        }
        Dimension chartPanelDimensions = this.chartPanel.getSize();
        Dimension size = new Dimension(chartPanelDimensions.width, chartPanelDimensions.height - scrollPane.getLocationOnScreen().y + this.chartPanel.getLocationOnScreen().y);
        Rectangle rectangle = new Rectangle(scrollPane.getLocationOnScreen(), size);
        return rectangle.contains(e.getLocationOnScreen());
    }

    private void initToolbar(String language, String filePath) {
        this.fixedToolbarPane = new ToolbarPane(this.project, language, filePath, this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getGenerateContentForm().getQuestionCodeWithExt(), this.chatTask);
        SwingUtil.foreachChildComponent(this.fixedToolbarPane.toolbarPane, cp -> cp.setOpaque(false));
        this.basePane.add((Component)this.fixedToolbarPane.toolbarPane, "North");
        if (this.generateAnswerPanel instanceof InlineChatAnswerPanel) {
            this.fixedToolbarPane.actionPanel.removeAll();
            this.fixedToolbarPane.actionPanel.add(this.fixedToolbarPane.copyLabel);
        }
        this.fixedToolbarPane.toolbarPane.setVisible(false);
    }

    private boolean needTestcaseNewFileButton() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        return ChatTaskEnum.GENERATE_TESTCASE.getName().equals(this.generateAnswerPanel.getChatTask());
    }

    private boolean needDiffButton() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        BaseChatPanel form = this.generateAnswerPanel.getGenerateContentForm();
        return form.isFirstRoundChatProcessing() && DIFF_TASK_SET.contains(form.getFirstRoundTask());
    }

    private boolean needFullLineInsert() {
        return this.isCommentGenerate();
    }

    private boolean isCommentGenerate() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        BaseChatPanel form = this.generateAnswerPanel.getGenerateContentForm();
        return ChatTaskEnum.CODE_GENERATE_COMMENT.getName().equals(form.getFirstRoundTask());
    }

    @Override
    public void updateText(String text, String language, boolean isCompleted) {
        this.isCompleted = isCompleted;
        if (this.fixedToolbarPane != null) {
            if (this.fixedToolbarPane.langLabel != null && StringUtils.isNotBlank((CharSequence)language)) {
                this.fixedToolbarPane.updateLanguage(language);
                this.fixedToolbarPane.updateSwitchViewPopupPanel();
            }
            if (this.fixedToolbarPane.toolbarPane != null && StringUtils.isNotBlank((CharSequence)text)) {
                this.fixedToolbarPane.toolbarPane.setVisible(true);
                if (isCompleted && this.fixedToolbarPane.applyLabel != null && !this.fixedToolbarPane.applyLabel.isVisible()) {
                    this.fixedToolbarPane.applyLabel.setVisible(true);
                }
            }
        }
        if (this.floatToolbarPane != null) {
            if (this.floatToolbarPane.langLabel != null && StringUtils.isNotBlank((CharSequence)language)) {
                this.floatToolbarPane.updateLanguage(language);
                this.floatToolbarPane.updateSwitchViewPopupPanel();
            }
            if (isCompleted && this.floatToolbarPane.applyLabel != null && !this.floatToolbarPane.applyLabel.isVisible()) {
                this.floatToolbarPane.applyLabel.setVisible(true);
            }
        }
        this.content = text;
        boolean canDisplayChartView = this.canDisplayChartView(language);
        if (canDisplayChartView && isCompleted) {
            this.showCode = false;
            this.showGraph(text, language);
            this.updateChartViewActionVisibility(this.showCode, language);
        } else {
            this.showCode = true;
            this.showCodeContent(text, language);
        }
        this.updateSwitchViewLabel();
    }

    private void updateSwitchViewLabel() {
        Icon switchViewIcon;
        if (!this.isCompleted) {
            return;
        }
        Icon icon = switchViewIcon = this.showCode ? CommonIcons.codeGreyIcon : CommonIcons.previewGreyIcon;
        if (this.fixedToolbarPane != null) {
            this.fixedToolbarPane.switchViewLabel.setIcon(switchViewIcon);
        }
        if (this.floatToolbarPane != null) {
            this.floatToolbarPane.switchViewLabel.setIcon(switchViewIcon);
        }
    }

    private boolean canDisplayChartView(String language) {
        Boolean ifDisplayChartView = this.checkIfDisplayChartView(language);
        LOG.info("canDisplayChartView, language: " + language + ", ifDisplayChartView: " + ifDisplayChartView);
        if (ifDisplayChartView.booleanValue()) {
            return true;
        }
        if (BooleanUtils.isTrue((Boolean)this.isCompleted) && CodeMarkdownRenderUtils.LANGUAGE_SUPPORT_CHART.contains(language)) {
            TelemetryService.getInstance().telemetryChatPreviewResult(this.project, this.requestId, this.chatTask, language, "unsupport");
        }
        return false;
    }

    private void showGraph(String text, String language) {
        LOG.info("showGraph, text: " + text + ", language: " + language);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isDarkScheme = editorColorsScheme.getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR) == null;
        JComponent graph = this.renderMermaid(text, this.jbScrollPane.getPreferredSize().width, language);
        this.showCode = false;
        if (graph instanceof Icon) {
            LOG.info("show icon graph");
            this.showGraph((Icon)((Object)graph));
        } else {
            this.chartPanel.removeAll();
            this.chartPanel.add((Component)graph, "Center");
            this.showMermaidChart();
        }
    }

    private void showMermaidChart() {
        this.jbScrollPane.setViewportView(this.chartPanel);
        Dimension parentSize = this.parentComponentSize;
        Dimension editSize = this.chartPanel.getPreferredSize();
        if (this.limitCodeBlockHeight > 0 && editSize.height > this.limitCodeBlockHeight) {
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        } else {
            this.jbScrollPane.setVerticalScrollBarPolicy(21);
        }
        this.chartPanel.setSize(editSize);
        int height = editSize.height + 4;
        if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
            height = this.limitCodeBlockHeight;
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.jbScrollPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.layeredPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
        this.layeredPane.revalidate();
    }

    private void showCodeContent(String text, String language) {
        this.editorTextField.setLanguage(language);
        this.editorTextField.setText(text);
        Dimension parentSize = this.parentComponentSize;
        Dimension editSize = this.editorTextField.getPreferredSize();
        this.editorTextField.setSize(editSize);
        int height = editSize.height + 4;
        if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
            height = this.limitCodeBlockHeight;
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.jbScrollPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.layeredPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
        this.layeredPane.revalidate();
    }

    private void showGraph(Icon graph) {
        if (graph != null) {
            this.editorTextField.setIcon(graph);
            this.showCode = false;
            Dimension parentSize = this.parentComponentSize;
            Dimension editSize = this.editorTextField.getPreferredSize();
            this.editorTextField.setSize(editSize);
            int height = editSize.height + 4;
            if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
                height = this.limitCodeBlockHeight;
                this.jbScrollPane.setVerticalScrollBarPolicy(20);
            }
            this.jbScrollPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
            this.layeredPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
            this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
            this.layeredPane.revalidate();
        }
    }

    private JComponent renderMermaid(String text, int maxWidth, final String language) {
        this.jbCefBrowser = new JBCefBrowser();
        JCefUtil.initCefSettings();
        String COMMON_SCRIPT_PATH = "/js/mermaidPage.html";
        Color textColor = ColorUtil.getTextForegroundColor();
        Color auxiliaryColor = ColorUtil.getAuxiliaryForegroundColor();
        Color cardBgColor = ColorUtil.getChatCardBackgroundColor();
        Color lineColor = ColorUtil.getToolWindowBackgroundColor();
        Color backgroundColor = ColorUtil.getEditorBackgroundColor();
        String textColorStr = String.format("%02x%02x%02x", textColor.getRed(), textColor.getGreen(), textColor.getBlue());
        String auxiliaryColorStr = String.format("%02x%02x%02x", auxiliaryColor.getRed(), auxiliaryColor.getGreen(), auxiliaryColor.getBlue());
        String cardBackgroundColorStr = String.format("%02x%02x%02x", cardBgColor.getRed(), cardBgColor.getGreen(), cardBgColor.getBlue());
        String lineColorStr = String.format("%02x%02x%02x", lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue());
        String backgroundColorStr = String.format("%02x%02x%02x", backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
        try {
            this.chartPageHtml = new String(Objects.requireNonNull(WelcomePanelUtil.class.getResourceAsStream(COMMON_SCRIPT_PATH)).readAllBytes());
            this.chartPageHtml = this.chartPageHtml.replace("${content}", text);
            this.chartPageHtml = this.chartPageHtml.replace("${cardBgColor}", cardBackgroundColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${textColor}", textColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${borderColor}", lineColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${lineColor}", auxiliaryColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${auxiliaryColor}", auxiliaryColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${backgroundColorStr}", backgroundColorStr);
            this.chartPageHtml = this.chartPageHtml.replace("${pageWidth}", String.valueOf(maxWidth));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JCefUtil.registerLifeSpanHandler(this.jbCefBrowser);
        this.jbCefBrowser.loadHTML(this.chartPageHtml);
        final JBCefJSQuery mouseWheelQuery = JBCefJSQuery.create((JBCefBrowser)this.jbCefBrowser);
        mouseWheelQuery.addHandler(mouseWheelPosition -> {
            int deltaYIndex = mouseWheelPosition.indexOf("Y:");
            int deltaXIndex = mouseWheelPosition.indexOf(",X:");
            int scrollToTopIndex = mouseWheelPosition.indexOf(",scrollToTop:");
            int scrollToBottomIndex = mouseWheelPosition.indexOf(",scrollToBottom:");
            int clientHeightIndex = mouseWheelPosition.indexOf(",clientHeight:");
            int deltaY = (int)Math.round(Double.valueOf(mouseWheelPosition.substring(deltaYIndex + 2, deltaXIndex)));
            int deltaX = (int)Math.round(Double.valueOf(mouseWheelPosition.substring(deltaXIndex + 3, scrollToTopIndex)));
            String scrollToTop = mouseWheelPosition.substring(scrollToTopIndex + 13, scrollToBottomIndex);
            String scrollToBottom = mouseWheelPosition.substring(scrollToBottomIndex + 16, clientHeightIndex);
            JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
            if (deltaY > 10 && BooleanUtils.toBooleanObject((String)scrollToBottom).booleanValue()) {
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getValue() + 10);
            } else if (deltaY < -10 && BooleanUtils.toBooleanObject((String)scrollToTop).booleanValue()) {
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getValue() - 10);
            }
            if (SystemInfo.isMac) {
                if (deltaX > 10) {
                    this.jbScrollPane.getHorizontalScrollBar().setValue(this.jbScrollPane.getHorizontalScrollBar().getValue() + 10);
                } else if (deltaX < -10) {
                    this.jbScrollPane.getHorizontalScrollBar().setValue(this.jbScrollPane.getHorizontalScrollBar().getValue() - 10);
                }
            } else if (deltaX > 10) {
                this.jbScrollPane.getHorizontalScrollBar().setValue(this.jbScrollPane.getHorizontalScrollBar().getValue() - 10);
            } else if (deltaX < -10) {
                this.jbScrollPane.getHorizontalScrollBar().setValue(this.jbScrollPane.getHorizontalScrollBar().getValue() + 10);
            }
            return null;
        });
        this.jbCefBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().executeJavaScript("window.callbackAfterMouseWheel = function(mouseWheelPosition) {" + mouseWheelQuery.inject("mouseWheelPosition") + "}", CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().getURL(), 0);
                CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().executeJavaScript("document.addEventListener('wheel', function(event) {\n        var scrollTop = document.documentElement.scrollTop || document.body.scrollTop;\n        var scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;\n        var clientHeight = document.documentElement.clientHeight || document.body.clientHeight;\n        var scrollToTop = false;\n        var scrollToBottom = false;\n        // \u6ed1\u52a8\u5230\u5e95\u90e8\u6216\u65e0\u9700\u6ed1\u52a8\n        // \u6709\u65f6\u5019 scrollHeight \u975e\u5e38\u63a5\u8fd1 clientHeight + scrollTop\uff0c\u4f46\u5e76\u4e0d\u76f8\u7b49\uff0c\u6b64\u65f6\u8981\u517c\u5bb9\u4e00\u4e0b\u8fd9\u79cd\u60c5\u51b5\n        if (scrollTop + clientHeight - scrollHeight >= -1 || scrollHeight === clientHeight) {\n            // \u6eda\u52a8\u5230\u5e95\u90e8\n            scrollToBottom = true;\n        }\n        if (scrollTop === 0 || scrollHeight === clientHeight) {\n            scrollToTop = true;\n        }\n        window.callbackAfterMouseWheel('mousewheel:Y:' + event.deltaY + \",X:\" + event.deltaX + \",scrollToTop:\" + scrollToTop +\n                \",scrollToBottom:\" + scrollToBottom + \",clientHeight:\" + clientHeight + \",scrollHeight:\" +\n                scrollHeight + \",scrollTop:\" + scrollTop);\n    })", CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().getURL(), 0);
            }
        }, this.jbCefBrowser.getCefBrowser());
        this.jbCefBrowser.getJBCefClient().getCefClient().addMessageRouter(CefMessageRouter.create((CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser cefBrowser, CefFrame cefFrame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                LOG.info("onQuery: " + request);
                if (request == null) {
                    return false;
                }
                if (!request.startsWith("onLoadEnd")) {
                    return false;
                }
                int isErrorIndex = request.indexOf("isError:");
                boolean isError = Boolean.parseBoolean(request.substring(isErrorIndex + 8));
                if (isError) {
                    LOG.warn("renderMermaid onQuery failed. Request: " + request);
                }
                Dimension size = CodeMarkdownHighlightComponent.this.jbCefBrowser.getComponent().getPreferredSize();
                int mermaidDivHeightIndex = request.indexOf("pageHeight:");
                int mermaidDivHeight = (int)Math.round(Double.valueOf(request.substring(mermaidDivHeightIndex + 11, isErrorIndex - 1)));
                if (BooleanUtils.isTrue((Boolean)isError)) {
                    CodeMarkdownHighlightComponent.this.showCode = true;
                    CodeMarkdownHighlightComponent.this.switchToCodeView(language);
                    CodeMarkdownHighlightComponent.this.updateChartViewActionVisibility(true, language);
                    if (CodeMarkdownHighlightComponent.this.floatToolbarPane != null) {
                        CodeMarkdownHighlightComponent.this.floatToolbarPane.switchViewPanel.setVisible(false);
                    }
                    if (CodeMarkdownHighlightComponent.this.fixedToolbarPane != null) {
                        CodeMarkdownHighlightComponent.this.fixedToolbarPane.switchViewPanel.setVisible(false);
                    }
                } else if (mermaidDivHeight != size.height) {
                    size.height = mermaidDivHeight;
                    CodeMarkdownHighlightComponent.this.jbCefBrowser.getComponent().setPreferredSize(size);
                    if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() < 241) {
                        CodeMarkdownHighlightComponent.this.jbCefBrowser.loadHTML(CodeMarkdownHighlightComponent.this.chartPageHtml);
                    } else {
                        CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().reload();
                    }
                    CodeMarkdownHighlightComponent.this.showMermaidChart();
                    JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(CodeMarkdownHighlightComponent.this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(CodeMarkdownHighlightComponent.this.project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)CodeMarkdownHighlightComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(CodeMarkdownHighlightComponent.this.project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(CodeMarkdownHighlightComponent.this.project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
                    if (scrollPane != null) {
                        scrollPane.validate();
                        scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
                    }
                    return true;
                }
                String result = BooleanUtils.isTrue((Boolean)isError) ? "fail" : "success";
                TelemetryService.getInstance().telemetryChatPreviewResult(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.chatTask, language, result);
                return true;
            }
        }));
        this.showCode = false;
        this.updateChartViewActionVisibility(false, language);
        return this.jbCefBrowser.getComponent();
    }

    private void updateLayerLocation() {
        Dimension parentSize;
        Dimension editSize = this.editorTextField.getPreferredSize();
        if (!this.showCode) {
            editSize = this.chartPanel.getPreferredSize();
        }
        this.parentComponentSize = parentSize = this.parentComponent.getSize();
        int height = editSize.height + 4;
        if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
            height = this.limitCodeBlockHeight;
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
        this.layeredPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.layeredPane.revalidate();
    }

    public void scrollLeft() {
        SwingUtilities.invokeLater(() -> this.jbScrollPane.getHorizontalScrollBar().setValue(0));
    }

    public boolean isShowCode() {
        return this.showCode;
    }

    @Override
    public Component getComponent() {
        return this.contentPane;
    }

    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        if (this.chartPanel != null && this.jbCefBrowser != null) {
            if (this.canDisplayChartView(this.editorTextField.getLanguage())) {
                this.showGraph(this.editorTextField.getText(), this.editorTextField.getLanguage());
            }
            if (this.fixedToolbarPane != null) {
                this.fixedToolbarPane.switchViewPopupPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                this.fixedToolbarPane.switchViewPopupPanel.repaint();
                this.fixedToolbarPane.scale = 100;
                this.fixedToolbarPane.zoomScaleLabel.setText(this.fixedToolbarPane.scale + "%");
                this.fixedToolbarPane.zoomInLabel.setEnabled(true);
                this.fixedToolbarPane.zoomInLabel.setIcon(CommonIcons.zoomInGreyIcon);
                this.fixedToolbarPane.zoomOutLabel.setEnabled(true);
                this.fixedToolbarPane.zoomOutLabel.setIcon(CommonIcons.zoomOutGreyIcon);
            }
            if (this.floatToolbarPane != null) {
                this.floatToolbarPane.switchViewPopupPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                this.floatToolbarPane.switchViewPopupPanel.repaint();
                this.floatToolbarPane.scale = 100;
                this.floatToolbarPane.zoomScaleLabel.setText(this.floatToolbarPane.scale + "%");
                this.floatToolbarPane.zoomInLabel.setEnabled(true);
                this.floatToolbarPane.zoomInLabel.setIcon(CommonIcons.zoomInGreyIcon);
                this.floatToolbarPane.zoomOutLabel.setEnabled(true);
                this.floatToolbarPane.zoomOutLabel.setIcon(CommonIcons.zoomOutGreyIcon);
            }
        }
    }

    private Boolean checkIfDisplayChartView(String language) {
        boolean isNotCompleted;
        boolean jcefNotSupport = !JBCefApp.isSupported();
        boolean languageNotSupport = !CodeMarkdownRenderUtils.LANGUAGE_SUPPORT_CHART.contains(language);
        boolean bl = isNotCompleted = !BooleanUtils.isTrue((Boolean)this.isCompleted);
        if (jcefNotSupport || languageNotSupport || isNotCompleted) {
            LOG.info("jcefNotSupport: " + jcefNotSupport + ", languageNotSupport: " + language + " " + languageNotSupport + ", isNotCompleted: " + isNotCompleted);
            return false;
        }
        int version = ApplicationInfo.getInstance().getBuild().getBaselineVersion();
        LOG.info("version: " + version);
        if (SystemInfo.isMac) {
            return version >= 221;
        }
        if (SystemInfo.isWindows) {
            return version >= 231 && SystemInfo.isWin10OrNewer;
        }
        return version >= 231;
    }

    private void updateChartViewActionVisibility(boolean showCode, String language) {
        boolean isVisible = !showCode;
        boolean displayChartView = this.checkIfDisplayChartView(language);
        if (this.floatToolbarPane != null) {
            this.floatToolbarPane.zoomPanel.setVisible(isVisible);
            this.floatToolbarPane.expandLabel.setVisible(displayChartView);
            if (showCode) {
                this.floatToolbarPane.switchViewLabel.setIcon(CommonIcons.codeGreyIcon);
            } else {
                this.floatToolbarPane.switchViewLabel.setIcon(CommonIcons.previewGreyIcon);
            }
        }
        if (this.fixedToolbarPane != null) {
            this.fixedToolbarPane.zoomPanel.setVisible(isVisible);
            this.fixedToolbarPane.expandLabel.setVisible(displayChartView);
            if (showCode) {
                this.fixedToolbarPane.switchViewLabel.setIcon(CommonIcons.codeGreyIcon);
            } else {
                this.fixedToolbarPane.switchViewLabel.setIcon(CommonIcons.previewGreyIcon);
            }
        }
    }

    private void switchToCodeView(String language) {
        SwingUtilities.invokeLater(() -> {
            this.jbScrollPane.setViewportView(this.editorTextField);
            Dimension editSize = this.editorTextField.getPreferredSize();
            if (this.limitCodeBlockHeight > 0 && editSize.height > this.limitCodeBlockHeight) {
                this.jbScrollPane.setVerticalScrollBarPolicy(20);
            } else {
                this.jbScrollPane.setVerticalScrollBarPolicy(21);
            }
            this.jbScrollPane.setHorizontalScrollBarPolicy(30);
            this.showCodeContent(this.content, language);
        });
    }

    class ToolbarPane {
        private JPanel toolbarPane;
        private JLabel langLabel;
        private Boolean isTestcase;
        private String chatTask;
        private String language;
        private String applyFilePath;
        private CodeWithExt questionWithExt;
        private JPanel switchViewPanel;
        private JLabel switchViewLabel;
        private JLabel switchViewPopupLabel;
        private JPanel switchViewPopupPanel;
        private JBPopup switchViewPopup;
        private JLabel chartViewPopupLabel;
        private JLabel codeViewPopupLabel;
        private JLabel zoomOutLabel;
        private JLabel zoomInLabel;
        private int scale = 100;
        private JLabel zoomScaleLabel;
        private JPanel zoomPanel;
        private JPanel actionPanel;
        private JLabel copyLabel;
        private final DisplayIcon expandLabel;
        private JLabel applyLabel;

        public ToolbarPane(final Project project, String language, String applyFilePath, final CodeWithExt questionWithExt, final String chatTask) {
            this.language = language;
            this.applyFilePath = applyFilePath;
            this.chatTask = chatTask;
            this.toolbarPane = new JPanel();
            this.toolbarPane.setBackground(CodeMarkdownHighlightComponent.this.editorTextField.getBackground());
            JBEmptyBorder leftAndRight = JBUI.Borders.empty((int)0, (int)12);
            Border bottom = JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)0, (int)0, (int)1, (int)0);
            this.toolbarPane.setBorder(BorderFactory.createCompoundBorder(bottom, (Border)leftAndRight));
            this.toolbarPane.setLayout(new BorderLayout());
            this.toolbarPane.setPreferredSize(new Dimension(-1, 32));
            JPanel toolbarBasePane = new JPanel();
            toolbarBasePane.setBorder((Border)JBUI.Borders.empty());
            toolbarBasePane.setLayout(new BorderLayout());
            this.toolbarPane.add((Component)toolbarBasePane, "Center");
            this.langLabel = new JLabel(com.alibabacloud.intellij.cosy.util.StringUtils.upperFirstLetter(language));
            this.langLabel.setFont(this.langLabel.getFont().deriveFont(14.0f));
            this.langLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
            this.switchViewPanel = new JPanel(new FlowLayout(0, 2, 0));
            this.switchViewPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.switchViewPanel.setVisible(false);
            this.switchViewLabel = new JLabel();
            this.switchViewLabel.setIcon(CommonIcons.previewGreyIcon);
            this.switchViewLabel.setPreferredSize(new Dimension(20, 20));
            this.switchViewPopupLabel = new JLabel(LingmaIcons.ArrowdownEmptyGreyIcon);
            this.switchViewPopupLabel.setPreferredSize(new Dimension(20, 20));
            this.switchViewPanel.add(this.switchViewLabel);
            this.switchViewPanel.add(this.switchViewPopupLabel);
            SwingUtil.foreachChildComponent(this.switchViewPanel, cp -> {
                this.addSwitchViewPopupEvent((JComponent)cp);
                this.setupSwitchViewPanelColor((JComponent)cp, this.switchViewPanel);
            });
            this.zoomPanel = new JPanel(new FlowLayout(0, 2, 0));
            this.zoomPanel.setVisible(false);
            this.zoomPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            this.zoomOutLabel = new DisplayIcon(CommonIcons.zoomOutGreyIcon);
            this.zoomOutLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.setupTabColor(this.zoomOutLabel);
            this.zoomOutLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ToolbarPane.this.zoomOut();
                }
            });
            this.zoomInLabel = new DisplayIcon(CommonIcons.zoomInGreyIcon);
            this.zoomInLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.setupTabColor(this.zoomInLabel);
            this.zoomInLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ToolbarPane.this.zoomIn();
                }
            });
            this.zoomScaleLabel = new JLabel();
            this.zoomScaleLabel.setText(this.scale + "%");
            this.zoomScaleLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.zoomScaleLabel.setFont(this.zoomScaleLabel.getFont().deriveFont(12.0f));
            this.zoomScaleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setupTabColor(this.zoomInLabel);
            this.setupTabColor(this.zoomOutLabel);
            this.zoomPanel.add(this.zoomOutLabel);
            this.zoomPanel.add(this.zoomScaleLabel);
            this.zoomPanel.add(this.zoomInLabel);
            JPanel langPane = new JPanel();
            langPane.setOpaque(false);
            langPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            langPane.setLayout(new FlowLayout(0, 0, 0));
            langPane.add(this.langLabel);
            langPane.add(this.switchViewPanel);
            langPane.add(this.zoomPanel);
            toolbarBasePane.add((Component)langPane, "West");
            this.actionPanel = new JPanel();
            this.actionPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            this.actionPanel.setLayout(new RightFlowLayout(2, 16, 0));
            if (StringUtils.isNotBlank((CharSequence)applyFilePath) && CodeMarkdownHighlightComponent.this.generateAnswerPanel != null) {
                SessionTypeEnum sessionTypeEnum = CodeMarkdownHighlightComponent.this.generateAnswerPanel.getSessionType();
                String chatMode = CodeMarkdownHighlightComponent.this.generateAnswerPanel.getChatMode();
                this.applyLabel = new JLabel(LingmaIcons.ApplyBlueIcon);
                this.applyLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.apply", new Object[0]));
                this.applyLabel.setFont(this.applyLabel.getFont().deriveFont(14.0f));
                this.applyLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.applyLabel.setForeground(ColorUtil.getLinkForegroundColor());
                this.applyLabel.addMouseListener(CodeMarkdownHighlightComponent.this.applyClickAdapter(applyFilePath, language, CodeMarkdownHighlightComponent.this.sessionType != null ? sessionTypeEnum.getTelemetryType() : null, chatMode));
                this.actionPanel.add(this.applyLabel);
                if (BooleanUtils.isNotTrue((Boolean)CodeMarkdownHighlightComponent.this.isCompleted)) {
                    this.applyLabel.setVisible(false);
                }
            }
            JLabel insertLabel = new JLabel(LingmaIcons.InsertBlueIcon);
            insertLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.insert", new Object[0]));
            insertLabel.setFont(insertLabel.getFont().deriveFont(14.0f));
            insertLabel.setCursor(Cursor.getPredefinedCursor(12));
            insertLabel.setForeground(ColorUtil.getLinkForegroundColor());
            insertLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_INSERT, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)"Chat Insert Code", (String)"TONGYI", () -> {
                        Editor editor;
                        String text = CodeMarkdownHighlightComponent.this.editorTextField.getText();
                        if (StringUtils.isNotBlank((CharSequence)text) && (editor = EditorUtil.getSelectedEditorSafely(project)) != null && editor.getDocument().isWritable()) {
                            int start = editor.getSelectionModel().getSelectionStart();
                            int end = editor.getSelectionModel().getSelectionEnd();
                            Integer startLineNumber = null;
                            if (editor.getSelectionModel().hasSelection() && start < end) {
                                if (CodeMarkdownHighlightComponent.this.needFullLineInsert()) {
                                    VisualPosition visualStartPosition = editor.getSelectionModel().getSelectionStartPosition();
                                    VisualPosition visualEndPosition = editor.getSelectionModel().getSelectionEndPosition();
                                    if (visualStartPosition != null && visualEndPosition != null) {
                                        start = editor.getDocument().getLineStartOffset(editor.visualToLogicalPosition((VisualPosition)visualStartPosition).line);
                                        end = editor.getDocument().getLineEndOffset(editor.visualToLogicalPosition((VisualPosition)visualEndPosition).line);
                                    }
                                    String textToReplace = editor.getDocument().getText(new TextRange(start, end));
                                    text = com.alibabacloud.intellij.cosy.util.StringUtils.makeIndentationConsistent(textToReplace, text);
                                }
                                startLineNumber = editor.getDocument().getLineNumber(start);
                                text = DocumentUtils.filterDocumentSlashR(editor.getDocument(), text);
                                editor.getDocument().replaceString(start, end, (CharSequence)text);
                            } else {
                                int caret = editor.getCaretModel().getOffset();
                                startLineNumber = editor.getDocument().getLineNumber(caret);
                                text = DocumentUtils.filterDocumentSlashR(editor.getDocument(), text);
                                editor.getDocument().insertString(caret, (CharSequence)text);
                            }
                            String filePath = EditorUtil.getEditorFilePath(editor);
                            TelemetryService.getInstance().telemetryTextChange(TextChangeContext.builder().project(editor.getProject()).filePath(filePath).addedText(text).startLineNumber(startLineNumber).accepted(true).language(LanguageUtil.getLanguageByFilePath(filePath)).source("chat").chatTask(chatTask).build());
                        }
                    }, (PsiFile[])new PsiFile[0]);
                }
            });
            this.actionPanel.add(insertLabel);
            this.copyLabel = new JLabel(LingmaIcons.CopyBlueIcon);
            this.copyLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.copy", new Object[0]));
            this.copyLabel.setFont(this.copyLabel.getFont().deriveFont(14.0f));
            this.copyLabel.setForeground(ColorUtil.getLinkForegroundColor());
            this.copyLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.copyLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_COPY, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    StringSelection selection = new StringSelection(CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    NotificationFactory.showToast((JComponent)ToolbarPane.this.copyLabel, LingmaIcons.AcceptIcon, CosyBundle.message("notifications.code.btn.copied", new Object[0]));
                    CosyCacheKeys.KEY_COPY_PASTE.set((UserDataHolder)ApplicationManager.getApplication(), (Object)ChatCopyContext.builder().text(CodeMarkdownHighlightComponent.this.editorTextField.getText()).chatTask(chatTask).build());
                }
            });
            this.actionPanel.add(this.copyLabel);
            this.questionWithExt = questionWithExt;
            if (CodeMarkdownHighlightComponent.this.needDiffButton()) {
                JLabel diffLabel = new JLabel(LingmaIcons.DiffBlueIcon);
                diffLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.diff", new Object[0]));
                diffLabel.setFont(diffLabel.getFont().deriveFont(14.0f));
                diffLabel.setCursor(Cursor.getPredefinedCursor(12));
                diffLabel.setForeground(ColorUtil.getLinkForegroundColor());
                diffLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_DIFF, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                        ((LingmaCodeDiffNotifier)project.getMessageBus().syncPublisher(LingmaCodeDiffNotifier.LINGMA_CODE_DIFF)).codeDiff(CodeMarkdownHighlightComponent.this.editorTextField.getText(), ToolbarPane.this.language, questionWithExt, CodeMarkdownHighlightComponent.this.sessionType);
                    }
                });
                this.actionPanel.add(diffLabel);
            }
            JLabel newLabel = new JLabel(LingmaIcons.NewBlueIcon);
            newLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.newFile", new Object[0]));
            newLabel.setFont(newLabel.getFont().deriveFont(14.0f));
            newLabel.setCursor(Cursor.getPredefinedCursor(12));
            newLabel.setForeground(ColorUtil.getLinkForegroundColor());
            this.isTestcase = CodeMarkdownHighlightComponent.this.needTestcaseNewFileButton();
            newLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_NEWFILE, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    TelemetryService.getInstance().telemetryTextChange(TextChangeContext.builder().project(project).filePath(null).addedText(CodeMarkdownHighlightComponent.this.editorTextField.getText()).startLineNumber(0).accepted(true).language(ToolbarPane.this.language).source("chat").sceneType(ToolbarPane.this.isTestcase != false ? SceneTypeEnum.TESTCASE.getKey() : SceneTypeEnum.COMMON.getKey()).chatTask(chatTask).build());
                    ((LingmaCodeNewFileNotifier)project.getMessageBus().syncPublisher(LingmaCodeNewFileNotifier.LINGMA_CODE_NEW_FILE)).newFile(CodeMarkdownHighlightComponent.this.editorTextField.getText(), ToolbarPane.this.language, questionWithExt, ToolbarPane.this.isTestcase, CodeMarkdownHighlightComponent.this.sessionType);
                }
            });
            this.actionPanel.add(newLabel);
            this.expandLabel = new DisplayIcon(LingmaIcons.ArrowUpEmptyGreyIcon);
            this.expandLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.collapse", new Object[0]));
            this.expandLabel.setFont(newLabel.getFont().deriveFont(14.0f));
            this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.expandLabel.setForeground(ColorUtil.getLinkForegroundColor());
            this.expandLabel.setVisible(false);
            this.expandLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    boolean visible = CodeMarkdownHighlightComponent.this.layeredPane.isVisible();
                    Icon icon = visible ? LingmaIcons.ArrowdownEmptyGreyIcon : LingmaIcons.ArrowUpEmptyGreyIcon;
                    String tooltipKey = visible ? "markdown.code.toolbar.expand" : "markdown.code.toolbar.collapse";
                    ToolbarPane.this.expandLabel.setIcon(icon);
                    ToolbarPane.this.expandLabel.setToolTipText(CosyBundle.message(tooltipKey, new Object[0]));
                    CodeMarkdownHighlightComponent.this.layeredPane.setVisible(!visible);
                    TrackEventTypeEnum eventType = visible ? TrackEventTypeEnum.CHAT_CODE_COLLAPSE : TrackEventTypeEnum.CHAT_CODE_EXPAND;
                    TelemetryService.getInstance().telemetryChatCodeExpand(project, eventType, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    CodeMarkdownHighlightComponent.this.basePane.revalidate();
                    CodeMarkdownHighlightComponent.this.basePane.repaint();
                }
            });
            this.actionPanel.add(this.expandLabel);
            toolbarBasePane.add((Component)this.actionPanel, "East");
        }

        public void updateLanguage(String language) {
            this.language = language;
            this.langLabel.setText(com.alibabacloud.intellij.cosy.util.StringUtils.upperFirstLetter(language));
        }

        private void addSwitchViewPopupEvent(JComponent component) {
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JLabel focusLabel;
                    if (ToolbarPane.this.switchViewPopup != null && ToolbarPane.this.switchViewPopup.isVisible()) {
                        ToolbarPane.this.switchViewPopup.cancel();
                    }
                    if (CodeMarkdownHighlightComponent.this.showCode) {
                        ToolbarPane.this.codeViewPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                        ToolbarPane.this.codeViewPopupLabel.setOpaque(true);
                        ToolbarPane.this.chartViewPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                        ToolbarPane.this.chartViewPopupLabel.setOpaque(false);
                        focusLabel = ToolbarPane.this.codeViewPopupLabel;
                    } else {
                        ToolbarPane.this.codeViewPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                        ToolbarPane.this.codeViewPopupLabel.setOpaque(false);
                        ToolbarPane.this.chartViewPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                        ToolbarPane.this.chartViewPopupLabel.setOpaque(true);
                        focusLabel = ToolbarPane.this.chartViewPopupLabel;
                    }
                    ToolbarPane.this.switchViewPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ToolbarPane.this.switchViewPopupPanel, (JComponent)focusLabel).setFocusable(true).setRequestFocus(true).setResizable(false).setCancelOnClickOutside(true).createPopup();
                    ToolbarPane.this.switchViewPopup.showUnderneathOf((Component)ToolbarPane.this.switchViewPanel);
                    ToolbarPane.this.switchViewPopupPanel.invalidate();
                    ToolbarPane.this.switchViewPopupPanel.repaint();
                }
            });
        }

        private void zoomIn() {
            this.zoomOutLabel.setEnabled(true);
            this.zoomOutLabel.setIcon(CommonIcons.zoomOutGreyIcon);
            this.scale += 20;
            if (this.scale > 400) {
                this.scale = 400;
                this.zoomInLabel.setEnabled(false);
                this.zoomInLabel.setIcon(CommonIcons.zoomInDisabledGreyIcon);
            }
            this.zoomScaleLabel.setText(this.scale + "%");
            Double zoomScale = (double)this.scale / 100.0;
            this.doZoomPage(zoomScale);
            if (!CodeMarkdownHighlightComponent.this.hasZoomInTelemetry.booleanValue()) {
                CodeMarkdownHighlightComponent.this.hasZoomInTelemetry = true;
                TelemetryService.getInstance().telemetryChatPreviewAction(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, this.chatTask, this.language, "zoom_in");
            }
        }

        private void zoomOut() {
            this.zoomInLabel.setEnabled(true);
            this.zoomInLabel.setIcon(CommonIcons.zoomInGreyIcon);
            this.scale -= 20;
            if (this.scale < 20) {
                this.scale = 20;
                this.zoomOutLabel.setEnabled(false);
                this.zoomOutLabel.setIcon(CommonIcons.zoomOutDisabledGreyIcon);
            }
            Double zoomScale = (double)this.scale / 100.0;
            this.zoomScaleLabel.setText(this.scale + "%");
            this.doZoomPage(zoomScale);
            if (!CodeMarkdownHighlightComponent.this.hasZoomOutTelemetry.booleanValue()) {
                CodeMarkdownHighlightComponent.this.hasZoomOutTelemetry = true;
                TelemetryService.getInstance().telemetryChatPreviewAction(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, this.chatTask, this.language, "zoom_out");
            }
        }

        private void doZoomPage(Double zoomScale) {
            CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().executeJavaScript("document.getElementsByClassName(\"flowchart\")[0].style.transformOrigin=\"top left\";document.getElementsByClassName(\"flowchart\")[0].style.transform= `scale(" + zoomScale + ")`", CodeMarkdownHighlightComponent.this.jbCefBrowser.getCefBrowser().getURL(), 0);
        }

        public JPanel updateSwitchViewPopupPanel() {
            if (!CodeMarkdownHighlightComponent.this.checkIfDisplayChartView(this.language).booleanValue()) {
                CodeMarkdownHighlightComponent.this.updateChartViewActionVisibility(true, this.language);
                if (CodeMarkdownHighlightComponent.this.floatToolbarPane != null) {
                    CodeMarkdownHighlightComponent.this.floatToolbarPane.switchViewPanel.setVisible(false);
                }
                if (CodeMarkdownHighlightComponent.this.fixedToolbarPane != null) {
                    CodeMarkdownHighlightComponent.this.fixedToolbarPane.switchViewPanel.setVisible(false);
                }
                return this.switchViewPopupPanel;
            }
            CodeMarkdownHighlightComponent.this.updateChartViewActionVisibility(CodeMarkdownHighlightComponent.this.showCode, this.language);
            if (CodeMarkdownHighlightComponent.this.floatToolbarPane != null) {
                CodeMarkdownHighlightComponent.this.floatToolbarPane.switchViewPanel.setVisible(true);
            }
            if (CodeMarkdownHighlightComponent.this.fixedToolbarPane != null) {
                CodeMarkdownHighlightComponent.this.fixedToolbarPane.switchViewPanel.setVisible(true);
            }
            if (this.switchViewPopupPanel == null) {
                this.switchViewPopupPanel = new JPanel();
                this.switchViewPopupPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
                this.switchViewPopupPanel.setBorder(JBUI.Borders.empty((int)8));
            }
            if (this.chartViewPopupLabel == null) {
                this.chartViewPopupLabel = new JLabel(CosyBundle.message("code.panel.view.chart", new Object[0]), CommonIcons.previewGreyIconBig, 10);
                this.chartViewPopupLabel.setFont(this.chartViewPopupLabel.getFont().deriveFont(14.0f));
                this.chartViewPopupLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)4));
                this.chartViewPopupLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.chartViewPopupLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ToolbarPane.this.switchViewPopup.cancel();
                        if (!CodeMarkdownHighlightComponent.this.showCode) {
                            return;
                        }
                        CodeMarkdownHighlightComponent.this.showCode = false;
                        if (CodeMarkdownHighlightComponent.this.chartPanel != null && CodeMarkdownHighlightComponent.this.jbCefBrowser != null) {
                            CodeMarkdownHighlightComponent.this.showMermaidChart();
                        } else {
                            CodeMarkdownHighlightComponent.this.showGraph(CodeMarkdownHighlightComponent.this.content, ToolbarPane.this.language);
                        }
                        CodeMarkdownHighlightComponent.this.hideFloatToolbar();
                        CodeMarkdownHighlightComponent.this.updateChartViewActionVisibility(CodeMarkdownHighlightComponent.this.showCode, ToolbarPane.this.language);
                        TelemetryService.getInstance().telemetryChatPreviewAction(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, ToolbarPane.this.chatTask, ToolbarPane.this.language, "as_preview");
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        ToolbarPane.this.chartViewPopupLabel.setOpaque(true);
                        ToolbarPane.this.chartViewPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                        ToolbarPane.this.chartViewPopupLabel.invalidate();
                        ToolbarPane.this.chartViewPopupLabel.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        ToolbarPane.this.chartViewPopupLabel.setOpaque(false);
                        ToolbarPane.this.chartViewPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                        ToolbarPane.this.chartViewPopupLabel.invalidate();
                        ToolbarPane.this.chartViewPopupLabel.repaint();
                    }
                });
                this.switchViewPopupPanel.add(this.chartViewPopupLabel);
            }
            if (this.codeViewPopupLabel == null) {
                this.codeViewPopupLabel = new JLabel(CosyBundle.message("code.panel.view.code", new Object[0]), CommonIcons.codeGreyIconBig, 10);
                this.codeViewPopupLabel.setFont(this.codeViewPopupLabel.getFont().deriveFont(14.0f));
                this.codeViewPopupLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)4));
                this.codeViewPopupLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.codeViewPopupLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ToolbarPane.this.switchViewPopup.cancel();
                        if (CodeMarkdownHighlightComponent.this.showCode) {
                            return;
                        }
                        CodeMarkdownHighlightComponent.this.showCode = true;
                        CodeMarkdownHighlightComponent.this.switchToCodeView(ToolbarPane.this.language);
                        CodeMarkdownHighlightComponent.this.updateChartViewActionVisibility(CodeMarkdownHighlightComponent.this.showCode, ToolbarPane.this.language);
                        TelemetryService.getInstance().telemetryChatPreviewAction(CodeMarkdownHighlightComponent.this.project, CodeMarkdownHighlightComponent.this.requestId, ToolbarPane.this.chatTask, ToolbarPane.this.language, "as_code");
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        ToolbarPane.this.codeViewPopupLabel.setOpaque(true);
                        ToolbarPane.this.codeViewPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                        ToolbarPane.this.codeViewPopupLabel.invalidate();
                        ToolbarPane.this.codeViewPopupLabel.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        ToolbarPane.this.codeViewPopupLabel.setOpaque(false);
                        ToolbarPane.this.codeViewPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                        ToolbarPane.this.codeViewPopupLabel.invalidate();
                        ToolbarPane.this.codeViewPopupLabel.repaint();
                    }
                });
                this.switchViewPopupPanel.add(this.codeViewPopupLabel);
            }
            return this.switchViewPopupPanel;
        }

        private void setupSwitchViewPanelColor(JComponent component, JComponent switchViewPanel) {
            this.setupTabColor(switchViewPanel);
        }

        private void setupTabColor(final JComponent component) {
            component.setBackground(CodeMarkdownHighlightComponent.this.editorTextField.getBackground());
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    component.setOpaque(true);
                    component.setBackground(ColorUtil.getTabbedHoverBgColor());
                    component.invalidate();
                    component.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    component.setOpaque(true);
                    component.setBackground(CodeMarkdownHighlightComponent.this.editorTextField.getBackground());
                    component.invalidate();
                    component.repaint();
                }
            });
        }

        @Generated
        public JPanel getToolbarPane() {
            return this.toolbarPane;
        }

        @Generated
        public JLabel getLangLabel() {
            return this.langLabel;
        }

        @Generated
        public Boolean getIsTestcase() {
            return this.isTestcase;
        }

        @Generated
        public String getChatTask() {
            return this.chatTask;
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public String getApplyFilePath() {
            return this.applyFilePath;
        }

        @Generated
        public CodeWithExt getQuestionWithExt() {
            return this.questionWithExt;
        }

        @Generated
        public JPanel getSwitchViewPanel() {
            return this.switchViewPanel;
        }

        @Generated
        public JLabel getSwitchViewLabel() {
            return this.switchViewLabel;
        }

        @Generated
        public JLabel getSwitchViewPopupLabel() {
            return this.switchViewPopupLabel;
        }

        @Generated
        public JPanel getSwitchViewPopupPanel() {
            return this.switchViewPopupPanel;
        }

        @Generated
        public JBPopup getSwitchViewPopup() {
            return this.switchViewPopup;
        }

        @Generated
        public JLabel getChartViewPopupLabel() {
            return this.chartViewPopupLabel;
        }

        @Generated
        public JLabel getCodeViewPopupLabel() {
            return this.codeViewPopupLabel;
        }

        @Generated
        public JLabel getZoomOutLabel() {
            return this.zoomOutLabel;
        }

        @Generated
        public JLabel getZoomInLabel() {
            return this.zoomInLabel;
        }

        @Generated
        public int getScale() {
            return this.scale;
        }

        @Generated
        public JLabel getZoomScaleLabel() {
            return this.zoomScaleLabel;
        }

        @Generated
        public JPanel getZoomPanel() {
            return this.zoomPanel;
        }

        @Generated
        public JPanel getActionPanel() {
            return this.actionPanel;
        }

        @Generated
        public JLabel getCopyLabel() {
            return this.copyLabel;
        }

        @Generated
        public DisplayIcon getExpandLabel() {
            return this.expandLabel;
        }

        @Generated
        public JLabel getApplyLabel() {
            return this.applyLabel;
        }
    }
}

