/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat.chooser;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineChatModeItem;
import com.alibabacloud.intellij.cosy.ui.chat.inline.InlineChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.InlineChatMode;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import lombok.Generated;

public class InlineChatModeChooser {
    private static final Logger LOG = Logger.getInstance(InlineChatModeChooser.class);
    public static final InlineChatModeItem EDIT_IN_SELECTION = ((InlineChatModeItem.InlineChatModeItemBuilder)InlineChatModeItem.builder().mode(InlineChatMode.EDIT_IN_SELECTION.getMode())).build();
    public static final InlineChatModeItem EDIT_IN_FILE = ((InlineChatModeItem.InlineChatModeItemBuilder)InlineChatModeItem.builder().mode(InlineChatMode.EDIT_IN_FILE.getMode())).build();
    public static final InlineChatModeItem ASK = ((InlineChatModeItem.InlineChatModeItemBuilder)InlineChatModeItem.builder().mode(InlineChatMode.ASK.getMode())).build();
    public static final List<InlineChatModeItem> MODES_DEFAULT = List.of(EDIT_IN_SELECTION, EDIT_IN_FILE);
    public static final List<InlineChatModeItem> MODES_ONLY_EDIT_IN_FILE = List.of(EDIT_IN_FILE);
    private static final int MAX_DISPLAY_NAME_WIDTH = 140;
    PrettyListPopup<InlineChatModeItem> popup;
    ModeSelectedLabel modeSelectedLabel;
    Project project;
    AskInputPanel askInputPanel;

    public InlineChatModeChooser(Project project, AskInputPanel askInputPanel) {
        this.project = project;
        this.askInputPanel = askInputPanel;
        this.modeSelectedLabel = new ModeSelectedLabel(EDIT_IN_SELECTION);
        this.popup = new PrettyListPopup<InlineChatModeItem>(project, this::onModeSelected, 140);
        this.setupModeSelectEvent();
    }

    public void onModeSelected(InlineChatModeItem modeItem) {
        if (modeItem == null) {
            return;
        }
        if (this.modeSelectedLabel.getModeItem().equals(modeItem)) {
            LOG.info("mode is same, no need to change");
            return;
        }
        this.modeSelectedLabel.selectMode(modeItem);
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    private void setupModeSelectEvent() {
        this.modeSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((InlineChatPanel)InlineChatModeChooser.this.askInputPanel.getChatInputContext().getBaseChatPanel()).isFloatingMode()) {
                    InlineChatModeChooser.this.popup.showAbove(InlineChatModeChooser.this.modeSelectedLabel, MODES_ONLY_EDIT_IN_FILE, 0);
                } else {
                    InlineChatModeChooser.this.popup.showAbove(InlineChatModeChooser.this.modeSelectedLabel, MODES_DEFAULT, 0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InlineChatModeChooser.this.modeSelectedLabel.setForeground(ColorUtil.getTextPaneForegroundColor());
                InlineChatModeChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getButtonHoverBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InlineChatModeChooser.this.modeSelectedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                InlineChatModeChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getToolWindowBackgroundColor());
            }
        });
    }

    public JComponent getBaseComponent() {
        return this.modeSelectedLabel;
    }

    @Generated
    public ModeSelectedLabel getModeSelectedLabel() {
        return this.modeSelectedLabel;
    }

    public static class ModeSelectedLabel
    extends RoundRectLabel {
        public static final int DEFAULT_VERTICAL_PADDING = 0;
        public static final int DEFAULT_HORIZONTAL_PADDING = 2;
        public static final int DEFAULT_HORIZONTAL_MARGIN = 0;
        public static final int DEFAULT_CORNER_RADIUS = 8;
        private static final int MAX_WIDTH = 150;
        InlineChatModeItem modeItem;

        public ModeSelectedLabel(InlineChatModeItem modeItem) {
            super(modeItem.getDisplayName(), ColorUtil.getToolWindowBackgroundColor(), 2, 0, 8, 0);
            this.modeItem = modeItem;
            this.setText(FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false));
            this.setIcon(AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.setIconTextGap(2);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setHorizontalTextPosition(2);
            this.setFont(this.getFont().deriveFont(12.0f));
            this.setBackground(ColorUtil.getToolWindowBackgroundColor());
            this.setAlignmentY(0.5f);
        }

        public void selectMode(InlineChatModeItem modeItem) {
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
        }

        @Generated
        public InlineChatModeItem getModeItem() {
            return this.modeItem;
        }
    }
}

