/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat.chooser;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelClassItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatModelClassResult;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatModelClassEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.ChatModelClassNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ChatModelClassChooser {
    private static final Logger LOG = Logger.getInstance(ChatModelClassChooser.class);
    private static final String SWITCH_MODEL_AUTO = "auto";
    private static final String SWITCH_MODEL_MANUAL = "manual";
    private static final int MAX_DISPLAY_NAME_WIDTH = 80;
    PrettyListPopup<ChatModelClassItem> popup;
    ModeSelectedLabel modeSelectedLabel;
    MessageBusConnection messageBusConnection;
    Project project;
    AskInputPanel askInputPanel;

    public ChatModelClassChooser(Project project, AskInputPanel askInputPanel, List<ChatModelClassResult> modelClasses) {
        this.project = project;
        this.askInputPanel = askInputPanel;
        this.modeSelectedLabel = new ModeSelectedLabel(ChatModelClassChooser.getInitModeItem(modelClasses));
        this.modeSelectedLabel.setVisible(false);
        this.popup = new PrettyListPopup<ChatModelClassItem>(project, this::onModeSelected, 80);
        this.setupModeSelectEvent();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::onLogin);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::onLogout);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::onAuthStatusChange);
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(ChatModelClassNotifier.CHAT_MODEL_CLASS_NOTIFIER, this::refreshModelClass);
        ThreadUtil.execute(() -> {
            AuthStatus status = LoginUtil.getAuthStatusCacheFirst(project);
            SwingUtilities.invokeLater(() -> this.onAuthStatusChange(status));
        });
    }

    private void refreshModelClass(ChatModelClassItem item) {
        this.onModeSelected(item, SWITCH_MODEL_AUTO);
    }

    public static ChatModelClassItem getInitModeItem(List<ChatModelClassResult> modelClasses) {
        return ChatModelClassChooser.getInitModeItem(modelClasses, null);
    }

    public static ChatModelClassItem getInitModeItem(List<ChatModelClassResult> modelClasses, Consumer<ChatModelClassItem> expireConsumer) {
        String modeClassSelected;
        LinkedHashMap map = modelClasses.stream().collect(Collectors.toMap(ChatModelClassResult::getName, e -> e, (e1, e2) -> e1, LinkedHashMap::new));
        if (map.isEmpty()) {
            return null;
        }
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && StringUtils.isNotEmpty((CharSequence)(modeClassSelected = CosyPersistentSetting.getInstance().getState().getChatModeClassSelected()))) {
            if (map.containsKey(modeClassSelected) && ((ChatModelClassResult)map.get(modeClassSelected)).getEnabled().booleanValue()) {
                return new ChatModelClassItem(ChatModelClassEnum.getById(modeClassSelected), (ChatModelClassResult)map.get(modeClassSelected));
            }
            ChatModelClassItem item = ChatModelClassChooser.getValidChatModelClassItem(modelClasses);
            if (null != expireConsumer && null != item) {
                expireConsumer.accept(item);
            }
            return item;
        }
        return ChatModelClassChooser.getValidChatModelClassItem(modelClasses);
    }

    @Nullable
    private static ChatModelClassItem getValidChatModelClassItem(List<ChatModelClassResult> modelClasses) {
        ChatModelClassResult defaultItem = null;
        ChatModelClassResult firstEnabledItem = null;
        for (ChatModelClassResult modelClass : modelClasses) {
            boolean enabled = Boolean.TRUE.equals(modelClass.getEnabled());
            if (enabled && null == firstEnabledItem) {
                firstEnabledItem = modelClass;
            }
            if (!Boolean.TRUE.equals(modelClass.getIsDefault()) || !enabled) continue;
            defaultItem = modelClass;
            break;
        }
        if (null != defaultItem) {
            return new ChatModelClassItem(ChatModelClassEnum.getById(defaultItem.getName()), defaultItem);
        }
        LOG.info("no default model class, try to use first enabled item");
        if (null != firstEnabledItem) {
            return new ChatModelClassItem(ChatModelClassEnum.getById(firstEnabledItem.getName()), firstEnabledItem);
        }
        LOG.warn("no enabled model class");
        return null;
    }

    private void updateUiTexts() {
        this.modeSelectedLabel.setText(FontUtil.getStringAdaptiveWidth(this.modeSelectedLabel, this.modeSelectedLabel.modeItem.getDisplayName(), 150, false));
        this.modeSelectedLabel.setToolTipText(CosyBundle.message("chat.model.class.tooltip", new Object[0]));
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    public void dispose() {
        this.messageBusConnection.disconnect();
    }

    private void onAuthStatusChange(AuthStatus status) {
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.onLogin(status);
        } else {
            this.onLogout(status);
        }
    }

    private void onLogin(AuthStatus status) {
        this.modeSelectedLabel.setVisible(true);
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    private void onLogout(AuthStatus status) {
        this.modeSelectedLabel.setVisible(false);
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    public void onModeSelected(ChatModelClassItem modeItem) {
        this.onModeSelected(modeItem, SWITCH_MODEL_MANUAL);
    }

    public void onModeSelected(ChatModelClassItem modeItem, String type) {
        if (modeItem == null) {
            return;
        }
        ChatModelClassItem fromMode = this.modeSelectedLabel.getModeItem();
        if (fromMode.getModelClass() == modeItem.getModelClass()) {
            LOG.info("model class is same, no need to change");
            return;
        }
        this.modeSelectedLabel.selectMode(modeItem);
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null) {
            cosySetting.setChatModeClassSelected(modeItem.getModelClassId());
        }
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
        TelemetryService.getInstance().telemetryChatModelClassSwitch(this.project, UUID.randomUUID().toString(), UUID.randomUUID().toString(), fromMode.getModelClassId(), modeItem.getModelClassId(), SessionTypeEnum.ASSISTANT.getTelemetryType(), type);
    }

    private void setupModeSelectEvent() {
        this.modeSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatModelClassChooser.this.showModeListPopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatModelClassChooser.this.modeSelectedLabel.setForeground(ColorUtil.getTextPaneForegroundColor());
                ChatModelClassChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getButtonHoverBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatModelClassChooser.this.modeSelectedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                ChatModelClassChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getEditorBackgroundColor());
            }
        });
    }

    public void showModeListPopup() {
        LanguageWebSocketService languageService = Cosy.INSTANCE.getLanguageService(this.project);
        if (null == languageService) {
            LOG.info("language service is null, wait for init");
            ThreadUtil.execute(() -> SwingUtilities.invokeLater(() -> {
                if (Cosy.INSTANCE.checkAndWaitCosyState(null, this.askInputPanel.getProject())) {
                    this.doShowModelClassListPop(Cosy.INSTANCE.getLanguageService(this.project));
                }
            }));
        } else {
            this.doShowModelClassListPop(languageService);
        }
    }

    private void doShowModelClassListPop(LanguageWebSocketService languageService) {
        List list = languageService.queryModelClasses(this.askInputPanel.getSessionType()).stream().map(e -> new ChatModelClassItem(ChatModelClassEnum.getById(e.getName()), (ChatModelClassResult)e)).collect(Collectors.toList());
        if (this.modeSelectedLabel.modeItem.getMeta().getEnabled().booleanValue()) {
            this.popup.showAbove(this.modeSelectedLabel, list, list.indexOf(this.modeSelectedLabel.modeItem));
        } else {
            int selectIndex = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (!((ChatModelClassItem)list.get(i)).getMeta().getEnabled().booleanValue()) continue;
                selectIndex = i;
                break;
            }
            this.popup.showAbove(this.modeSelectedLabel, list, selectIndex);
        }
    }

    public JComponent getBaseComponent() {
        return this.modeSelectedLabel;
    }

    static class ModeSelectedLabel
    extends RoundRectLabel {
        public static final int DEFAULT_VERTICAL_PADDING = 0;
        public static final int DEFAULT_HORIZONTAL_PADDING = 2;
        public static final int DEFAULT_HORIZONTAL_MARGIN = 0;
        public static final int DEFAULT_CORNER_RADIUS = 8;
        private static final int MAX_WIDTH = 150;
        ChatModelClassItem modeItem;

        public ModeSelectedLabel(ChatModelClassItem modeItem) {
            super(null == modeItem ? "" : modeItem.getDisplayName(), ColorUtil.getEditorBackgroundColor(), 2, 0, 8, 0);
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, null == modeItem ? "" : modeItem.getDisplayName(), 150, false);
            this.setText(newText);
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setIcon(AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.setIconTextGap(2);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setHorizontalTextPosition(2);
            this.setFont(this.getFont().deriveFont(12.0f));
            this.setToolTipText(CosyBundle.message("chat.model.class.tooltip", new Object[0]));
            this.setBackground(ColorUtil.getEditorBackgroundColor());
            this.setAlignmentY(0.5f);
        }

        public void selectMode(ChatModelClassItem modeItem) {
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
        }

        @Generated
        public ChatModelClassItem getModeItem() {
            return this.modeItem;
        }
    }
}

