/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.ui.search.component.markdown.WrappedHtmlEditorKit;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.alibabacloud.intellij.cosy.util.ThemeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.Border;

public class ChatThinkingPanel
extends JPanel
implements Disposable {
    private static final String EXPAND_STATE_KEY = "expand_state";
    JLabel timeLabel;
    JLabel expandLabel;
    JTextPane textPanel;
    JPanel basePanel;
    JSeparator separator;
    private Font originalFont;
    private Color originalColor;
    protected Timer timer;
    private int seconds;
    boolean isRecoverSession;

    public ChatThinkingPanel(boolean isRecoverSession, Long thinkTime) {
        super(new BorderLayout());
        this.isRecoverSession = isRecoverSession;
        this.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.basePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.basePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.add((Component)this.basePanel, "Center");
        this.setupHeader();
        this.setupContent();
        SwingUtil.foreachChildComponent(this, component -> component.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        if (isRecoverSession) {
            if (null != thinkTime) {
                this.seconds = thinkTime.intValue();
                this.timeLabel.setText(this.seconds + "s");
            }
        } else {
            this.seconds = 0;
            this.timer = new Timer(1000, e -> {
                ++this.seconds;
                this.timeLabel.setText(this.seconds + "s");
            });
            this.timer.start();
        }
        this.collapse();
        SwingUtil.preventRecursiveBackgroundUpdateOnToolwindow(this);
    }

    private void setupHeader() {
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        this.basePanel.add(headerPanel);
        this.separator = new JSeparator();
        this.separator.setForeground(ColorUtil.getChatCardBackgroundColor());
        this.separator.setBorder(BorderFactory.createLineBorder(ColorUtil.getChatCardBackgroundColor(), 2));
        this.basePanel.add(this.separator);
        Box headerLeftBox = Box.createHorizontalBox();
        headerPanel.add((Component)headerLeftBox, "West");
        JLabel thinkLabel = new JLabel(CosyBundle.message("chat.answer.deep.thinking.label", new Object[0]));
        thinkLabel.setFont(thinkLabel.getFont().deriveFont(13.0f));
        thinkLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        JLabel dotLabel = new JLabel("\u00b7");
        dotLabel.setFont(dotLabel.getFont().deriveFont(13.0f));
        dotLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.timeLabel = new JLabel("0s");
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(13.0f));
        this.timeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        headerLeftBox.add(thinkLabel);
        headerLeftBox.add(Box.createHorizontalStrut(8));
        headerLeftBox.add(dotLabel);
        headerLeftBox.add(Box.createHorizontalStrut(8));
        headerLeftBox.add(this.timeLabel);
        this.setupExpandLabel(headerPanel);
    }

    private void setupExpandLabel(JPanel headerPanel) {
        this.expandLabel = new JLabel(LingmaIcons.ExpandGrey16Icon);
        this.expandLabel.setToolTipText(CosyBundle.message("chat.answer.collapse.label", new Object[0]));
        this.expandLabel.putClientProperty(EXPAND_STATE_KEY, true);
        this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
        headerPanel.add((Component)this.expandLabel, "East");
        this.expandLabel.setVisible(false);
        SwingUtil.foreachChildComponent(headerPanel, cp -> cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Boolean state = (Boolean)ChatThinkingPanel.this.expandLabel.getClientProperty(ChatThinkingPanel.EXPAND_STATE_KEY);
                if (state != null && state.booleanValue()) {
                    ChatThinkingPanel.this.collapse();
                } else {
                    ChatThinkingPanel.this.expand();
                }
                ChatThinkingPanel.this.revalidate();
                ChatThinkingPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatThinkingPanel.this.expandLabel.setVisible(true);
                ChatThinkingPanel.this.revalidate();
                ChatThinkingPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatThinkingPanel.this.expandLabel.setVisible(false);
                ChatThinkingPanel.this.revalidate();
                ChatThinkingPanel.this.repaint();
            }
        }));
    }

    private void expand() {
        this.expandLabel.setIcon(LingmaIcons.ShrinkGrey16Icon);
        this.expandLabel.setToolTipText(CosyBundle.message("chat.answer.collapse.label", new Object[0]));
        this.expandLabel.putClientProperty(EXPAND_STATE_KEY, true);
        this.textPanel.setVisible(true);
        this.separator.setVisible(true);
    }

    private void collapse() {
        this.expandLabel.setIcon(LingmaIcons.ExpandGrey16Icon);
        this.expandLabel.setToolTipText(CosyBundle.message("chat.answer.expand.label", new Object[0]));
        this.expandLabel.putClientProperty(EXPAND_STATE_KEY, false);
        this.textPanel.setVisible(false);
        this.separator.setVisible(false);
    }

    private void setupContent() {
        this.textPanel = new JTextPane();
        this.textPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.textPanel.setEditable(false);
        this.textPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.textPanel.setFont(this.textPanel.getFont().deriveFont(13.0f));
        this.textPanel.setEditorKit(new WrappedHtmlEditorKit());
        this.textPanel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.basePanel.add(this.textPanel);
        this.originalFont = this.textPanel.getFont();
        this.originalColor = this.textPanel.getForeground();
    }

    public void setText(String text) {
        if (this.textPanel != null) {
            this.textPanel.setText(this.buildText(text));
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private String buildText(String text) {
        text = text.trim().replaceAll("\\n", "<br/>");
        return ThemeUtil.getMarkdownContent(this.originalColor, this.originalFont, "<SYS>" + text);
    }

    public void dispose() {
        this.stopTimer();
    }
}

