/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.apply.ApplyingStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.checkEnv.CheckEnvStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.generate.GenerateCaseStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.plan.PlanStageComponent;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.plan.TestAgentPlanParser;
import com.alibabacloud.intellij.cosy.ui.chat.testagent.component.prebuild.BuildStageComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatReferenceParser;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageContext;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageParser;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class ChatStagePanel
extends JPanel {
    private static final Logger log = Logger.getInstance(ChatStagePanel.class);
    public static final int VERTICAL_GAP = 12;
    static Map<String, ChatStageParser> resultParsers = new HashMap<String, ChatStageParser>(){
        {
            this.put(ChatStepEnum.DETERMINING_CODEBASE.getKey(), new ChatReferenceParser());
            this.put(ChatStepEnum.RETRIEVE_RELEVANT_INFO.getKey(), new ChatReferenceParser());
            this.put(ChatStepEnum.TEST_AGENT_PLAN.getKey(), new TestAgentPlanParser());
        }
    };
    LinkedHashMap<String, BaseChatStageComponent> stageItems = new LinkedHashMap();
    Project project;
    ChatStageContext context;
    GenerateAnswerPanel parentAnswerPanel;

    public ChatStagePanel(Project project, GenerateAnswerPanel parentAnswerPanel) {
        this(project, parentAnswerPanel, (LayoutManager)new VerticalFlowLayout(0, 0, 12, true, true), ColorUtil.getChatCardChildBackgroundColor());
    }

    public ChatStagePanel(Project project, GenerateAnswerPanel parentAnswerPanel, LayoutManager mgr, Color background) {
        this.project = project;
        this.parentAnswerPanel = parentAnswerPanel;
        this.context = new ChatStageContext(project);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.setLayout(mgr);
        this.setBackground(background);
    }

    public List<String> getStageNames() {
        return new ArrayList<String>(this.stageItems.keySet());
    }

    public void appendBottomBorder() {
        this.add(Box.createVerticalStrut(0));
    }

    public void stopAllSteps() {
        this.stageItems.values().forEach(BaseChatStageComponent::stop);
    }

    public void addOrUpdateStep(Project project, ChatStep stepItem, boolean isRecoverSession) {
        BaseChatStageComponent item = this.stageItems.get(stepItem.getStep());
        if (item == null) {
            item = this.initItemByChatStep(project, stepItem);
            this.stageItems.put(stepItem.getStep(), item);
            this.add(item);
            item.lateInit(isRecoverSession);
        } else {
            item.updateItem(stepItem);
        }
        ChatStageParser parser = resultParsers.get(stepItem.getStep());
        if (parser != null) {
            parser.parse(this.context, stepItem);
        }
    }

    public void addOrUpdateStep(Project project, ChatStep stepItem, boolean isRecoverSession, Color background) {
        BaseChatStageComponent item = this.stageItems.get(stepItem.getStep());
        if (item == null) {
            item = this.initItemByChatStep(project, stepItem);
            item.setBackground(background);
            this.stageItems.put(stepItem.getStep(), item);
            this.add(item);
            item.lateInit(isRecoverSession);
        } else {
            item.updateItem(stepItem);
        }
        ChatStageParser parser = resultParsers.get(stepItem.getStep());
        if (parser != null) {
            parser.parse(this.context, stepItem);
        }
    }

    public void addOrUpdateStepWithBorder(Project project, ChatStep stepItem, boolean isRecoverSession, Color background, Border border) {
        BaseChatStageComponent item = this.stageItems.get(stepItem.getStep());
        if (item == null) {
            item = this.initItemByChatStep(project, stepItem);
            item.setBorder(border);
            item.setBackground(background);
            this.stageItems.put(stepItem.getStep(), item);
            this.add(item);
            item.lateInit(isRecoverSession);
        } else {
            item.updateItem(stepItem);
        }
        ChatStageParser parser = resultParsers.get(stepItem.getStep());
        if (parser != null) {
            parser.parse(this.context, stepItem);
        }
    }

    private BaseChatStageComponent initItemByChatStep(Project project, ChatStep stepItem) {
        if (ChatStepEnum.TEST_AGENT_PLAN.getKey().equals(stepItem.getStep())) {
            return new PlanStageComponent(project, stepItem);
        }
        if (ChatStepEnum.TEST_AGENT_BUILD.getKey().equals(stepItem.getStep())) {
            return new BuildStageComponent(project, stepItem);
        }
        if (ChatStepEnum.TEST_AGENT_CHECK_ENV.getKey().equals(stepItem.getStep())) {
            return new CheckEnvStageComponent(project, this, stepItem);
        }
        if (ChatStepEnum.TEST_AGENT_GENERATE_TESTS.getKey().equals(stepItem.getStep())) {
            return new GenerateCaseStageComponent(project, this, stepItem);
        }
        if (ChatStepEnum.TEST_AGENT_APPLY_TEST_CASES.getKey().equals(stepItem.getStep())) {
            return new ApplyingStageComponent(project, this, stepItem);
        }
        return new ChatStageComponent(stepItem);
    }

    public void clearStepsAfterStepEnd() {
        this.stageItems.values().forEach(step -> {
            if (step.shouldRemoveAfterEndStep()) {
                this.remove((Component)step);
            }
        });
        this.checkIfShowPanel();
    }

    public void checkIfShowPanel() {
        if (this.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    private void updateUiTexts() {
        this.stageItems.values().forEach(BaseChatStageComponent::updateUiLanguage);
    }

    @Generated
    public LinkedHashMap<String, BaseChatStageComponent> getStageItems() {
        return this.stageItems;
    }

    @Generated
    public ChatStageContext getContext() {
        return this.context;
    }

    @Generated
    public GenerateAnswerPanel getParentAnswerPanel() {
        return this.parentAnswerPanel;
    }
}

