/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputContext;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.transfer.ObjectEncoder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class ChatContextTagDragGestureListener
implements DragGestureListener {
    private static final Logger LOG = Logger.getInstance(ChatContextTagDragGestureListener.class);
    ChatContextTagButton component;
    DragSource ds;
    ChatInputContext inputContext;

    public ChatContextTagDragGestureListener(DragSource ds, ChatContextTagButton component, ChatInputContext inputContext) {
        this.ds = ds;
        this.component = component;
        this.inputContext = inputContext;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        StringSelection transferable = null;
        try {
            transferable = new StringSelection(ObjectEncoder.encodeObject(this.component.getTag()));
        }
        catch (IOException e) {
            LOG.warn("fail to drag context tag:" + e.getMessage(), (Throwable)e);
            return;
        }
        Pair<Image, Point> dragImage = this.createDragImage(dge, this.component);
        this.ds.startDrag(dge, DragSource.DefaultMoveDrop, (Image)dragImage.getFirst(), (Point)dragImage.getSecond(), transferable, new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                if (dsde.getDropSuccess()) {
                    LOG.info("drag drop success, context tag id:" + ChatContextTagDragGestureListener.this.component.getTag().getId());
                } else {
                    LOG.info("drag drop failed, context tag id:" + ChatContextTagDragGestureListener.this.component.getTag().getId());
                }
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
                Point point = dsde.getLocation();
                SwingUtilities.convertPointFromScreen(point, ChatContextTagDragGestureListener.this.inputContext.getInputMainPanel());
                Component currentComponent = SwingUtilities.getDeepestComponentAt(ChatContextTagDragGestureListener.this.inputContext.getInputMainPanel(), point.x, point.y);
                if (currentComponent != null && currentComponent instanceof ChatInputTextArea) {
                    ChatInputTextArea textArea = (ChatInputTextArea)currentComponent;
                    textArea.getChatInputContext().getInputMainPanel().showInputPanelBorder();
                    textArea.getChatInputContext().getInputMainPanel().setTextFocus();
                }
            }
        });
    }

    private Pair<Image, Point> createDragImage(DragGestureEvent dge, Component button) {
        GraphicsConfiguration config = button.getGraphicsConfiguration();
        BufferedImage image = config.createCompatibleImage(button.getWidth(), button.getHeight(), 3);
        Graphics g = image.getGraphics();
        button.setBackground(ColorUtil.getToolWindowBackgroundColor());
        button.paint(g);
        g.dispose();
        Point point = dge.getDragOrigin();
        Point dragPoint = point.x <= 0 || point.y <= 0 ? new Point(-image.getWidth() / 2, -image.getHeight() / 2) : new Point(-point.x, -point.y);
        return new Pair((Object)image, (Object)dragPoint);
    }
}

