/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.ui.search.component.chat.BaseChatTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.SuggestPromptPopupPanelSourceEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ChatContextAddButton
extends BaseChatTagButton {
    private static final Logger LOGGER = Logger.getInstance(ChatContextAddButton.class);
    private static final long TOO_FAST_CLICK_TIME = 200L;
    private static final int CROSS_TEXT_SIZE = 10;
    private static final float CROSS_TEXT_WEIGHT = 1.5f;
    private static final int BUTTON_SIZE = 20;
    private final ChatContextTagsPanel tagsPanel;
    private boolean forceDisable;
    private JLabel label;

    public ChatContextAddButton(ChatContextTagsPanel tagsPanel) {
        super(new BorderLayout());
        this.tagsPanel = tagsPanel;
        this.setCornerRadius(8);
        this.label = new JLabel("+");
        this.label.setFont(FontUtil.LABEL_DEFAILT_FONT);
        this.label.setHorizontalAlignment(0);
        this.label.setForeground(ColorUtil.getLabelForegroundColor());
        this.add((Component)this.label, "Center");
        this.setBorder(JBUI.Borders.empty((int)4));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorder((Border)JBUI.Borders.empty());
        this.setDefaultBackgoundColor(ColorUtil.getToolWindowBackgroundColor());
        this.setHoverBackgoundColor(ColorUtil.getItemSelectionBackground());
        this.setSelectedBackgoundColor(ColorUtil.getLinkForegroundColor());
        SwingUtil.foreachChildComponent(this, component -> component.addMouseListener(new MouseAdapter((JComponent)component){
            final /* synthetic */ JComponent val$component;
            {
                this.val$component = jComponent;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.val$component.isEnabled()) {
                    ChatContextAddButton.this.handleClick();
                }
            }
        }));
        this.setup();
        this.setupKeyListener(tagsPanel.getChatInputContext().getProject());
    }

    public void checkState() {
        ChatInputTextArea textArea = this.tagsPanel.getChatInputContext().getInputMainPanel().getTextArea();
        if (textArea == null) {
            this.forceDisable = false;
            return;
        }
        List<ChatAskTag> tags = textArea.getTags();
        if (tags == null || tags.isEmpty()) {
            this.forceDisable = false;
            this.setEnabled(true);
            return;
        }
        if (ChatAskTag.nonContext(tags).booleanValue()) {
            this.forceDisable = true;
            this.setEnabled(false);
        } else {
            this.forceDisable = false;
            this.setEnabled(true);
        }
    }

    public void setResidentFocus(boolean focus) {
        if (!this.isEnabled()) {
            return;
        }
        this.setDisableBackgoundColorEvent(focus);
        this.setFocusState(focus);
        if (focus) {
            this.setBackground(this.getHoverBackgoundColor());
        } else {
            this.setBackground(this.getDefaultBackgoundColor());
        }
    }

    public void setFocusState(boolean focus) {
        if (!this.isEnabled()) {
            return;
        }
        if (focus) {
            this.setForeground(ColorUtil.getLabelForegroundColor());
        } else {
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.forceDisable) {
            enabled = false;
        }
        boolean targetEnabled = enabled;
        super.setEnabled(targetEnabled);
        if (!targetEnabled) {
            this.setForeground(ColorUtil.getInactiveForegroundColor());
        } else {
            this.setForeground(ColorUtil.getLabelForegroundColor());
        }
        SwingUtil.foreachChildComponent(this, component -> {
            if (this != component) {
                component.setEnabled(targetEnabled);
            }
        });
    }

    @Override
    public void handleClick() {
        SuggestPromptPopupPanel suggestPromptPopupPanel = this.tagsPanel.getChatInputContext().getInputMainPanel().getChatInputSuggester().getSuggestPromptPopupPanel();
        if (System.currentTimeMillis() - suggestPromptPopupPanel.getLastChooseTime() < 200L) {
            LOGGER.debug("click context add button too fast, ignore.");
            return;
        }
        this.setResidentFocus(true);
        suggestPromptPopupPanel.displaySuggestPrompts("", "context", this.tagsPanel.getChatInputContext().getInputMainPanel().getInputPanel().getLocationOnScreen(), "contextPanel", null, SuggestPromptPopupPanelSourceEnum.BUTTON);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.label.getForeground());
        g2.setStroke(new BasicStroke(1.5f));
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int halfCrossSize = 5;
        g2.drawLine(centerX - halfCrossSize, centerY, centerX + halfCrossSize, centerY);
        g2.drawLine(centerX, centerY - halfCrossSize, centerX, centerY + halfCrossSize);
        g2.dispose();
    }
}

