/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.SnapshotInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.SnapshotSyncAllResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkingSpaceFileInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkingSpaceFileParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.WorkspaceFileSyncResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.SnapshotOperateParams;
import com.alibabacloud.intellij.cosy.editor.InlineDiffManager;
import com.alibabacloud.intellij.cosy.search.util.PopUtil;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.SnapshotService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.service.impl.SnapshotServiceImpl;
import com.alibabacloud.intellij.cosy.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.cosy.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.SwitchSnapShotDialog;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotOperateEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SyncSnapshotTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.Snapshot;
import com.alibabacloud.intellij.cosy.ui.search.renderer.SnapshotListCellRender;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelDisableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnswerPanelEnableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.QuestionFormDisableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.QuestionFormEnableNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.SnapshotSyncNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.WorkspaceFileAddedNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;

public class WorkingSpacePanel
extends JPanel {
    private static final Logger log = Logger.getInstance(WorkingSpacePanel.class);
    private static final int CORNER_RADIUS = 16;
    private static final int MIN_DISPLAY_LIST_WIDTH = 170;
    private static final int MAX_DISPLAY_LIST_HEIGHT = 224;
    private Project project;
    private MessageBusConnection messageBusConnection;
    private CosyService cosyService;
    private SnapshotService snapshotService;
    private AtomicReference<Snapshot> currentSnapShot = new AtomicReference();
    private AtomicReference<Snapshot> chosenSnapShot = new AtomicReference();
    private AtomicReference<List<Snapshot>> snapshots = new AtomicReference(new ArrayList());
    private JBList<Snapshot> snapshotItemList;
    BaseChatPanel chatContentPanel;
    JPanel basePanel;
    JPanel titlePanel;
    Box titleAndSnapshotBox;
    JLabel expandCollapseBtn;
    JLabel titleLabel;
    Box statusAndOperateBox;
    JPanel snapshotPanel;
    JLabel snapshotNameLabel;
    JBPopup snapshotPopup;
    RoundRectPanel snapshotPopupPanel;
    JScrollPane snapshotScrollPane;
    JLabel switchBtn;
    AIDevFilePanel aiDevFilePanel;

    public WorkingSpacePanel(Project project, BaseChatPanel chatContentPanel) {
        this.project = project;
        this.chatContentPanel = chatContentPanel;
        this.cosyService = new CosyServiceImpl();
        this.snapshotService = new SnapshotServiceImpl();
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)0, (int)0, (int)0, (int)0));
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.basePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.add((Component)this.basePanel, "Center");
        this.aiDevFilePanel = new AIDevFilePanel(project, AIDevFileUsageEnum.WORKING_SPACE, new ArrayList<AIDevFilePanel.FileItem>());
        this.aiDevFilePanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        this.basePanel.add((Component)this.aiDevFilePanel, "South");
        this.titlePanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                int halfHeight = height / 2;
                int quarterHeight = height / 4;
                RoundRectangle2D.Float upperRoundRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, halfHeight, 16.0f, 16.0f);
                Rectangle lowerRect = new Rectangle(0, quarterHeight, width, height - quarterHeight);
                g2.setColor(ColorUtil.getEditorBackgroundColor());
                g2.fill(upperRoundRect);
                g2.fill(lowerRect);
                this.paintChildren(g2);
                g2.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 32);
            }
        };
        this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.titlePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.titleAndSnapshotBox = Box.createHorizontalBox();
        this.expandCollapseBtn = new JLabel(LingmaIcons.ArrowdownEmptyGreyIcon);
        this.expandCollapseBtn.setPreferredSize(new Dimension(16, 16));
        this.expandCollapseBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.expandCollapseBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WorkingSpacePanel.this.toggleAiDevFilePanel();
            }
        });
        this.titleAndSnapshotBox.add(this.expandCollapseBtn);
        this.titleAndSnapshotBox.add(Box.createHorizontalStrut(4));
        this.titleLabel = new JLabel(this.aiDevFilePanel.getFileCount() + " " + CosyBundle.message("working.space.title", new Object[0]));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(0, 13.0f));
        this.titleLabel.setForeground(ColorUtil.getLabelForegroundColor());
        this.titleAndSnapshotBox.add(this.titleLabel);
        this.titleAndSnapshotBox.add(Box.createHorizontalStrut(12));
        Snapshot chosen = this.chosenSnapShot.get();
        if (chosen != null) {
            this.setUpSnapshotPanel(chosen);
        }
        this.titlePanel.add((Component)this.titleAndSnapshotBox, "West");
        this.statusAndOperateBox = Box.createHorizontalBox();
        this.setUpSnapshotStatusPanel(chosen);
        this.titlePanel.add((Component)this.statusAndOperateBox, "East");
        this.titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point clickPoint = e.getPoint();
                if (!WorkingSpacePanel.this.titleAndSnapshotBox.getBounds().contains(clickPoint) && !WorkingSpacePanel.this.statusAndOperateBox.getBounds().contains(clickPoint)) {
                    WorkingSpacePanel.this.toggleAiDevFilePanel();
                }
            }
        });
        this.basePanel.add((Component)this.titlePanel, "North");
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(SnapshotSyncNotifier.SNAPSHOT_SYNC_NOTIFICATION, this::syncSnapshot);
        this.messageBusConnection.subscribe(WorkspaceFileAddedNotifier.WORKSPACE_FILE_ADDED_NOTIFICATION, this::syncWorkspaceFileAdded);
    }

    private void toggleAiDevFilePanel() {
        if (this.aiDevFilePanel.isVisible()) {
            this.expandCollapseBtn.setIcon(LingmaIcons.ArrowrightEmptyGreyIcon);
            this.aiDevFilePanel.setVisible(false);
        } else {
            this.aiDevFilePanel.setVisible(true);
            this.expandCollapseBtn.setIcon(LingmaIcons.ArrowdownEmptyGreyIcon);
        }
    }

    private void setUpSnapshotPanel(Snapshot chosen) {
        this.snapshotPanel = new JPanel();
        this.snapshotPanel.setLayout(new BoxLayout(this.snapshotPanel, 0));
        this.snapshotPanel.setOpaque(false);
        this.setUpSnapshotPopupPanel();
        this.snapshotNameLabel = new JLabel(chosen.getName());
        this.snapshotNameLabel.setFont(this.snapshotNameLabel.getFont().deriveFont(0, 12.0f));
        this.snapshotNameLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.snapshotNameLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.addSnapshotPopupEvent(this.snapshotNameLabel);
        this.snapshotPanel.add(this.snapshotNameLabel);
        this.snapshotPanel.add(Box.createHorizontalStrut(4));
        JLabel snapshotIcon = new JLabel(LingmaIcons.ArrowdownEmptyGreyIcon);
        snapshotIcon.setPreferredSize(new Dimension(16, 16));
        snapshotIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.addSnapshotPopupEvent(snapshotIcon);
        this.snapshotPanel.add(snapshotIcon);
        this.snapshotPanel.add(Box.createHorizontalStrut(4));
        this.switchBtn = new JLabel(CosyBundle.message("working.space.snapshot.operation.switch", new Object[0]));
        this.switchBtn.setFont(this.switchBtn.getFont().deriveFont(0, 12.0f));
        this.switchBtn.setForeground(ColorUtil.getLinkForegroundColor());
        this.switchBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.switchBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                WorkingSpacePanel.this.createSwitchSnapshotConfirmDialog(new Point(WorkingSpacePanel.this.switchBtn.getLocationOnScreen().x, WorkingSpacePanel.this.switchBtn.getLocationOnScreen().y + WorkingSpacePanel.this.switchBtn.getHeight() + 10), WorkingSpacePanel.this.currentSnapShot.get(), WorkingSpacePanel.this.chosenSnapShot.get(), CosyBundle.message("working.space.snapshot.switch.dialog.title", new Object[0]), CosyBundle.message("new.task.dialog.confirm", new Object[0]), CosyBundle.message("new.task.dialog.cancel", new Object[0]), CosyBundle.message("working.space.snapshot.switch.dialog.content", new Object[0]), null);
            }
        });
        Snapshot current = this.currentSnapShot.get();
        this.switchBtn.setVisible(current != null && !current.getId().equals(chosen.getId()));
        this.snapshotPanel.add(this.switchBtn);
        this.titleAndSnapshotBox.add(this.snapshotPanel);
        this.snapshotPanel.setVisible(false);
        this.snapshotNameLabel.setVisible(false);
    }

    public void createSwitchSnapshotConfirmDialog(Point location, final Snapshot fromSnapshot, final Snapshot toSnapshot, String title, String ok, String cancel, String content, final Consumer<Void> callback) {
        new SwitchSnapShotDialog(this.project, location, title, ok, cancel, content){

            protected void doOKAction() {
                super.doOKAction();
                SwingUtilities.invokeLater(() -> {
                    if (WorkingSpacePanel.this.chatContentPanel != null && WorkingSpacePanel.this.chatContentPanel.getAnswerPanel() != null) {
                        WorkingSpacePanel.this.chatContentPanel.getAnswerPanel().stopChatSync();
                    }
                    WorkingSpacePanel.this.switchSnapshot(fromSnapshot, toSnapshot);
                });
                if (null != callback) {
                    callback.accept(null);
                }
            }
        }.show();
    }

    public boolean switchSnapshot(Snapshot snapshot, Snapshot targetSnapshot) {
        if (snapshot == null) {
            log.warn("switchSnapshot snapshot is null");
            return false;
        }
        if (targetSnapshot == null) {
            log.warn("switchSnapshot targetSnapshot is null");
            return false;
        }
        List<WorkingSpaceFileInfo> list = this.snapshotService.listWorkingSpaceFilesBySnapshot(this.project, snapshot.getId());
        if (list == null) {
            list = new ArrayList<WorkingSpaceFileInfo>();
        }
        ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate> workingSpaceFiles = new ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate>();
        for (WorkingSpaceFileInfo info : list) {
            workingSpaceFiles.add(SnapshotOperateParams.WorkingSpaceFileToOperate.builder().id(info.getId()).fileId(info.getFileId()).content(InlineDiffManager.Companion.getInstance().getFileContent(this.project, info.getId())).build());
        }
        Boolean operated = this.snapshotService.operate(this.project, SnapshotOperateParams.builder().id(snapshot.getId()).opType(SnapshotOperateEnum.SWITCH.name()).workingSpaceFiles(workingSpaceFiles).params(SnapshotOperateParams.OperateTargetInfo.builder().targetSnapshotId(targetSnapshot.getId()).build()).build());
        if (Boolean.TRUE.equals(operated) && CollectionUtils.isNotEmpty(list)) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (WorkingSpaceFileInfo info : list) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(info.getFileId());
                if (null == file) continue;
                files.add(file);
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> LocalFileSystem.getInstance().refreshFiles((Iterable)files, false, false, null)));
        }
        return operated;
    }

    private void setUpSnapshotPopupPanel() {
        DefaultListModel listModel = new DefaultListModel();
        listModel.addAll(this.snapshots.get());
        this.snapshotItemList = new JBList(listModel);
        this.snapshotItemList.setVisibleRowCount(8);
        this.snapshotItemList.setOpaque(false);
        this.snapshotItemList.setFixedCellHeight(28);
        this.snapshotItemList.setCellRenderer((ListCellRenderer)new SnapshotListCellRender(this.project, this.currentSnapShot, this));
        this.snapshotItemList.setBorder(BorderFactory.createEmptyBorder());
        this.snapshotItemList.setCursor(Cursor.getPredefinedCursor(12));
        if (listModel.indexOf(this.currentSnapShot.get()) >= 0) {
            this.snapshotItemList.setSelectedValue((Object)this.currentSnapShot.get(), true);
        }
        ScrollingUtil.installActions(this.snapshotItemList);
        this.snapshotScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.width < 170) {
                    size.width = 170;
                }
                if (size.height > 224) {
                    size.height = 224;
                }
                return size;
            }
        };
        this.snapshotScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.snapshotScrollPane.setViewportView((Component)this.snapshotItemList);
        this.snapshotScrollPane.setOpaque(false);
        this.snapshotScrollPane.setVerticalScrollBarPolicy(20);
        this.snapshotScrollPane.setHorizontalScrollBarPolicy(31);
        this.snapshotPopupPanel = new RoundRectPanel();
        this.snapshotPopupPanel.setLayout(new BorderLayout());
        this.snapshotPopupPanel.setBorder(JBUI.Borders.empty((int)8));
        this.snapshotPopupPanel.add((Component)this.snapshotScrollPane, "Center");
        this.snapshotItemList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!PopUtil.isPopUsable(WorkingSpacePanel.this.snapshotPopup)) {
                    return;
                }
                WorkingSpacePanel.this.snapshotPopup.cancel();
                Snapshot snapshot = (Snapshot)WorkingSpacePanel.this.snapshotItemList.getSelectedValue();
                Snapshot oldChosen = WorkingSpacePanel.this.chosenSnapShot.get();
                if (oldChosen != null && oldChosen.getId().equals(snapshot.getId())) {
                    return;
                }
                WorkingSpacePanel.this.changeChosenSnapshot(snapshot, true);
            }
        });
    }

    private void changeChosenSnapshot(Snapshot destSnapshot, boolean manualOperate) {
        this.chosenSnapShot.set(destSnapshot);
        if (this.snapshotPanel == null) {
            this.setUpSnapshotPanel(destSnapshot);
        } else {
            DefaultListModel snapshotListModel = (DefaultListModel)this.snapshotItemList.getModel();
            snapshotListModel.clear();
            snapshotListModel.addAll((Collection)this.snapshots.get());
            if (snapshotListModel.indexOf(destSnapshot) >= 0) {
                this.snapshotItemList.setSelectedValue((Object)destSnapshot, true);
            }
            this.snapshotNameLabel.setText(destSnapshot.getName());
            this.switchBtn.setVisible(this.currentSnapShot.get() != null && !this.currentSnapShot.get().getId().equals(destSnapshot.getId()));
        }
        this.statusAndOperateBox.removeAll();
        this.setUpSnapshotStatusPanel(destSnapshot);
        this.statusAndOperateBox.revalidate();
        this.statusAndOperateBox.repaint();
        if (manualOperate) {
            List<WorkingSpaceFileInfo> list = this.snapshotService.listWorkingSpaceFilesBySnapshot(this.project, destSnapshot.getId());
            if (list != null) {
                List<AIDevFilePanel.FileItem> items = list.stream().map(fileInfo -> fileInfo.buildFileItem(destSnapshot)).collect(Collectors.toList());
                this.aiDevFilePanel.refreshFileItems(items);
            } else {
                this.aiDevFilePanel.refreshFileItems(new ArrayList<AIDevFilePanel.FileItem>());
            }
            this.chatContentPanel.scrollToAnswerPanel(destSnapshot.getRequestId());
        }
    }

    private void addSnapshotPopupEvent(JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WorkingSpacePanel.this.snapshotPopup != null && WorkingSpacePanel.this.snapshotPopup.isVisible()) {
                    WorkingSpacePanel.this.snapshotPopup.cancel();
                }
                WorkingSpacePanel.this.snapshotPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)WorkingSpacePanel.this.snapshotPopupPanel, null).setFocusable(true).setRequestFocus(true).setResizable(false).setCancelOnClickOutside(true).createPopup();
                WorkingSpacePanel.this.snapshotPopup.showUnderneathOf((Component)WorkingSpacePanel.this.snapshotPanel);
            }
        });
    }

    private void setUpSnapshotStatusPanel(Snapshot chosen) {
        if (chosen == null) {
            return;
        }
        if (SnapshotStatusEnum.INIT.getId().equals(chosen.getStatus()) || SnapshotStatusEnum.ACTIVE_INIT.getId().equals(chosen.getStatus())) {
            return;
        }
        JLabel statusIcon = new JLabel(chosen.buildStatusIcon());
        this.statusAndOperateBox.add(statusIcon);
        this.statusAndOperateBox.add(Box.createHorizontalStrut(4));
        JLabel statusLabel = new JLabel(chosen.buildStatusName());
        statusLabel.setFont(statusLabel.getFont().deriveFont(0, 12.0f));
        statusLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.statusAndOperateBox.add(statusLabel);
        if (this.currentSnapShot.get() == null || !this.currentSnapShot.get().getId().equals(chosen.getId())) {
            return;
        }
        if (SnapshotStatusEnum.APPLYING.getId().equals(chosen.getStatus())) {
            this.statusAndOperateBox.add(Box.createHorizontalStrut(12));
            JLabel cancelLabel = new JLabel(CosyBundle.message("working.space.snapshot.operation.cancel", new Object[0]));
            cancelLabel.setFont(statusLabel.getFont().deriveFont(0, 12.0f));
            cancelLabel.setForeground(ColorUtil.getLinkForegroundColor());
            cancelLabel.setCursor(Cursor.getPredefinedCursor(12));
            cancelLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorkingSpacePanel.this.changeSnapshotStatus(SnapshotOperateEnum.CANCEL);
                }
            });
            this.statusAndOperateBox.add(cancelLabel);
        } else if (SnapshotStatusEnum.APPLIED.getId().equals(chosen.getStatus())) {
            this.statusAndOperateBox.add(Box.createHorizontalStrut(12));
            JLabel rejectAllLabel = new JLabel(CosyBundle.message("working.space.snapshot.operation.reject", new Object[0]));
            rejectAllLabel.setFont(statusLabel.getFont().deriveFont(0, 12.0f));
            rejectAllLabel.setForeground(ColorUtil.getLinkForegroundColor());
            rejectAllLabel.setCursor(Cursor.getPredefinedCursor(12));
            rejectAllLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorkingSpacePanel.this.changeSnapshotStatus(SnapshotOperateEnum.REJECT_ALL);
                }
            });
            this.statusAndOperateBox.add(rejectAllLabel);
            this.statusAndOperateBox.add(Box.createHorizontalStrut(12));
            JLabel acceptAllLabel = new JLabel(CosyBundle.message("working.space.snapshot.operation.accept", new Object[0]));
            acceptAllLabel.setFont(statusLabel.getFont().deriveFont(0, 12.0f));
            acceptAllLabel.setForeground(ColorUtil.getLinkForegroundColor());
            acceptAllLabel.setCursor(Cursor.getPredefinedCursor(12));
            acceptAllLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorkingSpacePanel.this.changeSnapshotStatus(SnapshotOperateEnum.ACCEPT_ALL);
                }
            });
            this.statusAndOperateBox.add(acceptAllLabel);
        } else if (SnapshotStatusEnum.OUTDATED.getId().equals(chosen.getStatus())) {
            this.statusAndOperateBox.add(Box.createHorizontalStrut(12));
            JLabel outdatedLabel = new JLabel(CosyBundle.message("working.space.snapshot.operation.checkout", new Object[0]));
            outdatedLabel.setFont(statusLabel.getFont().deriveFont(0, 12.0f));
            outdatedLabel.setForeground(ColorUtil.getLinkForegroundColor());
            outdatedLabel.setCursor(Cursor.getPredefinedCursor(12));
            outdatedLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorkingSpacePanel.this.changeSnapshotStatus(SnapshotOperateEnum.ACTIVATE);
                }
            });
            this.statusAndOperateBox.add(outdatedLabel);
        }
    }

    public boolean changeSnapshotStatus(SnapshotOperateEnum operateEnum) {
        Snapshot chosen = this.chosenSnapShot.get();
        if (chosen == null || operateEnum == null) {
            log.warn("changeSnapshotStatus chosen is null or operate is null");
            return false;
        }
        Snapshot current = this.currentSnapShot.get();
        if (current == null || !chosen.getId().equals(current.getId())) {
            log.warn("changeSnapshotStatus chosen not equal current\uff0cchosenSnapshotId=" + chosen.getId() + ",current=" + JSON.toJSONString((Object)current));
            return false;
        }
        return this.changeCurrentSnapshotStatus(operateEnum);
    }

    public boolean changeCurrentSnapshotStatus(SnapshotOperateEnum operateEnum) {
        Snapshot current = this.currentSnapShot.get();
        if (current == null || operateEnum == null) {
            log.warn("changeCurrentSnapshotStatus current is null or operate is null");
            return false;
        }
        List<SnapshotOperateParams.WorkingSpaceFileToOperate> workingSpaceFiles = this.getWorkingSpaceFiles();
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            if (operateEnum == SnapshotOperateEnum.ACCEPT_ALL) {
                return this.changeSnapshotAcceptAll(workingSpaceFiles, current);
            }
            if (operateEnum == SnapshotOperateEnum.REJECT_ALL) {
                InlineDiffManager.Companion.getInstance().closeEditor(this.project, null, current.getId(), false);
            }
            return this.snapshotService.operate(this.project, SnapshotOperateParams.builder().id(current.getId()).opType(operateEnum.name()).workingSpaceFiles(workingSpaceFiles).build());
        }
        List filePathList = workingSpaceFiles.stream().map(SnapshotOperateParams.WorkingSpaceFileToOperate::getFileId).collect(Collectors.toList());
        Boolean operate = this.snapshotService.operate(this.project, SnapshotOperateParams.builder().id(current.getId()).opType(operateEnum.name()).workingSpaceFiles(workingSpaceFiles).build());
        if (operateEnum == SnapshotOperateEnum.ACCEPT_ALL || operateEnum == SnapshotOperateEnum.REJECT_ALL) {
            if (operateEnum == SnapshotOperateEnum.ACCEPT_ALL) {
                this.doTelemetry(workingSpaceFiles.stream().filter(e -> AIDevFileStatusEnum.APPLIED == e.getStatus()).collect(Collectors.toList()));
            }
            InlineDiffManager.Companion.getInstance().closeAllEditor(this.project);
            for (String filePath : filePathList) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath);
                if (null == virtualFile) continue;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }
        return operate;
    }

    private boolean changeSnapshotAcceptAll(List<SnapshotOperateParams.WorkingSpaceFileToOperate> workingSpaceFiles, Snapshot chosen) {
        String showDiffFileId = null;
        ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate> operateStraightFiles = new ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate>();
        ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate> toAcceptFiles = new ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate>();
        for (SnapshotOperateParams.WorkingSpaceFileToOperate item : workingSpaceFiles) {
            if (AIDevFileStatusEnum.APPLIED == item.getStatus()) {
                toAcceptFiles.add(item);
            }
            try {
                String stableFileContent;
                FileUtil.saveMemeryFileContentToDisk(this.project, item.getFileId());
                String localFileContent = "";
                if (null != LocalFileSystem.getInstance().findFileByPath(item.getFileId())) {
                    localFileContent = new String(LocalFileSystem.getInstance().findFileByPath(item.getFileId()).contentsToByteArray(), StandardCharsets.UTF_8);
                }
                if (!(stableFileContent = Cosy.INSTANCE.getLanguageService(this.project).getLastStableContent(new WorkingSpaceFileParams(item.getId(), null, null, null), 10000L).getContent()).equals(localFileContent)) {
                    showDiffFileId = item.getId();
                    continue;
                }
                operateStraightFiles.add(item);
            }
            catch (IOException iOException) {}
        }
        Boolean operate = true;
        if (CollectionUtils.isNotEmpty(operateStraightFiles)) {
            operate = this.snapshotService.operate(this.project, SnapshotOperateParams.builder().id(chosen.getId()).opType(SnapshotOperateEnum.ACCEPT.name()).workingSpaceFiles(operateStraightFiles).build());
        }
        if (CollectionUtils.isNotEmpty(toAcceptFiles)) {
            this.doTelemetry(toAcceptFiles);
        }
        if (showDiffFileId != null) {
            InlineDiffManager.Companion.getInstance().showMultipleDiff(this.project, chosen.getId(), null, showDiffFileId, false, false, true);
        } else {
            InlineDiffManager.Companion.getInstance().closeEditor(this.project, null, chosen.getId(), false);
        }
        return operate;
    }

    private void doTelemetry(List<SnapshotOperateParams.WorkingSpaceFileToOperate> toAcceptFiles) {
        toAcceptFiles.forEach(e -> AIDevFilePanel.telemetryTextChangeForAIDevFile(this.project, e.getFileId(), e.getAddedLines(), e.getAddedChars()));
    }

    private List<SnapshotOperateParams.WorkingSpaceFileToOperate> getWorkingSpaceFiles() {
        ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate> workingSpaceFiles = new ArrayList<SnapshotOperateParams.WorkingSpaceFileToOperate>();
        Object[] components = this.aiDevFilePanel.getListPanel().getComponents();
        if (ArrayUtils.isNotEmpty((Object[])components)) {
            for (Object component : components) {
                if (!(component instanceof AIDevFilePanel.FileItemPanel)) continue;
                AIDevFilePanel.FileItemPanel itemPanel = (AIDevFilePanel.FileItemPanel)component;
                workingSpaceFiles.add(SnapshotOperateParams.WorkingSpaceFileToOperate.builder().id(itemPanel.getFileItem().getId()).fileId(itemPanel.getFileItem().getFileId()).content(InlineDiffManager.Companion.getInstance().getFileContent(this.project, itemPanel.getFileItem().getId())).addedLines(itemPanel.getFileItem().getAddedLines()).deletedLines(itemPanel.getFileItem().getDeletedLines()).addedChars(itemPanel.getFileItem().getAddedChars()).deletedChars(itemPanel.getFileItem().getDeletedChars()).status(itemPanel.getFileItem().getStatus()).build());
            }
        }
        return workingSpaceFiles;
    }

    boolean checkSnapshotSyncAllResult(SnapshotSyncAllResult result) {
        if (result == null) {
            log.warn("WorkingSpacePanel syncSnapshot result is null");
            return false;
        }
        boolean sameSession = this.checkSameSession(result.getCurrentSessionId());
        if (!sameSession) {
            return false;
        }
        if (CollectionUtils.isEmpty(result.getSnapshots())) {
            log.warn("WorkingSpacePanel syncSnapshot snapshot list from go is empty");
            return false;
        }
        String currentSnapshotId = result.getCurrentSnapshotId();
        if (StringUtil.isBlank((String)currentSnapshotId)) {
            log.warn("WorkingSpacePanel syncSnapshot current snapshot id is blank");
            return false;
        }
        SnapshotInfo currentSnapshotInfo = result.getSnapshots().stream().filter(snapshot -> snapshot.getId().equals(currentSnapshotId)).findFirst().orElse(null);
        if (currentSnapshotInfo == null) {
            log.warn("syncSnapshot current snapshot not found, currentSnapshotId=" + currentSnapshotId);
            return false;
        }
        return true;
    }

    void syncSnapshot(SnapshotSyncAllResult result) {
        boolean currentSnapshotChanged;
        if (SyncSnapshotTypeEnum.SWITCH_FRUSH_END.name().equals(result.getType())) {
            return;
        }
        log.debug("WorkingSpacePanel syncSnapshot result=" + JSONObject.toJSONString((Object)result));
        boolean checkResult = this.checkSnapshotSyncAllResult(result);
        if (!checkResult) {
            return;
        }
        List<SnapshotInfo> snapshotInfoListFromGo = result.getSnapshots();
        if (CollectionUtils.isEmpty(snapshotInfoListFromGo = snapshotInfoListFromGo.stream().filter(item -> !SnapshotStatusEnum.OUTDATED.getId().equalsIgnoreCase(item.getStatus())).collect(Collectors.toList()))) {
            return;
        }
        if (SnapshotStatusEnum.ACTIVE_INIT.getId().equalsIgnoreCase(snapshotInfoListFromGo.get(0).getStatus())) {
            this.chatContentPanel.getInputPanel().enableInputPanel();
            this.chatContentPanel.getInputPanel().setTextAreaPlaceholder();
        }
        String currentSnapshotIdFromGo = result.getCurrentSnapshotId();
        SnapshotInfo currentSnapshotInfoFromGo = snapshotInfoListFromGo.stream().filter(snapshot -> snapshot.getId().equals(currentSnapshotIdFromGo)).findFirst().orElse(null);
        int currentIndex = snapshotInfoListFromGo.indexOf(currentSnapshotInfoFromGo);
        List<Snapshot> snapshotListFromGo = Snapshot.builds(snapshotInfoListFromGo, currentIndex);
        Snapshot currentBefore = this.currentSnapShot.get();
        boolean bl = currentSnapshotChanged = currentBefore == null || !currentBefore.getId().equals(currentSnapshotIdFromGo);
        if (currentSnapshotChanged) {
            boolean chosenSnapshotNotCurrent;
            this.currentSnapShot.set(Snapshot.build(currentSnapshotInfoFromGo, currentIndex, currentIndex));
            Snapshot chosen = this.chosenSnapShot.get();
            boolean bl2 = chosenSnapshotNotCurrent = chosen == null || !currentSnapshotIdFromGo.equals(chosen.getId());
            if (chosenSnapshotNotCurrent) {
                this.snapshots.set(snapshotListFromGo);
                this.changeChosenSnapshot(this.currentSnapShot.get(), false);
            } else {
                this.switchBtn.setVisible(false);
                this.switchBtn.revalidate();
                this.switchBtn.repaint();
                this.snapshots.set(snapshotListFromGo);
                DefaultListModel snapshotListModel = (DefaultListModel)this.snapshotItemList.getModel();
                snapshotListModel.clear();
                snapshotListModel.addAll((Collection)this.snapshots.get());
                if (snapshotListModel.indexOf(this.currentSnapShot.get()) >= 0) {
                    this.snapshotItemList.setSelectedValue((Object)this.currentSnapShot.get(), true);
                }
                this.statusAndOperateBox.removeAll();
                this.setUpSnapshotStatusPanel(chosen);
                this.statusAndOperateBox.revalidate();
                this.statusAndOperateBox.repaint();
            }
            if (SyncSnapshotTypeEnum.REFRESH_CURRENT.name().equals(result.getType())) {
                ArrayList<String> activeList = new ArrayList<String>();
                ArrayList<String> invalidList = new ArrayList<String>();
                snapshotListFromGo.forEach(item -> {
                    if (StringUtils.isBlank((CharSequence)item.getRequestId())) {
                        return;
                    }
                    if (item.isInvalid()) {
                        invalidList.add(item.getRequestId());
                    } else {
                        activeList.add(item.getRequestId());
                    }
                });
                this.activeOrInvalidAnswerPanel(activeList, invalidList);
            }
            if (currentSnapshotInfoFromGo != null && result.getWorkingSpaceFiles() != null && (SnapshotStatusEnum.INIT.getId().equals(currentSnapshotInfoFromGo.getStatus()) || SyncSnapshotTypeEnum.REFRESH_CURRENT.name().equals(result.getType()))) {
                List<AIDevFilePanel.FileItem> items = result.getWorkingSpaceFiles().stream().map(fileInfo -> fileInfo.buildFileItem(this.currentSnapShot.get())).collect(Collectors.toList());
                this.aiDevFilePanel.refreshFileItems(items);
            }
        } else {
            Snapshot chosenFormGo;
            this.snapshots.set(snapshotListFromGo);
            Snapshot chosenSnapshotBefore = this.chosenSnapShot.get();
            if (chosenSnapshotBefore != null && (chosenFormGo = (Snapshot)snapshotListFromGo.stream().filter(item -> item.getId().equals(chosenSnapshotBefore.getId())).findFirst().orElse(null)) != null) {
                boolean nameChanged;
                boolean statusChanged = !chosenFormGo.getStatus().equals(chosenSnapshotBefore.getStatus());
                boolean bl3 = nameChanged = !chosenFormGo.getName().equals(chosenSnapshotBefore.getName());
                if (statusChanged || nameChanged) {
                    this.changeChosenSnapshot(chosenFormGo, false);
                }
            }
        }
        this.titleLabel.setText(this.aiDevFilePanel.getFileCount() + " " + CosyBundle.message("working.space.title", new Object[0]));
        this.titleLabel.revalidate();
        this.titleLabel.repaint();
    }

    void syncWorkspaceFileAdded(WorkspaceFileSyncResult result) {
        log.debug("WorkingSpacePanel syncWorkspaceFileAdded result=" + JSONObject.toJSONString((Object)result));
        if (result.getWorkingSpaceFile() == null) {
            return;
        }
        boolean sameSession = this.checkSameSession(result.getWorkingSpaceFile().getSessionId());
        if (!sameSession) {
            return;
        }
        Snapshot chosen = this.chosenSnapShot.get();
        String addFileSnapshotId = result.getWorkingSpaceFile().getSnapshotId();
        if (chosen != null && !chosen.getId().equals(addFileSnapshotId)) {
            log.warn("WorkingSpacePanel syncWorkspaceFileAdded chosenSnapshotId=" + chosen.getId() + " not equal to file snapshotId=" + addFileSnapshotId);
            return;
        }
        WorkingSpaceFileInfo workingSpaceFileInfo = result.getWorkingSpaceFile();
        AIDevFilePanel.FileItem fileItem = workingSpaceFileInfo.buildFileItem(chosen);
        this.aiDevFilePanel.addFileItem(fileItem);
        this.setVisible(true);
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(() -> {
            this.chatContentPanel.moveScrollToBottom(false);
            this.titleLabel.setText(this.aiDevFilePanel.getFileCount() + " " + CosyBundle.message("working.space.title", new Object[0]));
        });
    }

    private boolean checkSameSession(String currentSessionId) {
        if (StringUtils.isEmpty((CharSequence)currentSessionId)) {
            log.warn("checkSameSession currentSessionId is empty");
            return false;
        }
        if (this.chatContentPanel.getInitInput() == null || this.chatContentPanel.getInitInput().getChatContext() == null) {
            log.warn("checkSameSession init input or chat context is null");
            return false;
        }
        String chatSessionId = this.chatContentPanel.getInitInput().getChatContext().getSessionId();
        if (!currentSessionId.equals(chatSessionId)) {
            log.warn("syncSnapshot currentSessionId=" + currentSessionId + " is not equal to chatSessionId=" + chatSessionId + ",project=" + this.project.getName());
            return false;
        }
        return true;
    }

    public void clear() {
        this.currentSnapShot.set(null);
        this.chosenSnapShot.set(null);
        this.snapshots.set(new ArrayList());
        this.clearSnapshotPanel();
        this.statusAndOperateBox.removeAll();
        this.statusAndOperateBox.invalidate();
        this.statusAndOperateBox.repaint();
        this.aiDevFilePanel.refreshFileItems(new ArrayList<AIDevFilePanel.FileItem>());
    }

    public void resetWorkspaceFromHistory(String sessionId, String sessionType) {
        if (!this.isShowing()) {
            this.setVisible(true);
        }
        this.clear();
        List<SnapshotInfo> snapshotInfoListFromGo = this.snapshotService.listSnapshotsBySession(this.project, sessionId);
        if (CollectionUtils.isNotEmpty(snapshotInfoListFromGo)) {
            Snapshot snapshot = Snapshot.build(snapshotInfoListFromGo.get(0), 0, 0);
            this.currentSnapShot.set(snapshot);
            this.snapshots.set(Snapshot.builds(snapshotInfoListFromGo, 0));
            this.changeChosenSnapshot(snapshot, true);
            this.chosenSnapShot.set(snapshot);
            this.clearSnapshotPanel();
            this.statusAndOperateBox.removeAll();
            this.setUpSnapshotStatusPanel(snapshot);
            this.statusAndOperateBox.revalidate();
            this.statusAndOperateBox.repaint();
            List<WorkingSpaceFileInfo> list = this.snapshotService.listWorkingSpaceFilesBySnapshot(this.project, snapshot.getId());
            if (list != null) {
                List<AIDevFilePanel.FileItem> items = list.stream().map(fileInfo -> fileInfo.buildFileItem(snapshot)).collect(Collectors.toList());
                this.aiDevFilePanel.refreshFileItems(items);
                this.titleLabel.setText(this.aiDevFilePanel.getFileCount() + " " + CosyBundle.message("working.space.title", new Object[0]));
                this.titleLabel.revalidate();
                this.titleLabel.repaint();
            } else if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                this.aiDevFilePanel.refreshFileItems(new ArrayList<AIDevFilePanel.FileItem>());
            } else {
                this.setVisible(false);
            }
            if (!SessionTypeEnum.ASSISTANT.getType().equals(sessionType) && SnapshotStatusEnum.OUTDATED.getId().equalsIgnoreCase(snapshot.getStatus())) {
                this.chatContentPanel.getInputPanel().disableInputPanel();
                this.chatContentPanel.getInputPanel().setTextAreaPlaceholder();
            }
        } else if (!CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.setVisible(false);
        }
    }

    private boolean isSessionActive(String sessionId) {
        List<String> activeSessionList = this.cosyService.listCurrentSession(this.project);
        return CollectionUtils.isNotEmpty(activeSessionList) && activeSessionList.contains(sessionId);
    }

    private void clearSnapshotPanel() {
        if (this.snapshotPanel != null) {
            this.snapshotPanel.removeAll();
            this.snapshotPanel.invalidate();
            this.snapshotPanel.repaint();
            this.snapshotPanel = null;
        }
    }

    public void updateUiTexts() {
        this.titleLabel.setText(this.aiDevFilePanel.getFileCount() + " " + CosyBundle.message("working.space.title", new Object[0]));
        Snapshot current = this.currentSnapShot.get();
        Snapshot choose = this.chosenSnapShot.get();
        if (current == null || choose == null) {
            return;
        }
        current.resetName();
        this.currentSnapShot.set(current);
        choose.resetName();
        this.chosenSnapShot.set(choose);
        List<Snapshot> snapshotList = this.snapshots.get();
        snapshotList.forEach(Snapshot::resetName);
        this.snapshots.set(snapshotList);
        if (this.snapshotPanel != null) {
            DefaultListModel snapshotListModel = (DefaultListModel)this.snapshotItemList.getModel();
            snapshotListModel.clear();
            snapshotListModel.addAll((Collection)this.snapshots.get());
            if (snapshotListModel.indexOf(choose) >= 0) {
                this.snapshotItemList.setSelectedValue((Object)choose, true);
            }
            this.snapshotNameLabel.setText(choose.getName());
            this.switchBtn.setVisible(!current.getId().equals(choose.getId()));
        }
        this.statusAndOperateBox.removeAll();
        this.setUpSnapshotStatusPanel(choose);
        this.statusAndOperateBox.revalidate();
        this.statusAndOperateBox.repaint();
        List<WorkingSpaceFileInfo> list = this.snapshotService.listWorkingSpaceFilesBySnapshot(this.project, choose.getId());
        if (list != null) {
            List<AIDevFilePanel.FileItem> items = list.stream().map(fileInfo -> fileInfo.buildFileItem(choose)).collect(Collectors.toList());
            this.aiDevFilePanel.refreshFileItems(items);
        } else {
            this.aiDevFilePanel.refreshFileItems(new ArrayList<AIDevFilePanel.FileItem>());
        }
    }

    public void activeOrInvalidAnswerPanel(List<String> activityRequestIds, List<String> invalidRequestIds) {
        if (CollectionUtils.isEmpty(activityRequestIds) && CollectionUtils.isEmpty(invalidRequestIds)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(activityRequestIds)) {
            ((QuestionFormEnableNotifier)this.project.getMessageBus().syncPublisher(QuestionFormEnableNotifier.QUESTION_FORM_ENABLE_NOTIFIER)).enableChatQuestionForm(activityRequestIds);
            ((AnswerPanelEnableNotifier)this.project.getMessageBus().syncPublisher(AnswerPanelEnableNotifier.ANSWER_PANEL_ENABLE_NOTIFIER)).enableGenerateAnswerPanel(activityRequestIds);
        }
        if (CollectionUtils.isNotEmpty(invalidRequestIds)) {
            ((QuestionFormDisableNotifier)this.project.getMessageBus().syncPublisher(QuestionFormDisableNotifier.QUESTION_FORM_DISABLE_NOTIFIER)).disableChatQuestionForm(invalidRequestIds);
            ((AnswerPanelDisableNotifier)this.project.getMessageBus().syncPublisher(AnswerPanelDisableNotifier.ANSWER_PANEL_DISABLE_NOTIFIER_TOPIC)).disableGenerateAnswerPanel(invalidRequestIds);
        }
    }

    public int getFileCount() {
        return this.aiDevFilePanel.getFileCount();
    }

    @Generated
    public AtomicReference<Snapshot> getCurrentSnapShot() {
        return this.currentSnapShot;
    }

    @Generated
    public AtomicReference<List<Snapshot>> getSnapshots() {
        return this.snapshots;
    }
}

