/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tree.CustomTreeNode;
import com.alibabacloud.intellij.cosy.ui.search.component.tree.TreeBuilder;
import com.alibabacloud.intellij.cosy.ui.search.enums.TodoTreeUsageEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.TodoViewItemStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.TodoViewStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.tool.task.TaskItem;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class TodoViewPanel
extends JPanel {
    private final Project project;
    private final JPanel titlePanel;
    private final JLabel titleLabel;
    private final JLabel currentLabel;
    private final JLabel summaryLabel;
    private final JScrollPane scrollPane;
    private JTree tree;
    private TodoViewStatusEnum statusEnum;
    private static int index = -1;
    private TaskItem currentTaskItem;

    public TodoViewPanel(Project project, String taskTreeJson) {
        this.project = project;
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)4, (int)12));
        this.statusEnum = TodoViewStatusEnum.TODO;
        this.currentTaskItem = null;
        RoundRectPanel contentPanel = new RoundRectPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.titlePanel = new JPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.titlePanel.setPreferredSize(new Dimension(-1, 32));
        this.titleLabel = new JLabel("To-dos", LingmaIcons.ArrowrightEmptyGreyIcon, 10);
        this.currentLabel = new JLabel("");
        this.summaryLabel = new JLabel("1 / 1");
        this.summaryLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.summaryLabel.setFont(this.summaryLabel.getFont().deriveFont(12.0f));
        Box leftBox = Box.createHorizontalBox();
        leftBox.add(this.titleLabel);
        leftBox.add(Box.createHorizontalStrut(8));
        leftBox.add(this.currentLabel);
        Box rightBox = Box.createHorizontalBox();
        rightBox.add(this.summaryLabel);
        this.titlePanel.add((Component)leftBox, "West");
        this.titlePanel.add((Component)rightBox, "East");
        this.titlePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (TodoViewPanel.this.currentLabel.isVisible()) {
                    int maxLength = TodoViewPanel.this.titlePanel.getWidth() - TodoViewPanel.this.titleLabel.getWidth() - TodoViewPanel.this.summaryLabel.getWidth() - 40;
                    if (null != TodoViewPanel.this.currentTaskItem) {
                        TodoViewPanel.this.currentLabel.setText(FontUtil.getStringAdaptiveWidth(TodoViewPanel.this.currentLabel, TodoViewPanel.this.currentTaskItem.getContent(), maxLength, false));
                        TodoViewPanel.this.titlePanel.revalidate();
                        TodoViewPanel.this.titlePanel.repaint();
                    }
                }
            }
        });
        this.tree = TodoViewPanel.constructTaskTree(taskTreeJson, TodoTreeUsageEnum.VIEW_PANEL);
        this.scrollPane = TodoViewPanel.constructTaskTreeScrollPanel(this.tree);
        contentPanel.add((Component)this.titlePanel, "North");
        contentPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)contentPanel, "Center");
        SwingUtil.foreachChildComponent(contentPanel, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
        this.titlePanel.setOpaque(false);
        SwingUtil.foreachChildComponent(this.scrollPane, cp -> cp.setOpaque(false));
        SwingUtil.foreachChildComponent(this.titlePanel, cp -> cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TodoViewPanel.this.scrollPane.isVisible()) {
                    TodoViewPanel.this.titleLabel.setIcon(LingmaIcons.ArrowrightEmptyGreyIcon);
                    TodoViewPanel.this.scrollPane.setVisible(false);
                } else {
                    TodoViewPanel.this.titleLabel.setIcon(LingmaIcons.ArrowdownEmptyGreyIcon);
                    TodoViewPanel.this.scrollPane.setVisible(true);
                }
                TodoViewPanel.this.revalidate();
                TodoViewPanel.this.repaint();
            }
        }));
        this.scrollPane.setVisible(false);
    }

    @NotNull
    public static JScrollPane constructTaskTreeScrollPanel(JTree tree) {
        JBScrollPane pane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                if (this.getViewport().getView() instanceof JTree) {
                    JTree treeView = (JTree)this.getViewport().getView();
                    int rowCount = treeView.getRowCount();
                    int rowHeight = treeView.getRowHeight();
                    int borderHeight = 20;
                    int contentHeight = rowCount * rowHeight + borderHeight;
                    int minHeight = rowHeight + borderHeight;
                    int actualHeight = Math.max(minHeight, Math.min(contentHeight, 240));
                    return new Dimension(super.getPreferredSize().width, actualHeight);
                }
                return super.getPreferredSize();
            }
        };
        if (tree != null) {
            pane.setViewportView((Component)tree);
        }
        pane.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        pane.getViewport().setScrollMode(0);
        pane.setViewportBorder((Border)JBUI.Borders.empty((int)8, (int)6));
        JBScrollPane jBScrollPane = pane;
        if (jBScrollPane == null) {
            TodoViewPanel.$$$reportNull$$$0(0);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JScrollPane constructTaskTreeScrollPanel(String taskTreeJson, TodoTreeUsageEnum usage) {
        return TodoViewPanel.constructTaskTreeScrollPanel(TodoViewPanel.constructTaskTree(taskTreeJson, usage));
    }

    @NotNull
    private static JTree constructTaskTree(String taskTreeJson, TodoTreeUsageEnum usage) {
        return TodoViewPanel.constructTaskTree(new CustomTreeNode(TreeBuilder.buildTreeFromJson(taskTreeJson)), usage);
    }

    @NotNull
    private JTree constructTaskTree(List<TaskItem> items) {
        return TodoViewPanel.constructTaskTree(new CustomTreeNode(TreeBuilder.buildTreeFromList(items)), TodoTreeUsageEnum.VIEW_PANEL);
    }

    @NotNull
    private static JTree constructTaskTree(CustomTreeNode customRoot, final TodoTreeUsageEnum usage) {
        Tree tree = new Tree(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                int height = super.getRowCount() * super.getRowHeight();
                if (size.height > height) {
                    size.height = height;
                }
                return size;
            }
        };
        tree.setModel(new DefaultTreeModel(customRoot));
        tree.setUI(TodoViewPanel.getTodoViewTreeUI(usage));
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree1, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                TodoItemPanel todoItemPanel = new TodoItemPanel();
                if (value instanceof CustomTreeNode) {
                    todoItemPanel.setData((CustomTreeNode)value, index == row, usage);
                }
                return todoItemPanel;
            }
        });
        tree.setRootVisible(false);
        tree.setRowHeight(28);
        tree.setAutoscrolls(true);
        tree.setBackground(ColorUtil.getEditorBackgroundColor());
        tree.setBorder((Border)JBUI.Borders.empty());
        tree.addMouseMotionListener(new MouseAdapter((JTree)tree){
            final /* synthetic */ JTree val$tree;
            {
                this.val$tree = jTree;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int calculatedRow;
                Point point = e.getPoint();
                int newHoveredIndex = -1;
                Insets insets = this.val$tree.getInsets();
                int adjustedY = point.y - insets.top;
                int rowHeight = this.val$tree.getRowHeight();
                if (adjustedY >= 0 && rowHeight > 0 && (calculatedRow = adjustedY / rowHeight) < this.val$tree.getRowCount()) {
                    newHoveredIndex = calculatedRow;
                }
                if (newHoveredIndex != index) {
                    index = newHoveredIndex;
                    this.val$tree.repaint();
                }
            }
        });
        tree.addMouseListener(new MouseAdapter((JTree)tree){
            final /* synthetic */ JTree val$tree;
            {
                this.val$tree = jTree;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                index = -1;
                this.val$tree.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.val$tree.getSelectionModel().clearSelection();
            }
        });
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        Tree tree2 = tree;
        if (tree2 == null) {
            TodoViewPanel.$$$reportNull$$$0(1);
        }
        return tree2;
    }

    @NotNull
    private static BasicTreeUI getTodoViewTreeUI(final TodoTreeUsageEnum usage) {
        return new BasicTreeUI(){

            private boolean areAllFirstLevelNodesLeaves() {
                TreeModel model = this.tree.getModel();
                Object root = model.getRoot();
                int childCount = model.getChildCount(root);
                for (int i = 0; i < childCount; ++i) {
                    Object child = model.getChild(root, i);
                    if (model.isLeaf(child)) continue;
                    return false;
                }
                return childCount > 0;
            }

            @Override
            protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                if (this.areAllFirstLevelNodesLeaves()) {
                    return false;
                }
                return !isLeaf;
            }

            @Override
            protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                if (this.areAllFirstLevelNodesLeaves()) {
                    return;
                }
                if (!isLeaf) {
                    super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
            }

            @Override
            protected int getRowX(int row, int depth) {
                TreePath path;
                if (this.areAllFirstLevelNodesLeaves() && (path = this.getPathForRow(this.tree, row)) != null && path.getPathCount() == 2) {
                    return usage == TodoTreeUsageEnum.VIEW_PANEL ? 4 : 0;
                }
                return super.getRowX(row, depth) + (usage == TodoTreeUsageEnum.VIEW_PANEL ? 6 : 2);
            }

            @Override
            protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
                if (!this.areAllFirstLevelNodesLeaves()) {
                    super.paintHorizontalLine(g, c, y, left, right);
                }
            }

            @Override
            protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
                if (!this.areAllFirstLevelNodesLeaves()) {
                    super.paintVerticalLine(g, c, x, top, bottom);
                }
            }
        };
    }

    public void reloadTaskTree(List<TaskItem> taskItems) {
        this.reloadTaskTree(taskItems, false);
    }

    public void summaryTask() {
        this.reloadTaskTree(null, true);
    }

    public void reloadTaskTree(List<TaskItem> taskItems, boolean isFinished) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (isFinished && this.statusEnum == TodoViewStatusEnum.FINISHED) {
            return;
        }
        if (!isFinished && CollectionUtils.isNotEmpty(taskItems)) {
            this.tree = this.constructTaskTree(taskItems);
            this.scrollPane.setViewportView(this.tree);
        }
        if (null != this.tree.getModel()) {
            int maxLength = this.titlePanel.getWidth() - this.titleLabel.getWidth() - this.summaryLabel.getWidth() - 40;
            CustomTreeNode rootNode = (CustomTreeNode)this.tree.getModel().getRoot();
            List<TaskItem> children = rootNode.getTreeNode().getChildren();
            if (null != children) {
                int total = children.size();
                int todo = 0;
                int finished = 0;
                int canceled = 0;
                int running = 0;
                int error = 0;
                for (TaskItem child : children) {
                    if (TodoViewItemStatusEnum.COMPLETE.getId().equals(child.getStatus())) {
                        ++finished;
                        continue;
                    }
                    if (TodoViewItemStatusEnum.IN_PROGRESS.getId().equals(child.getStatus())) {
                        this.currentTaskItem = child;
                        this.currentLabel.setText(FontUtil.getStringAdaptiveWidth(this.currentLabel, child.getContent(), maxLength, false));
                        ++running;
                        continue;
                    }
                    if (TodoViewItemStatusEnum.CANCELLED.getId().equals(child.getStatus())) {
                        ++canceled;
                        continue;
                    }
                    if (TodoViewItemStatusEnum.ERROR.getId().equals(child.getStatus())) {
                        ++error;
                        continue;
                    }
                    ++todo;
                }
                if (isFinished) {
                    this.finishTodos(finished, total, canceled, todo);
                } else if (todo == total) {
                    this.statusEnum = TodoViewStatusEnum.TODO;
                    this.currentLabel.setVisible(false);
                    this.summaryLabel.setText("0/" + total);
                } else if (running > 0 || finished + canceled + error < total) {
                    this.statusEnum = TodoViewStatusEnum.RUNNING;
                    this.currentLabel.setVisible(true);
                    this.summaryLabel.setText(finished + "/" + total);
                } else if (finished + canceled + error == total) {
                    this.finishTodos(finished, total, canceled, todo);
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void finishTodos(int finished, int total, int canceled, int todo) {
        StringBuilder sb = new StringBuilder();
        if (finished > 0) {
            sb.append(finished).append("/").append(total).append(" ").append(CosyBundle.message(TodoViewItemStatusEnum.COMPLETE.getTextKey(), new Object[0]));
        }
        if (canceled > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(canceled).append("/").append(total).append(" ").append(CosyBundle.message(TodoViewItemStatusEnum.CANCELLED.getTextKey(), new Object[0]));
        }
        if (todo > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(todo).append("/").append(total).append(" ").append(CosyBundle.message(TodoViewItemStatusEnum.PENDING.getTextKey(), new Object[0]));
        }
        this.statusEnum = TodoViewStatusEnum.FINISHED;
        this.currentLabel.setVisible(false);
        this.summaryLabel.setText(sb.toString());
    }

    @Generated
    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/alibabacloud/intellij/cosy/ui/search/component/TodoViewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "constructTaskTreeScrollPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "constructTaskTree";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class TodoItemPanel
    extends RoundRectPanel {
        private final JLabel itemLabel;

        public TodoItemPanel() {
            super((LayoutManager)new BorderLayout(), 8);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            this.itemLabel = new JLabel();
            this.add((Component)this.itemLabel, "Center");
        }

        private void setData(CustomTreeNode value, boolean hovered, TodoTreeUsageEnum usage) {
            this.itemLabel.setForeground(ColorUtil.getTextForegroundColor());
            this.itemLabel.setBackground(ColorUtil.getEditorBackgroundColor());
            if (hovered) {
                SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getToolWindowBackgroundColor()));
            } else {
                SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getEditorBackgroundColor()));
            }
            TodoViewItemStatusEnum status = TodoViewItemStatusEnum.getById(value.getTreeNode().getStatus());
            if (null != status) {
                this.itemLabel.setIcon(TodoTreeUsageEnum.ADD_TASK_TOOL == usage ? TodoViewItemStatusEnum.PENDING.getIcon() : status.getIcon());
                if (TodoViewItemStatusEnum.CANCELLED == status) {
                    this.itemLabel.setText("<html><body style='text-decoration: line-through;'>" + value.getTreeNode().getContent() + "</body></html>");
                    this.itemLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                } else if (TodoViewItemStatusEnum.ERROR == status || TodoViewItemStatusEnum.COMPLETE == status) {
                    this.itemLabel.setText(value.getTreeNode().getContent());
                    this.itemLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                } else {
                    this.itemLabel.setText(value.getTreeNode().getContent());
                    this.itemLabel.setForeground(ColorUtil.getTextForegroundColor());
                }
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return super.getAccessibleContext();
        }

        @Generated
        public JLabel getItemLabel() {
            return this.itemLabel;
        }
    }
}

