/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import lombok.Generated;

public class TitleTextPane
extends JTextPane {
    private String title;
    private List<String> keywords;
    private static Logger log = Logger.getInstance(TitleTextPane.class);

    public TitleTextPane() {
        this.setEditable(false);
    }

    public void initUI(String displayText) {
        this.initUI(null, displayText, 0);
    }

    public void initUI(JComponent component, String displayText, int padding) {
        SimpleAttributeSet highlightStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(highlightStyle, (Color)CosyColor.TEXT_HIGHLIGHT_COLOR);
        StyleConstants.setBold(highlightStyle, true);
        SimpleAttributeSet normalStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(normalStyle, (Color)CosyColor.TEXT_NORMAL_COLOR);
        StyleConstants.setBold(normalStyle, true);
        Document document = null;
        try {
            document = component != null ? SwingUtil.highlightCutterDocument(displayText, highlightStyle, normalStyle, component, padding) : SwingUtil.highlightDocument(displayText, highlightStyle, normalStyle);
        }
        catch (Exception e) {
            log.warn("Document get offset error: " + e.getMessage());
        }
        if (document == null) {
            document = new DefaultStyledDocument();
            try {
                document.insertString(0, displayText, normalStyle);
            }
            catch (BadLocationException ex) {
                log.info(ex.getMessage(), (Throwable)ex);
            }
        }
        this.setDocument(document);
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<String> getKeywords() {
        return this.keywords;
    }
}

