/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.layout.HFlowLayout;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnySearchNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import lombok.Generated;

public class TagListPanel
extends JPanel {
    private static final Color NORMAL_TEXT_COLOR = new JBColor(new Color(0x808080), new Color(13487823));
    private static final Color NORMAL_BG_COLOR = new JBColor(new Color(0xDFDFDF), new Color(-11644332));
    private static final Color HOVER_BG_COLOR = new JBColor(new Color(0xB8B8B8), new Color(0x787878));
    private static final int PANEL_MIN_WIDTH = 200;
    private static final int PADDING_WIDTH = 130;
    private static final int MAX_TAG_COUNT = 10;
    String tags;
    int hGap;
    JBPopup popup;
    Project project;
    int marginLeft;

    public TagListPanel(int hGap) {
        this.hGap = hGap;
        this.setLayout(new HFlowLayout(0, hGap, 0));
    }

    public void updateComponent(Project project, String tags, int marginLeft) {
        this.tags = tags;
        this.project = project;
        this.marginLeft = marginLeft;
        this.updateLayout();
    }

    public void updateLayout() {
        int maxWidth;
        this.removeAll();
        if (this.tags == null) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(Constants.PLUGIN_NAME);
        JComponent component = null;
        if (toolWindow != null) {
            component = toolWindow.getContentManager().getComponent();
        }
        if (component == null) {
            component = (JComponent)SwingManager.INSTANCE.getComponent(this.project, "MAIN_PANEL_KEY");
        }
        if ((maxWidth = component.getSize().width) <= 0) {
            maxWidth = component.getPreferredSize().width;
        }
        if (maxWidth < 200) {
            maxWidth = 200;
        }
        double remainWidth = maxWidth - component.getInsets().left - component.getInsets().right - this.marginLeft - 130;
        final DisplayLabel ellipsisLabel = new DisplayLabel("...", NORMAL_BG_COLOR, NORMAL_TEXT_COLOR);
        remainWidth -= (double)(ellipsisLabel.getPreferredSize().width - this.hGap);
        final List tagList = Arrays.stream(this.tags.split(" ")).map(this::convertToTagInfo).limit(10L).collect(Collectors.toList());
        Iterator it = tagList.iterator();
        boolean forceOnce = true;
        while (it.hasNext()) {
            TagInfo tag = (TagInfo)it.next();
            DisplayLabel label = new DisplayLabel(tag.getShortTag(), NORMAL_BG_COLOR, NORMAL_TEXT_COLOR);
            label.setExtraData(tag);
            label.setToolTipText(tag.getTagTips());
            if (!((remainWidth -= (double)(label.getPreferredSize().width - this.hGap)) > 0.0) && !forceOnce) break;
            this.registerTagAction(label);
            this.add(label);
            it.remove();
            forceOnce = false;
        }
        if (tagList.size() > 0) {
            ellipsisLabel.setToolTipText(I18NConstant.ELLIPSIS_TIP);
            this.registerTagAction(ellipsisLabel);
            this.add(ellipsisLabel);
            ellipsisLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TagListPanel.this.createTagsPopup(ellipsisLabel, tagList);
                }
            });
        }
    }

    private void createTagsPopup(JComponent target, List<TagInfo> tagList) {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.cancel();
            this.popup = null;
        } else {
            IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(tagList);
            builder.setRenderer((ListCellRenderer)new TagListCellRenderer());
            builder.setRequestFocus(true);
            builder.setItemChosenCallback((Consumer)new Consumer<Object>(){

                public void consume(Object object) {
                    if (object instanceof TagInfo) {
                        TagInfo info = (TagInfo)object;
                        TagListPanel.this.sendAPIEvent(info);
                    }
                }
            });
            this.popup = builder.createPopup();
            this.popup.showUnderneathOf((Component)target);
        }
    }

    private TagInfo convertToTagInfo(String tag) {
        return new TagInfo(tag, this.getDisplayText(tag), tag.replace("()", ""));
    }

    private String getDisplayText(String text) {
        int lastDotIndex = text.lastIndexOf(46);
        if (text.endsWith("()")) {
            int classLastDotIndex = text.lastIndexOf(46, lastDotIndex - 1);
            String shortName = text;
            if (classLastDotIndex >= 0) {
                shortName = text.substring(classLastDotIndex + 1);
            } else if (lastDotIndex >= 0) {
                shortName = text.substring(lastDotIndex + 1);
            }
            return shortName.replace("()", "");
        }
        String shortName = text;
        if (lastDotIndex >= 0) {
            shortName = text.substring(lastDotIndex + 1);
        }
        return shortName;
    }

    private void registerTagAction(final DisplayLabel label) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TagListPanel.this.project != null && label.getExtraData() != null && label.getExtraData() instanceof TagInfo) {
                    TagInfo info = (TagInfo)label.getExtraData();
                    TagListPanel.this.sendAPIEvent(info);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(HOVER_BG_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(NORMAL_BG_COLOR);
            }
        });
    }

    private void sendAPIEvent(TagInfo info) {
        String type;
        String fullName = info.getTag();
        if (fullName.endsWith("()")) {
            type = SearchValueTypeEnum.METHOD.getType();
            fullName = fullName.replace("()", "");
        } else {
            type = SearchValueTypeEnum.CLASS.getType();
        }
        SearchValue searchValue = new SearchValue(fullName, info.getShortTag(), type);
        SearchContext context = new SearchContext(OperationEnum.ADD.text, SearchActionTypeEnum.ADD_TAG_TRIGGER.getType());
        ((AnySearchNotifier)this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
    }

    static class TagListCellRenderer
    implements ListCellRenderer<TagInfo> {
        TagListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TagInfo> list, TagInfo tag, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel(new FlowLayout(0));
            DisplayLabel label = new DisplayLabel(tag.getShortTag(), NORMAL_BG_COLOR, NORMAL_TEXT_COLOR);
            label.setExtraData(tag);
            label.setToolTipText(tag.getTagTips());
            panel.add(label);
            return panel;
        }
    }

    static class TagInfo {
        String tag;
        String shortTag;
        String tagTips;

        public TagInfo(String tag, String shortTag, String tagTips) {
            this.tag = tag;
            this.shortTag = shortTag;
            this.tagTips = tagTips;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }

        @Generated
        public String getShortTag() {
            return this.shortTag;
        }

        @Generated
        public String getTagTips() {
            return this.tagTips;
        }

        @Generated
        public void setTag(String tag) {
            this.tag = tag;
        }

        @Generated
        public void setShortTag(String shortTag) {
            this.shortTag = shortTag;
        }

        @Generated
        public void setTagTips(String tagTips) {
            this.tagTips = tagTips;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagInfo)) {
                return false;
            }
            TagInfo other = (TagInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$shortTag = this.getShortTag();
            String other$shortTag = other.getShortTag();
            if (this$shortTag == null ? other$shortTag != null : !this$shortTag.equals(other$shortTag)) {
                return false;
            }
            String this$tagTips = this.getTagTips();
            String other$tagTips = other.getTagTips();
            return !(this$tagTips == null ? other$tagTips != null : !this$tagTips.equals(other$tagTips));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TagInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $shortTag = this.getShortTag();
            result = result * 59 + ($shortTag == null ? 43 : $shortTag.hashCode());
            String $tagTips = this.getTagTips();
            result = result * 59 + ($tagTips == null ? 43 : $tagTips.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TagListPanel.TagInfo(tag=" + this.getTag() + ", shortTag=" + this.getShortTag() + ", tagTips=" + this.getTagTips() + ")";
        }
    }
}

